#include "StdAfx.h"
#include "JobAdvancedSetting2Page.h"
#include "JobMaximumDownloadTimeSettingDlg.h"
#include "BITSUtil.h"
#include "WTLCtrlUtil.h"
#include "MiscUtil.h"


CJobAdvancedSetting2Page::CJobAdvancedSetting2Page(void):
	m_bModified(false),
	m_jobType(BG_JOB_TYPE_DOWNLOAD)
{
	NULL;
}


CJobAdvancedSetting2Page::~CJobAdvancedSetting2Page(void)
{
	NULL;
}


LRESULT CJobAdvancedSetting2Page::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(InitPropertyPageControls());
	ATLVERIFY(RefreshUI());

	return TRUE;
}


int CJobAdvancedSetting2Page::OnApply(void)
{
	if (true == m_bModified) {
		if (false == ModifyFileACLFlags()) {
			ATLVERIFY(RefreshUI());
			return 0;
		}

		if (true == IsBITS25Supported()) {
			if (false == ModifyHttpOptions()) {
				ATLVERIFY(RefreshUI());
				return 0;
			}
			if (BG_JOB_TYPE_DOWNLOAD == m_jobType) {
				if (false == ModifyPeerCachingFlags()) {
					ATLVERIFY(RefreshUI());
					return 0;
				}
			}
		}
		m_bModified = false;
	}

	ATLVERIFY(RefreshUI());

	return 1;
}


LRESULT CJobAdvancedSetting2Page::OnChangeMaximumDownloadTimeButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	CJobMaximumDownloadTimeSettingDlg dlg;
	dlg.SetBITSManagerIF(m_spBITSManager);
	dlg.SetJobIF(m_spJob4);
	dlg.DoModal();

	ATLVERIFY(RefreshOtherTimeoutInfo());

	return 0;
}


void CJobAdvancedSetting2Page::OnModify(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	SetModified(TRUE);
	m_bModified = true;

	return;
}


bool CJobAdvancedSetting2Page::InitPropertyPageControls(void)
{
	if (true == IsBITS25Supported()) {
		ATLVERIFY(InitPropertyPageControlsForBITS25());
	} else {
		ATLASSERT(IsBITS20Supported());
		ATLVERIFY(InitPropertyPageControlsForBITS20());
	}

	return true;
}


bool CJobAdvancedSetting2Page::InitPropertyPageControlsForBITS20(void)
{
	ATLVERIFY(EnableAllHttpOptionControls(FALSE));
	ATLVERIFY(EnableAllPeerControls(FALSE));
	m_buttonChangeMaximumDownloadTime.EnableWindow(FALSE);

	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticIntegrityLevel, IDS_NOT_APPLICABLE));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticElevationState, IDS_NOT_APPLICABLE));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticMaximumDownloadTime, IDS_NOT_APPLICABLE));

	return true;
}


bool CJobAdvancedSetting2Page::InitPropertyPageControlsForBITS25(void)
{
	if (false == InitHttpRedirectPolicyComboBox()) {
		ATLASSERT(false);
		return false;
	}

	if (BG_JOB_TYPE_DOWNLOAD != m_jobType) {
		ATLVERIFY(EnableAllPeerControls(FALSE));
	}

	return true;
}


bool CJobAdvancedSetting2Page::InitHttpRedirectPolicyComboBox(void)
{
	int nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboHttpRedirectPolicy, IDS_FLAG_HTTP_REDIRECT_POLICY_ALLOW_SILENT,
		BG_HTTP_REDIRECT_POLICY_ALLOW_SILENT);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboHttpRedirectPolicy, IDS_FLAG_HTTP_REDIRECT_POLICY_ALLOW_REPORT,
		BG_HTTP_REDIRECT_POLICY_ALLOW_REPORT);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	nListIndex = WTLCtrlUtil::AddStringAndSetData(m_comboHttpRedirectPolicy, IDS_FLAG_HTTP_REDIRECT_POLICY_DISALLOW,
		BG_HTTP_REDIRECT_POLICY_DISALLOW);
	if (CB_ERR == nListIndex) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(SetHttpRedirectPolicyToComboBox(BG_HTTP_REDIRECT_POLICY_ALLOW_SILENT));

	return true;
}


bool CJobAdvancedSetting2Page::ModifyFileACLFlags(void)
{
	ATLASSERT(m_spJob3);

	DWORD dwFileACLFlags = GetFileACLFlagsFromControls();
	HRESULT hr = BITSUtil::SetJobFileACLFlags(m_spJob3, dwFileACLFlags);
	if (FAILED(hr)) {
		ATLASSERT(false);

		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_EDIT_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return false;
	}

	return true;
}


bool CJobAdvancedSetting2Page::ModifyHttpOptions(void)
{
	ATLASSERT(m_spHttpOptions);

	DWORD dwHttpOptionFlags	= GetHttpOptionFlagsFromControls();
	HRESULT hr = BITSUtil::SetJobHttpOptions(m_spHttpOptions, dwHttpOptionFlags);
	if (FAILED(hr)) {
		ATLASSERT(false);

		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_EDIT_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return false;
	}

	return true;
}


bool CJobAdvancedSetting2Page::ModifyPeerCachingFlags(void)
{
	ATLASSERT(m_spJob4);

	DWORD dwPeerCachingFlags = GetPeerCachingFlagsFromControls();
	HRESULT hr = BITSUtil::SetJobPeerCachingFlags(m_spJob4, dwPeerCachingFlags);
	if (FAILED(hr)) {
		ATLASSERT(false);

		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_EDIT_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return false;
	}

	return true;
}


bool CJobAdvancedSetting2Page::RefreshUI(void)
{
	ATLVERIFY(RefreshFileACLInfo());

	if (true == IsBITS25Supported()) {
		ATLVERIFY(RefreshHttpsOption());
		ATLVERIFY(RefreshHttpRedirectPolicyInfo());
		if (BG_JOB_TYPE_DOWNLOAD == m_jobType) {
			ATLVERIFY(RefreshPeerInfo());
		}
		ATLVERIFY(RefreshSecurityState());
		ATLVERIFY(RefreshOtherTimeoutInfo());
	}

	return true;
}


bool CJobAdvancedSetting2Page::RefreshFileACLInfo(void)
{
	ATLASSERT(m_spJob3);

	DWORD dwFileACLFlags = 0;
	HRESULT hr = BITSUtil::GetJobFileACLFlags(m_spJob3, &dwFileACLFlags);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	if (BG_COPY_FILE_OWNER & dwFileACLFlags) {
		m_checkACLCopyFileOwner.SetCheck(BST_CHECKED);
	} else {
		m_checkACLCopyFileOwner.SetCheck(BST_UNCHECKED);
	}

	if (BG_COPY_FILE_GROUP & dwFileACLFlags) {
		m_checkACLCopyFileGroup.SetCheck(BST_CHECKED);
	} else {
		m_checkACLCopyFileGroup.SetCheck(BST_UNCHECKED);
	}

	if (BG_COPY_FILE_DACL & dwFileACLFlags) {
		m_checkACLCopyFileDACL.SetCheck(BST_CHECKED);
	} else {
		m_checkACLCopyFileDACL.SetCheck(BST_UNCHECKED);
	}

	if (BG_COPY_FILE_SACL & dwFileACLFlags) {
		m_checkACLCopyFileSACL.SetCheck(BST_CHECKED);
	} else {
		m_checkACLCopyFileSACL.SetCheck(BST_UNCHECKED);
	}

	return true;
}


bool CJobAdvancedSetting2Page::RefreshHttpsOption(void)
{
	ATLASSERT(m_spHttpOptions);

	DWORD dwHttpOptions = 0;
	HRESULT hr = BITSUtil::GetJobHttpOptions(m_spHttpOptions, &dwHttpOptions);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	if (BG_SSL_ENABLE_CRL_CHECK & dwHttpOptions) {
		m_checkSSLEnableCRLCheck.SetCheck(BST_CHECKED);
	} else {
		m_checkSSLEnableCRLCheck.SetCheck(BST_UNCHECKED);
	}

	if (BG_SSL_IGNORE_CERT_CN_INVALID & dwHttpOptions) {
		m_checkSSLIgnoreCertCNInvalid.SetCheck(BST_CHECKED);
	} else {
		m_checkSSLIgnoreCertCNInvalid.SetCheck(BST_UNCHECKED);
	}

	if (BG_SSL_IGNORE_CERT_DATE_INVALID & dwHttpOptions) {
		m_checkSSLIgnoreCertDateInvalid.SetCheck(BST_CHECKED);
	} else {
		m_checkSSLIgnoreCertDateInvalid.SetCheck(BST_UNCHECKED);
	}

	if (BG_SSL_IGNORE_UNKNOWN_CA & dwHttpOptions) {
		m_checkSSLIgnoreUnknownCA.SetCheck(BST_CHECKED);
	} else {
		m_checkSSLIgnoreUnknownCA.SetCheck(BST_UNCHECKED);
	}

	if (BG_SSL_IGNORE_CERT_WRONG_USAGE & dwHttpOptions) {
		m_checkSSLIgnoreCertWrongUsage.SetCheck(BST_CHECKED);
	} else {
		m_checkSSLIgnoreCertWrongUsage.SetCheck(BST_UNCHECKED);
	}

	return true;
}


bool CJobAdvancedSetting2Page::RefreshHttpRedirectPolicyInfo(void)
{
	ATLASSERT(m_spHttpOptions);

	DWORD dwHttpOptions = 0;
	HRESULT hr = BITSUtil::GetJobHttpOptions(m_spHttpOptions, &dwHttpOptions);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	ATLASSERT(BITSUtil::VerifyHttpRedirectPolicy(dwHttpOptions & BG_HTTP_REDIRECT_POLICY_MASK));
	ATLVERIFY(SetHttpRedirectPolicyToComboBox(dwHttpOptions & BG_HTTP_REDIRECT_POLICY_MASK));

	if (dwHttpOptions & BG_HTTP_REDIRECT_POLICY_ALLOW_HTTPS_TO_HTTP) {
		m_checkRedirectPolicyAllowHttpsToHttp.SetCheck(BST_CHECKED);
	} else {
		m_checkRedirectPolicyAllowHttpsToHttp.SetCheck(BST_UNCHECKED);
	}

	return true;
}


bool CJobAdvancedSetting2Page::RefreshPeerInfo(void)
{
	ATLASSERT(m_spJob4);
	ATLASSERT(BG_JOB_TYPE_DOWNLOAD == m_jobType);

	DWORD dwPeerCachingFlag = 0;
	HRESULT hr = BITSUtil::GetJobPeerCachingFlags(m_spJob4, &dwPeerCachingFlag);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	if (BG_ENABLE_PEERCACHING_CLIENT & dwPeerCachingFlag) {
		m_checkEnabelPeerCachingClient.SetCheck(BST_CHECKED);
	} else {
		m_checkEnabelPeerCachingClient.SetCheck(BST_UNCHECKED);
	}

	if (BG_ENABLE_PEERCACHING_SERVER & dwPeerCachingFlag) {
		m_checkEnabelPeerCachingServer.SetCheck(BST_CHECKED);
	} else {
		m_checkEnabelPeerCachingServer.SetCheck(BST_UNCHECKED);
	}

	return true;
}


bool CJobAdvancedSetting2Page::RefreshSecurityState(void)
{
	ATLASSERT(m_spJob4);

	ULONG ulLevel = 0;
	HRESULT hr = BITSUtil::GetJobOwnerIntegrityLevel(m_spJob4, &ulLevel);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}
	CString strIntegrityLevel = MiscUtil::GetIntegrityLevelString(ulLevel);
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticIntegrityLevel, strIntegrityLevel));

	BOOL bElevated = FALSE;
	hr = BITSUtil::GetJobOwnerElevationState(m_spJob4, &bElevated);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}
	CString strElevationState = MiscUtil::GetElevationStateString(bElevated);
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticElevationState, strElevationState));

	return true;
}


bool CJobAdvancedSetting2Page::RefreshOtherTimeoutInfo(void)
{
	ATLASSERT(m_spJob4);

	ULONG uMaximumDownloadTime = 0;
	HRESULT hr = BITSUtil::GetJobMaximumDownloadTime(m_spJob4, &uMaximumDownloadTime);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticMaximumDownloadTime, MiscUtil::FormatNumber(uMaximumDownloadTime)));

	return true;
}


bool CJobAdvancedSetting2Page::EnableAllHttpOptionControls(BOOL bEnable)
{
	m_checkSSLEnableCRLCheck.EnableWindow(bEnable);
	m_checkSSLIgnoreCertCNInvalid.EnableWindow(bEnable);
	m_checkSSLIgnoreCertDateInvalid.EnableWindow(bEnable);
	m_checkSSLIgnoreUnknownCA.EnableWindow(bEnable);
	m_checkSSLIgnoreCertWrongUsage.EnableWindow(bEnable);

	m_comboHttpRedirectPolicy.EnableWindow(bEnable);
	m_checkRedirectPolicyAllowHttpsToHttp.EnableWindow(bEnable);

	return true;
}


bool CJobAdvancedSetting2Page::EnableAllPeerControls(BOOL bEnable)
{
	m_checkEnabelPeerCachingClient.EnableWindow(bEnable);
	m_checkEnabelPeerCachingServer.EnableWindow(bEnable);

	return true;
}


__checkReturn DWORD CJobAdvancedSetting2Page::GetHttpRedirectPolicyFromComboBox(void)
{
	int nCurSel = m_comboHttpRedirectPolicy.GetCurSel();
	ATLASSERT(CB_ERR != nCurSel);

	return static_cast<DWORD>(m_comboHttpRedirectPolicy.GetItemData(nCurSel));
}


bool CJobAdvancedSetting2Page::SetHttpRedirectPolicyToComboBox(__in DWORD dwHttpRedirectPolicy)
{
	int nItemCount = m_comboHttpRedirectPolicy.GetCount();
	for (int nIndex = 0; nIndex < nItemCount; nIndex++) {
		if (dwHttpRedirectPolicy == static_cast<DWORD>(m_comboHttpRedirectPolicy.GetItemData(nIndex))) {
			m_comboHttpRedirectPolicy.SetCurSel(nIndex);
			return true;
		}
	}

	ATLASSERT(false);
	return false;
}


__checkReturn DWORD CJobAdvancedSetting2Page::GetFileACLFlagsFromControls(void)
{
	DWORD dwFlags = 0;
	if (BST_CHECKED == m_checkACLCopyFileOwner.GetState()) {
		dwFlags |= BG_COPY_FILE_OWNER;
	}
	if (BST_CHECKED == m_checkACLCopyFileGroup.GetState()) {
		dwFlags |= BG_COPY_FILE_GROUP;
	}
	if (BST_CHECKED == m_checkACLCopyFileDACL.GetState()) {
		dwFlags |= BG_COPY_FILE_DACL;
	}
	if (BST_CHECKED == m_checkACLCopyFileSACL.GetState()) {
		dwFlags |= BG_COPY_FILE_SACL;
	}

	return dwFlags;
}


__checkReturn DWORD CJobAdvancedSetting2Page::GetHttpOptionFlagsFromControls(void)
{
	DWORD dwFlags = 0;
	if (BST_CHECKED == m_checkSSLEnableCRLCheck.GetState()) {
		dwFlags |= BG_SSL_ENABLE_CRL_CHECK;
	}
	if (BST_CHECKED == m_checkSSLIgnoreCertCNInvalid.GetState()) {
		dwFlags |= BG_SSL_IGNORE_CERT_CN_INVALID;
	}
	if (BST_CHECKED == m_checkSSLIgnoreCertDateInvalid.GetState()) {
		dwFlags |= BG_SSL_IGNORE_CERT_DATE_INVALID;
	}
	if (BST_CHECKED == m_checkSSLIgnoreUnknownCA.GetState()) {
		dwFlags |= BG_SSL_IGNORE_UNKNOWN_CA;
	}
	if (BST_CHECKED == m_checkSSLIgnoreCertWrongUsage.GetState()) {
		dwFlags |= BG_SSL_IGNORE_CERT_WRONG_USAGE;
	}

	DWORD dwHttpRedirectPolicy = GetHttpRedirectPolicyFromComboBox();
	dwFlags |= dwHttpRedirectPolicy;

	if (BST_CHECKED == m_checkRedirectPolicyAllowHttpsToHttp.GetState()) {
		dwFlags |= BG_HTTP_REDIRECT_POLICY_ALLOW_HTTPS_TO_HTTP;
	}

	return dwFlags;
}


__checkReturn DWORD CJobAdvancedSetting2Page::GetPeerCachingFlagsFromControls(void)
{
	DWORD dwFlags = 0;
	if (BST_CHECKED == m_checkEnabelPeerCachingClient.GetState()) {
		dwFlags |= BG_ENABLE_PEERCACHING_CLIENT;
	}
	if (BST_CHECKED == m_checkEnabelPeerCachingServer.GetState()) {
		dwFlags |= BG_ENABLE_PEERCACHING_SERVER;
	}

	return dwFlags;
}


__checkReturn bool CJobAdvancedSetting2Page::IsBITS20Supported(void)
{
	if (!m_spJob3) {
		return false;
	}

	return true;
}


__checkReturn bool CJobAdvancedSetting2Page::IsBITS25Supported(void)
{
	if (!m_spJob4) {
		return false;
	}

	return true;
}


void CJobAdvancedSetting2Page::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}


void CJobAdvancedSetting2Page::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);
	if (m_spJob3) {
		ATLASSERT(false);
		m_spJob3.Release();
	}
	m_spJob3 = spJob;

	m_jobType = BG_JOB_TYPE_DOWNLOAD;
	HRESULT hr = BITSUtil::GetJobType(spJob, &m_jobType);
	if (FAILED(hr)) {
		ATLASSERT(false);
	}

	if (m_spJob4) {
		ATLASSERT(false);
		m_spJob4.Release();
	}
	m_spJob4 = spJob;

	if (m_spJob4) {
		if (m_spHttpOptions) {
			ATLASSERT(false);
			m_spHttpOptions.Release();
		}
		m_spHttpOptions = spJob;
	}

	return;
}

