/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.meta2xml.task.valueobject;

/**
 * NX [BlancoMeta2XmlProcess]̓̓o[IuWFNgNXłB
 */
public class BlancoMeta2XmlProcessInput {
    /**
     * verbose[hœ삳邩ǂB
     *
     * tB[h: [verbose]B
     * ftHg: [false]B
     */
    private boolean fVerbose = false;

    /**
     * ^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B
     *
     * tB[h: [metadir]B
     */
    private String fMetadir;

    /**
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B
     *
     * tB[h: [targetdir]B
     * ftHg: [blanco]B
     */
    private String fTargetdir = "blanco";

    /**
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B
     *
     * tB[h: [tmpdir]B
     * ftHg: [tmp]B
     */
    private String fTmpdir = "tmp";

    /**
     * \[Xt@C̕GR[fBOw肵܂B
     *
     * tB[h: [encoding]B
     */
    private String fEncoding;

    /**
     * `^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂ̃tOB
     *
     * tB[h: [cache]B
     * ftHg: [false]B
     */
    private String fCache = "false";

    /**
     * tB[h [verbose] ̒lݒ肵܂B
     *
     * tB[h̐: [verbose[hœ삳邩ǂB]B
     *
     * @param argVerbose tB[h[verbose]ɐݒ肷lB
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * tB[h [verbose] ̒l擾܂B
     *
     * tB[h̐: [verbose[hœ삳邩ǂB]B
     * ftHg: [false]B
     *
     * @return tB[h[verbose]擾lB
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * tB[h [metadir] ̒lݒ肵܂B
     *
     * tB[h̐: [^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B]B
     *
     * @param argMetadir tB[h[metadir]ɐݒ肷lB
     */
    public void setMetadir(final String argMetadir) {
        fMetadir = argMetadir;
    }

    /**
     * tB[h [metadir] ̒l擾܂B
     *
     * tB[h̐: [^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B]B
     *
     * @return tB[h[metadir]擾lB
     */
    public String getMetadir() {
        return fMetadir;
    }

    /**
     * tB[h [targetdir] ̒lݒ肵܂B
     *
     * tB[h̐: [o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B]B
     *
     * @param argTargetdir tB[h[targetdir]ɐݒ肷lB
     */
    public void setTargetdir(final String argTargetdir) {
        fTargetdir = argTargetdir;
    }

    /**
     * tB[h [targetdir] ̒l擾܂B
     *
     * tB[h̐: [o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B]B
     * ftHg: [blanco]B
     *
     * @return tB[h[targetdir]擾lB
     */
    public String getTargetdir() {
        return fTargetdir;
    }

    /**
     * tB[h [tmpdir] ̒lݒ肵܂B
     *
     * tB[h̐: [e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B]B
     *
     * @param argTmpdir tB[h[tmpdir]ɐݒ肷lB
     */
    public void setTmpdir(final String argTmpdir) {
        fTmpdir = argTmpdir;
    }

    /**
     * tB[h [tmpdir] ̒l擾܂B
     *
     * tB[h̐: [e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B]B
     * ftHg: [tmp]B
     *
     * @return tB[h[tmpdir]擾lB
     */
    public String getTmpdir() {
        return fTmpdir;
    }

    /**
     * tB[h [encoding] ̒lݒ肵܂B
     *
     * tB[h̐: [\[Xt@C̕GR[fBOw肵܂B]B
     *
     * @param argEncoding tB[h[encoding]ɐݒ肷lB
     */
    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * tB[h [encoding] ̒l擾܂B
     *
     * tB[h̐: [\[Xt@C̕GR[fBOw肵܂B]B
     *
     * @return tB[h[encoding]擾lB
     */
    public String getEncoding() {
        return fEncoding;
    }

    /**
     * tB[h [cache] ̒lݒ肵܂B
     *
     * tB[h̐: [`^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂ̃tOB]B
     *
     * @param argCache tB[h[cache]ɐݒ肷lB
     */
    public void setCache(final String argCache) {
        fCache = argCache;
    }

    /**
     * tB[h [cache] ̒l擾܂B
     *
     * tB[h̐: [`^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂ̃tOB]B
     * ftHg: [false]B
     *
     * @return tB[h[cache]擾lB
     */
    public String getCache() {
        return fCache;
    }

    /**
     * ̃o[IuWFNg̕\擾܂B
     *
     * <P>gp̒</P>
     * <UL>
     * <LI>IuWFNg̃V[͈͂̂ݕ񉻂̏ΏۂƂȂ܂B
     * <LI>IuWFNgzQƂĂꍇɂ́Ã\bh͎gȂłB
     * </UL>
     *
     * @return o[IuWFNg̕\B
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("blanco.meta2xml.task.valueobject.BlancoMeta2XmlProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",metadir=" + fMetadir);
        buf.append(",targetdir=" + fTargetdir);
        buf.append(",tmpdir=" + fTmpdir);
        buf.append(",encoding=" + fEncoding);
        buf.append(",cache=" + fCache);
        buf.append("]");
        return buf.toString();
    }
}
