/*
 * blancoCommons Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.calc.parser.block;

import java.util.ArrayList;

/**
 * JԂ^̃ubN܂B
 * 
 * @author iga
 */
public class BlancoCalcParserTableBlock extends AbstractBlancoCalcParserBlock {
    private ArrayList list = new ArrayList();

    private String blockRowName = "";

    /**
     * ^CgT[`ۂɁA^Cg̍siʏ͂Psj ̐񋟂܂B
     */
    private int waitForIteratorTitleSearchY = 1;

    public BlancoCalcParserTableBlock(String name) {
        setName(name);
    }

    public void add(BlancoCalcParserTableColumn item) {
        list.add(item);
    }

    /**
     * ^CgsɁAACe܂B
     * 
     * @param titleString
     * @return
     */
    public BlancoCalcParserTableColumn findByTitleString(String titleString) {
        for (int index = 0; index < list.size(); index++) {
            BlancoCalcParserTableColumn item = (BlancoCalcParserTableColumn) list
                    .get(index);
            if (item.isStartString(titleString)) {
                return item;
            }
        }
        return null;
    }

    /**
     * ԍɁAACe܂B
     * 
     * @param pos
     * @return
     */
    public BlancoCalcParserTableColumn findByColumnPosition(int pos) {
        for (int index = 0; index < list.size(); index++) {
            BlancoCalcParserTableColumn item = (BlancoCalcParserTableColumn) list
                    .get(index);
            if (item.getColumnPosition() == pos) {
                return item;
            }
        }
        return null;
    }

    public int getSearchRangeForTitleY() {
        return waitForIteratorTitleSearchY;
    }

    public void setSearchRangeForTitleY(int arg) {
        waitForIteratorTitleSearchY = arg;
    }

    public void setRowName(String arg) {
        blockRowName = arg;
    }

    public String getRowName() {
        return blockRowName;
    }
}
