/*
 * blancoCommons Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */

package blanco.commons.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;

/**
 * blanco Framework̖OɊւ郆[eBeBłB
 * 
 * @author IGA Tosiki
 */
public class BlancoNameUtil {
    /**
     * ^ꂽOt@CƂėpÓǂ𔻒f܂B
     * 
     * @param fileName
     *            t@CƂĔ肷镶B
     * @return
     */
    public static final boolean isValidFileName(final String fileName) {
        if (fileName.indexOf('/') >= 0 || fileName.indexOf('\\') >= 0
                || fileName.indexOf(':') >= 0 || fileName.indexOf(';') >= 0
                || fileName.indexOf('*') >= 0 || fileName.indexOf('?') >= 0
                || fileName.indexOf('\"') >= 0 || fileName.indexOf('>') >= 0
                || fileName.indexOf('<') >= 0 || fileName.indexOf('|') >= 0) {
            // ̕܂܂Ăt@CƂĂ͕sK؂łB
            return false;
        }
        return true;
    }

    /**
     * t@CƂėpׂłȂ̈ꗗ擾܂B
     * 
     * @return
     */
    public static final String invalidFileNameChar() {
        return "/ \\ : ; * ? \" > < |";
    }

    /**
     * t@C(fBNg͊܂܂Ȃŗ^܂)gq܂B<br>
     * hbg͊gqƓ܂B<br>
     *  .cvsignorê悤ȃt@C^ꂽꍇɂ́Â܂ܖ߂܂B
     * 
     * @param t@C(fBNg܂܂Ȃ)
     * @return gq܂܂Ȃt@C
     */
    public static final String trimFileExtension(final String fileName) {
        final int posDot = fileName.lastIndexOf(".");
        if (posDot == 0) {
            // hbgJnt@CłB͂̂܂ܕԂ܂B
            return fileName;
        }
        if (posDot > 0) {
            // gq͏܂B
            return fileName.substring(0, posDot);
        }
        return fileName;
    }

    /**
     * ^ꂽw̋؂蕶ŕ܂B<br>
     * <br>
     * ؂蕶 '/'łꍇ͉̋L̒ʂB<br>
     * ʏP[X1F[aaa/bbb/ccc]{ "aaa", "bbb", "ccc" }<br>
     * ʏP[X2F[aaa//ccc]{ "aaa", "", "ccc" }<br>
     * ʏP[X3: [/aaa/bbb]{ "", "aaa", "bbb" }<br>
     * ŏ̃XbV͈ƂăJEg܂B<br>
     * ʏP[X4F[/aaa/bbb/]{ "", "aaa", "bbb" }<br>
     * Ō̃XbV͖܂B<br>
     * <br>
     * EP[X1F[/]{ "" }<br>
     * EP[X2F[///]{ "", "", "" }<br>
     * EP[X3F[]0̔z<br>
     * EP[X4Fnull0̔z<br>
     * 
     * @param arg
     *            ؂蕶ŋ؂ꂽBnull^ꍇɂ 0Stringz񂪖߂܂B
     * @return ꂽB؂蕶̂̂͊܂܂܂B
     */
    public static final String[] splitString(final String arg,
            final char delimiter) {
        if (arg == null) {
            // nullɊւẮAڂȂ̂ƂĈ܂B
            return new String[0];
        }
        final StringReader reader = new StringReader(arg);
        StringWriter writer = null;
        final ArrayList result = new ArrayList();
        for (;;) {
            final int read;
            try {
                read = reader.read();
            } catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(
                        "[NStringReader̓ǂݍ݂ŗO܂BSz肵ȂP[XłB:"
                                + e.toString());
            }
            if (read < 0) {
                break;
            }
            if (writer == null) {
                writer = new StringWriter();
            }
            if ((char) read == delimiter) {
                if (writer != null) {
                    try {
                        writer.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                        throw new IllegalArgumentException(
                                "[NStringWriter̃N[YŗO܂BSz肵ȂP[XłB:"
                                        + e.toString());
                    }
                    result.add(writer.toString());
                    // [Nϐ̒gZbg܂B
                    writer = null;
                }
            } else {
                writer.write((char) read);
            }
        }
        if (writer != null) {
            try {
                writer.close();
            } catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(
                        "Sz肵ȂA肦ȂP[Xł̃G[܂B:" + e.toString());
            }
            result.add(writer.toString());
            // [Nϐ̒gZbg܂B
            writer = null;
        }
        return (String[]) result.toArray(new String[result.size()]);
    }

    /**
     * ^ꂽpXłƉ肵A/(XbV)Lŋ؂ĕ𕪊܂B<br>
     * <br>
     * ʏP[X1F[aaa/bbb/ccc]{ "aaa", "bbb", "ccc" }<br>
     * ʏP[X2F[aaa//ccc]{ "aaa", "", "ccc" }<br>
     * ʏP[X3: [/aaa/bbb]{ "", "aaa", "bbb" }<br>
     * ŏ̃XbV͈ƂăJEg܂B<br>
     * ʏP[X4F[/aaa/bbb/]{ "", "aaa", "bbb" }<br>
     * Ō̃XbV͖܂B<br>
     * <br>
     * EP[X1F[/]{ "" }<br>
     * EP[X2F[///]{ "", "", "" }<br>
     * EP[X3F[]0̔z<br>
     * EP[X4Fnull0̔z<br>
     * 
     * @param arg
     *            /(XbV)Lŋ؂ꂽBnull^ꍇɂ 0Stringz񂪖߂܂B
     * @return ꂽB/(XbV)L͊܂܂܂B
     */
    public static final String[] splitPath(final String arg) {
        return splitString(arg, '/');
    }

    /**
     * ^ꂽNXpbP[W܂B
     * 
     * @param argClassName
     * @return
     */
    public static final String trimJavaPackage(final String argClassName) {
        final String[] work = splitString(argClassName, '.');
        for (int index = work.length - 1; index >= 0; index--) {
            if (work[index].length() > 0) {
                return work[index];
            }
        }
        throw new IllegalArgumentException("[" + argClassName
                + "]pbP[WtJavaNXƂďł܂B");
    }

    /**
     * ^ꂽURIA閽Kɏ] JavapbP[W擾܂B
     * 
     * @param uri
     * @return
     */
    public static final String uri2JavaPackage(final String uri) {
        final StringWriter writer = new StringWriter();
        final String[] splitedUri = splitString(uri, ':');
        boolean isFirst = true;
        if (splitedUri.length < 2) {
            throw new IllegalArgumentException(
                    "^ꂽURI["
                            + uri
                            + "]͌`słB[http://www.w3.org/XML/Schema]̂悤Ȍ`Ŏw肵ĂB");
        }
        final String[] splitDir = BlancoNameUtil
                .splitString(splitedUri[1], '/');
        for (int index = 0; index < splitDir.length; index++) {
            final String[] splitDomain = BlancoNameUtil.splitString(
                    splitDir[index], '.');
            for (int indexDomain = splitDomain.length - 1; indexDomain >= 0; indexDomain--) {
                // hC\Ǝvӏł̂ŁAtŏs܂B
                if (splitDomain[indexDomain].length() > 0) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        writer.write(".");
                    }
                    writer.write(splitDomain[indexDomain]);
                }
            }
        }
        for (int indexUri = 2; indexUri < splitedUri.length; indexUri++) {
            final String[] splitDirAfter = BlancoNameUtil.splitString(
                    splitedUri[indexUri], '/');
            // |CgFŏ̃m[h |[gԍł낤 𖳎܂B
            for (int index = 1; index < splitDirAfter.length; index++) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.write(".");
                }
                writer.write(splitDirAfter[index]);
            }
        }

        try {
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "肦ȂO: StringWriterclose()̍ۂɗO܂B:"
                            + e.toString());
        }
        return writer.toString();
    }
}
