/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.test.db.ddl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import blanco.commons.util.BlancoNameUtil;

/**
 * {vOblancoDb̎ڂ̂AP\Ɋւ鎎{邽߂̃[eBeBłB
 * 
 * 2̗񂪊܂܂ꂽ\ΏۂƂȂ܂B<br>
 * ̃vO SQL Server 2005pDDL𐶐܂B
 */
public class SimpleTableSQLServer2005DoubleColumnDDL {
    /**
     * DDL̏o̓C^B
     */
    private PrintWriter fWriter = null;

    /**
     * DDL̍쐬s܂B
     * 
     * @param args
     *            Bw肳ꂽe͖܂B
     */
    public static void main(final String[] args) {
        try {
            new SimpleTableSQLServer2005DoubleColumnDDL().generate();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void generate() throws IOException {
        final File fileTargetDirectory = new File("./sqlserver2005/ddl");
        if (fileTargetDirectory.exists() == false) {
            fileTargetDirectory.mkdirs();
        }

        fWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(
                fileTargetDirectory.getAbsolutePath()
                        + "/"
                        + BlancoNameUtil.trimJavaPackage(this.getClass()
                                .getName()) + ".txt")));
        try {
            fWriter.println("------------------------------------------");
            fWriter.println("-- 폜GAłB --");
            fWriter.println("------------------------------------------");

            generateDeleteDoubleColumnPrimary1();
            generateDeleteDoubleColumnPrimary2();
            generateDeleteDoubleColumnPrimary3();
            generateDeleteDoubleColumnNonPrimary();
            generateDeleteDoubleColumnPrimary1Nullable();
            generateDeleteDoubleColumnPrimary2Nullable();
            generateDeleteDoubleColumnPrimary3Nullable();
            generateDeleteDoubleColumnNonPrimaryNullable();

            fWriter.println("------------------------------------------");
            fWriter.println("-- 琶GAłB --");
            fWriter.println("------------------------------------------");

            generateDoubleColumnPrimary1();
            generateDoubleColumnPrimary2();
            generateDoubleColumnPrimary3();
            generateDoubleColumnNonPrimary();
            generateDoubleColumnPrimary1Nullable();
            generateDoubleColumnPrimary2Nullable();
            generateDoubleColumnPrimary3Nullable();
            generateDoubleColumnNonPrimaryNullable();
        } finally {
            fWriter.close();
        }
    }

    private final void generateDoubleColumnPrimary1() {

        fWriter.println("------------------------------------------");
        fWriter.println("-- 2̍ڂŁA1ڂ̃vC}L[ɂ\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("/*2̍ڂŁA1ڂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY1_"
                    + (index + 1) + " (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
            fWriter.println(", FIELD_VARCHAR_FIXED VARCHAR(50) NOT NULL");
            fWriter.println(", PRIMARY KEY (FIELD_" + fieldName + ")");
            fWriter.println(");");
            fWriter.println("");
        }
    }

    private final void generateDoubleColumnPrimary2() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2̍ڂŁA2ڂ̃vC}L[ɂ\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("/*2̍ڂŁA2ڂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY2_"
                    + (index + 1) + " (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
            fWriter.println(", FIELD_VARCHAR_FIXED VARCHAR(50) NOT NULL");
            fWriter.println(", PRIMARY KEY (FIELD_VARCHAR_FIXED)");
            fWriter.println(");");
            fWriter.println("");
        }
    }

    private final void generateDoubleColumnPrimary3() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2̍ڂŁA2ƂvC}L[ł\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("/*2̍ڂŁAƂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY3_"
                    + (index + 1) + " (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
            fWriter.println(", FIELD_VARCHAR_FIXED VARCHAR(50) NOT NULL");
            fWriter.println(", PRIMARY KEY (FIELD_" + fieldName
                    + ", FIELD_VARCHAR_FIXED)");
            fWriter.println(");");
            fWriter.println("");
        }
    }

    private final void generateDoubleColumnNonPrimary() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2̍ڂŁA2ƂvC}L[łȂ\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("/*2̍ڂŁAƂvC}L[łȂ\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_DOUBLE_COLUMN_NON_PRIMARY_"
                    + (index + 1) + " (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
            fWriter.println(", FIELD_VARCHAR_FIXED VARCHAR(50) NOT NULL");
            fWriter.println(");");
            fWriter.println("");
        }
    }

    private final void generateDoubleColumnPrimary1Nullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2nulleȍڂŁA1ڂvC}L[ł\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("/*2nulleȍڂŁA1ڂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY1_"
                    + (index + 1) + "_NULLABLE (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index]);
            fWriter.println(", FIELD_VARCHAR_FIXED VARCHAR(50)");
            fWriter.println(", PRIMARY KEY (FIELD_" + fieldName + ")");
            fWriter.println(");");
            fWriter.println("");
        }
    }

    private final void generateDoubleColumnPrimary2Nullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2nulleȍڂŁA2ڂvC}L[ł\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("/*2nulleȍڂŁA2ڂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY2_"
                    + (index + 1) + "_NULLABLE (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index]);
            fWriter.println(", FIELD_VARCHAR_FIXED VARCHAR(50)");
            fWriter.println(", PRIMARY KEY (FIELD_VARCHAR_FIXED)");
            fWriter.println(");");
            fWriter.println("");
        }
    }

    private final void generateDoubleColumnPrimary3Nullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2nulleȍڂŁA2ƂvC}L[ł\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("/*2nulleȍڂŁAƂvC}L[̕\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_DOUBLE_COLUMN_PRIMARY3_"
                    + (index + 1) + "_NULLABLE (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index]);
            fWriter.println(", FIELD_VARCHAR_FIXED VARCHAR(50)");
            fWriter.println(", PRIMARY KEY (FIELD_" + fieldName
                    + ", FIELD_VARCHAR_FIXED)");
            fWriter.println(");");
            fWriter.println("");
        }
    }

    private final void generateDoubleColumnNonPrimaryNullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2nulleȍڂŁA2ƂvC}L[łȂ\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("/*2nulleȍڂŁAƂvC}L[łȂ\𐶐܂B("
                    + TypesOfSQLServer2005.TYPES[index] + ")*/");
            fWriter.println("CREATE TABLE TEST_DOUBLE_COLUMN_NON_PRIMARY_"
                    + (index + 1) + "_NULLABLE (");
            fWriter.println("FIELD_" + fieldName + " "
                    + TypesOfSQLServer2005.TYPES[index]);
            fWriter.println(", FIELD_VARCHAR_FIXED VARCHAR(50)");
            fWriter.println(");");
            fWriter.println("");
        }
    }

    // ͍폜GAłB
    // 폜pDDL𐶐܂B

    private final void generateDeleteDoubleColumnPrimary1() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2̍ڂŁA1ڂ̃vC}L[ɂ\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY1_"
                    + (index + 1) + ";");
        }
    }

    private final void generateDeleteDoubleColumnPrimary2() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2̍ڂŁA2ڂ̃vC}L[ɂ\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY2_"
                    + (index + 1) + ";");
        }
    }

    private final void generateDeleteDoubleColumnPrimary3() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2̍ڂŁA2ƂvC}L[ł\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY3_"
                    + (index + 1) + ";");
        }
    }

    private final void generateDeleteDoubleColumnNonPrimary() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2̍ڂŁA2ƂvC}L[łȂ\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("DROP TABLE TEST_DOUBLE_COLUMN_NON_PRIMARY_"
                    + (index + 1) + ";");
        }
    }

    private final void generateDeleteDoubleColumnPrimary1Nullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2nulleȍڂŁA1ڂvC}L[ł\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY1_"
                    + (index + 1) + "_NULLABLE;");
        }
    }

    private final void generateDeleteDoubleColumnPrimary2Nullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2nulleȍڂŁA2ڂvC}L[ł\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY2_"
                    + (index + 1) + "_NULLABLE;");
        }
    }

    private final void generateDeleteDoubleColumnPrimary3Nullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2nulleȍڂŁA2ƂvC}L[ł\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TypesOfSQLServer2005.TYPES[index])
                    || "NTEXT".equals(TypesOfSQLServer2005.TYPES[index])
                    || "TEXT".equals(TypesOfSQLServer2005.TYPES[index])) {
                fWriter.println("-- " + TypesOfSQLServer2005.TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                fWriter.println("");
                continue;
            }

            fWriter.println("DROP TABLE TEST_DOUBLE_COLUMN_PRIMARY3_"
                    + (index + 1) + "_NULLABLE;");
        }
    }

    private final void generateDeleteDoubleColumnNonPrimaryNullable() {
        fWriter.println("------------------------------------------");
        fWriter.println("-- 2nulleȍڂŁA2ƂvC}L[łȂ\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println("DROP TABLE TEST_DOUBLE_COLUMN_NON_PRIMARY_"
                    + (index + 1) + "_NULLABLE;");
        }
    }
}
