/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * blanco FrameworkɂAXg[Ɋւ郆[eBeB܂܂܂B
 * 
 * ƂĂقƂǂ̃\bhstatic\bhƂĒ񋟂܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoStreamUtil {
    /**
     * ^ꂽXg[oCgzɕϊ܂B
     * 
     * ByteArrayInputStream̋ťʂ𓾂邽߂̃\bhłB
     * 
     * @param inStream
     *            ̓Xg[B
     * @return ϊ̃oCgzB
     * @throws IOException
     *             o͗OꍇB
     */
    public static byte[] stream2Bytes(final InputStream inStream)
            throws IOException {
        if (inStream == null) {
            throw new IllegalArgumentException(
                    "̓Xg[oCgzɕϊ郁\bhɓ̓Xg[Ƃnull^܂BnullȊO̒l^ĂB");
        }

        final ByteArrayOutputStream result = new ByteArrayOutputStream();

        // Xg[̃Rs[s܂B
        copy(inStream, result);

        result.flush();
        return result.toByteArray();
    }

    /**
     * ^ꂽ̓Xg[o̓Xg[ւƃRs[܂B
     * 
     * obt@TCY8192oCgŃXg[ubNRs[܂B<br>
     * ̃\bh̓ł̓tbV͍s܂BKvɉČĂяo\bhɂ flush()ĂB
     * 
     * @param inStream
     *            ̓Xg[B
     * @param outStream
     *            o̓Xg[B
     * @throws IOException
     *             o͗OꍇB
     */
    public static final void copy(final InputStream inStream,
            final OutputStream outStream) throws IOException {
        if (inStream == null) {
            throw new IllegalArgumentException(
                    "BlancoStreamUtil.copy\bh̓̓Xg[p[^null^܂BnullȊO̒lw肵ĂB");
        }
        if (outStream == null) {
            throw new IllegalArgumentException(
                    "BlancoStreamUtil.copy\bh̏o̓Xg[p[^null^܂BnullȊO̒lw肵ĂB");
        }

        final byte[] buf = new byte[8192];
        for (;;) {
            final int length = inStream.read(buf, 0, buf.length);
            if (length < 0) {
                break;
            }
            outStream.write(buf, 0, length);
        }
    }
}
