/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.db;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import blanco.commons.calc.parser.BlancoCalcParser;

public abstract class BlancoDbMeta2Xml implements IBlancoDbProgress {

    /**
     * ^񂩂璆ԃt@CłXML쐬܂B
     * 
     * @author IGA Tosiki
     */
    public static void main(final String[] args) {
        new File("tmp/db").mkdirs();

        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(
                    "./meta/db/template/blancoDbTemplate.xls"));
            outStream = new BufferedOutputStream(new FileOutputStream(
                    "./tmp/db/aaa.xml"));

            new BlancoDbMeta2Xml() {
                public boolean progress(int progressCurrent, int progressTotal,
                        String progressItem) {
                    return true;
                }
            }.process(inStream, outStream);
            outStream.flush();
            outStream.close();
            outStream = null;
        } catch (IOException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void process(final InputStream inStreamMetaSource,
            final OutputStream outStreamTarget) throws TransformerException,
            IOException {
        InputStream inStreamDef = null;
        try {
            inStreamDef = new BufferedInputStream(getClass().getClassLoader()
                    .getResourceAsStream("blanco/db/BlancoDbMeta2Xml.xml"));
            new BlancoCalcParser().process(inStreamDef, inStreamMetaSource,
                    outStreamTarget);
        } finally {
            if (inStreamDef != null)
                inStreamDef.close();
        }
    }
}
