/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;

import blanco.db.mapping.BlancoDbMappingUtil;

/**
 * @author Yasuo Nakanishi
 * @author Tosiki Iga {IɌver.1 2005.05.06
 */
public class FieldFactory {

    public boolean isSupportedDatabaseType(final ResultSet resultSet)
            throws SQLException {
        return isSupportedDatabaseType(resultSet.getInt("DATA_TYPE"));
    }

    public boolean isSupportedDatabaseType(final int type) {
        boolean result = false;

        switch (type) {
        case java.sql.Types.CHAR:
        case java.sql.Types.VARCHAR:
        case java.sql.Types.LONGVARCHAR:
        case java.sql.Types.BINARY:
        case java.sql.Types.DATE:
        case java.sql.Types.TIMESTAMP:
        case java.sql.Types.DECIMAL:
        case java.sql.Types.NUMERIC:
        case java.sql.Types.REAL:
        case java.sql.Types.FLOAT:
        case java.sql.Types.DOUBLE:
        case java.sql.Types.INTEGER:
        case java.sql.Types.BIGINT:
        case java.sql.Types.SMALLINT:
        case java.sql.Types.TINYINT:
        case java.sql.Types.BIT:
        case java.sql.Types.LONGVARBINARY:
            result = true;
            break;
        default:
            // T|[gĂ܂B
            break;
        }
        return result;
    }

    /**
     * JDBČ^Javǎ^}bsOӏłB <br>
     * TODO I nulleڂƔnullڂƂŌ^}bv̎gȂǂKvłB
     */
    public TableField createTableField(final ResultSet resultSet)
            throws SQLException {
        // assert isSupportedDatabaseType(resultSet);

        final int type = resultSet.getInt("DATA_TYPE");
        final String name = resultSet.getString("COLUMN_NAME");

        TableField result = null;

        final int isNullable = resultSet.getInt("NULLABLE");

        switch (type) {
        case java.sql.Types.CHAR:
        case java.sql.Types.VARCHAR:
            result = new TableField(String.class, name);
            result.setSize(resultSet.getInt("CHAR_OCTET_LENGTH"));
            break;
        case java.sql.Types.LONGVARCHAR:
            result = new TableField(java.io.Reader.class, name);
            break;
        case java.sql.Types.DATE:
        case java.sql.Types.TIME:
        case java.sql.Types.TIMESTAMP:
            // TODO DATETIMESTAMP؂^DateɂȂ̂ǂ̍l@KvB
            result = new TableField(Date.class, name);
            break;
        case java.sql.Types.REAL:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new TableField(float.class, name);
            } else {
                result = new TableField(Float.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.FLOAT:
        case java.sql.Types.DOUBLE:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new TableField(double.class, name);
            } else {
                result = new TableField(Double.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.DECIMAL:
        case java.sql.Types.NUMERIC:
            // DECIMALNUMERICƂ̍ق́ASuñ}bv\ɂ͌Ȃ
            result = new TableField(BigDecimal.class, name);
            result.setScale(resultSet.getInt("DECIMAL_DIGITS"));
            break;
        case java.sql.Types.INTEGER:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new TableField(int.class, name);
            } else {
                result = new TableField(Integer.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.BIGINT:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new TableField(long.class, name);
            } else {
                result = new TableField(Long.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.SMALLINT:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new TableField(short.class, name);
            } else {
                result = new TableField(Short.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.TINYINT:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new TableField(byte.class, name);
            } else {
                result = new TableField(Byte.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.BIT:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new TableField(boolean.class, name);
            } else {
                result = new TableField(Boolean.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.BINARY:
        case java.sql.Types.LONGVARBINARY:
            result = new TableField(InputStream.class, name);
            break;
        default:
        // assert false : "\Ȃlnꂽ";
        }
        result.setJdbcType(type);
        result.setSize(resultSet.getInt("COLUMN_SIZE"));

        result.setNullable(resultSet.getInt("NULLABLE"));

        return result;
    }

    /**
     * JDBČ^Javǎ^}bsOӏłB <br>
     * TODO I nulleڂƔnullڂƂŌ^}bv̎gȂǂKvłB
     */
    public QueryField createQueryField(final int index,
            final ResultSetMetaData meta) throws SQLException {
        // assert isSupportedDatabaseType(meta.getColumnType(index));

        final int type = meta.getColumnType(index);
        final String name = meta.getColumnName(index);

        QueryField result = null;

        final int isNullable = meta.isNullable(index);

        switch (type) {
        case java.sql.Types.CHAR:
        case java.sql.Types.VARCHAR:
            result = new QueryField(String.class, name);
            break;
        case java.sql.Types.LONGVARCHAR:
            result = new QueryField(java.io.Reader.class, name);
            break;
        case java.sql.Types.DATE:
        case java.sql.Types.TIME:
        case java.sql.Types.TIMESTAMP:
            // TODO DATETIMESTAMP؂^DateɂȂ̂ǂ̍l@KvB
            result = new QueryField(Date.class, name);
            break;
        case java.sql.Types.REAL:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new QueryField(float.class, name);
            } else {
                result = new QueryField(Float.class, name);
            }
            break;
        case java.sql.Types.FLOAT:
        case java.sql.Types.DOUBLE:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new QueryField(double.class, name);
            } else {
                result = new QueryField(Double.class, name);
            }
            break;
        case java.sql.Types.DECIMAL:
        case java.sql.Types.NUMERIC:
            // DECIMALNUMERICƂ̍ق́ASuñ}bv\ɂ͌Ȃ
            result = new QueryField(BigDecimal.class, name);
            result.setPrecision(meta.getPrecision(index));
            result.setScale(meta.getScale(index));
            break;
        case java.sql.Types.INTEGER:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new QueryField(int.class, name);
            } else {
                result = new QueryField(Integer.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.BIGINT:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new QueryField(long.class, name);
            } else {
                result = new QueryField(Long.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.SMALLINT:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new QueryField(short.class, name);
            } else {
                result = new QueryField(Short.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.TINYINT:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new QueryField(byte.class, name);
            } else {
                result = new QueryField(Byte.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.BIT:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
                result = new QueryField(boolean.class, name);
            } else {
                result = new QueryField(Boolean.class, name);
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.BINARY:
        case java.sql.Types.LONGVARBINARY:
            result = new QueryField(InputStream.class, name);
            break;
        default:
            System.out.println("^`FbN: T|[gĂȂ^^܂: "
                    + BlancoDbMappingUtil.convertJdbcTypeToString(type));
            // assert false : "\Ȃlnꂽ";
            break;
        }
        result.setJdbcType(type);

        // e탁^L܂B
        // 2005.05.01 tosiki iga
        result.setNullable(isNullable);
        result.setReadOnly(meta.isReadOnly(index));
        result.setWritable(meta.isWritable(index));
        result.setDefinitelyWritable(meta.isDefinitelyWritable(index));

        result.setSize(meta.getColumnDisplaySize(index));

        return result;
    }
}