/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;

import blanco.db.definition.QueryCaller;
import blanco.db.mapping.BlancoDbMappingUtil;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.db.util.BlancoDbQueryParserUtil;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class GetCallerOutputParameterMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private QueryCaller _caller = null;

    public GetCallerOutputParameterMethod(final BlancoDbObjectStorage storage,
            final QueryCaller caller) {
        super("getOutputParameter");
        _caller = caller;
        this.storage = storage;
    }

    public void setupSignature() {
        addException(SQLException.class);

        getJavaDoc().addLine("XgAhvV[W̎sʂ̏o̓p[^擾܂B");
        getJavaDoc().addLine("XgAhvV[W̎sʂƂĖ߂Ƃł̂͒lЂƂłB");

        final Iterator ite = _caller.getOutParameterIterator();
        while (ite.hasNext()) {
            final Value val = (Value) ite.next();
            setReturnType(val.getType());
        }
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            getData().addLine("if (fLog.isDebugEnabled()) {");
            getData().addLine("fLog.debug(\"" + getName() + "\");");
            getData().addLine("}");
            getData().addLine("");
        }

        getJavaDoc().addLine("NGɗ^̓p[^Zbg܂B");

        final BlancoDbQueryParserUtil query = new BlancoDbQueryParserUtil(
                _caller.getQuery());

        final Iterator ite = _caller.getOutParameterIterator();
        while (ite.hasNext()) {
            // TODO: SQLp[^𔭌ȂĂ͂Ȃ܂B
            // AƂ肠^ꂽœoƉ肪Ă܂B
            final Value val = (Value) ite.next();

            final int[] listCol = query.getSqlParameters(val.getName());
            if (listCol == null) {
                System.out.println("[" + _caller.getName() + "] SQLo̓p[^["
                        + val.getName() + "]тĂ܂.");
                continue;
            }
            for (int iteSame = 0; iteSame < listCol.length; iteSame++) {
                final int index = listCol[iteSame];
                final String type = BlancoDbMappingUtil
                        .getResultSetGetterMethodName(val.getType().getName());
                if (val.getType().getName().equals("Date")) {
                    implementor.addUsingType(new Type(Timestamp.class));
                }

                if (BlancoDbMappingUtil.isMapWrapperClassNecessity(val
                        .getType().getName())) {
                    getData().addLine(
                            val.getType().getName()
                                    + " wrk = "
                                    + BlancoDbMappingUtil
                                            .mapWrapperClassForPrimitive(
                                                    "fStatement." + type + "("
                                                            + index + ")", val
                                                            .getType()
                                                            .getName()) + ";");
                    getData().addLine("if (fStatement.wasNull()) {");
                    getData().addLine("return null;");
                    getData().addLine("}");
                    getData().addLine("return wrk;");
                } else {
                    getData().addLine(
                            "return fStatement." + type + "(" + index + ");");
                }
            }
        }
    }
}