/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.ResultSet;

import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class GetResultSetMethod extends MethodExpander {
    private Value _resultSet = null;

    public GetResultSetMethod(final BlancoDbObjectStorage storage) {
        super("getResultSet");
        _resultSet = new Value(ResultSet.class, "fResultSet");
    }

    public void setupSignature() {
        setReturnType(_resultSet.getType());

        getJavaDoc().addLine("ResultSet擾܂B");
        getJavaDoc().addLine("@deprecated {IResultSet𒼐ڗpKv͂܂B");
        getJavaDoc().addReturn("ResultSetIuWFNg");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        implementor.addReturn(_resultSet);
    }
}