/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.SQLException;

import blanco.db.definition.QueryIterator;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class UpdateRowMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    public UpdateRowMethod(final BlancoDbObjectStorage storage,
            final QueryIterator iterator) {
        super("updateRow");
        this.storage = storage;
    }

    public void setupSignature() {
        final Type integrityConstraintException = new Type(storage.getSetting()
                .getRootNameSpace()
                + ".exception.IntegrityConstraintException");
        addException(integrityConstraintException);
        addUsingType(integrityConstraintException);

        addException(SQLException.class);

        getJavaDoc().addLine("݂̍s̐VeŃf[^x[XXV܂<br>");
        getJavaDoc().addLine(
                "f[^x[Xᔽꍇɂ IntegrityConstraintException O܂B");
    }

    /**
     * Rg <br>
     * 
     * PostgreSQLɂ FOR UPDATEJ[\updateRowĂяoۂ ᔽ̍ۂɂ́ASQLState[23505],
     * ErrorCode [0] ܂B <br>
     * java.sql.SQLException: ERROR: duplicate key violates unique constraint
     * "ract007_ketsugo_model_pkey" at
     * org.postgresql.core.v3.QueryExecutorImpl.receiveErrorResponse(QueryExecutorImpl.java:1471)
     */
    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        // ׂƓWJ܂B
        implementor.addLine("try{");
        implementor.addLine("fResultSet.updateRow();");
        implementor.addLine("} catch (SQLException ex) {");
        implementor
                .addLine("if (ex.getSQLState() != null && ex.getSQLState().startsWith(\"23\")) {");
        implementor
                .addLine("final IntegrityConstraintException exBlanco = new IntegrityConstraintException(\"ᔽɂύXɎs܂B:\" + ex.toString(), ex.getSQLState(), ex.getErrorCode());");
        implementor.addLine("exBlanco.initCause(ex);");
        implementor.addLine("throw exBlanco;");
        implementor.addLine("}");
        implementor.addLine("throw ex;");
        implementor.addLine("}");
    }
}