/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class ExecuteMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    public ExecuteMethod(final BlancoDbObjectStorage storage) {
        super("execute");
        this.storage = storage;
    }

    public void setupSignature() {
        // ^CpbP[W̕ωɑΉB
        String runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }

        final Type integrityConstraintException = new Type(runtimePackage
                + ".exception.IntegrityConstraintException");
        getJavaDoc().addException(integrityConstraintException,
                "f[^x[XᔽꍇB");
        addException(integrityConstraintException);

        final Type deadlockException = new Type(runtimePackage
                + ".exception.DeadlockException");
        getJavaDoc().addException(deadlockException, "f[^x[XfbhbNꍇB");
        addException(deadlockException);

        final Type timeoutException = new Type(runtimePackage
                + ".exception.TimeoutException");
        getJavaDoc().addException(timeoutException, "f[^x[X^CAEgꍇB");
        addException(timeoutException);

        getJavaDoc().addException(new Type("java.sql.SQLException"),
                "SQLOꍇB");
        addException(new Type("java.sql.SQLException"));

        getJavaDoc().addLine("XgAhvV[Ws܂B<br>");

        getJavaDoc().addReturn("CallableStatement.execute\bh̖߂lB");
        setReturnType(new Type("boolean"));
    }

    public void implement() {
        if (storage.getSetting().isLogging()) {
            getData().addLine("if (fLog.isDebugEnabled()) {");
            getData().addLine("fLog.debug(\"" + getName() + "\");");
            getData().addLine("}");
            getData().addLine("");
        }

        getData().addLine("if (fStatement == null) {");
        getData()
                .addLine(
                        "// CallableStatement擾̏ԂȂ̂ŁACallableStatement.execute()sɐ旧prepareCall()\bhĂяoĎ擾܂B");
        getData().addLine("prepareCall();");
        getData().addLine("}");

        // O܂߂ēWJ܂B
        getData().addLine("");
        getData().addLine("// execute\bh̎sʂɂĂ͈ȂƂƂ܂B");
        getData().addLine("try {");
        getData().addLine("return fStatement.execute();");
        getData().addLine("} catch (SQLException ex) {");
        getData().addLine("throw BlancoDbUtil.convertToBlancoException(ex);");
        getData().addLine("}");
    }
}