/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.sax;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;

import javax.xml.transform.sax.SAXResult;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.MethodExpander;
import blanco.ig.generator.GeneratorSetting;
import blanco.ig.generator.ImplementGenerator;
import blanco.sax.util.BlancoSaxUtil;

/**
 * ͗pXML͂ċۉSAXC^[̃eXgNX𐶐܂B<br>
 * ̃NXł́AConcreteSaxSerializer𐶐܂B<br>
 * <br>
 * ͂͗pXMLt@ĆAӓIȂ̂܂B_ł ȂIȂ̂ɂȂ܂B<br>
 * 1: ͗pXML̃Agr[gׂ͂Ďw肳ė̂Ɖ肵܂B<br>
 * 2: قȂKwɂēÕGeBeB݂Ȃ̂Ɖ肵܂B<br>
 * Ql:http://java.sun.com/j2se/1.5.0/ja/docs/ja/api/org/xml/sax/ContentHandler.html<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoSaxXml2HandlerTest {
    /**
     * oꂵGgׂĂL܂B<br>
     * 2xڂɓoꂵGg𖳎邽߂ɂp܂B
     */
    private final Hashtable totalElementHashtable = new Hashtable();

    /**
     * eXgp̃Gg|Cg
     * 
     * @param args
     */
    public static void main(String[] args) {
        try {
            new BlancoSaxXml2HandlerTest().process(new File(
                    BlancoSaxXml2Handler.MAIN_INPUT_FILENAME), "blanco",
                    "sample", "AaaHandler");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * \[XR[hs܂B
     * 
     * @param sourceFile
     * @param targetDirectory
     * @param packageName
     * @param className
     * @throws IOException
     */
    public void process(final File sourceFile, final String targetDirectory,
            final String packageName, final String className)
            throws IOException {
        // Java\[XR[h𐶐̂߂̐ݒ
        GeneratorSetting setting = new GeneratorSetting();
        // o͐fBNgݒ肵܂B
        setting.setWorkDirectory(targetDirectory);
        ImplementGenerator implementGenerator = new ImplementGenerator(setting);
        // 쐬NXo^܂B
        implementGenerator.addTest(getClassExpander(sourceFile, packageName,
                className));
        // ۂɃ\[XR[hs܂B
        implementGenerator.generate();
        // System.out.println("\[XR[h܂B");
    }

    /**
     * ̃NXWJs܂B
     * 
     * @param sourceFile
     * @param packageName
     * @param className
     * @return
     * @throws IOException
     */
    private ClassExpander getClassExpander(final File sourceFile,
            final String packageName, final String className)
            throws IOException {
        BufferedReader readerXml = null;
        StringBuffer xmlImageWrk = new StringBuffer();
        try {
            readerXml = new BufferedReader(new InputStreamReader(
                    new FileInputStream(sourceFile), "UTF-8"));
            for (;;) {
                int iRead = readerXml.read();
                if (iRead < 0) {
                    break;
                }
                if (iRead == '\r') {
                    continue;
                }
                xmlImageWrk.append((char) iRead);
            }
        } finally {
            if (readerXml != null) {
                readerXml.close();
            }
        }
        final String xmlImage = xmlImageWrk.toString();

        return new ClassExpander(new Type(packageName, className + "Test")) {
            protected void expandClassStruct() {
                addFileComment(className + "ۉSAXNXeXgNX<br>");
                getJavaDoc().addLine(className + "ۉSAXNXeXgNX<br>");
                getJavaDoc()
                        .addLine("SAX𗘗pXMLǂݍ݂bsONX̃eXgNXłB<br>");
                getJavaDoc().addLine(
                        "̃NX͉͗pXMLt@C͂ƂċۉSAXNXƂĐ܂B<br>");
                getJavaDoc().addLine("̃\[XR[hblancoIgɂ@BIɎĂ܂B");
                setSuperClass(new Type("junit.framework.TestCase"));

                addMethod(new MethodExpander("testHandler") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        addUsingType(new Type("java.io.BufferedInputStream"));
                        addUsingType(new Type("java.io.ByteArrayInputStream"));
                        addUsingType(new Type("java.io.InputStream"));
                        addUsingType(new Type("javax.xml.transform.Transformer"));
                        addUsingType(new Type(
                                "javax.xml.transform.TransformerFactory"));
                        addUsingType(new Type(
                                "javax.xml.transform.sax.SAXResult"));
                        addUsingType(new Type(
                                "javax.xml.transform.stream.StreamSource"));
                        addUsingType(new Type("org.xml.sax.SAXException"));

                        addException(new Type("java.lang.Exception"));

                        // tB[hϐ錾܂B
                        FieldExpander field1 = new FieldExpander(new Type(
                                "java.lang.String"), "fXmlImage") {
                            protected Scope getScope() {
                                return Scope.PUBLIC;
                            }

                            protected boolean isStatic() {
                                return true;
                            }

                            protected boolean isFinal() {
                                return true;
                            }
                        };
                        field1.setLiteralValue(BlancoJavaSourceUtil
                                .escapeStringAsJavaSource(xmlImage));
                        field1.getJavaDoc().addLine("eXgpXMLf[^ł<br>");
                        field1.getJavaDoc().addLine(
                                "ꂪXML\͂ۂ̓̓f[^ł܂B");
                        addField(field1);
                    }

                    public void implement() {
                        getData().addLine(
                                "SAXResult result = new SAXResult(new "
                                        + className + "() {");

                        SAXResult result = new SAXResult(new ContentHandler() {
                            public void endDocument() throws SAXException {
                                getData().addLine("});");
                                getData().addLine("");

                                getData().addLine(
                                        "InputStream inStream = null;");
                                getData().addLine("try {");
                                getData()
                                        .addLine(
                                                "inStream = new BufferedInputStream(new ByteArrayInputStream(fXmlImage.getBytes()));");
                                getData()
                                        .addLine(
                                                "TransformerFactory tf = TransformerFactory.newInstance();");
                                getData()
                                        .addLine(
                                                "Transformer transformer = tf.newTransformer();");
                                getData()
                                        .addLine(
                                                "transformer.transform(new StreamSource(inStream), result);");
                                getData().addLine("} finally {");
                                getData().addLine("if (inStream != null) {");
                                getData().addLine("inStream.close();");
                                getData().addLine("}");
                                getData().addLine("}");
                            }

                            public void startDocument() throws SAXException {
                                getData()
                                        .addLine(
                                                "public void startDocument() throws SAXException {");
                                getData().addLine("}");
                                getData().addLine("");
                                getData()
                                        .addLine(
                                                "public void endDocument() throws SAXException {");
                                getData().addLine("}");
                            }

                            public void characters(char[] ch, int start,
                                    int length) throws SAXException {
                            }

                            public void ignorableWhitespace(char[] arg0,
                                    int arg1, int arg2) throws SAXException {
                            }

                            public void endPrefixMapping(String arg0)
                                    throws SAXException {
                            }

                            public void skippedEntity(String arg0)
                                    throws SAXException {
                            }

                            public void setDocumentLocator(Locator arg0) {
                            }

                            public void processingInstruction(String arg0,
                                    String arg1) throws SAXException {
                            }

                            public void startPrefixMapping(String arg0,
                                    String arg1) throws SAXException {
                            }

                            public void startElement(String arg0, String arg1,
                                    String qName, Attributes atts)
                                    throws SAXException {
                                if (totalElementHashtable.get(qName) != null) {
                                    // łɓoꂵGgłB
                                    // ̓XLbv܂B
                                    return;
                                }
                                totalElementHashtable.put(qName, "found");

                                String lineStatement = "public void startElement"
                                        + BlancoNameAdjuster.toClassName(qName)
                                        + "(String uri, String localName, String qName";
                                String attrList = "";
                                for (int index = 0; index < atts.getLength(); index++) {
                                    lineStatement += ", ";
                                    lineStatement += "String attr"
                                            + BlancoNameAdjuster
                                                    .toClassName(atts
                                                            .getQName(index));
                                    attrList += ": "
                                            + atts.getQName(index)
                                            + "[\" + attr"
                                            + BlancoNameAdjuster
                                                    .toClassName(atts
                                                            .getQName(index))
                                            + " + \"]";
                                }
                                lineStatement += ") throws SAXException {";
                                getData().addLine(lineStatement);
                                getData().addLine(
                                        "System.out.println(\"start: " + qName
                                                + attrList + "\");");
                                getData().addLine("}");

                                getData().addLine("");

                                getData()
                                        .addLine(
                                                "public void endElement"
                                                        + BlancoNameAdjuster
                                                                .toClassName(qName)
                                                        + "(String uri, String localName, String qName"
                                                        + ") throws SAXException {");
                                getData().addLine(
                                        "System.out.println(\"end: " + qName
                                                + "\");");
                                getData().addLine("}");
                                getData().addLine("");
                                getData()
                                        .addLine(
                                                "public void characters"
                                                        + BlancoNameAdjuster
                                                                .toClassName(qName)
                                                        + "(char[] ch, int start, int length) throws SAXException {");
                                getData()
                                        .addLine(
                                                "System.out.println(\"characters: "
                                                        + qName
                                                        + "[\" + new String(ch, start, length) + \"]\");");
                                getData().addLine("}");
                                getData().addLine("");
                                getData()
                                        .addLine(
                                                "public void ignorableWhitespace"
                                                        + BlancoNameAdjuster
                                                                .toClassName(qName)
                                                        + "(char[] ch, int start, int length) throws SAXException {");
                                getData().addLine("}");
                                getData().addLine("");
                            }

                            public void endElement(String arg0, String arg1,
                                    String arg2) throws SAXException {
                            }
                        });

                        BlancoSaxUtil.doTransform(sourceFile, result);
                    }
                });
            }
        };
    }
}
