/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.valueobject;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.SAXException;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.method.MethodExpander;
import blanco.valueobject.concretesax.BlancoValueObjectHandler;

public class BlancoValueObjectXml2JavaClass {

    /**
     * @param args
     */
    public static void main(String[] args) {
        try {
            new BlancoValueObjectXml2JavaClass().process(new File(
                    "./meta/valueobject/BlancoValueObject.xml"), new File(
                    "blanco"));
        } catch (IOException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        }
        System.out.println("SĂ̏");
    }

    public void process(File fileSource, final File directoryTarget)
            throws IOException, TransformerException {
        SAXResult result = new SAXResult(new BlancoValueObjectHandler() {
            private ClassStructure _class = null;

            private ArrayList listField = new ArrayList();

            private FieldStructure field = null;

            private String javadoc = null;

            public void startDocument() throws SAXException {
            }

            public void endDocument() throws SAXException {
            }

            public void startElementBlanco(String uri, String localName,
                    String qName, String attrVersion) throws SAXException {
                // System.out.println("start: blanco: version[" + attrVersion
                // + "]");
            }

            public void endElementBlanco(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersBlanco(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceBlanco(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementTarget(String uri, String localName,
                    String qName, String attrName) throws SAXException {
            }

            public void endElementTarget(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersTarget(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceTarget(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementFile(String uri, String localName,
                    String qName) throws SAXException {
                // System.out.println("start: file");
            }

            public void endElementFile(String uri, String localName,
                    String qName) throws SAXException {
                // System.out.println("end: file");
            }

            public void charactersFile(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceFile(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void startElementComment(String uri, String localName,
                    String qName) throws SAXException {
                // System.out.println("start: comment");
            }

            public void endElementComment(String uri, String localName,
                    String qName) throws SAXException {
                // System.out.println("end: comment");
            }

            public void charactersComment(char[] ch, int start, int length)
                    throws SAXException {
                // System.out.println("characters: comment["
                // + new String(ch, start, length) + "]");
                _class._filecomment = new String(ch, start, length);
            }

            public void ignorableWhitespaceComment(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementClass(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementClass(String uri, String localName,
                    String qName) throws SAXException {
                if (javadoc != null) {
                    _class._javadoc = javadoc;
                    javadoc = null;
                }
            }

            public void charactersClass(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceClass(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementJavadoc(String uri, String localName,
                    String qName) throws SAXException {
                // System.out.println("start: javadoc");
            }

            public void endElementJavadoc(String uri, String localName,
                    String qName) throws SAXException {
                // System.out.println("end: javadoc");
            }

            public void charactersJavadoc(char[] ch, int start, int length)
                    throws SAXException {
                // System.out.println("characters: javadoc["
                // + new String(ch, start, length) + "]");
                javadoc = new String(ch, start, length);
            }

            public void ignorableWhitespaceJavadoc(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementField(String uri, String localName,
                    String qName, String attrName, String attrType)
                    throws SAXException {
                // System.out.println("start: field: name[" + attrName
                // + "]: type[" + attrType + "]");
                field = new FieldStructure();
                field._name = attrName;
                field._type = attrType;
                // ŃXgɋL܂B
                listField.add(field);
            }

            public void endElementField(String uri, String localName,
                    String qName) throws SAXException {
                // System.out.println("end: field");
                if (javadoc != null) {
                    field._javadoc = javadoc;
                    javadoc = null;
                }
            }

            public void charactersField(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceField(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementDefault(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementDefault(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersDefault(char[] ch, int start, int length)
                    throws SAXException {
                field._default = new String(ch, start, length);
            }

            public void ignorableWhitespaceDefault(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementBlancovalueobject(String uri,
                    String localName, String qName, String attrName,
                    String attrPackage) throws SAXException {
                _class = new ClassStructure();
                _class._name = attrName;
                _class._package = attrPackage;
            }

            public void endElementBlancovalueobject(String uri,
                    String localName, String qName) throws SAXException {
                try {
                    processJavaSource(_class, listField, directoryTarget);
                } catch (Exception ex) {
                    throw new SAXException(ex);
                }
            }

            public void charactersBlancovalueobject(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceBlancovalueobject(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void startElementPattern(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementPattern(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersPattern(char[] ch, int start, int length)
                    throws SAXException {
                field._pattern = new String(ch, start, length);
            }

            public void ignorableWhitespacePattern(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementMinLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementMinLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersMinLength(char[] ch, int start, int length)
                    throws SAXException {
                field._minLength = new String(ch, start, length);
            }

            public void ignorableWhitespaceMinLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementMaxLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementMaxLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersMaxLength(char[] ch, int start, int length)
                    throws SAXException {
                field._maxLength = new String(ch, start, length);
            }

            public void ignorableWhitespaceMaxLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersLength(char[] ch, int start, int length)
                    throws SAXException {
                field._length = new String(ch, start, length);
            }

            public void ignorableWhitespaceLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementMinInclusive(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementMinInclusive(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersMinInclusive(char[] ch, int start, int length)
                    throws SAXException {
                field._minInclusive = new String(ch, start, length);
            }

            public void ignorableWhitespaceMinInclusive(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementMaxInclusive(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementMaxInclusive(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersMaxInclusive(char[] ch, int start, int length)
                    throws SAXException {
                field._maxInclusive = new String(ch, start, length);
            }

            public void ignorableWhitespaceMaxInclusive(char[] ch, int start,
                    int length) throws SAXException {
            }
        });

        InputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(fileSource));
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    class ClassStructure {
        public String _name;

        public String _package;

        public String _javadoc;

        public String _filecomment;
    }

    class FieldStructure {
        public String _name;

        public String _type;

        public String _default;

        public String _javadoc;

        public String _pattern;

        public String _minLength;

        public String _maxLength;

        public String _length;

        public String _minInclusive;

        public String _maxInclusive;
    }

    /**
     * JavaDocƂĕGXP[v܂B
     * 
     * @param arg
     * @return
     */
    public static final String[] escapeStringAsJavaDoc(final String arg) {
        final ArrayList result = new ArrayList();
        final StringReader reader = new StringReader(arg);
        StringWriter writer = new StringWriter();
        try {
            for (;;) {
                final int iRead = reader.read();
                if (iRead < 0) {
                    break;
                }
                switch (iRead) {
                case '<':
                    writer.write("&gt;");
                    break;
                case '>':
                    writer.write("&lt;");
                    break;
                case '&':
                    writer.write("&amp;");
                    break;
                case '\r':
                    // ܂B
                    break;
                case '\n':
                    writer.write("<br>");
                    writer.flush();
                    result.add(writer.toString().trim());
                    writer = new StringWriter();
                    break;
                default:
                    writer.write((char) iRead);
                    break;
                }
            }
            writer.flush();
            String value = writer.toString();
            if (value.length() > 0) {
                result.add(value.trim());
            }
        } catch (IOException e) {
            // ܂ 肦܂B
            e.printStackTrace();
        }
        String[] returnValue = new String[result.size()];
        result.toArray(returnValue);
        return returnValue;
    }

    private static void processJavaSource(final ClassStructure classInfo,
            final ArrayList listField, final File directoryTarget)
            throws IOException {
        final ClassExpander classExpander = new ClassExpander(new Type(
                classInfo._package, classInfo._name)) {
            protected void expandClassStruct() {
                if (classInfo._filecomment != null) {
                    String[] lines = escapeStringAsJavaDoc(classInfo._filecomment);
                    for (int index = 0; index < lines.length; index++) {
                        addFileComment(lines[index]);
                    }
                }

                if (classInfo._javadoc != null) {
                    String[] lines = escapeStringAsJavaDoc(classInfo._javadoc);
                    for (int index = 0; index < lines.length; index++) {
                        getJavaDoc().addLine(lines[index]);
                    }
                }

                for (int indexField = 0; indexField < listField.size(); indexField++) {
                    final FieldStructure field = (FieldStructure) listField
                            .get(indexField);

                    if (field._name == null) {
                        throw new IllegalArgumentException("["
                                + classInfo._name
                                + "] ŃtB[hw肳ĂȂ̂܂B");
                    }
                    if (field._type == null) {
                        throw new IllegalArgumentException("["
                                + classInfo._name + "] tB[h[" + field._name
                                + "]́u^vw肳Ă܂Bu^vw肵ĂB");
                    }

                    final String fieldNameAdjustered = BlancoNameAdjuster
                            .toClassName(field._name);

                    FieldExpander field1 = new FieldExpander(new Type(
                            field._type), "f" + fieldNameAdjustered);
                    field1.getJavaDoc().addLine(
                            "tB[h [" + field._name + "]<br>");
                    field1.getJavaDoc().addLine(
                            "ڂ̌^ [" + field._type + "]<br>");
                    if (field._default != null) {
                        field1.getJavaDoc().addLine(
                                "Kl   [" + field._default + "]<br>");
                        if (field._type.equals("java.lang.String")) {
                            field1
                                    .setDefaultStatement(new Statement(
                                            "\""
                                                    + BlancoJavaSourceUtil
                                                            .escapeStringAsJavaSource(field._default)
                                                    + "\""));
                        } else if (field._type.equals("java.util.Date")) {
                            throw new IllegalArgumentException("["
                                    + classInfo._name + "] tB[h["
                                    + field._name + "]́uftHgl("
                                    + field._default
                                    + ")vZbgĂ܂Bu^v̓ftHglT|[g܂BB");
                        } else if (field._type.equals("int")
                                || field._type.equals("long")) {
                            field1
                                    .setDefaultStatement(new Statement(
                                            BlancoJavaSourceUtil
                                                    .escapeStringAsJavaSource(field._default)));
                        } else {
                            throw new IllegalArgumentException("["
                                    + classInfo._name + "] tB[h["
                                    + field._name + "]́uftHgl("
                                    + field._default + ")vZbgĂ܂Bu"
                                    + field._type + "v̓ftHglT|[g܂BB");
                        }
                    }
                    if (field._javadoc != null) {
                        String[] lines = escapeStringAsJavaDoc(field._javadoc);
                        for (int index = 0; index < lines.length; index++) {
                            field1.getJavaDoc().addLine(lines[index]);
                        }
                    }
                    addField(field1);

                    addMethod(new MethodExpander("set" + fieldNameAdjustered) {
                        // \bh̃VOj`w
                        public void setupSignature() {
                            getJavaDoc().addLine(
                                    "tB[h [" + field._name + "]̃Zb^[\bh<br>");
                            getJavaDoc().addLine(
                                    "ڂ̌^ [" + field._type + "]<br>");
                            if (field._javadoc != null) {
                                String[] lines = escapeStringAsJavaDoc(field._javadoc);
                                for (int index = 0; index < lines.length; index++) {
                                    getJavaDoc().addLine(lines[index]);
                                }
                            }

                            getJavaDoc().addParameter(
                                    "arg" + fieldNameAdjustered,
                                    "tB[h[" + field._name + "]Ɋi[l");
                            addArgument(new Value(new Type(field._type), "arg"
                                    + fieldNameAdjustered));
                        }

                        // \bh̎
                        public void implement() {
                            getData().addLine(
                                    "f" + fieldNameAdjustered + " = " + "arg"
                                            + fieldNameAdjustered + ";");
                        }
                    });

                    addMethod(new MethodExpander("get" + fieldNameAdjustered) {
                        // \bh̃VOj`w
                        public void setupSignature() {
                            getJavaDoc().addLine(
                                    "tB[h[" + field._name + "]̃Qb^[\bh<br>");
                            getJavaDoc().addLine(
                                    "ڂ̌^ [" + field._type + "]<br>");
                            if (field._default != null) {
                                getJavaDoc().addLine(
                                        "Kl   [" + field._default + "]<br>");
                            }
                            if (field._javadoc != null) {
                                String[] lines = escapeStringAsJavaDoc(field._javadoc);
                                for (int index = 0; index < lines.length; index++) {
                                    getJavaDoc().addLine(lines[index]);
                                }
                            }

                            getJavaDoc().addReturn(
                                    "tB[h[" + field._name + "]Ɋi[Ăl");
                            setReturnType(new Type(field._type));
                        }

                        // \bh̎
                        public void implement() {
                            getData().addLine(
                                    "return f" + fieldNameAdjustered + ";");
                        }
                    });
                }
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
