/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.xsd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.commons.io.File2StreamWrapper;
import blanco.xsd.parser.AbstractTypeStructure;
import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeFieldStructure;
import blanco.xsd.parser.ComplexTypeStructure;

/**
 * XML Schema (xsd) ̑Ó؂s܂<br>
 * ł blancoSOAPŗL̃of[V`FbNs܂B<br>
 * xsdƂĐł͂ȂblancoƂĖ]܂pł邩ǂ`FbNĂ_dvłB
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdXsdValidator {
    private static final boolean IS_DEBUG = false;

    private HashMap checkedType = new HashMap();

    public static void main(String[] args) {
        try {
            new File("tmp/telegram/wsdl").mkdirs();
            new File2StreamWrapper(new File(
                    "./tmp/telegram/wsdl/TAAA0001Input.xsd"), null) {
                protected void process(InputStream inStream,
                        OutputStream outStreamIgnore) throws Exception {
                    new BlancoXsdXsdValidator().process(inStream,
                            "TAAA0001Input");
                }
            }.run();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * ^ꂽxsd̑Ó؂܂B<br>
     * łblancoL̎dl܂߂Ó`FbNs܂B
     * 
     * @param inStream
     * @param targetName
     * @return
     * @throws IOException
     * @throws TransformerException
     * @throws SAXException
     */
    public ComplexTypeStructure process(final InputStream inStream,
            final String targetName) throws IOException, TransformerException,
            SAXException {
        // xsdp[X܂B
        BlancoXsdParser parser = new BlancoXsdParser();
        final ComplexTypeStructure type = parser.process(inStream, targetName);

        // ^̂ڂĂă`FbNs܂B
        expandComplexType(type);

        checkUnprocessedType(parser.getAllKnownTypes());

        return type;
    }

    /**
     * ^ꂽ^̑Ó`FbN܂B
     * 
     * @param type
     * @throws SAXException
     * @throws IOException
     * @throws TransformerConfigurationException
     */
    private void expandComplexType(final ComplexTypeStructure type)
            throws SAXException, IOException, TransformerConfigurationException {

        if (checkedType.get(type.getName()) != null) {
            // ̌^ɂẮAς݂łB߂܂B
            // ͎ȂElement̐錾sꍇȂǂɔԂłB
            return;
        }

        checkedType.put(type.getName(), type);

        // ܂ɎQƂĂNXWJ܂B
        for (int index = 0; index < type.getListField().size(); index++) {
            final ComplexTypeFieldStructure field = (ComplexTypeFieldStructure) type
                    .getListField().get(index);

            if (field.getTypeStructure() instanceof ComplexTypeStructure) {
                expandComplexType((ComplexTypeStructure) field
                        .getTypeStructure());
            } else {
                // if (IS_DEBUG) {
                // System.out.println("^[" + field.getFieldName()
                // + "]܂B");
                // }
            }
        }

        if (IS_DEBUG) {
            System.out.println("^[" + type.getName() + "]`FbN܂");
        }

        AbstractTypeStructure typeStructureFound = null;
        for (int index = 0; index < type.getListField().size(); index++) {
            final ComplexTypeFieldStructure field = (ComplexTypeFieldStructure) type
                    .getListField().get(index);

            if (BlancoXsdUtil.isMaxOccursArray(field.getMaxOccurs())) {
                // ̏ꍇɂ͔z񈵂܂B
                typeStructureFound = field.getTypeStructure();
                if (IS_DEBUG) {
                    System.out.println("^[" + field.getFieldName() + "]͌^["
                            + field.getTypeStructure().getTypeOfJava()
                            + "]̔złB");
                }
            } else {
                if (IS_DEBUG) {
                    System.out
                            .println("^[" + field.getFieldName() + "]͕ʂ̌^["
                                    + field.getTypeStructure().getTypeOfJava()
                                    + "]łB");
                }
            }
            checkedType.put(field.getFieldName(), field.getTypeStructure());
        }

        if (type.getListField().size() > 1 && typeStructureFound != null) {
            throw new IllegalArgumentException(
                    "^["
                            + type.getName()
                            + "]ɂĔz^["
                            + typeStructureFound.getName()
                            + "]݂Ă܂BuKw`v́uMaxv2ȏ(邢unbounded)̏ꍇɂ́AdKwɕ̒`sƂ͂ł܂BuMaxv2ȏ(邢unbounded)B`ꂽuKw`vVɍ쐬ĂB");
        }
    }

    /**
     * ̕^݂Ȃǂ`FbN܂B
     * 
     * @param allKnownTypes
     */
    private void checkUnprocessedType(final LinkedHashMap allKnownTypes) {
        for (Iterator ite = allKnownTypes.values().iterator(); ite.hasNext();) {
            final AbstractTypeStructure typeLook = (AbstractTypeStructure) ite
                    .next();
            if (typeLook instanceof ComplexTypeStructure) {
                if (checkedType.get(typeLook.getName()) == null) {
                    throw new IllegalArgumentException("xsd̕^["
                            + typeLook.getName()
                            + "]錾Ăɂ炸A̕^gpĂ܂Bgp̕^łB");
                }
            }
        }
    }
}