/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.method;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Expander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.ImplementData;
import blanco.ig.expander.javadoc.MethodJavaDoc;

/**
 * @author Yasuo Nakanishi
 */
public abstract class MethodExpander extends Expander {
    private Type _returnType = new Type(void.class);

    private String _name = "";

    private List _exceptionList = new ArrayList();

    private Map _exceptionMap = new Hashtable();

    private ArrayList _arguments = new ArrayList();

    private List _code = new ArrayList();

    private MethodJavaDoc _javaDoc = new MethodJavaDoc();

    private ImplementData _data = null;

    private ClassExpander _classExpander;

    public MethodExpander(String name) {
        _name = name;
        _classExpander = null;
        _data = new ImplementData();
    }

    protected ImplementData getData() {
        return _data;
    }

    protected List getImplementList() {
        return _data.getImplementList();
    }

    protected MethodJavaDoc getJavaDoc() {
        return _javaDoc;
    }

    public List getUsingTypeList() {
        return _data.getUsingTypeList();
    }

    public void addArgument(Value argument) {
        addUsingType(argument.getType());
        _arguments.add(argument);
    }

    protected final int getArgumentCount() {
        return _arguments.size();
    }

    protected final Value getArgument(int index) {
        return (Value) _arguments.get(index);
    }

    public void addException(Type type) {
        addUsingType(type);
        if (!_exceptionMap.containsKey(type.getFullName())) {
            _exceptionList.add(type);
            _exceptionMap.put(type.getFullName(), type);
        }
    }

    public void addException(Class type) {
        addException(new Type(type));
    }

    private int getExceptionCount() {
        return _exceptionList.size();
    }

    private Type getException(int index) {
        return (Type) _exceptionList.get(index);
    }

    protected void addUsingType(Type type) {
        _data.getUsingTypeList().add(type);
    }

    protected boolean isStatic() {
        return false;
    }

    protected String makeSignature() {
        return makeSignature(false);
    }

    protected String makeSignature(boolean isConstructor) {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassExpander.INDENT);
        sb.append(getScope().get());

        if (!isConstructor) {
            if (isStatic()) {
                sb.append(" static");
            }
            if (isAbstract()) {
                sb.append(" abstract");
            }
            if (isFinal()) {
                sb.append(" final");
            }
            sb.append(" ");
            sb.append(getReturnType().getName());
        }
        sb.append(" ");
        sb.append(_name);
        sb.append("(");
        for (int i = 0; i < getArgumentCount(); i++) {
            if (i != 0) {
                sb.append(", ");
            }
            // ftHgŃ\bh̃p[^finalƂ܂B
            sb.append("final ");

            sb.append(getArgument(i).getType().getName());
            sb.append(" ");
            sb.append(getArgument(i).getName());
        }
        sb.append(")");

        if (exsistException()) {
            sb.append(" throws ");
            sb.append(makeExceptionClassList());
        }

        if (isAbstract()) {
            sb.append(";");
        } else {
            sb.append(" {");
        }
        return new String(sb);
    }

    private String makeExceptionClassList() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < getExceptionCount(); i++) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(getException(i).getName());
        }
        return new String(sb);
    }

    private boolean exsistException() {
        return _exceptionList.size() != 0;
    }

    public abstract void implement();

    public abstract void setupSignature();

    public List expand() {
        if (!_javaDoc.isEmpty()) {
            List list = _javaDoc.expand();
            for (int i = 0; i < list.size(); i++) {
                _code.add(ClassExpander.INDENT + list.get(i));
            }
        }
        _code.add(makeSignature());

        _code.addAll(_data.getImplementList());
        if (!isAbstract()) {
            _code.add(ClassExpander.INDENT + "}");
        }
        return _code;
    }

    public List getCode() {
        return _code;
    }

    public Type getReturnType() {
        return _returnType;
    }

    protected void setReturnType(Type type) {
        addUsingType(type);
        _returnType = type;
    }

    public String getName() {
        return _name;
    }

    protected Value getField(String name) {
        return _classExpander.getFieldValue(name);
    }

    public void setClassSource(ClassExpander classSource) {
        _classExpander = classSource;
        for (int i = 0; i < _data.getUsingTypeList().size(); i++) {
            _classExpander.addImport((Type) _data.getUsingTypeList().get(i));
        }
        _data.getUsingTypeList().clear();
    }

    public void clear() {
        _arguments = null;
        _code = null;
        _data = null;
        _exceptionList = null;
        _exceptionMap = null;
        _javaDoc = null;
    }
}
