<?php
// $Id: xoops_version.php,v 0.97 2009/01/10 17:58:22 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                      BmSurvey - Bluemoon Multi-Survey                     //
//                   Copyright (c) 2005 - 2007 Bluemoon inc.                 //
//                       <http://www.bluemooninc.biz/>                       //
//              Original source by : phpESP V1.6.1 James Flemer              //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
/**
 * Setup globals for later use
 */
Global $xoopsDB, $xoopsUser, $xoopsModule;
Global $xoopsModuleConfig, $xoopsMSModule;
$modhandler = &xoops_gethandler('module');
$xoopsMSModule = &$modhandler->getByDirname("bmsurvey");

$modversion['name'] = _MI_SURVEY_NAME;
$modversion['version'] = 0.97;
$modversion['description'] = _MI_SURVEY_DESC." (Irene)";
$modversion['author'] = "Yoshi Sakai";
$modversion['credits'] = "Copright(c) Bluemoon inc. "
."Based By phpESP project";
$modversion['help'] = "bmsurvey.html";
$modversion['license'] = "GPL see LICENSE";
$modversion['official'] = 0;
$modversion['image'] = "images/bmsurvey_slogo.png";
$modversion['dirname'] = "bmsurvey";

// Sql file (must contain sql generated by phpMyAdmin or phpPgAdmin)
// All tables should not have any prefix!
$modversion['sqlfile']['mysql'] = "sql/mysql.sql";
//$modversion['sqlfile']['postgresql'] = "sql/pgsql.sql";

// Tables created by sql file (without prefix!)
$modversion['tables'][0] = "bmsurvey_realm";
$modversion['tables'][1] = "bmsurvey_respondent";
$modversion['tables'][2] = "bmsurvey_designer";
$modversion['tables'][3] = "bmsurvey_survey" ;
$modversion['tables'][4] = "bmsurvey_question_type" ;
$modversion['tables'][5] = "bmsurvey_question" ;
$modversion['tables'][6] = "bmsurvey_question_choice" ;
$modversion['tables'][7] = "bmsurvey_access" ;
$modversion['tables'][8] = "bmsurvey_response" ;
$modversion['tables'][9] = "bmsurvey_response_bool" ;
$modversion['tables'][10] = "bmsurvey_response_single" ;
$modversion['tables'][11] = "bmsurvey_response_multiple" ;
$modversion['tables'][12] = "bmsurvey_response_rank" ;
$modversion['tables'][13] = "bmsurvey_response_text" ;
$modversion['tables'][14] = "bmsurvey_response_other" ;
$modversion['tables'][15] = "bmsurvey_response_date" ;


// Admin things
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = "admin/index.php";	//manage.php";
$modversion['adminmenu'] = "admin/menu.php";

$modversion['templates'][1]['file'] = 'bmsurvey_index.html';
$modversion['templates'][1]['description'] = '';
$modversion['templates'][2]['file'] = 'bmsurvey_view.html';
$modversion['templates'][2]['description'] = '';
$modversion['templates'][3]['file'] = 'bmsurvey_results.html';
$modversion['templates'][3]['description'] = '';
// Menu
$modversion['hasMain'] = 1;
if (is_object($xoopsUser) && isset($xoopsModuleConfig['MANAGERS'])){
    if (is_object($xoopsMSModule) && $xoopsMSModule->getVar('isactive')){
        $groups = $xoopsUser->getGroups();
//print_r   ($groups);
//print_r   ($xoopsModuleConfig['MANAGERS']);
        if (array_intersect($xoopsModuleConfig['MANAGERS'], $groups)){
			$modversion['sub'][1]['name'] = _MI_SURVEY_ADMIN;
			$modversion['sub'][1]['url'] = "manage.php";
        }
    }
}

// Blocks
$modversion['blocks'][1]['file'] = "bmsurvey_top.php";
$modversion['blocks'][1]['name'] = _MI_SURVEY_BNAME1;
$modversion['blocks'][1]['description'] = "Bluemoon.Multi-Survey";
$modversion['blocks'][1]['show_func'] = "b_bmsurvey_show";
$modversion['blocks'][1]['edit_func'] = "b_bmsurvey_edit";
$modversion['blocks'][1]['options'] = "1";
$modversion['blocks'][1]['template'] = 'bmsurvey_block.html';

$modversion['templates'][] = array(
	'file'        => 'bmsurvey_list.html',
	'description' => 'Survey List'
);
$modversion['templates'][] = array(
	'file'        => 'bmsurvey_survey.html',
	'description' => 'Survey Render'
);
$modversion['templates'][] = array(
	'file'        => 'bmsurvey_test.html',
	'description' => 'Survey Test'
);

// Menu
$modversion['hasMain'] = 1;

// Comments
$modversion['hasComments'] = 0;

// Admin Preferences
// 2005/05/22 Add by Y.Sakai
$modversion['config'][] = array(
	'name'        => 'FILE_CHARSET',
	'title'       => '_MI_MSURVEY_FILECHARSET',
	'description' => '_MI_MSURVEY_FILECHARSET_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => 'ASCII'
);
$modversion['config'][] = array(
	'name'        => 'CSV_CHARSET',
	'title'       => '_MI_MSURVEY_CSVCHARSET',
	'description' => '_MI_MSURVEY_CSVCHARSET_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => 'ASCII'
);
$modversion['config'][] = array(
	'name'        => 'CSV_ADDNUMBER',
	'title'       => '_MI_MSURVEY_CSVADDNUM',
	'description' => '_MI_MSURVEY_CSVADDNUM_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => '(%u)'
);
$modversion['config'][] = array(
	'name'        => 'CSV_CHOICEOPT',
	'title'       => '_MI_MSURVEY_CHOICEOPT',
	'description' => '_MI_MSURVEY_CHOICEOPT_DESC',
	'formtype'    => 'select',
	'valuetype'   => 'int',
	'default'     => 0,
	'options'     => array('Strings' => 0,'Number' => 1)
);
$modversion['config'][] = array(
	'name'        => 'CSV_OTHERF',
	'title'       => '_MI_MSURVEY_CSVOTHERF',
	'description' => '_MI_MSURVEY_CSVOTHERF_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => 'Other(%s)'
);
$modversion['config'][] = array(
	'name'        => 'MAILSERVER',
	'title'       => '_MI_MSURVEY_MAILSERVER',
	'description' => '_MI_MSURVEY_MAILSERVER_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'MAILUSER',
	'title'       => '_MI_MSURVEY_MAILUSER',
	'description' => '_MI_MSURVEY_MAILUSER_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'MAILPWD',
	'title'       => '_MI_MSURVEY_MAILPWD',
	'description' => '_MI_MSURVEY_MAILPWD_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'MAILADDR',
	'title'       => '_MI_MSURVEY_MAILADDR',
	'description' => '_MI_MSURVEY_MAILADDR_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'CAST_KEY',
	'title'       => '_MI_MSURVEY_CASTKEY',
	'description' => '_MI_MSURVEY_CASTKEY_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'MANAGERS',
	'title'       => '_MI_MSURVEY_MANAGEGROUP',
	'description' => '_MI_MSURVEY_MANAGEGROUP_DESC',
	'formtype'    => 'group_multi',
	'valuetype'   => 'array',
	'default'     => array(1)
);
$modversion['config'][] = array(
	'name'        => 'PSTATUS',
	'title'       => '_MI_MSURVEY_MGPSTATUS',
	'description' => '_MI_MSURVEY_MGPSTATUS_DESC',
	'formtype'    => 'yesno',
	'valuetype'   => 'int',
	'default'     => 1
);
$modversion['config'][] = array(
	'name'        => 'BLOCKLIST',
	'title'       => '_MI_MSURVEY_BLOCKLIST',
	'description' => '_MI_MSURVEY_BLOCKLIST_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'int',
	'default'     => 10
);
$modversion['config'][] = array(
	'name'        => 'ADD_INFO',
	'title'       => '_MI_MSURVEY_ADDINFO',
	'description' => '_MI_MSURVEY_ADDINFO_DESC',
	'formtype'    => 'yesno',
	'valuetype'   => 'int',
	'default'     => 0
);
$modversion['config'][] = array(
	'name'        => 'ADD_USAGE',
	'title'       => '_MI_MSURVEY_ADDUSAGE',
	'description' => '_MI_MSURVEY_ADDUSAGE_DESC',
	'formtype'    => 'yesno',
	'valuetype'   => 'int',
	'default'     => 1
);
$modversion['config'][] = array(
	'name'        => 'ONE_RESPONSE',
	'title'       => '_MI_MSURVEY_ONERESPONSE',
	'description' => '_MI_MSURVEY_ONERESPONSE_DESC',
	'formtype'    => 'yesno',
	'valuetype'   => 'int',
	'default'     => 0
);
$modversion['config'][] = array(
	'name'        => 'RESET_RB',
	'title'       => '_MI_MSURVEY_RESETRADIOBUTTON',
	'description' => '_MI_MSURVEY_RESETRADIOBUTTON_DESC',
	'formtype'    => 'yesno',
	'valuetype'   => 'int',
	'default'     => 1
);
$modversion['config'][] = array(
	'name'        => 'RESULT_RANK',
	'title'       => '_MI_MSURVEY_RESULTRANK',
	'description' => '_MI_MSURVEY_RESULTRANK_DESC',
	'formtype'    => 'select',
	'valuetype'   => 'int',
	'default'     => 0,
	'options'     => array('Avarage' => 0,'Count' => 1)
);
?>
