using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.Xml.Serialization;

using Boon.IO.File;

namespace Boon.Collections
{
    [Serializable()]
    [XmlRoot("VideoFileDataCollectionsRoot")]
    public class VideoFileDataCollections
    {
        ArrayList ar = new ArrayList();

        public VideoFileDataCollections()
        {
        }

        public void Serialize(ListView lv)
        {
            ListView.ListViewItemCollection datas = lv.Items;
            ar.Clear();

            foreach (ListViewItem i in datas)
            {
                VideoFileData vfd = (VideoFileData)i.Tag;
                ar.Add(vfd);
            }

            try
            {
                string path = Application.StartupPath + @"\downloadListView.xml";

                FileStream fs = new FileStream(path, FileMode.Create);
                XmlSerializer sr = new XmlSerializer(typeof(ArrayList), new Type[] { typeof(VideoFileData) });
                sr.Serialize(fs, ar);
                fs.Close();
            }
            catch (Exception)
            {
            }
            
        }

        public void Deserialize(ListView lv)
        {
            try
            {
                string path = Application.StartupPath + @"\downloadListView.xml";

                FileStream fs = new FileStream(path, FileMode.Open);
                XmlSerializer sr = new XmlSerializer(typeof(ArrayList), new Type[] { typeof(VideoFileData) });
                ar = (ArrayList) sr.Deserialize(fs);
                fs.Close();

                foreach (VideoFileData i in ar)
                {
                    ListViewItem lvi =
                        new ListViewItem
                        (
                            new string[]
                            {
                                i.videoTitle,
                                i.GetStatusMessage(),
                                string.Format("{0:F4}/{1:F4}", (double)i.videoFileDownloadedSize/ (1024 * 1024), (double)i.videoFileSize / (1024 * 1024)),
                                string.Format("{0:F1}%", (i.videoFileSize != 0) ? ((double)i.videoFileDownloadedSize * 100 / i.videoFileSize) : 0.0),
                                "",
                                "",
                                "",
                                i.videoFileExtension,
                                (i.registeredTime != 0) ? new DateTime(i.registeredTime).ToString("yyyy/MM/dd HH:mm:ss") : "",
                                string.Format("{0:F4}", (double) i.videoFileSize / (1024 * 1024) ),
                                (i.registeredTime != 0) ? new DateTime(i.registeredTime).ToString("yyyy/MM/dd/HH:mm:ss") : "",
                                "",
                            }
                        );
                    lvi.Name = i.videoID;
                    lvi.Tag = i;
                    lv.Items.Add(lvi);
                }
            }
            catch (Exception)
            {
            }
    
        }
    }
}
