using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Net;
using System.Runtime.InteropServices;
using AxSHDocVw;
using mshtml;
using ProjectBoon.Win32;

namespace Boon.Controls.Browsers
{
	/// <summary>
	/// AxWebBrowserzXguEURg[łB
	/// </summary>
	public class WebBrowserAx : UserControl, ITbPageControl
	{
		#region ###  Constant / Static Field  ###
		/// <summary>
		/// VEBhEŊJtargetFrame
		/// </summary>
		public const string BLANK_TGT = "_blank";

		public static IOleClientSite OLEClientSite;
			
		#endregion

		#region #########   Field   #########

		/// <summary>
		/// uEU
		/// </summary>
		private AxWebBrowser _browser;
		/// <summary>
		/// ߂Eiނ̗ǗIuWFNg
		/// </summary>
		private ExHtmlHistory _history;
		/// <summary>
		/// uEŰ@\𐧌IuWFNg
		/// </summary>
		private InternetSecurityManager _ism;
		/// <summary>
		/// ݎgpĂ܂B
		/// </summary>
		private List<string> _edited_keys;

		/// <summary>
		/// <see cref="CanGoBack"/>vpeB̓tB[hłB
		/// </summary>
		private bool _canGoBack = false;
		/// <summary>
		/// <see cref="CanGoForward"/>vpeB̓tB[hłB
		/// </summary>
		private bool _canGoFore = false;

		/// <summary>
		/// VInternet Explorer_Server̃EBhEv[W[łB
		/// </summary>
		private WindowProcDelegate _del_windowproc = null;
		/// <summary>
		/// Internet Explorer_Server̃ftHg̃EBhEv[W[ւ̃|C^JȂ悤ێtB[hłB
		/// </summary>
		private IntPtr _pIEWindowDefProc = IntPtr.Zero;
		private string _pagetitle = "";

		#endregion

		#region ++++ Constructor / Initializer ++++

		/// <summary>
		/// ̃NX̃RXgN^łB
		/// </summary>
		/// <exception cref="System.Runtime.InteropServices.ExternalException">COM̏ԂsȂƂɔ܂B</exception>
		public WebBrowserAx()
		{
			this.InitializeComponent();
			this.Silent = false;
			if(OLEClientSite != null)
			{
				IOleObject obj = this.Ocx as IOleObject;
				obj.SetClientSite(OLEClientSite);
			}
			this._history = new ExHtmlHistory(this);
			this._ism = new InternetSecurityManager(this._browser.Application);
			this._edited_keys = new List<string>(4);
		}

		private void InitializeComponent()
		{
			this.SuspendLayout();

			this.SetStyle(ControlStyles.ResizeRedraw, false);
			this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
			this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
			this.SetStyle(ControlStyles.UserPaint, true);
			this.DoubleBuffered = true;

			this._browser = new AxWebBrowser();
			this._browser.BeginInit();
			this._browser.Dock = DockStyle.Fill;
			// Attach Events
			this._browser.BeforeNavigate2 += new DWebBrowserEvents2_BeforeNavigate2EventHandler(browser_BeforeNavigate2);
			this._browser.NavigateComplete2 += new DWebBrowserEvents2_NavigateComplete2EventHandler(browser_NavigateComplete2);
			this._browser.NavigateError += new DWebBrowserEvents2_NavigateErrorEventHandler(browser_NavigateError);
			this._browser.ProgressChange += new DWebBrowserEvents2_ProgressChangeEventHandler(browser_ProgressChange);
			this._browser.DownloadComplete += new EventHandler(browser_DownloadComplete);
			this._browser.DocumentComplete += new DWebBrowserEvents2_DocumentCompleteEventHandler(browser_DocumentComplete);
			this._browser.NewWindow2 += new DWebBrowserEvents2_NewWindow2EventHandler(browser_NewWindow2);
			this._browser.StatusTextChange += new DWebBrowserEvents2_StatusTextChangeEventHandler(browser_StatusTextChange);
			this._browser.TitleChange += new DWebBrowserEvents2_TitleChangeEventHandler(browser_TitleChange);
			this._browser.WindowClosing += new DWebBrowserEvents2_WindowClosingEventHandler(browser_WindowClosing);
			this._browser.PreviewKeyDown += new PreviewKeyDownEventHandler(browser_PreviewKeyDown);
			this._browser.CommandStateChange += new DWebBrowserEvents2_CommandStateChangeEventHandler(browser_CommandStateChange);

			this.Controls.Add(this._browser);

			this.Dock = DockStyle.Fill;

			this._browser.EndInit();


			this.initializeNaviHistory();
			this.ResumeLayout(false);

		}
		/// <summary>
		/// ̃NX̃EBhEv[W[AV̂ւƒu܂B
		/// </summary>
		private void set_WindowProcedure()
		{
			if(this._del_windowproc != null)
			{
				InnerLogger.LOut("WindowProcedure is already replaced.", InnerLogger.ErrorLevel.L1_ERROR);
				return;
			}
			IntPtr pHWND_IEServer = IntPtr.Zero;
			IntPtr pHWND_SHDocVw = IntPtr.Zero;

			pHWND_SHDocVw = User32.GetWindow(this._browser.Handle, User32.GW_CHILD);
			if(pHWND_SHDocVw != IntPtr.Zero)
			{
				pHWND_IEServer = User32.GetWindow(pHWND_SHDocVw, User32.GW_CHILD);

				// Vv[W[쐬
				this._del_windowproc = new WindowProcDelegate(this.BeforeIEWndProc);
				IntPtr ptr_func = Marshal.GetFunctionPointerForDelegate(this._del_windowproc);
				// v[W[̓ւEftHg̃v[W[̃AhXێ
				this._pIEWindowDefProc = User32.SetWindowLong(pHWND_IEServer, User32.GWL_WNDPROC, ptr_func);
				// ւɎsꍇɍ쐬v[W[j
				if(this._pIEWindowDefProc == IntPtr.Zero)
				{
					this._del_windowproc = null;
				}
			}
		}
		/// <summary>
		/// ̃NX̃EBhEv[W[AftHĝ̂ɒu܂B
		/// </summary>
		private void reset_WindowProdure()
		{
			if(this._del_windowproc == null)
			{
				InnerLogger.LOut("WindowProcedure is not until replaced.", InnerLogger.ErrorLevel.L1_ERROR);
				return;
			}
			IntPtr pHWND_IEServer = IntPtr.Zero;
			IntPtr pHWND_SHDocVw = IntPtr.Zero;

			pHWND_SHDocVw = User32.GetWindow(this._browser.Handle, User32.GW_CHILD);
			if(pHWND_SHDocVw != IntPtr.Zero)
			{
				pHWND_IEServer = User32.GetWindow(pHWND_SHDocVw, User32.GW_CHILD);
				if(this._pIEWindowDefProc != IntPtr.Zero)
				{
					User32.SetWindowLong(pHWND_IEServer, User32.GWL_WNDPROC, this._pIEWindowDefProc);
				}
				this._del_windowproc = null;
			}
			pHWND_IEServer = IntPtr.Zero;
			pHWND_SHDocVw = IntPtr.Zero;
		}

		#endregion

		#region - Properties / Methods Access Proxy -

		/// <summary>
		/// ɂȂActiveXIuWFNgւ̎QƂ擾܂B
		/// AxWebBrowser.GetOcx() ւ̃ANZXłB
		/// </summary>
		public object Ocx
		{
			get { return this._browser.GetOcx(); }
		}
		/// <summary>
		/// ɂȂActiveXIuWFNg̎QƂ擾܂B
		/// AxWebBrowser.Application ւ̃ANZXłB
		/// </summary>
		public object Application
		{
			get { return this._browser.Application; }
		}
		/// <summary>
		/// AxWebBrowser::RegisterAsBrowser
		/// </summary>
		public bool RegisterAsBrowser
		{
			get { return this._browser.RegisterAsBrowser; }
			set { this._browser.RegisterAsBrowser = value; }
		}

		/// <summary>
		/// uEŨrV[Ԃ擾܂B
		/// </summary>
		public bool IsBusy
		{
			get { return this._browser.Busy; }
		}
		/// <summary>
		/// uEUŕ\̃y[WURL擾܂B
		/// </summary>
		public string Url
		{
			get { return this._browser.LocationURL; }
		}
		/// <summary>
		/// uEUŕ\̃y[W̃^Cg擾܂B
		/// </summary>
		public string DocumentTitle
		{
			get { lock(this._pagetitle) { return this._pagetitle; } }
		}
		/// <summary>
		/// uEUŕ\StatusText擾܂B
		/// </summary>
		public string StatusText
		{
			get { return this._browser.StatusText; }
		}
		/// <summary>
		/// ItCԂ擾Eݒ肵܂B
		/// </summary>
		public bool Offline
		{
			get { return this._browser.Offline; }
			set { this._browser.Offline = value; }
		}
		/// <summary>
		/// Sʃ[h̏Ԃ擾Eݒ肵܂B
		/// </summary>
		public bool FullScreen
		{
			get { return this._browser.FullScreen; }
			set { this._browser.FullScreen = value; }
		}
		/// <summary>
		/// ׂẴ_CAO}TCg[h̏Ԃ擾Eݒ肵܂B
		/// </summary>
		public bool Silent
		{
			get { return this._browser.Silent; }
			set { this._browser.Silent = value; }
		}
		/// <summary>
		/// uEUReadyState擾Eݒ肵܂B
		/// </summary>
		public WebBrowserReadyState ReadyState
		{
			get { return (WebBrowserReadyState)this._browser.ReadyState; }
		}
		/// <summary>
		/// uEUDOMIuWFNg擾܂B
		/// </summary>
		public object Document
		{
			get { return this._browser.Document; }
		}

		/// <summary>
		/// uEU̖߂鑀삪Lǂ擾܂B
		/// </summary>
		public bool CanGoBack
		{
			get { return this._canGoBack; }
		}
		/// <summary>
		/// uEU̐iޑ삪Lǂ擾܂B
		/// </summary>
		public bool CanGoForward
		{
			get { return this._canGoFore; }
		}

		/// <summary>
		/// AxWebBrowser::ClientToWindowւ̃ANZXłB
		/// </summary>
		/// <param name="x">XW</param>
		/// <param name="y">YW</param>
		/// <returns>Point</returns>
		public Point ClientToWindow(int x, int y)
		{
			int xret = x;
			int yret = y;
			this._browser.ClientToWindow(ref xret, ref yret);
			return new Point(xret, yret);
		}

		#endregion

		#region ------  Properties / Other -------
		
		/// <summary>
		/// uEÜړǗNXւ̎QƂ擾܂B
		/// </summary>
		/// <seealso cref="Browser.Controls.Browsers.ExHtmlHistory"/>
		public ExHtmlHistory History
		{
			get { return this._history; }
		}
		/// <summary>
		/// uEŨZLeBxǗNXւ̎QƂ擾܂B
		/// </summary>
		/// <seealso cref="Browser.Controls.Browsers.InternetSecurityManager"/>
		public InternetSecurityManager SecurityManager
		{
			get { return this._ism; }
		}


		/// <summary>
		/// IɃRg[NCAg̈𖳌Aɂ̃Rg[̂ĕ`悷悤ɂ܂B
		/// UserControl::Refreshւ̃ANZXłB
		/// </summary>
		public void RefreshControl()
		{
			base.Refresh();
		}

		/// <summary>
		/// gp܂B
		/// </summary>
		/// <param name="editorkey"></param>
		/// <returns></returns>
		public bool PageIsEdited(string editorkey)
		{
			return this._edited_keys.Contains(editorkey);
		}
		/// <summary>
		/// gp܂B
		/// </summary>
		/// <param name="editorkey"></param>
		public void PageEdited(string editorkey)
		{
			if(this._edited_keys.Contains(editorkey))
			{
				throw new TabBrowserException("WebBrowserAx::SetPageEdited - ɑ݂L[o^邱Ƃ͏o܂");
			}
			else
			{
				this._edited_keys.Add(editorkey);
			}
		}
		/// <summary>
		/// gp܂B
		/// </summary>
		private void clearEditorKeys()
		{
			this._edited_keys.Clear();
		}

		#region NavigateHistory

		/// <summary>
		/// u߂Eiށv̗̈ꗗ|bvAbvj[\܂B
		/// </summary>
		/// <param name="screenPos">j[\XN[W</param>
		/// <param name="isBackHistory">u߂v̏ꍇtrueAuiށv̏ꍇfalse</param>
		public void ShowNavigateHistory(Point screenPos, bool isBackHistory)
		{
			if(this.History != null)
			{
				TravelLogEntry[] entry = this.History.EnumEntries(
					isBackHistory ? TLENUMF.TLEF_RELATIVE_BACK : TLENUMF.TLEF_RELATIVE_FORE, this.tsmiHistory.Length);
				if(entry != null && entry.Length > 0)
				{
					int i;
					for(i = 0; i < entry.Length; ++i)
					{
						this.tsmiHistory[i].ImageIndex = isBackHistory ? 0 : 1;
						this.tsmiHistory[i].Text = entry[i].Title;
						this.tsmiHistory[i].Tag = entry[i].Url;
						this.tsmiHistory[i].Visible = true;
					}
					while(i < this.tsmiHistory.Length)
					{
						this.tsmiHistory[i].Visible = false;
						this.tsmiHistory[i].Tag = null;
						++i;
					}
					this._frg_travellog_isback = isBackHistory;
					this.ctxNaviHistory.Show(screenPos);
				}
			}
		}

		private ToolStripMenuItem[] tsmiHistory;
		private ContextMenuStrip ctxNaviHistory;
		private bool _frg_travellog_isback = false;
		private int _frg_travellog_maxshow = 5;

		private void initializeNaviHistory()
		{
			this.ctxNaviHistory = new ContextMenuStrip();
			this.ctxNaviHistory.ImageList = new ImageList();
			this.ctxNaviHistory.ShowCheckMargin = false;
			this.ctxNaviHistory.ShowItemToolTips = true;
			this.ctxNaviHistory.ItemClicked += new ToolStripItemClickedEventHandler(ctxNaviHistory_ItemClicked);

			this.tsmiHistory = new ToolStripMenuItem[this._frg_travellog_maxshow];
			for(int i = 0; i < this.tsmiHistory.Length; ++i)
			{
				this.tsmiHistory[i] = new ToolStripMenuItem();
				this.tsmiHistory[i].Name = i.ToString();
				this.tsmiHistory[i].ImageIndex = 0;
				this.tsmiHistory[i].Height = 18;
				this.tsmiHistory[i].Visible = false;
			}
			this.ctxNaviHistory.Items.AddRange(this.tsmiHistory);
		}

		void ctxNaviHistory_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
		{
			int cindex = this.ctxNaviHistory.Items.IndexOf(e.ClickedItem);
			if(cindex >= 0)
			{
				this.History.TravelTo((cindex + 1) * (this._frg_travellog_isback ? -1 : 1));
			}
		}

		#endregion

		#endregion

		#region --------  Browser Navigation  --------

		/// <summary>
		/// wURLɈړ܂B
		/// </summary>
		/// <param name="url">ړURL</param>
		public void Navigate(string url)
		{
			object url_ = url as object;
			this._browser.Navigate2(ref url_);
		}
		/// <summary>
		/// wURLɈړ܂
		/// </summary>
		/// <param name="url">ړURL</param>
		/// <param name="frame">^[Qbgt[</param>
		public void Navigate(string url, string frame)
		{
			object url_ = url as object;
			object frame_ = frame as object;
			object frags_ = 0;
			object post_ =  "";
			object head_ = "";
			this._browser.Navigate2(ref url_, ref frags_, ref frame_, ref post_, ref head_);
		}
		/// <summary>
		/// wURLɈړ܂B
		/// </summary>
		/// <param name="url">ړURL</param>
		/// <param name="frags"><see cref="BrowserNavConstants"/>̒l</param>
		/// <param name="frame">^[Qbgt[</param>
		/// <param name="postdata">POST̏ꍇɎwBnull̏ꍇGET</param>
		/// <param name="headers">wb_[f[^̎wB</param>
		public void Navigate(string url, BrowserNavConstants frags, string frame, object postdata, object headers)
		{
			object url_ = url as object;
			object frame_ = frame as object;
			object frags_ = frags as object;
			object post_ = postdata as object;
			object head_ = headers as object;
			this._browser.Navigate2(ref url_, ref frags_, ref frame_, ref post_, ref head_);
		}
		/// <summary>
		/// \̃y[Wēǂݍ݂܂B
		/// </summary>
		/// <remarks>
		/// ̃\bh́AUserControl::RefreshB܂B
		/// UserControl::RefreshKvȏꍇ́ARefreshControl\bh痘pł܂B
		/// </remarks>
		public new void Refresh()
		{
			if(!String.IsNullOrEmpty(this.Url))
			{
				this._browser.Refresh2();
				this.clearEditorKeys();
			}
		}
		/// <summary>
		/// ۗ̃irQ[VLZA
		/// obNOEh TEhAj[VȂǂ̓Iȃy[WvfׂĒ~܂
		/// </summary>
		public void Stop()
		{
			this._browser.Stop();
		}
		/// <summary>
		/// irQ[VɑÕy[WꍇɁAÕy[Wɖ߂܂B
		/// </summary>
		public void GoBack()
		{
			this._browser.GoBack();
		}
		/// <summary>
		/// irQ[VɎ̃y[WꍇɁÃy[WɈړ܂B
		/// </summary>
		public void GoForward()
		{
			this._browser.GoForward();
		}
		/// <summary>
		/// ݂ Internet Explorer ̃z[ y[WɈړ܂B
		/// </summary>
		public void GoHome()
		{
			this._browser.GoHome();
		}
		/// <summary>
		/// ݂ Internet Explorer ̌y[WɈړ܂B
		/// </summary>
		public void GoSearch()
		{
			this._browser.GoSearch();
		}
		/// <summary>
		/// AxWebBrowser::Quit
		/// </summary>
		public void Quit()
		{
			this._browser.Quit();
		}

		#endregion

		#region ---------  Browser Events  ------------

		/// <summary>
		/// WebTCgł̃}EXL,R,M{^ꂽɔ܂B
		/// XButton1,2̕ߑ<see cref="System.Windows.Forms.Control.MouseDown" />CxgsĂB
		/// </summary>
		/// <seealso cref="WebBrowserMouseMessageEventArgs"/>
		/// <seealso cref="System.Windows.Forms.Control.MouseDown"/>
		public event EventHandler<WebBrowserMouseMessageEventArgs> BrowserMouseDown;

		/// <summary>
		/// <see href="CanGoBack" />vpeB̒lύXꂽꍇɔ܂B
		/// </summary>
		/// <seealso cref="CanGoBackChanged"/>
		public event EventHandler CanGoBackChanged;
		/// <summary>
		/// <see href="CanGoForward" />vpeB̒lύXꂽꍇɔ܂B
		/// </summary>
		/// <seealso cref="CanGoForwardChanged"/>
		public event EventHandler CanGoForwardChanged;
		/// <summary>
		/// uEUVhLgɈړOɔ܂B
		/// </summary>
		/// <seealso cref="WebBrowserBeforeNavigateEventArgs"/>
		public event EventHandler<WebBrowserBeforeNavigateEventArgs> BeforeNavigate;
		/// <summary>
		/// uEUVhLgVEBhEŊJƂ鎞ɔ܂B
		/// </summary>
		/// <seealso cref="WebBrowserBeforeNewWindowEventArgs"/>
		public event EventHandler<WebBrowserBeforeNewWindowEventArgs> BeforeNewWindow;
		/// <summary>
		/// uEUVhLgւ̈ړɔ܂B
		/// </summary>
		/// <seealso cref="System.Windows.Forms.WebBrowserNavigatedEventArgs"/>
		public event WebBrowserNavigatedEventHandler Navigated;
		/// <summary>
		/// uEU̐Vy[Wւ̈ړsɔ܂B
		/// </summary>
		/// <seealso cref="WebBrowserNavigateErrorEventArgs"/>
		public event EventHandler<WebBrowserNavigateErrorEventArgs> NavigateError;
		/// <summary>
		/// uEUhLg̕\ɕKvȂׂĂ̗vf_E[hɔ܂B
		/// <remarks>
		/// Vy[WɈړꍇ́ÃCxg܂ŃuEUDOM@\ɃANZXł܂B
		/// </remarks>
		/// </summary>
		public event EventHandler DownloadCompleted;
		/// <summary>
		/// uEUhLg̕\ɕKvȂׂĂ̏ɔ܂B
		/// ēǂݍ݂găy[WXVꍇɂ͔ȂƂɒӂĂB
		/// </summary>
		/// <seealso cref="WebBrowserDocumentCompletedEventHandler"/>
		/// <seealso cref="System.Windows.Forms.WebBrowser.DocumentCompleted"/>
		public event WebBrowserDocumentCompletedEventHandler DocumentCompleted;
		/// <summary>
		/// uEUStatusTextύXꂽɔ܂B
		/// </summary>
		/// <seealso cref="System.Windows.Forms.WebBrowser.StatusTextChanged"/>
		public event EventHandler StatusTextChanged;
		/// <summary>
		/// \̃hLg̃^CgύXꂽɔ܂B
		/// </summary>
		/// <seealso cref="DocumentTitle"/>
		/// <seealso cref="System.Windows.Forms.WebBrowser.DocumentTitleChanged"/>
		public event EventHandler DocumentTitleChanged;
		/// <summary>
		/// ړƂȂhLg̃_E[h̐is󋵂Ɋւ񂪍XVꂽƂɔ܂B
		/// </summary>
		/// <seealso cref="System.Windows.Forms.WebBrowser.ProgressChanged"/>
		public event WebBrowserProgressChangedEventHandler ProgressChanged;
		/// <summary>
		/// uEUXNvgȂǂŕꂽɔ܂B
		/// ߑ͏o܂ALZ͏o܂B
		/// </summary>
		/// <seealso cref="WebBrowserWindowClosingEventArgs"/>
		public event EventHandler<WebBrowserWindowClosingEventArgs> WindowClosing;

		/// <summary>
		/// IFJp̓CxgB
		/// </summary>
		private event ITbDisplayEventHandler _evt_DisplayTextChanged;

		#region Event Triggers

		/// <summary>
		/// <see cref="CanGoBackChanged"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e">EventArgs</param>
		protected void OnCanGoBackChanged(object sender, EventArgs e)
		{
			if(this.CanGoBackChanged != null)
			{
				this.CanGoBackChanged(sender, e);
			}
		}
		/// <summary>
		/// <see cref="CanGoForward"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e">EventArgs</param>
		protected void OnCanGoForwardChanged(object sender, EventArgs e)
		{
			if(this.CanGoForwardChanged != null)
			{
				this.CanGoForwardChanged(sender, e);
			}
		}
		/// <summary>
		/// <see cref="BeforeNavigate"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_BeforeNavigate2Event"/></param>
		protected void OnBeforeNavigate(object sender, DWebBrowserEvents2_BeforeNavigate2Event e)
		{
			if(this.BeforeNavigate != null)
			{
				WebBrowserBeforeNavigateEventArgs ev = new WebBrowserBeforeNavigateEventArgs(e);
				this.BeforeNavigate(sender, ev);
				ev.Release();
			}
		}
		/// <summary>
		/// <see cref="BeforeNewWindow"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_NewWindow2Event"/></param>
		protected void OnBeforeNewWindow(object sender, DWebBrowserEvents2_NewWindow2Event e)
		{
			if(this.BeforeNewWindow != null)
			{
				WebBrowserBeforeNewWindowEventArgs ev = new WebBrowserBeforeNewWindowEventArgs(e);
				this.BeforeNewWindow(sender, ev);
				ev.Release();
			}
		}
		/// <summary>
		/// <see cref="Navigated"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_NavigateComplete2Event"/></param>
		protected void OnNavigated(object sender, DWebBrowserEvents2_NavigateComplete2Event e)
		{
			if(this.Navigated != null)
			{
				WebBrowserNavigatedEventArgs ev = new WebBrowserNavigatedEventArgs(new Uri(e.uRL as string));
				this.Navigated(sender, ev);
			}
		}
		/// <summary>
		/// <see cref="NavigateError"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_NavigateErrorEvent"/></param>
		protected void OnNavigateError(object sender, DWebBrowserEvents2_NavigateErrorEvent e)
		{
			if(this.NavigateError != null)
			{
				WebBrowserNavigateErrorEventArgs ev = new WebBrowserNavigateErrorEventArgs(e);
				this.NavigateError(sender, ev);
				ev.Release();
			}
		}
		/// <summary>
		/// <see cref="DownloadCompleted"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e">EventArgs</param>
		protected void OnDownloadCompleted(object sender, EventArgs e)
		{
			if(this.DownloadCompleted != null)
			{
				this.DownloadCompleted(sender, e);
			}
		}
		/// <summary>
		/// <see cref="DocumentCompleted"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_DocumentCompleteEvent"/></param>
		protected void OnDocumentCompleted(object sender, DWebBrowserEvents2_DocumentCompleteEvent e)
		{
			if(this.DocumentCompleted != null)
			{
				Uri uri = null;
				Uri.TryCreate(e.uRL as string, UriKind.Absolute, out uri);
				WebBrowserDocumentCompletedEventArgs ev = new WebBrowserDocumentCompletedEventArgs(uri);
				this.DocumentCompleted(sender, ev);
				uri = null;
			}
		}
		/// <summary>
		/// <see cref="StatusTextChanged"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_StatusTextChangeEvent"/></param>
		protected void OnStatusTextChanged(object sender, DWebBrowserEvents2_StatusTextChangeEvent e)
		{
			if(this.StatusTextChanged != null)
			{
				this.StatusTextChanged(sender, new EventArgs());
			}
		}
		/// <summary>
		/// <see cref="DocumentTitleChanged"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_TitleChangeEvent"/></param>
		protected void OnDocumentTitleChanged(object sender, DWebBrowserEvents2_TitleChangeEvent e)
		{
			if(this.DocumentTitleChanged != null)
			{
				this.DocumentTitleChanged(sender, new EventArgs());
			}
		}
		/// <summary>
		/// <see cref="ProgressChanged"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_ProgressChangeEvent"/></param>
		protected void OnProgressChanged(object sender, DWebBrowserEvents2_ProgressChangeEvent e)
		{
			if(this.ProgressChanged != null)
			{
				WebBrowserProgressChangedEventArgs ev = new WebBrowserProgressChangedEventArgs(e.progress, e.progressMax);
				this.ProgressChanged(sender, ev);
			}
		}
		/// <summary>
		/// <see cref="WindowClosing"/>Cxg̃gKłB
		/// </summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_WindowClosingEvent"/></param>
		protected void OnWindowClosing(object sender, DWebBrowserEvents2_WindowClosingEvent e)
		{
			if(this.WindowClosing != null)
			{
				WebBrowserWindowClosingEventArgs ev = new WebBrowserWindowClosingEventArgs(e);
				this.WindowClosing(sender, ev);
				ev.Release();
			}
		}

		#endregion

		#region Browser Event Handler

		void browser_NewWindow2(object sender, DWebBrowserEvents2_NewWindow2Event e)
		{
			this.OnBeforeNewWindow(this, e);
		}
		void browser_BeforeNavigate2(object sender, DWebBrowserEvents2_BeforeNavigate2Event e)
		{
			this.OnBeforeNavigate(this, e);
		}
		void browser_NavigateComplete2(object sender, DWebBrowserEvents2_NavigateComplete2Event e)
		{
			if(this._del_windowproc == null)
			{
				this.set_WindowProcedure();
			}
			this.OnNavigated(this, e);

			if(this._evt_DisplayTextChanged != null)
			{
				this._evt_DisplayTextChanged(this as ITbPageControl, new ITbDisplayEventArgs(ITbDisplayEventType.Url, e.uRL as string));
			}
			this.clearEditorKeys();
		}
		void browser_NavigateError(object sender, DWebBrowserEvents2_NavigateErrorEvent e)
		{
			this.OnNavigateError(this, e);
		}
		void browser_ProgressChange(object sender, DWebBrowserEvents2_ProgressChangeEvent e)
		{
			this.OnProgressChanged(this, e);
		}
		void browser_DownloadComplete(object sender, EventArgs e)
		{
			this.OnDownloadCompleted(this, e);
		}

		void browser_DocumentComplete(object sender, DWebBrowserEvents2_DocumentCompleteEvent e)
		{
			this.OnDocumentCompleted(this, e);
		}
		void browser_TitleChange(object sender, DWebBrowserEvents2_TitleChangeEvent e)
		{
			lock(this._pagetitle)
			{
				this._pagetitle = e.text;
			}
			this.OnDocumentTitleChanged(this, e);
			if(this._evt_DisplayTextChanged != null)
			{
				this._evt_DisplayTextChanged(this as ITbPageControl, new ITbDisplayEventArgs(ITbDisplayEventType.Title, e.text));
			}
		}
		void browser_StatusTextChange(object sender, DWebBrowserEvents2_StatusTextChangeEvent e)
		{
			this.OnStatusTextChanged(this, e);
			if(this._evt_DisplayTextChanged != null)
			{
				this._evt_DisplayTextChanged(this as ITbPageControl, new ITbDisplayEventArgs(ITbDisplayEventType.StatusText, e.text));
			}
		}
		void browser_WindowClosing(object sender, DWebBrowserEvents2_WindowClosingEvent e)
		{
			this.OnWindowClosing(this, e);
		}
		void browser_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
		{
			this.OnPreviewKeyDown(e);
		}
		void browser_CommandStateChange(object sender, DWebBrowserEvents2_CommandStateChangeEvent e)
		{
			switch(e.command)
			{
				case CommandState.NavigateForward:
					this._canGoFore = e.enable;
					this.OnCanGoForwardChanged(this, new EventArgs());
					break;
				case CommandState.NavigateBack:
					this._canGoBack = e.enable;
					this.OnCanGoBackChanged(this, new EventArgs());
					break;
			}
		}

		#endregion


		/// <summary>
		/// InternetExplorerServer ftHg̃v[W[ĂяoOɁAbZ[W擾ď܂B
		/// </summary>
		/// <param name="hWnd"></param>
		/// <param name="message"></param>
		/// <param name="wParam"></param>
		/// <param name="mParam"></param>
		/// <returns></returns>
		private IntPtr BeforeIEWndProc(IntPtr hWnd, int message, IntPtr wParam, IntPtr mParam)
		{
			if(message == 0x207) // WM_MBUTTONDOWN
			{
				if(this.BrowserMouseDown != null)
				{
					int i32mParam = mParam.ToInt32();
					int i32wP = wParam.ToInt32();

					WebBrowserMouseMessageEventArgs arg = new WebBrowserMouseMessageEventArgs(
						MouseButtons.Middle, 1, i32mParam & 0x0000FFFF, i32mParam >> 16, 0,
						(i32wP & 0x8) == 0x8, (i32wP & 0x4) == 0x4);
					this.BrowserMouseDown(this, arg);
					if(arg.CancelMessage)
					{
						return User32.CallWindowProc(IntPtr.Zero, hWnd, message, wParam, mParam);
					}
				}
			}
			else if(message == 0x201) // WM_L/RBUTTONDOWN
			{
				if(this.BrowserMouseDown != null)
				{
					int i32mParam = mParam.ToInt32();
					int i32wP = wParam.ToInt32();
					MouseButtons btn = MouseButtons.None;
					if((i32wP & 0x1) == 0x1) { btn |= MouseButtons.Left; }
					if((i32wP & 0x2) == 0x2) { btn |= MouseButtons.Right; }
					WebBrowserMouseMessageEventArgs arg = new WebBrowserMouseMessageEventArgs(
						btn, 1, i32mParam & 0x0000FFFF, i32mParam >> 16, 0,
						(i32wP & 0x8) == 0x8, (i32wP & 0x4) == 0x4);
					this.BrowserMouseDown(this, arg);
					if(arg.CancelMessage)
					{
						return User32.CallWindowProc(IntPtr.Zero, hWnd, message, wParam, mParam);
					}
				}
			}
			return User32.CallWindowProc(this._pIEWindowDefProc, hWnd, message, wParam, mParam);
		}
		/// <summary>
		/// EBhEbZ[W܂B
		/// </summary>
		/// <param name="m"></param>
		protected override void WndProc(ref Message m)
		{
			if(m.Msg == 0x210)//WM_NOTIFY
			{
				int iwParam = m.WParam.ToInt32();
				if(LOWORD(iwParam) == 0x20B) // WM_XBUTTONDOWN
				{
					int ipoint = m.LParam.ToInt32();
					MouseButtons btn = MouseButtons.None;
					switch(HIWORD(iwParam))
					{
						case (0x1): { btn |= MouseButtons.XButton1; break; }
						case (0x2): { btn |= MouseButtons.XButton2; break; }
					}
					MouseEventArgs arg = new MouseEventArgs(
						btn, 1, this.LOWORD(ipoint), this.HIWORD(ipoint), 0);
					this.OnMouseDown(arg); // sync ver
					//this.sync_mousedown(arg);
				}
			}
			base.WndProc(ref m);
		}
		/// <summary>
		/// ̃Rg[}EXCxg𔭐鎞Ɏgp郁\bh\܂B
		/// </summary>
		/// <param name="e"></param>
		delegate void MouseDownEventDelegate(MouseEventArgs e);
		/// <summary>
		/// MouseEventArgs}EXCxg󂯎āA<see cref="MouseDown"/>Cxg𔭐܂B
		/// </summary>
		/// <param name="e"></param>
		private void async_mousedown(MouseEventArgs e)
		{
			this.BeginInvoke(new MouseDownEventDelegate(this.OnMouseDown), new object[] { e });
		}

		/// <summary>
		/// <see cref="Int32"/>A16bitiPjuj𔲂o<see cref="Int16"/>ƂĕԂ܂B
		/// </summary>
		/// <param name="dword"></param>
		/// <returns>16biti1juj</returns>
		private short HIWORD(int dword)
		{
			return (short)(dword >> 16);
		}
		/// <summary>
		/// <see cref="Int32"/>A16bitiPjuj𔲂o<see cref="Int16"/>ƂĕԂ܂B
		/// </summary>
		/// <param name="dword"></param>
		/// <returns>16biti1juj</returns>
		private short LOWORD(int dword)
		{
			return (short)(dword & 0xFFFF);
		}

		#endregion
		


		#region I/F **** ITbPageControl o

		string ITbPageControl.DisplayUrl
		{
			get
			{
				string url = null;
				try { url = this.Url; }
				catch { url = ""; }
				if(url == null) { url = ""; }
				return url;
			}
		}
		string ITbPageControl.DisplayTitle
		{
			get
			{
				string title;
				try { title = this.DocumentTitle; }
				catch { title = ""; }
				if(title == null) { title = ""; }
				return title;
			}
		}
		string ITbPageControl.DisplayStatusText
		{
			get
			{
				string status = this.StatusText;
				if(status == null) status = "";
				return status;
			}
		}

		bool ITbPageControl.Navigate(string url)
		{
			this.Navigate(url);
			return true;
		}
		bool ITbPageControl.IsWebBrowser
		{
			get { return true; }
		}
		WebBrowserAx ITbPageControl.AsBrowser
		{
			get { return this; }
		}
		Control ITbPageControl.AsControl
		{
			get { return this as Control; }
		}
		void ITbPageControl.ReleaseControl()
		{
			if(this._browser != null)
			{
				this.Silent = true;
				this._browser.Stop();
				this.reset_WindowProdure();
				this._browser.Dispose();
				this._ism = null;
				this._history.Dispose();
				this._history = null;
				this._browser = null;
				this._pIEWindowDefProc = IntPtr.Zero;
				this.Dispose();
			}
		}
		event ITbDisplayEventHandler ITbPageControl.DisplayTextChanged
		{
			add { this._evt_DisplayTextChanged += value; }
			remove { this._evt_DisplayTextChanged -= value; }
		}
		
		#endregion


		#region ==== Inner Class Definitions ====

		delegate IntPtr WindowProcDelegate(IntPtr hWnd, int message, IntPtr wParam, IntPtr mParam);
		static class CommandState
		{
			public const int UpdateCommands		= -1;
			public const int NavigateForward	= 0x00000001;
			public const int NavigateBack		= 0x00000002;
		}

		#endregion

	}


	#region EventArgs

	/// <summary>
	/// Browser.Controls.Browsers.WebBrowserAx.BrowserMouseDownCxg̏i[NXłB
	/// </summary>
	/// <seealso cref="WebBrowserAx"/>
	/// <seealso cref="WebBrowserAx.BrowserMouseDown"/>
	/// <seealso cref="System.Windows.Forms.MouseEventArgs"/>
	public class WebBrowserMouseMessageEventArgs : MouseEventArgs
	{
		bool _trapMess;
		bool _ctrl = false;
		bool _shift = false;
		/// <summary>
		/// uCtrlvL[Ă邩ǂ擾܂B
		/// </summary>
		public bool CtrlKey
		{
			get { return this._ctrl; }
		}
		/// <summary>
		/// uShiftvL[Ă邩ǂ擾܂B
		/// </summary>
		public bool ShiftKey
		{
			get { return this._shift; }
		}
		/// <summary>
		/// bZ[WjAInternetExplorerServerɓ`BȂǂ擾Eݒ肵܂B
		/// trueɐݒ肳ƁAInternetExplorerServer̃ftHg삪ŝj~ł܂B
		/// </summary>
		public bool CancelMessage
		{
			get { return this._trapMess; }
			set { this._trapMess = value; }
		}

		/// <summary>
		/// ̃NX̃RXgN^łB
		/// Kvȏ󂯎EventArgs쐬܂B
		/// </summary>
		/// <param name="buttons">Ă{^</param>
		/// <param name="clicks">NbN</param>
		/// <param name="x">NCAgWX</param>
		/// <param name="y">NCAgWX</param>
		/// <param name="delta">zC[̉]</param>
		/// <param name="ctrl">CtrlL[̗̉L</param>
		/// <param name="shift">ShiftL[̗̉L</param>
		internal WebBrowserMouseMessageEventArgs(
			MouseButtons buttons, int clicks, int x, int y, int delta, bool ctrl, bool shift)
			: base(buttons, clicks, x, y, delta)
		{
			this._trapMess = false;
			this._ctrl = ctrl;
			this._shift = shift;
		}
	}
	/// <summary>
	/// Browser.Controls.Browsers.WebBrowserAx.BeforeNewWindowCxg̏i[NXłB
	/// </summary>
	/// <seealso cref="WebBrowserAx.BeforeNewWindow"/>
	/// <seealso cref="WebBrowserAx"/>
	/// <seealso cref="System.ComponentModel.CancelEventArgs"/>
	public class WebBrowserBeforeNewWindowEventArgs : CancelEventArgs
	{
		private DWebBrowserEvents2_NewWindow2Event _arg;

		/// <summary>
		/// Kvȏ󂯎EventArgs쐬܂B
		/// </summary>
		/// <param name="e">ɂȂAxSHDocVw.DWebBrowserEvents2_NewWindow2Event</param>
		public WebBrowserBeforeNewWindowEventArgs(DWebBrowserEvents2_NewWindow2Event e)
			: base(e.cancel)
		{
			this._arg = e;
		}

		/// <summary>
		/// NewWindowƂėpWebBrowser ActiveXIuWFNgւ̎QƂ擾Eݒ肵܂B
		/// </summary>
		public object ppDisp
		{
			get { return this._arg.ppDisp; }
			set { this._arg.ppDisp = value; }
		}
		/// <summary>
		/// LZ邩ǂ擾Eݒ肵܂B
		/// </summary>
		public new bool Cancel
		{
			get { return this._arg.cancel; }
			set { this._arg.cancel = value; base.Cancel = value; }
		}

		/// <summary>
		/// AxSHDocVw.DWebBrowserEvents2_NewWindow2Eventւ̎QƂO܂B
		/// </summary>
		internal void Release()
		{
			this._arg = null;
		}
	}
	/// <summary>
	/// Browser.Controls.Browsers.WebBrowserAx.BeforeNavigateCxg̏i[NXłB
	/// </summary>
	/// <seealso cref="System.ComponentModel.CancelEventArgs"/>
	public class WebBrowserBeforeNavigateEventArgs : CancelEventArgs
	{
		private DWebBrowserEvents2_BeforeNavigate2Event _arg;

		/// <summary>
		/// Kvȏ󂯎EventArgs쐬܂B
		/// </summary>
		/// <param name="e"></param>
		public WebBrowserBeforeNavigateEventArgs(DWebBrowserEvents2_BeforeNavigate2Event e)
			: base(e.cancel)
		{
			this._arg = e;
		}
		/// <summary>
		/// ړURL擾܂B
		/// </summary>
		public string Url
		{
			get { return _arg.uRL as string; }
		}
		/// <summary>
		/// ړ̃^[Qbgt[擾܂B
		/// </summary>
		public string Frame
		{
			get { return _arg.targetFrameName as string; }
		}
		/// <summary>
		/// ړsWebBrowser ActiveXIuWFNg擾܂B
		/// </summary>
		public object pDisp
		{
			get { return this._arg.pDisp; }
		}
		/// <summary>
		/// JڂLZ邩ǂ擾Eݒ肵܂B
		/// </summary>
		public new bool Cancel
		{
			get { return this._arg.cancel; }
			set { this._arg.cancel = value; base.Cancel = value; }
		}

		/// <summary>
		/// AxSHDocVw.DWebBrowserEvents2_BeforeNavigate2Eventւ̎QƂO܂B
		/// </summary>
		internal void Release()
		{
			this._arg = null;
		}
	}
	/// <summary>
	/// Browser.Controls.Browsers.WebBrowserAx.NavigateErrorCxg̏i[NXłB
	/// </summary>
	/// <seealso cref="System.ComponentModel.CancelEventArgs"/>
	public class WebBrowserNavigateErrorEventArgs : CancelEventArgs
	{
		private DWebBrowserEvents2_NavigateErrorEvent _arg;
		
		/// <summary>
		/// ړłURL擾܂B
		/// </summary>
		public string Url
		{
			get { return this._arg.uRL as string; }
		}
		/// <summary>
		/// ړ̃^[Qbgłt[擾܂B
		/// </summary>
		public string Frame
		{
			get { return this._arg.frame as string; }
		}
		/// <summary>
		/// JڂsWebBrowser ActiveXIuWFNgւ̎QƂ擾܂B
		/// </summary>
		public object pDisp
		{
			get { return this._arg.pDisp; }
		}
		/// <summary>
		/// sړLZ邩ǂ擾Eݒ肵܂B
		/// </summary>
		public new bool Cancel
		{
			get { return this._arg.cancel; }
			set { this._arg.cancel = value; base.Cancel = value; }
		}
		/// <summary>
		/// T[o[ԂꂽHTTPXe[^XR[h擾܂B
		/// </summary>
		public string StatusCode
		{
			get { return this._arg.statusCode as string; }
		}

		/// <summary>
		/// Kvȏ󂯎EventArgs쐬܂B
		/// </summary>
		/// <param name="e"></param>
		public WebBrowserNavigateErrorEventArgs(DWebBrowserEvents2_NavigateErrorEvent e)
			: base(e.cancel)
		{
			this._arg = e;
		}

		internal void Release()
		{
			this._arg = null;
		}
	}
	/// <summary>
	/// Browser.Controls.Browsers.Webbrowserax.WindowclosingCxg̏i[NXłB
	/// </summary>
	public class WebBrowserWindowClosingEventArgs : CancelEventArgs
	{
		private DWebBrowserEvents2_WindowClosingEvent _arg;
		/// <summary>
		/// XNvgɂĊJꂽEBhEł邩ǂ擾Eݒ肵܂B
		/// </summary>
		public bool IsChildWindow
		{
			get { return this._arg.isChildWindow; }
			set { this._arg.isChildWindow = value; }
		}
		/// <summary>
		/// ̃vpeB͎gp܂B
		/// </summary>
		public new bool Cancel
		{
			get { return this._arg.cancel; }
			set { this._arg.cancel = value; base.Cancel = value; }
		}
		/// <summary>
		/// AxSHDocVw.DWebBrowserEvents2_WindowClosing_Event̎QƂO܂B
		/// </summary>
		internal void Release()
		{
			this._arg = null;
		}

		/// <summary>
		/// KvȒl󂯎āAEventArgs쐬܂B
		/// </summary>
		/// <param name="arg"></param>
		public WebBrowserWindowClosingEventArgs(DWebBrowserEvents2_WindowClosingEvent arg)
			: base(arg.cancel)
		{
		}
	}

	#endregion

	/// <summary>
	/// WebBrowserAx::Navigateɓn̓̈BrbgtB[hłB
	/// </summary>
	[Flags]
	public enum BrowserNavConstants
	{
		/// <summary>
		/// VEBhEŊJ܂B
		/// </summary>
		navOpenInNewWindow=0x1,
		/// <summary>
		/// IE̗ɒǉ܂B
		/// </summary>
		navNoHistory=0x2,
		/// <summary>
		/// LbV̌s܂B
		/// </summary>
		navNoReadFromCache=0x4,
		/// <summary>
		/// t@CLbV܂B
		/// </summary>
		navNoWriteToCache=0x8,
		/// <summary>
		/// 
		/// </summary>
		navAllowAutosearch=0x10,
		/// <summary>
		/// 
		/// </summary>
		navBrowserBar=0x20,
		/// <summary>
		/// 
		/// </summary>
		navHyperlink=0x40,
		/// <summary>
		/// 
		/// </summary>
		navEnforceRestricted=0x80,
		/// <summary>
		/// 
		/// </summary>
		navNewWindowsManaged=0x0100,
		/// <summary>
		/// 
		/// </summary>
		navUntrustedForDownload=0x0200,
		/// <summary>
		/// 
		/// </summary>
		navTrustedForActiveX=0x0400,
		/// <summary>
		/// 
		/// </summary>
		navOpenInNewTab=0x0800,
		/// <summary>
		/// 
		/// </summary>
		navOpenInBackgroundTab=0x1000,
		/// <summary>
		/// 
		/// </summary>
		navKeepWordWheelText=0x2000,
		/// <summary>
		/// 
		/// </summary>
		navVirtualTab=0x4000
	}
	/// <summary>
	/// WebBrowserAx::Refreshɓn̈
	/// </summary>
	public enum RefreshConstant
	{
		/// <summary>
		/// W̓łB
		/// </summary>
		REFRESH_NORMAL=0,
		/// <summary>
		/// ؂̃LbVɊւĂ͍ă_E[h܂B
		/// </summary>
		REFRESH_IFEXPIRED=1,
		/// <summary>
		/// ׂẴt@Că_E[h܂B
		/// </summary>
		REFRESH_COMPLETELY=3
	}
	/// <summary>
	/// y[ẄÍԂ\񋓎q
	/// </summary>
	public enum SecureLockIconConstants
	{
		Unsecure=0,
		Mixed=0x1,
		SecureUnknownBits=0x2,
		Secure40Bit=0x3,
		Secure56Bit=0x4,
		SecureFortezza=0x5,
		Secure128Bit=0x6
	}

}
