using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;
using System.IO;

using System.Drawing;
using System.Windows.Forms;
using System.ComponentModel;


namespace Boon.Controls.Favorite
{
	using Boon.Functions;
	using SoapFormatter = System.Runtime.Serialization.Formatters.Soap.SoapFormatter;
	using TabBrowserDragDropData = Boon.Controls.Browsers.TabBrowserDragDropData;

	/// <summary>
	/// Cɓ@\Ǘ<see cref="System.Windows.Forms.Control"/>񋟂܂B
	/// </summary>
	public class FavoriteTreeView : Control, IBrowserNavigator
	{
		/// <summary>
		/// ̃NX̃RXgN^łB
		/// </summary>
		public FavoriteTreeView()
			: base()
		{
			this._syncCol = new object();

			FavoriteNode root = this.CreateRoot();

			this._core = new TreeView();
			this._core.Nodes.Add(root);
			this._root = root;

			this._core.ShowRootLines = true;
			this._core.LabelEdit = false;
			this._core.AllowDrop = true;
			this._core.ShowNodeToolTips = true;
			this._core.Margin = new Padding(0);
			this._core.Dock = DockStyle.Fill;
			this._core.ImageList = GlobalImages.GlobalListA;

			this._core.ItemDrag += new ItemDragEventHandler(FavoriteTreeView_ItemDrag);
			this._core.DragEnter += new DragEventHandler(FavoriteTreeView_DragEnter);
			this._core.DragOver += new DragEventHandler(FavoriteTreeView_DragOver);
			this._core.DragDrop += new DragEventHandler(FavoriteTreeView_DragDrop);

			this._core.MouseDown += new MouseEventHandler(FavoriteTreeView_MouseDown);
			this._core.NodeMouseClick += new TreeNodeMouseClickEventHandler(FavoriteTreeView_NodeMouseClick);
			this._core.NodeMouseDoubleClick += new TreeNodeMouseClickEventHandler(FavoriteTreeView_NodeMouseDoubleClick);
			this._core.AfterExpand += new TreeViewEventHandler(FavoriteTreeView_AfterExpand);
			this._core.AfterCollapse += new TreeViewEventHandler(FavoriteTreeView_AfterCollapse);

			this._core.PreviewKeyDown += new PreviewKeyDownEventHandler(FavoriteTreeView_PreviewKeyDown);
			this._core.KeyDown += new KeyEventHandler(FavoriteTreeView_KeyDown);

			this.Controls.Add(this._core);
			this.Margin = new Padding(0);
			this.Dock = DockStyle.Fill;

			this.init_ContextMenu();
		}


		#region ****** Event Handler *******

		#region +  Mouse / Keyboard

		/// <summary>
		/// TreeViewKeyDownCxg܂B
		/// </summary>
		/// <param name="sender">Cxg𔭐object</param>
		/// <param name="e">Cxg̃f[^i[Args</param>
		void FavoriteTreeView_KeyDown(object sender, KeyEventArgs e)
		{
		}
		/// <summary>
		/// TreeViewPreviewKeyDownCxg܂B
		/// </summary>
		/// <param name="sender">Cxg𔭐object</param>
		/// <param name="e">Cxg̃f[^i[Args</param>
		void FavoriteTreeView_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
		{
			if(e.KeyCode == Keys.Apps)
			{
				FavoriteNode node = this._core.SelectedNode as FavoriteNode;
				if(node != null)
				{
					Rectangle rect = this._core.SelectedNode.Bounds;
					this.FvShowItemContextMenu(this._core.SelectedNode as FavoriteNode, new Point(rect.Right, rect.Bottom));
				}
			}
			else if(e.KeyCode == Keys.Delete)
			{
				FavoriteNode node = this._core.SelectedNode as FavoriteNode;
				if(node != null && !node.IsProtected)
				{
					node.Remove();
				}
			}
		}

		/// <summary>
		/// TreeViewMouseDownCxg܂B
		/// </summary>
		/// <param name="sender">Cxg𔭐object</param>
		/// <param name="e">Cxg̃f[^i[Args</param>
		void FavoriteTreeView_MouseDown(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Right)
			{
				TreeNode node = this._core.GetNodeAt(e.Location);
				this._core.SelectedNode = node;
			}
			else if(e.Button == MouseButtons.Middle)
			{
				FavoriteNode node = this._core.GetNodeAt(e.Location) as FavoriteNode;
				if(node.IsNavigatable)
				{
					if(Uri.IsWellFormedUriString(node.Url, UriKind.Absolute))
					{
						this.OnNavigateRequired(new NavigateRequiredEventArgs(node.Url, true));
					}
				}
			}
		}
		/// <summary>
		/// TreeViewNodeMouseClickCxg܂B
		/// </summary>
		/// <param name="sender">Cxg𔭐object</param>
		/// <param name="e">Cxg̃f[^i[Args</param>
		void FavoriteTreeView_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
		{
			FavoriteNode node = e.Node as FavoriteNode;
			if(node != null)
			{
				if(e.Button == MouseButtons.Left)
				{
					if(node.IsNavigatable)
					{
						if(Uri.IsWellFormedUriString(node.Url, UriKind.Absolute))
						{
							this.OnNavigateRequired(new NavigateRequiredEventArgs(node.Url, false));
						}
					}
				}
				else if(e.Button == MouseButtons.Right)
				{
					if(node != null)
					{
						this._core.SelectedNode = node;
						this.FvShowItemContextMenu(node, e.Location);
					}
				}
			}
		}
		/// <summary>
		/// TreeViewNodeMouseDoubleClickCxg܂B
		/// </summary>
		/// <param name="sender">Cxg𔭐object</param>
		/// <param name="e">Cxg̃f[^i[Args</param>
		void FavoriteTreeView_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
		{
		}

		#endregion

		#region +  Drag & Drop

		/// <summary>
		/// TreeViewItemDragCxg܂B
		/// </summary>
		/// <param name="sender">Cxg𔭐object</param>
		/// <param name="e">Cxg̃f[^i[Args</param>
		void FavoriteTreeView_ItemDrag(object sender, ItemDragEventArgs e)
		{
			if(e.Button == MouseButtons.Left)
			{
				FavoriteNode node = e.Item as FavoriteNode;
				if(node != null && !node.IsFixed)
				{
					DataObject dataobj = new DataObject();

					dataobj.SetData(node);
					if(node.IsNavigatable)
					{
						dataobj.SetText(node.Url);
						byte[] ascii = BoonCommon.StringToASCIIBytes(node.Url);
						if(ascii.Length > 1)
						{
							MemoryStream ms = new MemoryStream(ascii);
							dataobj.SetData(Identify.UniformResourceLocator, ms);
						}
					}
					else { dataobj.SetText(node.Title); }

					DragDropEffects dde = DragDropEffects.Copy | DragDropEffects.Move | DragDropEffects.Link;
					dde = this._core.DoDragDrop(dataobj, dde);
				}
			}
		}
		/// <summary>
		/// TreeViewDragEnterCxg܂B
		/// </summary>
		/// <param name="sender">Cxg𔭐object</param>
		/// <param name="e">Cxg̃f[^i[Args</param>
		void FavoriteTreeView_DragEnter(object sender, DragEventArgs e)
		{
			if(e.Data.GetDataPresent(Identify.Favorite.TypeOfFavoriteNode))
			{
				e.Effect = e.AllowedEffect & DragDropEffects.Move;
			}
			else if(e.Data.GetDataPresent(Identify.Browsers.TypeOfTabBrowserDragDropData))
			{
				e.Effect = e.AllowedEffect & DragDropEffects.Copy;
			}
			else if(e.Data.GetDataPresent(Identify.UniformResourceLocator))
			{
				e.Effect = e.AllowedEffect & DragDropEffects.Copy;
			}
		}
		/// <summary>
		/// TreeViewDragOverCxg܂B
		/// </summary>
		/// <param name="sender">Cxg𔭐object</param>
		/// <param name="e">Cxg̃f[^i[Args</param>
		void FavoriteTreeView_DragOver(object sender, DragEventArgs e)
		{
			if(e.Data.GetDataPresent(Identify.Favorite.TypeOfFavoriteNode))
			{
				FavoriteNode node = this._core.GetNodeAt(this.PointToClient(new Point(e.X, e.Y))) as FavoriteNode;
				if(node == null)
				{
					this._core.SelectedNode = e.Data.GetData(Identify.Favorite.TypeOfFavoriteNode) as TreeNode;
					e.Effect = DragDropEffects.None;
				}
				else
				{
					this._core.SelectedNode = node;
					e.Effect = e.AllowedEffect & DragDropEffects.Move;
				}
			}
			else if(e.Data.GetDataPresent(Identify.Browsers.TypeOfTabBrowserDragDropData))
			{
				e.Effect = e.AllowedEffect & DragDropEffects.Copy;
			}
			else if(e.Data.GetDataPresent(Identify.UniformResourceLocator))
			{
				e.Effect = e.AllowedEffect & DragDropEffects.Copy;
			}
		}
		/// <summary>
		/// TreeViewDragDropCxg܂B
		/// </summary>
		/// <param name="sender">Cxg𔭐object</param>
		/// <param name="e">Cxg̃f[^i[Args</param>
		void FavoriteTreeView_DragDrop(object sender, DragEventArgs e)
		{
			if(e.Data.GetDataPresent(Identify.Favorite.TypeOfFavoriteNode))
			{
				FavoriteNode node = e.Data.GetData(Identify.Favorite.TypeOfFavoriteNode) as FavoriteNode;
				if(node != null && !node.IsFixed)
				{
					FavoriteNode droptarget = this._core.GetNodeAt(this.PointToClient(new Point(e.X, e.Y))) as FavoriteNode;
					if(droptarget != null
						&& node != droptarget
						&& node.Parent != droptarget
						&& (e.AllowedEffect & DragDropEffects.Move) == DragDropEffects.Move)
					{
						if(droptarget.IsContainer)
						{
							this.FvRemoveItem(node);
							if(this.FvAddItem(node, droptarget))
							{
								e.Effect = DragDropEffects.Move;
								e.Data.SetData(Identify.Favorite.DragDrop_Moved, "1");
							}
						}
						else if(droptarget.Parent != null)
						{
							int index = droptarget.Index;
							this.FvRemoveItem(node);
							if(this.FvInsertItem(node, droptarget.Parent as FavoriteNode, index))
							{
								e.Effect = DragDropEffects.Move;
								e.Data.SetData(Identify.Favorite.DragDrop_Moved, "1");
							}
						}
					}
				}
			}
			else if(e.Data.GetDataPresent(Identify.Browsers.TypeOfTabBrowserDragDropData))
			{
				TabBrowserDragDropData data = e.Data.GetData(Identify.Browsers.TypeOfTabBrowserDragDropData) as TabBrowserDragDropData;
				if(data != null)
				{
					if((e.AllowedEffect & DragDropEffects.Copy) == DragDropEffects.Copy)
					{
						FavoriteNode target = this._core.GetNodeAt(this.PointToClient(new Point(e.X, e.Y))) as FavoriteNode;
						FavoriteNode node = FavoriteNode.CreatePageNode(data.Title, data.Url, String.Empty);
						this.FvAddItem(node, target);
					}
				}
			}
			else if(e.Data.GetDataPresent(Identify.UniformResourceLocator))
			{
				e.Effect = e.AllowedEffect & DragDropEffects.Copy;
			}
		}
		#endregion

		#region +  TreeView Event

		/// <summary>
		/// TreeViewAfterCollapseCxg܂B
		/// </summary>
		/// <param name="sender">Cxg𔭐object</param>
		/// <param name="e">Cxg̃f[^i[Args</param>
		void FavoriteTreeView_AfterCollapse(object sender, TreeViewEventArgs e)
		{
			FavoriteNode node = e.Node as FavoriteNode;
			if(node != null && node.ImageKey == GlobalImages.IKEY_A_FOLDER_OPEN)
			{
				if(node == this._root) { return; }
				node.ImageKey = GlobalImages.IKEY_A_FOLDER;
				node.SelectedImageKey = GlobalImages.IKEY_A_FOLDER;
			}
		}
		/// <summary>
		/// TreeViewAfterExpandCxg܂B
		/// </summary>
		/// <param name="sender">Cxg𔭐object</param>
		/// <param name="e">Cxg̃f[^i[Args</param>
		void FavoriteTreeView_AfterExpand(object sender, TreeViewEventArgs e)
		{
			FavoriteNode node = e.Node as FavoriteNode;
			if(node != null && node.ImageKey == GlobalImages.IKEY_A_FOLDER)
			{
				if(node == this._root) { return; }
				node.ImageKey = GlobalImages.IKEY_A_FOLDER_OPEN;
				node.SelectedImageKey = GlobalImages.IKEY_A_FOLDER_OPEN;
			}
		}

		#endregion

		#endregion

		#region ****** Private ******

		/// <summary>
		/// Cɓ胋[gm[h쐬܂B
		/// </summary>
		/// <returns>쐬ꂽm[h</returns>
		private FavoriteNode CreateRoot()
		{
			FavoriteNode node = FavoriteNode.CreateFolderNode("Cɓ", "Cɓ̃[gvfłB");
			node.NodeType = FavoriteNodeType.Root;
			node.ImageKey = GlobalImages.IKEY_A_FAVORITE;
			node.SelectedImageKey = GlobalImages.IKEY_A_FAVORITE;
			return node;
		}

		#endregion


		#region ****** Tool Methods ******

		/// <summary>
		/// ɓnꂽm[hAɓnꂽm[h̑cɂ邩ǂ𔻒f܂B
		/// </summary>
		/// <param name="nodeMe">m[h</param>
		/// <param name="nodeAncestor">m[h̑cł邩𔻒fm[h</param>
		/// <returns>cł邱ƂmFłtrue</returns>
		public bool IsAncestor(TreeNode nodeMe, TreeNode nodeAncestor)
		{
			if(nodeMe == null || nodeAncestor == null) { return false; }
			TreeNode upper = nodeMe.Parent;
			while(upper != null)
			{
				if(upper == nodeAncestor) { return true; }
				else { upper = upper.Parent; }
			}
			return false;
		}


		#endregion


		#region ====== Field =======
		private TreeView _core;
		/// <summary>
		/// Cɓc[̍ŏʃm[h
		/// </summary>
		FavoriteNode _root;
		/// <summary>
		/// RNVւ̒ǉE폜𓯊邽߂̃IuWFNg
		/// </summary>
		object _syncCol;
		#endregion


		#region ------ Property ------

		/// <summary>
		/// ʏ̂Cɓm[h̍ŏʂɂ<see cref="FavoriteNode"/>擾܂B
		/// </summary>
		public FavoriteNode RootNode
		{
			get { return this._root; }
		}
		/// <summary>
		/// RootNodẽRNV̒Aw肵CfbNẌʒuɂm[h擾܂B
		/// </summary>
		/// <param name="index">擾m[h̃CfbNX</param>
		/// <returns><see cref="FavoriteNode"/>̃CX^XB</returns>
		public FavoriteNode GetNode(int index)
		{
			return this._core.Nodes[index] as FavoriteNode;
		}

		#endregion


		#region Collection Access Methods

		#region +    Item Add/Insert

		/// <summary>
		/// Cɓm[hc[ɒǉ܂Bǉ́A<see cref="RootNode"/>m[h̎q̍ŌłB
		/// </summary>
		/// <param name="node">ǉm[h</param>
		/// <returns>ꍇtrue</returns>
		public bool FvAddItem(FavoriteNode node)
		{
			return this.FvAddItem(node, this.RootNode);
		}
		/// <summary>
		/// Cɓm[hc[ɍ쐬܂Bǉ́A<paramref name="target"/>m[h̎q̍ŌłB
		/// <para><paramref name="target"/>m[h<see cref="FavoriteNode.IsContainer"/>vpeB̒l<value>false</value>̎͂̃m[ḧʒuɑ}܂B</para>
		/// </summary>
		/// <param name="node">ǉm[h</param>
		/// <param name="target">ǉ̃m[hB<value>null</value>nꂽꍇA<see cref="RootNode"/>ɂȂ܂B</param>
		/// <returns>ꍇtrue</returns>
		public bool FvAddItem(FavoriteNode node, FavoriteNode target)
		{
			if(node == null) { return false; }
			if(target == null) { target = this.RootNode; }
			if(target.IsContainer)
			{
				return this.AddItemInternal(node, target);
			}
			else if(target.Parent != null)
			{
				return this.AddItemInternal(node, target.Parent as FavoriteNode);
			}
			return false;
		}
		/// <summary>
		/// Cɓm[hw肵CfbNXʒuɒǉ܂Bw肳ꂽCfbNXȂ玸s܂B
		/// </summary>
		/// <param name="node">ǉ邨Cɓm[h</param>
		/// <param name="target">ǉ̃m[hB<value>null</value>nꂽꍇA<see cref="RootNode"/>ɂȂ܂B</param>
		/// <param name="index">m[h̒ǉʒuB</param>
		/// <returns><value>true</value>Ԃ܂B</returns>
		public bool FvInsertItem(FavoriteNode node, FavoriteNode target, int index)
		{
			if(node == null) { return false; }
			if(target == null) { target = this.RootNode; }
			if(!target.IsContainer) { return false; }
			return this.InsertItemInternal(node, target, index);
		}

		#endregion

		#region +    Create and Add/Insert

		/// <summary>
		/// CɓtH_c[ɍ쐬܂Bǉ́A<see cref="RootNode"/>m[h̎q̍ŌłB
		/// ߂l͍쐬ꂽm[hłB
		/// </summary>
		/// <param name="title">m[hɕ\^Cg</param>
		/// <param name="comment">m[h̊T\Rg</param>
		/// <returns>ǉꂽm[hBsꍇ<value>null</value></returns>
		public FavoriteNode FvAddFolder(string title, string comment)
		{
			return this.FvAddFolder(title, comment, this.RootNode);
		}
		/// <summary>
		/// CɓtH_c[ɍ쐬܂Bǉ́A<paramref name="target"/>m[h̍ŌłB
		/// ߂l͍쐬ꂽm[hłB
		/// </summary>
		/// <param name="title">m[hɕ\^Cg</param>
		/// <param name="comment">m[h̊T\Rg</param>
		/// <param name="target">ǉ̃m[hB<value>null</value>nꂽꍇA<see cref="RootNode"/>ɂȂ܂B</param>
		/// <returns>ǉꂽm[hBsꍇ<value>null</value></returns>
		public FavoriteNode FvAddFolder(string title, string comment, FavoriteNode target)
		{
			FavoriteNode node = FavoriteNode.CreateFolderNode(title, comment);
			if(this.FvAddItem(node, target)) { return node; }
			else return null;
		}

		/// <summary>
		/// CɓtH_w肵CfbNXʒuɍ쐬܂Bw肳ꂽCfbNXȂ玸s܂B
		/// ߂l͍쐬ꂽm[hłB
		/// </summary>
		/// <param name="title">m[hɕ\^Cg</param>
		/// <param name="comment">m[h̊Tv\</param>
		/// <param name="target">ǉ̃m[hB<value>null</value>nꂽꍇA<see cref="RootNode"/>ɂȂ܂B</param>
		/// <param name="index">m[h̒ǉʒuB</param>
		/// <returns>쐬ꂽm[hBsꍇ<see cref="null"/>Ԃ܂B</returns>
		public FavoriteNode FvInsertFolder(string title, string comment, FavoriteNode target, int index)
		{
			FavoriteNode node = FavoriteNode.CreateFolderNode(title, comment);
			if(this.FvInsertItem(node, target, index)) { return node; }
			return null;
		}


		/// <summary>
		/// CɓtH_c[ɍ쐬܂Bǉ́A<paramref name="target"/>m[h̍ŌłB
		/// ߂l͍쐬ꂽm[hłB
		/// </summary>
		/// <param name="title">m[hɕ\^Cg</param>
		/// <param name="comment">m[h̊T\Rg</param>
		/// <param name="target">ǉ̃m[hB<value>null</value>nꂽꍇA<see cref="RootNode"/>ɂȂ܂B</param>
		public FavoriteNode FvAddPage(string title, string url, string comment)
		{
			return this.FvAddPage(title, url, comment, this.RootNode);
		}
		/// <summary>
		/// CɓtH_c[ɍ쐬܂Bǉ́A<paramref name="target"/>m[h̍ŌłB
		/// <paramref name="target"/><value>null</value>̏ꍇAǉ<see cref="RootNode"/>̎q̍ŌłB
		/// ߂l͍쐬ꂽm[hłB
		/// </summary>
		/// <param name="title">m[hɕ\^Cg</param>
		/// <param name="comment">m[h̊T\Rg</param>
		/// <param name="target">ǉ̃m[hB<value>null</value>nꂽꍇA<see cref="RootNode"/>ɂȂ܂B</param>
		public FavoriteNode FvAddPage(string title, string url, string comment, FavoriteNode target)
		{
			FavoriteNode node = FavoriteNode.CreatePageNode(title, url, comment);
			if(this.FvAddItem(node, target)) { return node; }
			return null;
		}

		/// <summary>
		/// Cɓy[Ww肵CfbNXʒuɍ쐬܂Bw肳ꂽCfbNXȂ玸s܂B
		/// ߂l͍쐬ꂽm[hłB
		/// </summary>
		/// <param name="title">m[hɕ\^Cg</param>
		/// <param name="url">m[hɊ֘AtꂽURL</param>
		/// <param name="comment">m[h̊Tv\</param>
		/// <param name="target">ǉ̃m[hB<value>null</value>nꂽꍇA<see cref="RootNode"/>ɂȂ܂B</param>
		/// <param name="index">m[h̒ǉʒuB</param>
		/// <returns>쐬ꂽm[hBsꍇ<see cref="null"/>Ԃ܂B</returns>
		public FavoriteNode FvInsertPage(string title, string url, string comment, FavoriteNode target, int index)
		{
			FavoriteNode node = FavoriteNode.CreatePageNode(title, url, comment);
			if(this.FvInsertItem(node, target, index)) { return node; }
			return null;
		}

		#endregion

		#region +    Edit / Remove

		/// <summary>
		/// nꂽm[h̓e܂Ƃ߂ĕύX܂B<paramref name="node"/>ȊÖ<value>null</value>nꂽꍇÄɑΉvpeB͍XV܂B
		/// </summary>
		/// <param name="node">ҏWΏۂ̃m[h</param>
		/// <param name="title">V<see cref="Title"/>vpeB̒l</param>
		/// <param name="url">V<see cref="Url"/>vpeB̒l</param>
		/// <param name="comment">V<see cref="Comment"/>vpeB̒l</param>
		/// <returns>ҏWꂽm[hB<paramref name="node"/>ɓnꂽCX^XłB</returns>
		public FavoriteNode FvEditItem(FavoriteNode node, string title, string url, string comment)
		{
			if(node != null)
			{
				if(title != null) { node.Title = title; }
				if(url != null) { node.Url = url; }
				if(comment != null) { node.Comment = comment; }
				return node;
			}
			return null;
		}
		/// <summary>
		/// _CAO\ėvfҏW܂B
		/// </summary>
		/// <param name="node">lҏWm[h</param>
		/// <returns>vf̒lXVꍇ<value>true</value></returns>
		public bool FvEditItemCustom(FavoriteNode node)
		{
			if(node != null)
			{
				using(EditDialog dialog = new EditDialog())
				{
					if(dialog.ShowDialog(this, node, false) == DialogResult.OK)
					{
						node.Title = dialog.TitleText;
						if(dialog.ContainsUrl)
						{
							node.Url = dialog.UrlText;
						}
						node.Comment = dialog.CommentText;
						return true;
					}
				}
			}
			return false;
		}

		/// <summary>
		/// Cɓm[hTreeView폜܂B
		/// </summary>
		/// <param name="node">菜m[h</param>
		public void FvRemoveItem(FavoriteNode node)
		{
			if(node != null)
			{
				this.RemoveItemInternal(node);
			}
		}
		/// <summary>
		/// <see cref="RootNode"/>̉ʃRNVɊi[Ăm[hNA܂B
		/// </summary>
		public void FvClearItem()
		{
			this.RootNode.Nodes.Clear();
		}

		#endregion

		#region +    Customized Add/Edit

		/// <summary>
		/// _CAO\ēeҏWAy[Wvf}܂B
		/// </summary>
		/// <param name="title">_CAOɕ\鏉^Cg</param>
		/// <param name="url">_CAOɕ\鏉URL</param>
		/// <param name="comment">_CAOɕ\鏉Rg</param>
		/// <returns>vf̒ǉꍇ<value>true</value></returns>
		public bool FvAddPageCustom(string title, string url, string comment)
		{
			bool res = false;
			using(AddItemDialog dialog = new AddItemDialog(this))
			{
				if(dialog.ShowDialog(this, title, url, comment) == DialogResult.OK)
				{
					FavoriteNode target = dialog.Selected;
					if(target == null) { target = this.RootNode; }
					FavoriteNode node = FavoriteNode.CreatePageNode(dialog.TitleText, dialog.UrlText, dialog.CommentText);
					if(node != null) { res = this.FvAddItem(node, target); }
				}
			}
			return res;
		}
		/// <summary>
		/// _CAO\ēeҏWAtH_vf}܂B
		/// </summary>
		/// <param name="title">_CAOɕ\鏉^Cg</param>
		/// <param name="comment">_CAOɕ\鏉Rg</param>
		/// <returns>vf̒ǉꍇ<value>true</value></returns>
		public bool FvAddFolderCustom(string title, string comment)
		{
			bool res = false;
			using(AddItemDialog dialog = new AddItemDialog(this))
			{
				if(dialog.ShowDialog(this, title, comment) == DialogResult.OK)
				{
					FavoriteNode target = dialog.Selected;
					if(target == null) { target = this.RootNode; }
					FavoriteNode node = FavoriteNode.CreateFolderNode(dialog.TitleText, dialog.CommentText);
					if(node != null) { res = this.FvAddItem(node, target); }
				}
			}
			return res;
		}

		#endregion

		#region +    Private Members for CollectionAccess
		/// <summary>
		/// RNVւAddANZX󂯂܂B
		/// </summary>
		/// <param name="node">ǉm[h</param>
		/// <param name="target">ǉʒuiem[hj</param>
		/// <returns><value>true</value></returns>
		private bool AddItemInternal(FavoriteNode node, FavoriteNode target)
		{
			if(!target.IsContainer) { throw new FavoriteException(); }
			lock(this._syncCol)
			{
				int i = target.Nodes.Add(node);
				if(i >= 0) { return true; }
			}
			return false;
		}
		/// <summary>
		/// RNVւInsertANZX󂯂܂B
		/// </summary>
		/// <param name="node">ǉm[h</param>
		/// <param name="target">ǉʒuiem[hj</param>
		/// <param name="index">ǉʒuiCfbNXj</param>
		/// <returns><value>true</value></returns>
		private bool InsertItemInternal(FavoriteNode node, FavoriteNode target, int index)
		{
			if(!target.IsContainer) { throw new FavoriteException(); }
			lock(this._syncCol)
			{
				if(0 <= index && index <= target.Nodes.Count)
				{
					target.Nodes.Insert(index, node);
					return true;
				}
			}
			return false;
		}
		/// <summary>
		/// RNVւRemoveANZX󂯂܂B
		/// </summary>
		/// <param name="node">폜m[h</param>
		private void RemoveItemInternal(FavoriteNode node)
		{
			lock(this._syncCol) { if(node.Parent != null) { node.Parent.Nodes.Remove(node); }; }
		}
		#endregion

		#endregion


		#region Serialize / Deserialize Methods

		/// <summary>
		/// Cɓf[^t@Cǂݍ݂܂B
		/// </summary>
		/// <param name="filepath">ǂݍ݃t@C̃tpX</param>
		/// <returns>ǂݍ݂ɐꍇtrue</returns>
		/// <exception cref="System.IO.InvalidDataException">Cɓt@Cvdl𖞂ĂȂꍇɔ܂B</exception>
		/// <exception cref="System.Runtime.Serialization.SerializationException"><see cref="FavoriteNode"/>ւ̃fVACYɎsꍇɔ܂B</exception>
		/// <exception cref="System.IO.IOException">t@Cւ̃ANZXɎsۂɔ܂</exception>
		/// <exception cref="System.UnauthorizedAccessException">t@Cւ̓ǂݍ݃ANZXȂƂɔ܂B</exception>
		/// <exception cref="System.NotSupportedException"></exception>
		/// <exception cref="System.Security.SecurityException"></exception>
		public bool FvLoadFavorite(string filepath)
		{
			if(!Path.IsPathRooted(filepath)) { return false; }
			FileInfo file = new FileInfo(filepath);
			if(!file.Exists) { return false; }
			FavoriteNode node = null;
			SoapFormatter formatter = new SoapFormatter();
			lock(this._syncCol)
			{
				using(Stream reader = file.OpenRead())
				{
					node = formatter.Deserialize(reader) as FavoriteNode;
					reader.Close();
				}

				if(node.NodeType == FavoriteNodeType.Root)
				{
					this._core.Nodes.Clear();
					this._core.Nodes.Add(node);
					this._root = node;
					return true;
				}
				else { throw new InvalidDataException("Cɓt@C̍\jĂ܂B"); }
			}
		}
		/// <summary>
		/// Cɓf[^t@C֏o܂B
		/// </summary>
		/// <param name="filepath">ۑ̃t@CpX</param>
		/// <returns>ꍇtrue</returns>
		/// <exception cref="System.Runtime.Serialization.SerializationException"><see cref="FavoriteNode"/>̃VACYɎsꍇɔ܂B</exception>
		/// <exception cref="System.IO.IOException">t@Cւ̃ANZXɎsۂɔ܂</exception>
		/// <exception cref="System.UnauthorizedAccessException">t@Cւ̓ǂݍ݃ANZXȂƂɔ܂B</exception>
		/// <exception cref="System.NotSupportedException"></exception>
		/// <exception cref="System.Security.SecurityException"></exception>
		public void FvSaveFavorite(string filepath)
		{
			lock(this._syncCol)
			{
				FileInfo file = new FileInfo(filepath);
				string backuppath = file.FullName + ".old";
				if(file.Exists)
				{
					if(File.Exists(backuppath)) { File.Delete(backuppath); }
					file.MoveTo(backuppath);
				}
				SoapFormatter formatter = new SoapFormatter();
				file = new FileInfo(filepath);
				using(Stream writer = file.Create())
				{
					formatter.Serialize(writer, this._root);
					writer.Close();
				}
			}
		}

		#endregion


		#region Group : Context Menu

		/// <summary>
		/// m[h̃ReLXgj[J܂B
		/// </summary>
		/// <param name="target">Ώۂ̃m[h</param>
		/// <param name="ptLocal">j[\郍[JW</param>
		public void FvShowItemContextMenu(FavoriteNode target, Point ptLocal)
		{
			if(target == null) { return; }
			this._ctxMenu.Tag = target;
			this._ctxMenu.Show(this, ptLocal);
		}

		/// <summary>
		/// ReLXgj[܂B
		/// </summary>
		private void init_ContextMenu()
		{
			this._ctxMenu = new ContextMenuStrip();
			this._ctxMenu.Opening += new CancelEventHandler(_ctxMenu_Opening);
			this._ctxMenu.Closed += new ToolStripDropDownClosedEventHandler(_ctxMenu_Closed);
			this._ctxMenu.AutoSize = true;

			this._tsmi_00_Open = new ToolStripMenuItem("݂̃^uŊJ");
			this._tsmi_00_Open.Click += new EventHandler(_tsmi_00_Open_Click);

			this._tsmi_01_OpenNew = new ToolStripMenuItem("V^uŊJ");
			this._tsmi_01_OpenNew.Click += new EventHandler(_tsmi_01_OpenNew_Click);

			this._tsmi_02_Edit = new ToolStripMenuItem("eҏW");
			this._tsmi_02_Edit.Click += new EventHandler(_tsmi_02_Edit_Click);

			this._tsmi_03_CreateFolder = new ToolStripMenuItem("ɃtH_쐬");
			this._tsmi_03_CreateFolder.Click += new EventHandler(_tsmi_03_CreateFolder_Click);

			this._tsmi_04_CreatePage = new ToolStripMenuItem("Ƀy[W쐬");
			this._tsmi_04_CreatePage.Click += new EventHandler(_tsmi_04_CreatePage_Click);

			this._tsmi_05_Delete = new ToolStripMenuItem("̃ACe폜");
			this._tsmi_05_Delete.Click += new EventHandler(_tsmi_05_Delete_Click);

			this._ctxMenu.Items.AddRange(new ToolStripItem[]{
				this._tsmi_00_Open,
				this._tsmi_01_OpenNew,
				this._tsmi_02_Edit,
				this._tsmi_03_CreateFolder,
				this._tsmi_04_CreatePage,
				this._tsmi_05_Delete,
			});
		}

		#region +    Context Menu Event Handlers

		void _ctxMenu_Opening(object sender, CancelEventArgs e)
		{
			FavoriteNode node = this._ctxMenu.Tag as FavoriteNode;
			if(node == null) { e.Cancel = true; }
			else
			{
				this._tsmi_00_Open.Visible = node.IsNavigatable;
				this._tsmi_01_OpenNew.Visible = node.IsNavigatable;
				this._tsmi_02_Edit.Visible = !node.IsProtected;
				this._tsmi_03_CreateFolder.Visible = node.IsContainer;
				this._tsmi_04_CreatePage.Visible = node.IsContainer;
				this._tsmi_05_Delete.Visible = !node.IsProtected;

				foreach(ToolStripMenuItem item in this._ctxMenu.Items)
				{
					e.Cancel = e.Cancel && (!item.Visible);
				}
			}
		}
		void _ctxMenu_Closed(object sender, ToolStripDropDownClosedEventArgs e)
		{
			if(e.CloseReason != ToolStripDropDownCloseReason.ItemClicked)
			{
				this._ctxMenu.Tag = null;
			}
		}

		void _tsmi_00_Open_Click(object sender, EventArgs e)
		{
			FavoriteNode node = this._ctxMenu.Tag as FavoriteNode;
			this._ctxMenu.Tag = null;
			if(node != null && (node.NodeType & FavoriteNodeType._Navigatable) == FavoriteNodeType._Navigatable)
			{
				string url = node.Url;
				if(Uri.IsWellFormedUriString(url, UriKind.Absolute))
				{
					this.OnNavigateRequired(new NavigateRequiredEventArgs(url, false));
				}
			}
		}
		void _tsmi_01_OpenNew_Click(object sender, EventArgs e)
		{
			FavoriteNode node = this._ctxMenu.Tag as FavoriteNode;
			this._ctxMenu.Tag = null;
			if(node != null && (node.NodeType & FavoriteNodeType._Navigatable) == FavoriteNodeType._Navigatable)
			{
				string url = node.Url;
				if(Uri.IsWellFormedUriString(url, UriKind.Absolute))
				{
					this.OnNavigateRequired(new NavigateRequiredEventArgs(url, true));
				}
			}
		}
		void _tsmi_02_Edit_Click(object sender, EventArgs e)
		{
			FavoriteNode node = this._ctxMenu.Tag as FavoriteNode;
			this._ctxMenu.Tag = null;
			if(!node.IsProtected)
			{
				this.FvEditItemCustom(node);
			}
		}
		void _tsmi_03_CreateFolder_Click(object sender, EventArgs e)
		{
			FavoriteNode node = this._ctxMenu.Tag as FavoriteNode;
			this._ctxMenu.Tag = null;
			if(node != null)
			{
				this.FvAddFolder("NewFolder", String.Empty, node); 
			}
		}
		void _tsmi_04_CreatePage_Click(object sender, EventArgs e)
		{
			FavoriteNode node = this._ctxMenu.Tag as FavoriteNode;
			this._ctxMenu.Tag = null;
			if(node != null)
			{
				this.FvAddPage("about:blank", "about:blank", String.Empty, node);
			}
		}
		void _tsmi_05_Delete_Click(object sender, EventArgs e)
		{
			FavoriteNode node = this._ctxMenu.Tag as FavoriteNode;
			this._ctxMenu.Tag = null;
			if(node != null)
			{
				if(!node.IsProtected)
				{
					node.Remove();
				}
			}
		}

		#endregion

		/// <summary>
		/// TreeViewŎgpReLXgj[
		/// </summary>
		ContextMenuStrip _ctxMenu;
		/// <summary>
		/// <see cref="_ctxMenu"/>Ŏgp<see cref="ToolStripMenuItem"/>B
		/// NbNƃm[hɊ֘AtꂽURLŃirQ[g˗o܂B
		/// </summary>
		ToolStripMenuItem _tsmi_00_Open;
		/// <summary>
		/// <see cref="_ctxMenu"/>Ŏgp<see cref="ToolStripMenuItem"/>B
		/// NbNƃm[hɊ֘AtꂽURLŁAVK^uł̃irQ[g˗o܂B
		/// </summary>
		ToolStripMenuItem _tsmi_01_OpenNew;
		/// <summary>
		/// <see cref="_ctxMenu"/>Ŏgp<see cref="ToolStripMenuItem"/>B
		/// NbNƃm[h<see cref="FvEditItemCustom"/>Kp܂B
		/// </summary>
		ToolStripMenuItem _tsmi_02_Edit;
		/// <summary>
		/// <see cref="_ctxMenu"/>Ŏgp<see cref="ToolStripMenuItem"/>B
		/// NbNƃm[h<see cref="FvAddFolderCustom"/>Kp܂B
		/// </summary>
		ToolStripMenuItem _tsmi_03_CreateFolder;
		/// <summary>
		/// <see cref="_ctxMenu"/>Ŏgp<see cref="ToolStripMenuItem"/>B
		/// NbNƃm[h<see cref="FvAddPageCustom"/>Kp܂B
		/// </summary>
		ToolStripMenuItem _tsmi_04_CreatePage;
		/// <summary>
		/// <see cref="_ctxMenu"/>Ŏgp<see cref="ToolStripMenuItem"/>B
		/// NbNƃm[h<see cref="FvRemoveItem"/>Kp܂B
		/// </summary>
		ToolStripMenuItem _tsmi_05_Delete;

		#endregion


		#region IBrowserNavigator o

		/// <summary>
		/// <see cref="NavigateRequired"/>Cxg𔭐܂B
		/// </summary>
		/// <param name="args">Cxg̃f[^i[Args</param>
		protected void OnNavigateRequired(NavigateRequiredEventArgs args)
		{
			if(this.NavigateRequired != null)
			{
				this.NavigateRequired(this, args);
			}
		}
		/// <summary>
		/// uEUɃirQ[g˗o܂B
		/// </summary>
		public event NavigateRequiredEventHandler NavigateRequired;

		#endregion

	}

	/// <summary>
	/// <see cref="Boon.Control.Favorite"/>OԂŎgpO\܂B
	/// </summary>
	public class FavoriteException : Exception
	{
		const string DEF_MSG = "CɓR|[lgŃG[܂B";
		/// <summary>
		/// ̃NX̃RXgN^łB
		/// </summary>
		public FavoriteException() : base(DEF_MSG)
		{
		}
		/// <summary>
		/// ̃NX̃RXgN^łB
		/// </summary>
		/// <param name="inner">Ɋi[O</param>
		public FavoriteException(Exception inner)
			: base(DEF_MSG, inner)
		{
		}
	}
}