using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Net;
using System.Text;
using System.Threading;
using System.Text.RegularExpressions;
using System.Windows.Forms;

using Boon.Controls.Browsers;

using Boon.Collections;
using Boon.Net;
using Boon.IO.File;
using HttpService.API;
using HttpService.API.Request;
using Boon.Forms.Dialog;

namespace Boon.Forms
{
	public partial class MainForm : Form
	{

		#region Event Handler

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void downloadListView_SelectedIndexChanged(object sender, EventArgs e)
		{

		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void downloadListView_SizeChanged(object sender, EventArgs e)
		{

		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void downloadListView_ColumnClick(object sender, ColumnClickEventArgs e)
		{
			this.downloadListView.ListViewItemSorter = new DownloadListViewItemComparer(e.Column);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void downloadListView_MouseClick(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Right)
			{
				ListView.SelectedListViewItemCollection list = this.downloadListView.SelectedItems;
				if(list == null) return;
				bool canCancel = true;
				for(int i = 0; i < list.Count; i++)
				{
					ListViewItem lvi = list[i];
					VideoFileData vfd = (VideoFileData)lvi.Tag;
					if((vfd.videoFileStatus != VideoFileData.DOWNLOAD_PROCESSING) && (vfd.videoFileStatus != VideoFileData.DOWNLOAD_WAITING))
					{
						canCancel = false;
						break;
					}
				}

				this.contextMenuStrip300_ForDownloadList.Items[0].Visible = canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[1].Visible = !canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[2].Visible = canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[3].Visible = canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[4].Visible = !canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[5].Visible = !canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[6].Visible = !canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[7].Visible = !canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[8].Visible = !canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[9].Visible = !canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[10].Visible = !canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[11].Visible = !canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[12].Visible = !canCancel;
				this.contextMenuStrip300_ForDownloadList.Items[13].Visible = !canCancel;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void downloadListView_ItemDrag(object sender, ItemDragEventArgs e)
		{
			//DataObject obj = new DataObject(DataFormats.FileDrop, (ListView)sender);
			DataObject obj = new DataObject();
			ListView.SelectedListViewItemCollection list = this.downloadListView.SelectedItems;
			if((list == null) || (list.Count == 0)) return;

			FileInfo[] vfi = new FileInfo[list.Count];
			FileInfo[] cfi = new FileInfo[list.Count];
			for(int i = 0; i < vfi.Length; i++)
			{
				VideoFileData vfd = list[i].Tag as VideoFileData;

				cfi[i] = new FileInfo(vfd.commentFilePath);
				vfi[i] = new FileInfo(vfd.videoFilePath);
			}

			obj.SetData("commentPath", cfi);
			obj.SetData("videoPath", vfi);

			if(list.Count > 0)
			{
				MemoryStream ms = new MemoryStream(System.Text.Encoding.ASCII.GetBytes(((VideoFileData)list[0].Tag).fileUrl));
				obj.SetData("UniformResourceLocator", ms);
				Debug.WriteLine(((VideoFileData)list[0].Tag).fileUrl);
			}

			if(((ListView)sender).DoDragDrop(obj, DragDropEffects.Link | DragDropEffects.Move) == DragDropEffects.Move)
			{
				foreach(ListViewItem lvi in list)
				{
					//lvi.Remove();
				}
			}

		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void downloadListView_DragEnter(object sender, DragEventArgs e)
		{
			Debug.WriteLine(sender.ToString());
		}

		/// <summary>
		/// DownloadListViewD&Dꂽۂ̃CxgłB
		/// </summary>
		/// <param name="sender">Cxg𔭍sIuWFNg</param>
		/// <param name="e">Cxgp[^ێDragEventArgsIuWFNg</param>
		private void downloadListView_DragDrop(object sender, DragEventArgs e)
		{
			System.Diagnostics.Debug.WriteLine(e.Data.GetData(typeof(String)));
		}

		#endregion


		/// <summary>
		/// 
		/// </summary>
		/// <param name="videoID"></param>
		/// <returns></returns>
		public ListViewItem getListViewItem(string videoID)
		{
			foreach(ListViewItem i in this.downloadListView.Items)
			{
				if(videoID.Equals(i.Name)) return (i);
			}

			return (null);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="fullpath"></param>
		private void updateSaveFolderListView(string fullpath)
		{
			string[] movieFiles = Directory.GetFiles(fullpath, "*.*", SearchOption.TopDirectoryOnly);
			this.saveFolderListView.Items.Clear();

			for(int i = 0; i < movieFiles.Length; i++)
			{
				FileInfo f = new FileInfo(movieFiles[i]);
				if(!Regex.IsMatch(f.Extension, @"\.(flv|mp4|swf)$", RegexOptions.IgnoreCase)) continue;
				ListViewItem lvi =
					new ListViewItem
					(
						new string[]
                        {
                            f.Name.Substring(0, f.Name.Length - f.Extension.Length),
                            string.Format("{0:F4}", (((float)f.Length) / (1024 * 1024))),
                            f.LastWriteTime.ToString("yyyy/MM/dd HH:mm:ss"),
                            f.Extension
                        }
					);
				lvi.Tag = f.FullName;
				this.saveFolderListView.Items.Add(lvi);
			}

		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="listKind"></param>
		private void toggleListView(int listKind)
		{
			switch(listKind)
			{
				case BoonDefine.DOWNLOAD_FOLDER_INDEX:
					this.saveFolderListView.Visible = false;
					this.saveFolderListView.Items.Clear();
					this.SearchResultListView.Visible = false;
					this.downloadListView.Visible = true;

					break;

				case BoonDefine.SAVE_FOLDER_INDEX:
					this.downloadListView.Visible = false;
					this.SearchResultListView.Visible = false;
					this.saveFolderListView.Visible = true;

					break;

				case BoonDefine.SEARCH_FILES_INDEX:
					this.saveFolderListView.Visible = false;
					this.saveFolderListView.Items.Clear();
					this.SearchResultListView.Visible = true;
					this.downloadListView.Visible = false;
					this.SearchResultListView.Clear();
					this.SearchResultListView.Columns.AddRange
					(
						new System.Windows.Forms.ColumnHeader[]
                        {
                           (ColumnHeader) this.columnHeader1_title.Clone(),
					       (ColumnHeader) this.columnHeader1_size.Clone(),
					       (ColumnHeader) this.columnHeader1_registTimestamp.Clone(),
					       (ColumnHeader) this.columnHeader1_extension.Clone(),
					       (ColumnHeader) this.columnHeader1_fullpath.Clone()
                        }
					);

					break;

				default:
					break;
			}
		}



		/// <summary>
		/// DownloadListViewItemRNṼ\[gNXłB
		/// </summary>
		class DownloadListViewItemComparer : System.Collections.IComparer
		{
			/// <summary>
			/// \[gsJ̃CfbNXłB
			/// </summary>
			private int col;

			/// <summary>
			/// RXgN^łB
			/// J̓ftHg0ݒ肳܂B
			/// </summary>
			public DownloadListViewItemComparer()
			{
				this.col = 0;
			}

			/// <summary>
			/// RXgN^łB
			/// </summary>
			/// <param name="column">\[gsJ</param>
			public DownloadListViewItemComparer(int column)
			{
				this.col = column;
			}

			/// <summary>
			/// 2̃IuWFNgrA菬AA傫lԂ܂B
			/// ł̑召r{܂B
			/// </summary>
			/// <param name="x">rΏۂ̑1IuWFNg</param>
			/// <param name="y">rΏۂ̑2IuWFNg</param>
			/// <returns>xy菬Ε̒lA0Axy傫ΐ̒l</returns>
			public int Compare(object x, object y)
			{
				return (String.Compare(((ListViewItem)x).SubItems[this.col].Text, ((ListViewItem)y).SubItems[this.col].Text));
			}
		}


	}



	/// <summary>
	/// DownlistListViewItemr邽߂IComparerIuWFNg񋟂܂B
	/// </summary>
	public class ListViewItemComparer : Comparer<ListViewItem>
	{

		/// <summary>
		/// rΏۂƂȂListViewItemTextvpeBA<see cref="ComparerType.Text"/>răCX^X쐬܂B
		/// </summary>
		public ListViewItemComparer()
		{
			this._col = 0;
			this._sorttype = CompareType.Text;
		}
		/// <summary>
		/// rΏۂƂȂListViewItem̃TuACẽCfbNXƁAr@w肵ăCX^X쐬܂B
		/// </summary>
		/// <param name="column">rΏۂƂȂ</param>
		/// <param name="sortType">\[g̔f킷<see cref="CompareType"/>񋓑</param>
		public ListViewItemComparer(int column, CompareType sortType)
		{
			this._col = column;
			this._sorttype = sortType;
		}

		#region Fields
		int _col = 0;
		CompareType _sorttype = CompareType.Text;
		#endregion

		/// <summary>
		/// 2̃IuWFNgrA菬AA傫lԂ܂B
		/// ł̑召r{܂B
		/// </summary>
		/// <param name="x">rΏۂ̑1IuWFNg</param>
		/// <param name="y">rΏۂ̑2IuWFNg</param>
		/// <returns>xy菬Ε̒lA0Axy傫ΐ̒l</returns>
		public override int Compare(ListViewItem x, ListViewItem y)
		{
			if(this._sorttype == CompareType.Text)
			{
				return String.Compare(x.SubItems[this._col].Text, y.SubItems[this._col].Text);
			}
			else if(this._sorttype == CompareType.Number) // Number
			{
				int xi, yi;
				if(!Int32.TryParse(x.SubItems[this._col].Text, out xi)) { xi = 0; }
				if(!Int32.TryParse(y.SubItems[this._col].Text, out yi)) { yi = 0; }
				return xi - yi;
			}
			else if(this._sorttype == CompareType.DateTime) // DateTime
			{
				DateTime xi, yi;
				if(!DateTime.TryParse(x.SubItems[this._col].Text, out xi)) { xi = DateTime.MinValue; }
				if(!DateTime.TryParse(y.SubItems[this._col].Text, out yi)) { yi = DateTime.MinValue; }
				return DateTime.Compare(xi, yi);
			}
			else return 0;
		}
	}
	/// <summary>
	/// DownlistItemComparer̔r@`񋓑̂łB
	/// </summary>
	public enum CompareType
	{
		/// <summary>
		/// leLXgƂĔr܂B
		/// </summary>
		Text,
		/// <summary>
		/// l𐔒lƂĔr܂B
		/// </summary>
		Number,
		/// <summary>
		/// lƂĔr܂B
		/// </summary>
		DateTime
	}
}