using System;
using System.Collections.Generic;
using System.Text;

namespace Boon.Functions
{
	interface IBrowserNavigator
	{
		event NavigateRequiredEventHandler NavigateRequired;
	}
	interface IQueryBrowserInfo
	{
		GetInt32Delegate RetrieveBrowserCount { get; set;}
		GetInt32Delegate RetrieveBrowserSelectedIndex { get; set;}

		GetStringDelegate RetrieveUrlSelected { get; set;}
		Int32ToStringDelegate RetrieveUrlByIndex { get;set;}

		GetStringDelegate RetrieveTitleSelected { get;set;}
		Int32ToStringDelegate RetrieveTitleByIndex { get;set;}
	}
	interface IQueryBrowserInfo2
	{
		GetBooleanDelegate RetrieveIsLockedSelected { get;set;}
		Int32ToBooleanDelegate RetrieveIsLockedByIndex { get;set;}

		GetInt32Delegate RetrieveSecurityFlagsSelected { get;set;}
		Int32ConvertDelegate RetrieveSecurityFlagsByIndex { get;set;}
	}

	public delegate void NavigateRequiredEventHandler(object sender, NavigateRequiredEventArgs e);

	public class NavigateRequiredEventArgs : EventArgs
	{
		string _url;
		bool _opennew;

		public string Url
		{
			get{return this._url;}
		}
		public bool OpenNew
		{
			get{return this._opennew;}
		}

		public NavigateRequiredEventArgs(string url, bool opennew)
		{
			this._url = url;
			this._opennew = opennew;
		}
	}

	public delegate void BrowserTabAccessEventHandler(object sender, BrowserAccessEventArgs args);

	public class BrowserAccessEventArgs : EventArgs
	{
		BrowserAccessCommand _comm;
		BrowserAccessResult _result;

		public BrowserAccessCommand Command
		{
			get { return this._comm; }
		}
		public BrowserAccessResult Result
		{
			get { return this._result; }
			set { this._result = value; }
		}

		public BrowserAccessEventArgs(BrowserAccessCommand command)
		{
			this._comm = command;
			this._result = BrowserAccessResult.NotUntil;
		}
	}

	public class BrowserAccessCommand
	{
		public const int PARAMS_MAX = 3;

		/// <summary>
		/// <para>w肳ꂽURLֈړ܂B</para>
		/// <para>  p[^ [0:Str]=URL, [1:Num]=Ώۃ^uIndex</para>
		/// </summary>
		public const string F_Navigate = "navi";
		/// <summary>
		/// <para>V^uJAw肳ꂽURLֈړ܂B</para>
		/// <para>  p[^ [0:Str]=URL, [1:Num]=V^uIndex, [2:Bool]=tH[JXړ</para>
		/// </summary>
		public const string F_OpenNew = "open";
		/// <summary>
		/// <para>^u܂B</para>
		/// <para>  p[^ [0:Num]=Ώۃ^uIndex</para>
		/// </summary>
		public const string F_CloseTab = "close";
		public const string F_Select = "select";
		public const string F_Security = "secure";
		public const string F_TabLock = "tablock";
		public const string R_Restore = "restore";

		public const string P_I_Current = "@";
		public const string P_U_Blank = "about:blank";

		string _func;
		string[] _params;

		public string FunctionCode
		{
			get { return this._func; }
		}
		public string[] Paramator
		{
			get { return this._params; }
		}

		public BrowserAccessCommand(string function, params string[] param)
		{
			if(param != null && param.Length > PARAMS_MAX) { throw new ArgumentException(String.Format("p[^̐܂Bő{0}܂Ŏwł܂A{1}n܂", PARAMS_MAX, param.Length)); }
			this._func = function ?? String.Empty;
			this._params = param ?? new string[0];
		}
	}
	public enum BrowserAccessResult
	{
		Completed = 0x00,
		NotUntil = 0xFF,
		InvalidIndex = 0x10,
		InvalidCommand = 0x20,
		CommandNotSupported = 0x21,
	}

	public delegate string GetStringDelegate();
	public delegate int GetInt32Delegate();
	public delegate bool GetBooleanDelegate();
	public delegate object GetObjectDelegate();

	public delegate string StringConvertDelegate(string s);
	public delegate int Int32ConvertDelegate(int i);
	public delegate string Int32ToStringDelegate(int i);
	public delegate bool Int32ToBooleanDelegate(int i);




}
