using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;
using mshtml;
using System.Security;

namespace ProjectBoon.Win32
{
	[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("00000119-0000-0000-C000-000000000046")]
	public interface IOleInPlaceSite
	{
		IntPtr GetWindow();
		[PreserveSig]
		int ContextSensitiveHelp(int fEnterMode);
		[PreserveSig]
		int CanInPlaceActivate();
		[PreserveSig]
		int OnInPlaceActivate();
		[PreserveSig]
		int OnUIActivate();
		[PreserveSig]
		int GetWindowContext([MarshalAs(UnmanagedType.Interface)] out IOleInPlaceFrame ppFrame, [MarshalAs(UnmanagedType.Interface)] out IOleInPlaceUIWindow ppDoc, [Out] COMRECT lprcPosRect, [Out] COMRECT lprcClipRect, [In, Out] tagOIFI lpFrameInfo);
		[PreserveSig]
		int Scroll(tagSIZE scrollExtant);
		[PreserveSig]
		int OnUIDeactivate(int fUndoable);
		[PreserveSig]
		int OnInPlaceDeactivate();
		[PreserveSig]
		int DiscardUndoState();
		[PreserveSig]
		int DeactivateAndUndo();
		[PreserveSig]
		int OnPosRectChange([In] COMRECT lprcPosRect);
	}

	[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("00000116-0000-0000-C000-000000000046")]
	public interface IOleInPlaceFrame
	{
		IntPtr GetWindow();
		[PreserveSig]
		int ContextSensitiveHelp(int fEnterMode);
		[PreserveSig]
		int GetBorder([Out] COMRECT lprectBorder);
		[PreserveSig]
		int RequestBorderSpace([In] COMRECT pborderwidths);
		[PreserveSig]
		int SetBorderSpace([In] COMRECT pborderwidths);
		[PreserveSig]
		int SetActiveObject([In, MarshalAs(UnmanagedType.Interface)] IOleInPlaceActiveObject pActiveObject, [In, MarshalAs(UnmanagedType.LPWStr)] string pszObjName);
		[PreserveSig]
		int InsertMenus([In] IntPtr hmenuShared, [In, Out] tagOleMenuGroupWidths lpMenuWidths);
		[PreserveSig]
		int SetMenu([In] IntPtr hmenuShared, [In] IntPtr holemenu, [In] IntPtr hwndActiveObject);
		[PreserveSig]
		int RemoveMenus([In] IntPtr hmenuShared);
		[PreserveSig]
		int SetStatusText([In, MarshalAs(UnmanagedType.LPWStr)] string pszStatusText);
		[PreserveSig]
		int EnableModeless(bool fEnable);
		[PreserveSig]
		int TranslateAccelerator([In] ref MSG lpmsg, [In, MarshalAs(UnmanagedType.U2)] short wID);
	}

	[ComImport, Guid("00000117-0000-0000-C000-000000000046"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown), SuppressUnmanagedCodeSecurity]
	public interface IOleInPlaceActiveObject
	{
		[PreserveSig]
		int GetWindow(out IntPtr hwnd);
		void ContextSensitiveHelp(int fEnterMode);
		[PreserveSig]
		int TranslateAccelerator([In] ref MSG lpmsg);
		void OnFrameWindowActivate(bool fActivate);
		void OnDocWindowActivate(int fActivate);
		void ResizeBorder([In] COMRECT prcBorder, [In] IOleInPlaceUIWindow pUIWindow, bool fFrameWindow);
		void EnableModeless(int fEnable);
	}
	[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("00000115-0000-0000-C000-000000000046")]
	public interface IOleInPlaceUIWindow
	{
		IntPtr GetWindow();
		[PreserveSig]
		int ContextSensitiveHelp(int fEnterMode);
		[PreserveSig]
		int GetBorder([Out] COMRECT lprectBorder);
		[PreserveSig]
		int RequestBorderSpace([In] COMRECT pborderwidths);
		[PreserveSig]
		int SetBorderSpace([In] COMRECT pborderwidths);
		void SetActiveObject([In, MarshalAs(UnmanagedType.Interface)] IOleInPlaceActiveObject pActiveObject, [In, MarshalAs(UnmanagedType.LPWStr)] string pszObjName);
	}

}
