
/* ------------------------
ContainerAbst.js
-- コンテナオブジェクト系抽象クラス

*BExpItem
  *.Separator
  *.String
*BExpContainer
*/

/* ====================
** (コンテナオブジェクト抽象クラス + MathRowオブジェクト) 抽象クラス
*/
function BExpItem(par) {
    this.wrap = par;
    this.exp = par.exp;
    this.exp.issueID(this);
}

BExpItem.prototype.construct = function(par) {
    this.wrap = par;
    this.exp = par.exp;
    this.exp.issueID(this);
}

// 必要サイズ応答
BExpItem.prototype.getPreferredSize = function() {
    return {
        top: this.top,
        bottom: this.bottom,
        height: this.height,
        width: this.width
    };
}

// 再配置
BExpItem.prototype.layout = function() {
    this._layout();
    this.wrap.layout();
}

BExpItem.prototype._setSize = function() {
    BUtil.obj.setSize(this.obj, this.width, this.height);
}

 /* ====================
** 数式内オブジェクトで使用する部品類
*/
/* 区切り文字 */
BExpItem.Separator = function(wrap) {
    this.objType = 'separator';
    this.obj = document.createElement('div');
    this.obj.className = 'separator';
}

// 表示部品削除
BExpItem.Separator.prototype.removeObj = function() {
    this.obj.parentNode.removeChild(this.obj);
}

/* 文字 */
BExpItem.String = function(wrap, str) {
    this.objType = 'stringspan';
    this.str = str;
    this.level = wrap.level;
    this.obj = document.createElement('span');
    this.obj.className = 'stringspan ' + ((this.level == 1) ? 'level1' : 'level2');
    this.node = document.createTextNode(this.str);
    this.obj.appendChild(this.node);
    this.width = this.str.length * Const.tokenWidth[this.level];
    this.height = Const.tokenHeight[this.level];
}

// 必要サイズ応答
BExpItem.String.prototype.getPreferredSize = function() {
    return {
        top: this.height / 2,
        bottom: this.height / 2,
        height: this.height,
        width: this.width
    };
}

// 表示部品削除
BExpItem.String.prototype.removeObj = function() {
    this.obj.parentNode.removeChild(this.obj);
}

/* ====================
** コンテナオブジェクト抽象クラス
*/
function BExpContainer(par, levels) {
    this.obj = document.createElement('div');
    BExpContainer.superClass.apply(this, arguments);
    this.obj.className = 'Container';
    this.rows = new Array;
    for(var i = 0; i < this.rowCount; i++) {
        this.rows[i] = new MathRow(this, (levels) ? levels[i] : this.wrap.level);
        this.obj.appendChild(this.rows[i].obj);
    }
    this.content = this.rows[0];
}

BUtil.inherit(BExpContainer, BExpItem);

BExpContainer.prototype.construct = function(par, levels) {
    //this.constructBase(par);
    this.obj = document.createElement('div');
    BExpContainer.superClass.apply(this, arguments);
    this.obj.className = 'Container';
    this.rows = new Array;
    for(var i = 0; i < this.rowCount; i++) {
        this.rows[i] = new MathRow(this, (levels) ? levels[i] : this.wrap.level);
        this.obj.appendChild(this.rows[i].obj);
    }
    this.content = this.rows[0];
}

// 初期の内容を決める
BExpContainer.prototype.setInitialValue = function(val) {
    this.content.setInitialValue(val);
}

// 前のブロックにカーソルを移動
BExpContainer.prototype.backCursor = function(bid) {
    if(bid == this.rows[0].obj.id) {
        this.wrap.backCursor(this.obj.id);
    }
    else {
        for(var i = 1; i < this.rowCount; i++) {
            if(bid == this.rows[i].obj.id) {
                this.rows[i-1].setCursor(-1);
                return;
            }
        }
    }
}

// 次のブロックにカーソルを移動
BExpContainer.prototype.fwdCursor = function(bid) {
    if(bid == this.rows[this.rowCount - 1].obj.id) {
        this.wrap.fwdCursor(this.obj.id);
    }
    else {
        for(var i = 0; i < this.rowCount - 1; i++) {
            if(bid == this.rows[i].obj.id) {
                this.rows[i+1].setCursor(0);
                return;
            }
        }
    }
}

// 端にカーソルを置く
BExpContainer.prototype.setCursor = function(num) {
    if(num == 0) {
        this.rows[0].setCursor(0);
    }
    else if(num == -1) {
        this.rows[this.rowCount - 1].setCursor(-1);
    }
}

// MathMLコード書き出し
BExpContainer.prototype.outputMathML = function(expand) {
    var ret = '';
    for(var i = 0; i < this.rowCount; i++) {
        ret += this.rows[i].outputMathML(expand);
    }
    return this._tagMML(ret);
}

// LaTeXコード書き出し
BExpContainer.prototype.outputLatex = function() {
    var ret = '';
    for(var i = 0; i < this.rowCount; i++) {
        ret += this.rows[i].outputLatex();
    }
    return this._commandTex(ret);
}

// 表示部品削除
BExpContainer.prototype.removeObj = function() {
    this._removeObj();
}

// ---------- private

// 表示部品削除
BExpContainer.prototype._removeObj = function() {
    for(var i = 0; i < this.rowCount; i++) {
        this.rows[i].removeObj();
    }
    this.obj.parentNode.removeChild(this.obj);
}

// MathMLコード書き出し
BExpContainer.prototype._tagMML = function(content) {
    if(this.mathmlTag != '') {
        var out = '<' + this.mathmlTag + '>' + "\n";
        out += content;
        out += '</' + this.mathmlTag + '>' + "\n";
        return out;
    }
}

// LaTeXコード書き出し
BExpContainer.prototype._commandTex = function(content) {
    if(this.texCommand != '') {
        return Const.backslash + this.texCommand + content;
    }
}

// 計算して保存
BExpContainer.prototype._calcPosition = function(otop, obottom, owidth) {
    var prefer = this.content.getPreferredSize();
    this.top = prefer.top + otop;
    this.bottom = prefer.bottom + obottom;
    this.height = this.top + this.bottom;
    this.width = prefer.width + owidth;
}

BExpContainer.prototype._setLayout = function(otop, oright, obottom, oleft) {
    var prefer = this.content.getPreferredSize();
    this.top = prefer.top + otop;
    this.bottom = prefer.bottom + obottom;
    this.height = this.top + this.bottom;
    this.width = prefer.width + oleft + oright;
    this._setSize();
    BUtil.obj.setPos(this.content.obj, oleft, otop);
}

    BUtil.style.add(
		    [['div.Container', 'position: absolute; border: 1px solid #f82;'],
		     ['img.containerParts', 'position: absolute;']]
		    );
