
/* ------------------------
MathRow.js
*/

/* ====================
** <mrow>オブジェクト
*/
function MathRow(par, level) {
//    this.objType = 'row';
    this.obj = document.createElement('div');
    this.__super__(par);
    this.level = level;
    this.array = new Array;
    this.obj.className = 'MathRow';

    this.add(new MathInput(this, 'visible'), 0);
    this._layout();
}

BUtil.inherit(MathRow, BExpItem);

BUtil.setProperty(MathRow, {
		      objType: 'row'
		  });

// 行内の要素間の隙間
MathRow.rowSpacing = 6;

// 配列中の順番を返す
MathRow.prototype.getPos = function(id) {
    for(var i = 0; i < this.array.length; i++) {
        if(this.array[i].obj.id == id) return i;
    }
    return null;
}

// 要素を追加
MathRow.prototype.add = function(child, pos) {
    var at = this.array.splice(0, pos);
    this.array = at.concat(child, this.array);
    this.obj.appendChild(child.obj);
}

// 要素を削除
MathRow.prototype.del = function(pos) {
    this.array[pos].removeObj();
    this.array.splice(pos, 1);
    if((pos > 0) && (this.array[pos-1].objType == 'input')) {
        var aftercursor = this.array[pos-1].obj.value.length;
        this.array[pos-1].obj.value += this.array[pos].obj.value;
        this.array[pos].removeObj();
        this.array.splice(pos, 1);
        //this.array[pos-1].optimizeSize();
        this.array[pos-1].setCursor(aftercursor);
    }
    //this.layout();
}

// 初期の内容を決める
MathRow.prototype.setInitialValue = function(val) {
    this.array[0].setInitialValue(val);
}

// 前のブロックにカーソルを移動
MathRow.prototype.backCursor = function(bid) {
    bnum = this.getPos(bid);
    if(bnum == 0) {
        this.wrap.backCursor(this.obj.id);
    }
    else {
        bnum--;
        this.array[bnum].setCursor(-1);
    }
}

// 次のブロックにカーソルを移動
MathRow.prototype.fwdCursor = function(bid) {
    bnum = this.getPos(bid);
    if(bnum == this.array.length - 1) {
        this.wrap.fwdCursor(this.obj.id);
    }
    else {
        bnum++;
        this.array[bnum].setCursor(0);
    }
}

// 端にカーソルを置く
MathRow.prototype.setCursor = function(num) {
    if(num == 0) {
        this.array[0].setCursor(0);
    }
    else if(num == -1) {
        this.array[this.array.length - 1].setCursor(-1);
    }
}

// MathMLコード書き出し
MathRow.prototype.outputMathML = function(expand) {
    var tmp = '';
    var out = '<mrow>';
    var curr;
    var inputout = new Object;
    for(var i = 0; i < this.array.length; i++) {
        curr = this.array[i]
        if(curr.objType == 'sup' || curr.objType == 'sub') {
            tmp = curr.outputMathML(expand, tmp);
        }
        else {
            if(curr.objType == 'input') {
                inputout = curr.outputMathML(expand);
                if(inputout != null) {
                    out += tmp;
                    out += inputout.front;
                    tmp = inputout.rear;
                }
            }
            else {
                out += tmp;
                tmp = curr.outputMathML(expand);
            }
        }
    }
    out += tmp;
    out += '</mrow>' + "\n";
    return out;
}

// LaTeXコード書き出し
MathRow.prototype.outputLatex = function(noFence) {
    var tmp = '';
    var i;
    for(i = 0; i < this.array.length - 1; i++) {
        tmp += this.array[i].outputLatex();
        tmp += ' ';
    }
    tmp += this.array[this.array.length - 1].outputLatex();
    
    if(noFence) {
        return tmp;
    }
    else {
        return '{' + tmp + '}';
    }
}

// 表示部品削除
MathRow.prototype.removeObj = function() {
    for(var o in this.array) {
        this.array[o].removeObj();
    }
    this.obj.parentNode.removeChild(this.obj);
}

// ---- private

MathRow.prototype._layout = function() {
    // 計算して保存
    var ptmp = new Array;
    var ptop = 0, pbottom = 0, pwidth = 0;
    for(i = 0; i < this.array.length; i++) {
        ptmp[i] = this.array[i].getPreferredSize();
        if(ptop < ptmp[i].top) ptop = ptmp[i].top;
        if(pbottom < ptmp[i].bottom) pbottom = ptmp[i].bottom;
        pwidth += ptmp[i].width;
    }
    pwidth += (this.array.length - 1) * MathRow.rowSpacing;
    this.top = ptop;
    this.bottom = pbottom;
    this.height = ptop + pbottom;
    this.width = pwidth;
    // 適応
    this._setSize();
    var left = 0;
    var curr;
    for(i = 0; i < this.array.length; i++) {
        curr = this.array[i];
        curr.obj.style.top = (this.top - ptmp[i].top) + 'px';
        curr.obj.style.left = left + 'px';
        left += (4 + ptmp[i].width);
    }
}

BUtil.style.add(
		[['div.MathRow', 'position: absolute;']]
		);


    