
/* ------------------------
parts.js
-- コンテナオブジェクト内部品, その他部品

*Separator - 横線
*StringSpan - 文字
*----
*MathFormulaContainer - つまりMathRowの番兵
*SymbolButtons - 実体参照文字入力ボタンの行
*ContainerButtons - コンテナオブジェクト挿入ボタンの行
*/

 /* ====================
** ただの横線
*/
function Separator(wrap) {
    this.objType = 'separator';
    this.obj = document.createElement('div');
    this.obj.className = 'separator';
}

// 表示部品削除
Separator.prototype.removeObj = function() {
    this.obj.parentNode.removeChild(this.obj);
}

/* ====================
** ただの文字
*/
function StringSpan(wrap, str) {
    this.objType = 'stringspan';
    this.str = str;
    this.level = wrap.level;
    this.obj = document.createElement('span');
    this.obj.className = 'stringspan ' + ((this.level == 1) ? 'level1' : 'level2');
    this.node = document.createTextNode(this.str);
    this.obj.appendChild(this.node);
    this.width = this.str.length * Const.tokenWidth[this.level];
    this.height = Const.tokenHeight[this.level];
}

// 必要サイズ応答
StringSpan.prototype.getPreferredSize = function() {
    return {
        top: this.height / 2,
        bottom: this.height / 2,
        height: this.height,
        width: this.width
    };
}

// 表示部品削除
StringSpan.prototype.removeObj = function() {
    this.obj.parentNode.removeChild(this.obj);
}

//StringSpan.levelWidth = [0, 10, 7];
//StringSpan.levelHeight = [0, 16, 12];

/* ====================
** 基底に置くオブジェクト
*/
/*
function MathFormulaContainer(par) {
    this.backCursor = function() {
    }
    
    this.fwdCursor = function() {
    }
    // 再配置 された時にはプレビューを更新
    this.layout = function(){
        Control.updatePreview();
    }
    
    // 式全体のMathMLコード書き出し
    this.outputMathML = function(expand) {
        var out = '<math xmlns="http://www.w3.org/1998/Math/MathML" display="block">' + "\n";
        out += this.content.outputMathML(expand);
        out += '</math>' + "\n";
        return out;
    }
    
    this.outputLatex = function() {
        return this.content.outputLatex(true);
    }
    
    this.content = new MathRow(this, 1);
    par.appendChild(this.content.obj);
    // 選択
    this.content.setInitialValue('');
    
}
*/
/* ====================
** ボタンまとめオブジェクト
*/
/*
function SymbolButtons(bredima, ttype, syms) {
    this.bredima = bredima;
    this.type = ttype;
    this.wrap = document.getElementById(this.type + '_buttons');
    this.buttons = new Array;
    this.level = 1;
    var self = this;
    var i = 0;
    for(var sym in syms) {
        var obj = document.createElement('div');
        obj.className = 'function_button symbol_button';
        obj.id = 'button_' + sym;
        obj.onclick = function() {
            self._myOnClick(this);
        }
        var symbol = new Symbol(this, sym, true);
        this.buttons.push(symbol);
        obj.appendChild(symbol.obj);
        this.wrap.appendChild(obj);
        BUtil.obj.setSize(obj, Const.tokenHeight[1] + 2, Const.tokenHeight[1] + 2);
        BUtil.obj.setPos(obj, i++ * (Const.tokenHeight[1] + 6), 0);
    }
}

SymbolButtons.prototype._myOnClick = function(btn) {
    var bid = btn.id.substring(btn.id.indexOf('_') + 1);
    var type = this.type;
    this.bredima.exp.insert(function(w){return new MathSymbol(w, bid, type)});
}
*/
/* ====================
** コンテナオブジェクト挿入ボタン管理
*/
/*
function ContainerButtons(bredima) {
    this.bredima = bredima
    this.wrap = document.getElementById('container_buttons');
    this.buttons = new Array;
    var count = 0;
    var self = this;
    for(var i = 0; i < ContainerButtons.buttonArray.length; i++) {
        if(ContainerButtons.buttonArray[i] != null) {
        var btn = ContainerButtons.buttonArray[i];
            var obj = document.createElement('div');
            obj.className = 'container_button';
            obj.id = 'containerbutton_' + i;
            obj.onclick = function() {
                self._myOnClick(this);
            }
            Control.setSize(obj, Const.containerButtonSize[0] + 4, Const.containerButtonSize[1] + 2);
            var img = document.createElement('img');
            img.src = Const.containerImgDir + btn.name + '.png';
            obj.appendChild(img);
            this.wrap.appendChild(obj);
            Control.setPosition(obj, count++ * (Const.containerButtonSize[0] + 8), 0);
        }
    }
}

// 申請受付用配列
ContainerButtons.buttonArray = new Array;

// ボタン表示の申請受付
ContainerButtons.submit = function(tid, tname, tfunc) {
    ContainerButtons.buttonArray[tid] = {name: tname, func: tfunc};
}

// private
ContainerButtons.prototype._myOnClick = function(btn) {
    var i = btn.id.substring(btn.id.indexOf('_') + 1);
    this.bredima.exp.insert(ContainerButtons.buttonArray[i].func);
    //this.bredima.exp.focusObj.insert(ContainerButtons.buttonArray[i].func(Control.focusObj.wrap));
}
*/
    ContainerButtons = function() {};
ContainerButtons.submit = BFrame.btnSubmit;

/* ====================
** ソース出力部分管理
*/
/*
function SourceArea() {
    this.obj = document.getElementById('sourceOutput');
    this.isVisible = false;
    
    var self = this;

    // ボタンハンドラ設定
    document.getElementById('button_viewmathml').onmouseup = function() {
	self.put(Root.outputMathML(false));
    }
    document.getElementById('button_viewlatex').onmouseup = function() {
	self.put(Root.outputLatex());
    }
}

// 渡された内容を表示
SourceArea.prototype.put = function(str) {
    if(this.isVisible == false) {
	this.obj.style.display = 'block';
	this.isVisible = true;
	this.height = 1;
	this.appearAnim();
    }
    this.obj.value = str;
}

// 表示アニメーション
SourceArea.prototype.appearAnim = function() {
    if(this.height <= 10) {
	this.obj.style.height = this.height + 'em';
	this.height += 3;
	Control.timeoutObj = this;
	setTimeout("Control.timeoutObj.appearAnim()", 60);
    }
}

*/