
/**
 * @class プレビュー部品
 * @constructor
 * @extends Bredima.Panel
 * @param {Object} bredima bredima
 */
Bredima.Frame.Preview = function(bredima) {
    this.__super__();
    this.bredima = bredima;
    this.isMML = bredima.getConfig('isMML');
    this.timer = ''; // 自動プレビューのためのタイマー
    var self = this;
    this.setClassName('preview');

    // タブ部品で表示状態の切り替え
    this.add(new Bredima.Panel.Tab(['Preview']), 'tab');
    this.tab.observer.attach(this);

    // 非表示時に隠すものはframe内に
    this.frame = new Bredima.Panel();
    this.frame.setClassName('preview_frame');
    this.frame.hide();

    // Updateボタン
    this.frame.addDom('button', 'button');
    this.frame.button.appendChild(document.createTextNode('Update'));
    this.frame.button.onclick = function() { self.preview(); };

    // 自動更新チェック
    var t = document.createElement('input');
    t.type = 'checkbox'; // DOMツリーに組み込むまえでないとIEでエラーが出る
    this.frame.addDom(t, 'check');
    this.frame.addDom(document.createTextNode('Automatic'));

    // 表示領域
    this.frame.add(new Bredima.Panel(), 'display');
    this.frame.display.setClassName('preview_display');
    if(!this.isMML) {
	this.image = document.createElement('img');
	this.frame.display.addDom(this.image, 'img');
    }

    this.add(this.frame);
}

Bredima.util.inherit(Bredima.Frame.Preview, Bredima.Panel);

/**
 * 実際にプレビューを領域内に表示
 */
Bredima.Frame.Preview.prototype.preview = function() {
    if(this.isMML)
	this.frame.display.innerHTML = this.bredima.toMML('expand');
    else
	this.image.src = Bredima.util.getTexURI(this.bredima.toLatex(), 'Large');
}

/**
 * タブを押した際の処理
 * @private
 */
Bredima.Frame.Preview.prototype.onTabClick = function() {
    var self = this;
    if(this.frame.getVisibility()) {
	clearTimeout(this.timer);
	Bredima.util.smoothAnimation( {
				    start: 100, end: 1, step: 6,
				    func: function(num) { self.frame.getDom().style.height = Math.floor(num) + 'px';},
				    finalize: function() {
					self.frame.hide();
					self.tab.hilite(-1);
				    }
				});
    }
    else {
	this.frame.getDom().style.height = '1px';
	this.frame.show();
	this.preview();
	Bredima.util.smoothAnimation({
				   start: 1, end: 100, step: 6,
				   func: function(num) {self.frame.getDom().style.height = Math.floor(num) + 'px';}
			       });
    }
}

/**
 * 数式の変更を受信した際の処理
 * 受信後0.5秒後にプレビュー更新
 * @private
 */
Bredima.Frame.Preview.prototype.onExpressionChange = function() {
    if(this.frame.getVisibility() && this.frame.check.checked) {
	var self = this;
	clearTimeout(this.timer);
	this.timer = setTimeout(function() {self.preview();}, 500);
    }
}

Bredima.style.add(
    ['.preview', 'position: absolute; bottom: 2px; width: 99%; z-index: 1;'],
    ['.preview .preview_frame', 'background-color: #eee; padding: 5px; position: relative; overflow: hidden;'],
    ['.preview .preview_display', 'background-color: white; padding: 10px;']
);
