
/**
 * @class モーダルダイアログ
 * @constructor
 * @extends Bredima.Panel
 */
Bredima.Panel.Dialog = function() {
    arguments.callee.superClass.apply(this, arguments);
    this.setClassName('dialog');

    Bredima.Panel.prototype.hide.apply(this);

    this.addDom('div', 'back');
    this.back.className = 'dialog_padding dialog_back';

    var table = document.createElement('table');
    table.className = 'dialog_padding';
    var td = table.insertRow(0).insertCell(0);
    td.className = 'dialog_outerBox';    
    this.frame = new Bredima.Panel();
    this.frame.setClassName('dialog_frame');
    td.appendChild(this.frame.getDom());
    this.addDom(table);

    var self = this;
    table.onclick = function() {
	self.hide();
    }

    this.frame.getDom().onclick = function(evt) {
	Bredima.util.stopEvent(evt);
    }
    Bredima.util.setOpacity(this.back, 0);
    Bredima.util.setOpacity(this.frame.getDom(), 0);
}

Bredima.util.inherit(Bredima.Panel.Dialog, Bredima.Panel);

Bredima.Panel.Dialog.prototype.show = function() {
    var self = this;
    Bredima.Panel.prototype.show.apply(this);
    Bredima.util.animation({
			       start: 0, end: 1, step: 4,
			       func: function(num) {
				   Bredima.util.setOpacity(self.back, num * .7);
				   Bredima.util.setOpacity(self.frame.getDom(), num);
			       }
			   });
}

Bredima.Panel.Dialog.prototype.hide = function() {
    var self = this;
    Bredima.Panel.prototype.show.apply(this);
    Bredima.util.animation({
			       start: 1, end: 0, step: 4,
			       func: function(num) {
				   Bredima.util.setOpacity(self.back, num * .7);
				   Bredima.util.setOpacity(self.frame.getDom(), num);
			       },
			       finalize: function() { Bredima.Panel.prototype.hide.apply(self);}
			   });
}

/**
 * （継承先で使用）ダイアログのフレーム内にパーツを追加
 */
Bredima.Panel.Dialog.prototype._addFrame = function(elem) {
    this.frame.add(elem);
}

Bredima.style.add(
    ['.dialog', 'position: absolute; left: 0; top: 0; width: 100%; height: 100%; z-index: 5'],
    ['.dialog .dialog_padding', 'position: absolute; width: 100%; height: 100%;'],
    ['.dialog .dialog_back', 'background-color: #eee2dd; opacity: .7; filter: alpha(opacity=70);'],
    ['.dialog .dialog_outerBox', 'vertical-align: middle;'],
    ['.dialog .dialog_frame', 'margin-left: auto; margin-right: auto; padding: 10px; background-color: white; width: 60%;']
);
