
/**
 * @class フレーム内のツールバーの管理
 * @constructor
 * @extends Bredima.Panel
 * @param {Object} bredima bredimaオブジェクト 主にコールバック関数作成時のため
 */
Bredima.Panel.Toolbar = function(bredima) {
    arguments.callee.superClass.apply(this, arguments);
    this.bredima = bredima;
}

Bredima.util.inherit(Bredima.Panel.Toolbar, Bredima.Panel);

/**
 * 与えられた配列に従ってツールバーを一気に初期化
 * @param {Array} array ボタン名を並べた配列
 */
Bredima.Panel.Toolbar.prototype.initFromArray = function(array) {
    for(var i = 0; i < array.length; i++) {
	var content = this.createContent(array[i], this.bredima);
	var func = this.createListenerFunc(array[i], this.bredima);
	this.add(new Bredima.Parts.Button(content, func));
    }
}

/* ================================
*/
/**
 * ツールバーに置くサブメニュー
 * @constructor
 */
Bredima.Panel.Toolbar.Submenu = function() {
    //stub
}

/* ================================
*/
/**
 * ポップアップメニュー
 * @constructor
 * @extends Bredima.Panel
 */
Bredima.Panel.Menu = function() {
    arguments.callee.superClass.apply(this, arguments);
    this.setClassName('menu');
    this.observer = new Bredima.Observer();
    this.serial = 0;
}

Bredima.util.inherit(Bredima.Panel.Menu, Bredima.Panel);

Bredima.Panel.Menu.prototype.addMenuItem = function(elem) {
    var self = this;
    var p = document.createElement('p');
    p.className = 'menu_item';
    p.onclick = (function(num) {
		     return function(evt) {
			 Bredima.util.stopEvent(evt);
			 self.observer.notify('MenuClick', num); };
		 })(this.serial++);
    p.appendChild(elem.getDom());
    this.addDom(p);
}

Bredima.style.add(
    ['.menu', 'position: absolute; z-index: 1; border: 1px solid gray; background-color:silver; text-align: center;'],
    ['.menu .menu_item', 'margin: 1px 0; padding: 0; background-color: white; line-height: 0;']
);
