
/**
 * @class メインクラス
 */
Bredima = function(dom) {
    this.serial = Bredima.serial++;
    this.dom = dom;

    // 初期設定から設定をコピー
    this.config = new Array();
    for(var key in Bredima.config.def) {
	this.config[key] = Bredima.config.def[key];
    }
}

Bredima.version = '0.6.20080103';

Bredima.serial = 0;

/**
 * 全フレーム共通の設定を行う
 */
Bredima.setConfig = function(key, val) {
    Bredima.config.set(key, val);
}

/**
 * インスタンスの設定を変更
 */
Bredima.prototype.setConfig = function(key, val) {
    for(var v in this.config) {
	if(v == key) {
	    this.config[key] = val;
	}
    }
}

Bredima.prototype.toMML = function(expand) { return this.exp.root.toMML(expand); }

Bredima.prototype.toLatex = function() { return this.exp.root.toLatex(); }

/**
 * JSON書き出し
 */
Bredima.prototype.toJSON = function() {
    return JSON.stringify(this.exp.root.toRundown());
}

/**
 * 指定された領域にフレーム作成
 */
Bredima.prototype.write = function(dom) {
    if(dom) this.dom = dom;
    this.init = new Bredima.Init();
    this.locale = new Bredima.Locale(this);
    this.history = new Bredima.History();
    this.frame = new Bredima.Frame(this, this.dom);
    this.exp = new Bredima.ExpCtrl(this);
    this.menu = new Bredima.Menu(this);
    this.init.observer.attach(this);
    this.init.exec();
}

/**
 * 初期化終了時に呼ばれる
 */
Bredima.prototype.onInitialized = function() {
    var rundown = (this.config.json) ? JSON.parse(this.config.json) : null;
    this.frame.finalize();
    this.exp.init(rundown);
    this.frame.appear();
}
/* ========================
内向き関数
*/

/**
 * （アクセサ）Bredimaの設定を返す
 */
Bredima.prototype.getConfig = function(key) { return this.config[key];}
