

/**
 * 定数定義
 * keys- キーコード, chars- 文字コード
 */
Bredima.consts = {

    keys: {
	bs: 8,
	left: 37,
	up: 38,
	right: 39,
	down: 40,
	enter: 13
    },
    texSize: ['', 'large', 'normal']
}

Bredima.config = {};

Bredima.config.def = {
    'uri_mimetex' : 'mimetex.cgi',
    'uri_img' : 'img/',
    'isMML' : false,
    'locale' : 'ja',
    'json' : '',
    'showJson' : ''
};

/**
 * 全Bredima共通設定を返す
 */
Bredima.config.get = function(key) {return Bredima.config.def[key];}

/**
 * 全Bredima共通設定を書き換える
 */
Bredima.config.set = function(key, val) {
    for(var v in Bredima.config.def) {
	if(v == key)
	    Bredima.config.def[key] = val;
    }
}

/**
 * @class 全体で使い回すクラス関数群
 */
Bredima.util = function(){};

/* ---------------------
オブジェクト構築関係
 */
/**
 * 継承
 * 継承されていないクラスではthis.__super__(foo)
 * 継承されるクラスではthis.superClass.apply(this, foo)
 * __super__がサブクラスで上書きされて自分自身への再帰になってしまうため。
 * @param {Object} sub サブクラス
 * @param {Object} sp スーパークラス
 */
Bredima.util.inherit = function(sub, sp) {
    function tmp() {};
    tmp.prototype = sp.prototype;
    sub.prototype = new tmp();
    sub.prototype.__super__ = sp;
    sub.superClass = sp;
    sub.prototype.constructor = sub;
}

/**
 * クラスのプロトタイプ属性を設定
 */
Bredima.util.setProperty = function(c, props) {
    for(var key in props) {
	c.prototype[key] = props[key];
    }
}

Bredima.util.applySuper = function(name, ist, args) {
    ist.constructor.superClass.prototype[name].apply(ist, (args) ? args : []);
    //IEは空でもオブジェクトを渡さないとエラー
}

/* ---------------------
DOM関係
 */
/**
 * イベントの伝播を止める。ブラウザ依存なので依存性排除のためのラッパ。
 */
Bredima.util.stopEvent = function(evt) {
    if(evt && evt.preventDefault) {
	evt.preventDefault();
    }
    else if(window.event) {
	window.event.returnValue = false;
    }
    
    if(evt && evt.stopPropagation) {
	evt.stopPropagation();
    }
    else if(window.event) {
	window.event.cancelBubble = true;
    }
}

/**
 * 指定オブジェクトからの位置を算出
 * @param {Object} obj 算出したいオブジェクト
 * @param {Object} parent 基準にしたいオブジェクト
 */
Bredima.util.getOffset = function(obj, parent) {
    var left = 0;
    var top = 0;
    while(obj != parent) {
	left += obj.offsetLeft;
	top += obj.offsetTop;
	obj = obj.offsetParent;
    }
    return {left: left, top: top};
}

/* ---------------------
スタイルシート関係
 */
/**
 * 幅と高さのスタイル設定
 * @param {DOMObject} obj 設定をするDOMオブジェクト
 * @param {Number} width 幅
 * @param {Number} height 高さ
 */
Bredima.util.setSize = function(obj, width, height) {
    obj.style.width = width + 'px';
    obj.style.height = height + 'px';
}

/**
 * 透過率を設定
 * @param {Object} dom 設定先のDOMオブジェクト
 * @param {Number} num 透過率 0-1 0で全部透過
 */
Bredima.util.setOpacity = function(dom, num) {
    dom.style.opacity = num;
    dom.style.filter = 'alpha(opacity=' + Math.floor(num * 100) + ')';
}

/* ---------------------
その他
 */
/**
 * 引数に合わせてタグを付けて返す
 * @param {String} tag タグ名
 * @param {String} str タグに挟まれる文字列
 * @param {String} attr タグ内に挿入される、属性を記述する文字列
 */
Bredima.util.addTag = function(tag, str, attr) {
    var out = '<' + tag + ((attr) ? (' ' + attr) : '') + '>';
    out += str;
    out += '</' + tag + '>' + "\n";
    return out;
}

/**
 * mimetexで画像を取得するURIを返す
 * @param {String} str tex文
 * @param {Number_String} size 取得画像のサイズ 1/2, あるいはmimetexでサポートされている文字サイズ
 */
Bredima.util.getTexURI = function(str, size) {
    if(size) {
	size = (typeof(size) == 'number') ? Bredima.consts.texSize[size] : size;
	size = '\\' + size + ' ';
    }
    return encodeURI(Bredima.config.get('uri_mimetex') + '?' + size + str);
}

Bredima.note = function(str) {
    document.getElementById('debugFrame').innerHTML += '[' + str + '] ';
}

/**
 * 単純な数値遷移処理
 * @param {Object} param パラメタを集めた連想配列
 * start: 開始値, end: 終了値, step: アニメーションコマ数
 * func: アニメーション処理関数, finalize: 終了処理関数
 */
Bredima.util.animation = function(param) {
    var number = param.start;
    var count = 0;
    var cv = (param.end - param.start) / param.step;
    var timer = setInterval(function() {
				param.func(number);
				if(count++ == param.step) {
				    clearInterval(timer);
				    if(param.finalize) param.finalize();
				}
				if(count == param.step)
				    number = param.end;
				else
				    number = param.start + cv * count;
			    }, 30);
}

/**
 * ちょっと凝った数値遷移処理
 * @param {Object} param パラメタを集めた連想配列
 * start: 開始値, end: 終了値, step: アニメーションコマ数
 * func: アニメーション処理関数, finalize: 終了処理関数
 */
Bredima.util.smoothAnimation = function(param) {
    var number = param.start;
    var count = 0;
    var cv = (param.end - param.start) / (param.step - 2); // constant velocity
    var timer = setInterval(function() {
				param.func(number);
				if(count++ == param.step) {
				    clearInterval(timer);
				    if(param.finalize) param.finalize();
				}
				if(count == param.step)
				    number = param.end;
				else if(count < 3)
				    number = param.start + (cv * 2 / 14 * ((count - 1) * 5 + 3));
				else if(count > param.step - 3)
				number = param.end - (cv * 2 / 14 * ((param.step - 1 - count) * 5 + 3));
				else
				    number = param.start + (cv * (count - 1));
			    }, 30);
}

/* =============================
 スタイルシート登録
 */
Bredima.style = {};

Bredima.style.str = '';

/**
 * スタイルを登録
 * @param {Array*} 登録するスタイルを可変長引数で指定
 */
Bredima.style.add = function() {
    for( var i = 0; i < arguments.length; i++) {
	var s = arguments[i];
	var a = new Array();
	for(var n = 0; n < s.length - 1; n++) {
	    a[n] = 'div.BrEdiMa_Frame ' + s[n];
	}
	Bredima.style.str += a.join(',') + '{' + s[s.length - 1] + '} ';
    }
}

/**
 * スタイルシートを書き出し
 */
Bredima.style.addStylesheet = function() {
    var head = document.getElementsByTagName('head')[0];
    if(!head) return;
    var style = document.createElement('style');
    if(typeof(style.styleSheet) == 'object') { // IE
	style.type = 'text/css';
	style.styleSheet.cssText = Bredima.style.str;
    }
    else { // それ以外
	style = document.createElement('link');
	style.rel = 'stylesheet';
	style.href = 'data:text/css,' + escape(Bredima.style.str);
    }
    head.appendChild(style);
}

