

var mimetex = '/cgi-bin/mimetex.cgi';
var democgi = '/cgi-bin/demo_ajax.cgi';

Bredima.setConfig('uri_mimetex', mimetex);

function LineItem(id, tex, json) {
    var self = this;
    this.id = id;
    this.json = json;

    var obj = document.createElement('div');
    obj.className = 'line_item';
    this.obj = obj;

    this.frame = document.createElement('div');
    this.frame.className = 'b_frame';
    this.bd = document.createElement('div');
    this.frame.appendChild(this.bd);
    obj.appendChild(this.frame);

    this.img = document.createElement('img');
    this.img.className = 'expression';
    this.img.src = (tex == '') ? '' : mimetex + '?\\LARGE ' + tex;
    this.img.style.visibility = (tex == '') ? 'hidden' : 'visible';
    obj.appendChild(this.img);

    this.buttons = document.createElement('p');
    this.buttons.className = 'buttons';
    this.buttons.style.visibility = 'hidden';

    var b = document.createElement('input');
    b.type = 'button';
    b.value = 'Edit';
    b.onclick = function() {
	self.edit(this.json);
    }
    this.buttons.appendChild(b);
    
    b = document.createElement('input');
    b.type = 'button';
    b.value = 'Remove';
    b.onclick = function() {
	new Ajax.Request(democgi, {
			     method: 'post',
			     postBody: 'remove\t\t\t' + id,
			     onComplete: function() {self.remove();}
			 });
    }
    this.buttons.appendChild(b);
    
    obj.appendChild(this.buttons);
    
    obj.onmouseover = function() {
	self.buttons.style.visibility = 'visible';
    }

    obj.onmouseout = function() {
	self.buttons.style.visibility = 'hidden';
    }

    
}

LineItem.prototype = {
    edit: function() {
	var self = this;
	this.tmpHeight = this.obj.clientHeight;
	Bredima.util.smoothAnimation({
				   start: this.tmpHeight, end: 210, step: 8,
				   func: function(num) {
				       self.obj.style.height = num + 'px';
				   },
				   finalize: function() {
				       self.edit2();
				   }});
    },
    edit2: function() {
	if(!this.bredima) {
	    var self = this;
	    this.bredima = new Bredima(this.bd);
	    this.bredima.setConfig('use_button', true);
	    this.bredima.setConfig('json', this.json);
	    this.bredima.onsubmit = function() {
		self.close();
	    }
	    this.bredima.write();
	}
	else {
	    this.bredima.frame.show();
	}
    },
    close: function() {
	var self = this;
	var latex = this.bredima.toLatex();
	this.img.src = (latex == '') ? '' : mimetex + '?\\LARGE ' + latex;
	this.img.style.visibility = (latex == '') ? 'hidden' : 'visible';
	this.json = this.bredima.toJSON();
	note = ['post', self.id, latex, self.json].join("\t\t\t");
	new Ajax.Request(democgi, {
			     method: 'post',
			     postBody: ['post', self.id, latex, self.json].join("\t\t\t"),
			     onComplete: function(res) {
				 if(self.id == 0) self.id = res.responseText;
			     }
			 });
	Bredima.util.smoothAnimation({
				   start: 210, end: this.tmpHeight, step: 8,
				   func: function(num) {
				       self.obj.style.height = num + 'px';
				   },
				   finalize: function() {
				       self.close2();
				   }});
    },
    close2: function() {
	this.obj.style.height = '';
    },
	
    remove: function() {
	var self = this;
	var height = this.obj.clientHeight;
	this.obj.style.height = height + 'px';
	this.obj.removeChild(this.img);
	this.obj.removeChild(this.buttons);
	Bredima.util.smoothAnimation({
					 start: height, end: 5, step: 6,
					 func: function(num) {
					     self.obj.style.height = num + 'px';
					 },
					 finalize: function() {
					     self.obj.parentNode.removeChild(self.obj);
					 }});
    },
    getDom: function() {
	return this.obj;
    }
}

onload = function() {
    var frame = document.getElementById('main_frame');

    function listListItem(res) {
	var list = res.responseText.split("\n\n");
	for(var i = 0; i < list.length; i++) {
	    var tj = list[i].split("\t\t\t");
	    frame.appendChild(new LineItem(tj[0], tj[1], tj[2]).getDom());
	}
    }

    new Ajax.Request(democgi, {
				    method: 'post',
				    postBody: 'get',
				    onComplete: listListItem
				});
    var n = document.getElementById('newItem');
    n.onclick = function() {
	var item = new LineItem(0, '', '');
	frame.appendChild(item.getDom());
	item.edit();
    }
}


var testArray = [
    {tex: '\\' + 'frac{aaa}{bbb}', json: '["",["frac",["aaa"],["bbb"]],""]'},
    {tex: '\\' + 'sqrt{t _{2} } ', json: '["",["sqrt",["t",["sub",["2"]],""]],""]'}
];
