
/**
 * @class 数式内に乗る全要素の共通抽象クラス
 * @constructor
 * @extends Bredima.Parts
 */
Bredima.Exp = function(param) {
    if(this.domName) this.obj = document.createElement(this.domName);
    this.setClassName(['expelem']);
    if(this.constructor.classID != this.constructor.objType) this.addClassName(this.constructor.objType);
    this.addClassName(this.constructor.classID);
}

Bredima.util.inherit(Bredima.Exp, Bredima.Parts);

// 数式内に乗る要素の標準DOM要素はdiv。違う場合はプロパティ上書き。
Bredima.util.setProperty(Bredima.Exp, {domName: 'div'});

/* ====================
 Expインタフェース
   -----------------------------
 オブジェクト情報入出力関係
*/
/**
 * オブジェクトの文字列表記を返す 通常は概要オブジェクトを文字列化したもの
 */
Bredima.Exp.prototype.toString = function() {
    return JSON.stringify(this.toRundown);
}

/**
 * 概要オブジェクトを返す
 * 標準ではオブジェクトのID+_toRundownContent
 */
Bredima.Exp.prototype.toRundown = function() {
    return new Array().concat(this.constructor.classID, this._toRundownContent());
}

/**
 * 概要オブジェクトの中身を返す
 * 標準ではtoStringそのまま
 */
Bredima.Exp.prototype._toRundownContent = function() {
    return this.toString();
}

/**
 * MathML文字列を返す タグを付与するだけで実際の操作は_toMML()
 */
Bredima.Exp.prototype.toMML = function(expand, param) {
    if(this.MML) return Bredima.util.addTag(this.MML, this._toMMLContent(expand, param));
}
    
/**
 * 仮想関数 - MathML文字列中のタグの中身を返す
 * 標準ではtoStringそのまま
 */
Bredima.Exp.prototype._toMMLContent = function() {
    return this.toString();
}

/**
 * LaTeX文字列を返す コマンドを付与するだけで実際の操作は_toLatexContent()
 */
Bredima.Exp.prototype.toLatex = function() {
    if(this.tex) return '\\' + this.tex + this._toLatexContent();
}

/**
 * 仮想関数 - LaTeX文字列の中の先頭のコマンドを除いた部分を返す
 */
Bredima.Exp.prototype._toLatexContent = function() { Bredima.util.error(); }

/* -------------------------------
 レイアウト関係
*/
/**
 * 自分の配下にある全オブジェクトの再配置
 */
Bredima.Exp.prototype.repositionAll = function() {
    // 自分の配下に別のオブジェクトを持つ場合はオーバーライドする
    this._reposition();
}

/**
 * （仮想関数）Rootに向かって再配置
 */
Bredima.Exp.prototype.repositionToRoot = function() { Bredima.util.error(); }

/**
 * （仮想関数）自分の再配置
 */
Bredima.Exp.prototype._reposition = function() {
}

/**
 * （継承先クラスで使用）自分の再配置
 * 自分のサイズをフィールド値に合わせて表示に反映
 */
Bredima.Exp.prototype._resize = function() {
    if(this.top != null) this.height = this.top + this.bottom;
    Bredima.util.setSize(this.obj, this.width, this.height);
}

/* ====================
 クラス関数
 */

Bredima.Exp.classes = new Array;

/**
 * 数式内で利用するクラスを登録
 * @params {Function} func コンストラクタ関数
 * @params {String} type クラスの分類
 * @params {String} id クラスのID（オプション）
 */
Bredima.Exp.register = function(func, type, id) {
    func.classID = (id) ? id : type;
    func.objType = type;
    Bredima.Exp.classes.push(func);
}

/**
 * IDに該当するクラスを返す
 * @params {String} id ID
 */
Bredima.Exp.getClassById = function(id) {
    for(var i = 0; i < Bredima.Exp.classes.length; i++) {
	if(Bredima.Exp.classes[i].classID == id) {
	    return Bredima.Exp.classes[i];
	}
    }
    return null;
}

Bredima.style.add(
    ['.expelem', 'position: absolute;']
);
