/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionWatchdog
implements Runnable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$ConnectionWatchdog == null ? (class$com$limegroup$gnutella$ConnectionWatchdog = ConnectionWatchdog.class$("com.limegroup.gnutella.ConnectionWatchdog")) : class$com$limegroup$gnutella$ConnectionWatchdog));
    private static final ConnectionWatchdog INSTANCE = new ConnectionWatchdog();
    private static final int EVALUATE_TIME = 30000;
    private static final int REEVALUATE_TIME = 15000;
    static /* synthetic */ Class class$com$limegroup$gnutella$ConnectionWatchdog;

    public static ConnectionWatchdog instance() {
        return INSTANCE;
    }

    private ConnectionWatchdog() {
    }

    public void start() {
        ManagedThread managedThread = new ManagedThread(this, "ConnectionWatchdog");
        managedThread.setDaemon(true);
        managedThread.start();
    }

    private List findDuds() {
        ManagedConnection managedConnection;
        HashMap hashMap = new HashMap();
        Iterator iterator = this.allConnections();
        while (iterator.hasNext()) {
            managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isKillable()) continue;
            hashMap.put((Object)managedConnection, (Object)new ConnectionState(managedConnection));
        }
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        iterator = new ArrayList();
        managedConnection = this.allConnections();
        while (managedConnection.hasNext()) {
            ConnectionState connectionState;
            ConnectionState connectionState2;
            Object object;
            ManagedConnection managedConnection2 = (ManagedConnection)managedConnection.next();
            if (!managedConnection2.isKillable() || (object = hashMap.get((Object)managedConnection2)) == null || !(connectionState2 = new ConnectionState(managedConnection2)).notProgressedSince(connectionState = (ConnectionState)object)) continue;
            iterator.add((Object)managedConnection2);
        }
        return iterator;
    }

    private void killIfStillDud(List list) {
        ManagedConnection managedConnection;
        HashMap hashMap = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isKillable()) continue;
            hashMap.put((Object)managedConnection, (Object)new ConnectionState(managedConnection));
            managedConnection.setHorizonEnabled(false);
            RouterService.getMessageRouter().sendPingRequest(new PingRequest(1), managedConnection);
        }
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            ConnectionState connectionState;
            ConnectionState connectionState2;
            managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isKillable()) continue;
            managedConnection.setHorizonEnabled(true);
            Object object = hashMap.get((Object)managedConnection);
            if (object == null || !(connectionState2 = new ConnectionState(managedConnection)).notProgressedSince(connectionState = (ConnectionState)object)) continue;
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Killing connection: " + managedConnection));
            }
            RouterService.removeConnection(managedConnection);
        }
    }

    public void run() {
        if (!ConnectionSettings.WATCHDOG_ACTIVE.getValue()) {
            return;
        }
        try {
            while (true) {
                List list;
                if ((list = this.findDuds()).size() <= 0) {
                    continue;
                }
                this.killIfStillDud(list);
            }
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
            return;
        }
    }

    private Iterator allConnections() {
        List list = RouterService.getConnectionManager().getInitializedConnections();
        List list2 = RouterService.getConnectionManager().getInitializedClientConnections();
        ArrayList arrayList = new ArrayList(list.size() + list2.size());
        arrayList.addAll((Collection)list);
        arrayList.addAll((Collection)list2);
        return arrayList.iterator();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ConnectionState {
        final long sentDropped;
        final long sent;
        final long received;

        ConnectionState(ManagedConnection managedConnection) {
            this.sentDropped = managedConnection.getNumSentMessagesDropped();
            this.sent = managedConnection.getNumMessagesSent();
            this.received = managedConnection.getNumMessagesReceived();
        }

        boolean notProgressedSince(ConnectionState connectionState) {
            long l = this.sent - connectionState.sent;
            long l2 = this.sentDropped - connectionState.sentDropped;
            long l3 = this.received - connectionState.received;
            if (l == l2 && l != 0L) {
                return true;
            }
            return l3 == 0L;
        }

        public String toString() {
            return "{sent: " + this.sent + ", sdropped: " + this.sentDropped + "}";
        }
    }
}

