/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorCallback;

public final class ErrorService {
    private static ErrorCallback _errorCallback = new ShellErrorCallback();

    private ErrorService() {
    }

    public static void setErrorCallback(ErrorCallback errorCallback) {
        _errorCallback = errorCallback;
    }

    public static ErrorCallback getErrorCallback() {
        return _errorCallback;
    }

    public static void error(Throwable throwable) {
        _errorCallback.error(throwable);
    }

    public static void error(Throwable throwable, String string) {
        _errorCallback.error(throwable, string);
    }

    private static class ShellErrorCallback
    implements ErrorCallback {
        private ShellErrorCallback() {
        }

        public void error(Throwable throwable) {
            throwable.printStackTrace();
        }

        public void error(Throwable throwable, String string) {
            throwable.printStackTrace();
            System.out.println(string);
        }
    }
}

