/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPHostRanker;
import com.limegroup.gnutella.bootstrap.BootstrapServer;
import com.limegroup.gnutella.bootstrap.BootstrapServerManager;
import com.limegroup.gnutella.bootstrap.UDPHostCache;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.BucketQueue;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FixedsizePriorityQueue;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Set;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCatcher {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$HostCatcher == null ? (class$com$limegroup$gnutella$HostCatcher = HostCatcher.class$("com.limegroup.gnutella.HostCatcher")) : class$com$limegroup$gnutella$HostCatcher));
    static final int CACHE_SIZE = 20;
    static final int GOOD_SIZE = 1000;
    static final int NORMAL_SIZE = 400;
    static final int PERMANENT_SIZE = 400;
    public static final int CACHE_PRIORITY = 2;
    public static final int GOOD_PRIORITY = 1;
    public static final int NORMAL_PRIORITY = 0;
    private final BucketQueue ENDPOINT_QUEUE = new BucketQueue(new int[]{400, 1000, 20});
    private final Set ENDPOINT_SET = new HashSet();
    private final Set FREE_ULTRAPEER_SLOTS_SET = new HashSet();
    private final Set FREE_LEAF_SLOTS_SET = new HashSet();
    private final Map LOCALE_SET_MAP = new HashMap();
    private static final int LOCALE_SET_SIZE = 100;
    private FixedsizePriorityQueue permanentHosts = new FixedsizePriorityQueue(ExtendedEndpoint.priorityComparator(), 400);
    private Set permanentHostsSet = new HashSet();
    private BootstrapServerManager gWebCache = BootstrapServerManager.instance();
    private UDPHostCache udpHostCache = new UDPHostCache();
    private final File HOST_FILE;
    private int _failures;
    private final Set EXPIRED_HOSTS = new HashSet();
    private final Set PROBATION_HOSTS = new HashSet();
    private static long PROBATION_RECOVERY_WAIT_TIME = 60000L;
    private static long PROBATION_RECOVERY_TIME = 60000L;
    public static final int PROBATION_HOSTS_SIZE = 500;
    public static final int EXPIRED_HOSTS_SIZE = 500;
    public final Bootstrapper FETCHER = new Bootstrapper();
    private volatile int _catchersWaiting = 0;
    private long lastAllowedPongRankTime = 0L;
    private final long PONG_RANKING_EXPIRE_TIME = 20000L;
    private static final int MAX_CONNECTIONS = 5;
    static boolean DEBUG = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$HostCatcher;

    public HostCatcher() {
        this.HOST_FILE = new File(CommonUtils.getUserSettingsDir(), "gnutella.net");
    }

    public void initialize() {
        LOG.trace((Object)"START scheduling");
        Runnable runnable = new Runnable(){

            public void run() {
                if (RouterService.acceptedIncomingConnection() && RouterService.isSupernode()) {
                    byte[] byArray = RouterService.getAddress();
                    int n = RouterService.getPort();
                    if (NetworkUtils.isValidAddress(byArray) && NetworkUtils.isValidPort(n) && !NetworkUtils.isPrivateAddress(byArray)) {
                        Endpoint endpoint = new Endpoint(byArray, n);
                        HostCatcher.this.gWebCache.sendUpdatesAsync(endpoint);
                    }
                }
            }
        };
        RouterService.schedule(runnable, BootstrapServerManager.UPDATE_DELAY_MSEC, BootstrapServerManager.UPDATE_DELAY_MSEC);
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LOG.trace((Object)"restoring hosts on probation");
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    Iterator iterator = HostCatcher.this.PROBATION_HOSTS.iterator();
                    while (iterator.hasNext()) {
                        Endpoint endpoint = (Endpoint)iterator.next();
                        HostCatcher.this.add(endpoint, false);
                    }
                    HostCatcher.this.PROBATION_HOSTS.clear();
                }
            }
        };
        RouterService.schedule(runnable2, PROBATION_RECOVERY_WAIT_TIME, PROBATION_RECOVERY_TIME);
        RouterService.schedule(this.FETCHER, 0L, 2000L);
        LOG.trace((Object)"STOP scheduling");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUDPPings() {
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            this.rank((Collection)new HashSet((Collection)this.ENDPOINT_SET));
        }
    }

    private void rank(Collection collection) {
        if (this.needsPongRanking()) {
            UDPHostRanker.rank(collection, new Cancellable(){

                public boolean isCancelled() {
                    return !HostCatcher.this.needsPongRanking();
                }
            });
        }
    }

    private boolean needsPongRanking() {
        if (RouterService.isFullyConnected()) {
            return false;
        }
        int n = RouterService.getConnectionManager().getInitializedConnections().size();
        if (n >= 5) {
            return false;
        }
        long l = System.currentTimeMillis();
        if (l > this.lastAllowedPongRankTime) {
            return false;
        }
        int n2 = RouterService.isSupernode() ? this.FREE_ULTRAPEER_SLOTS_SET.size() : this.FREE_LEAF_SLOTS_SET.size();
        int n3 = RouterService.getConnectionManager().getPreferredConnectionCount();
        return n2 < n3 - n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void read(File file) throws FileNotFoundException, IOException {
        LOG.trace((Object)"entered HostCatcher.read(File)");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while (true) {
                String string = bufferedReader.readLine();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("read line: " + string));
                }
                if (string == null) {
                    break;
                }
                try {
                    this.gWebCache.addBootstrapServer(new BootstrapServer(string));
                }
                catch (ParseException parseException) {
                    try {
                        this.add(ExtendedEndpoint.read(string), 0);
                    }
                    catch (ParseException parseException2) {}
                }
            }
        }
        finally {
            this.gWebCache.bootstrapServersAdded();
            this.udpHostCache.hostCachesAdded();
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        LOG.trace((Object)"left HostCatcher.read(File)");
    }

    synchronized void write() throws IOException {
        this.write(this.HOST_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void write(File file) throws IOException {
        BootstrapServer bootstrapServer;
        this.repOk();
        FileWriter fileWriter = new FileWriter(file);
        Object object = this.gWebCache;
        synchronized (object) {
            Iterator iterator = this.gWebCache.getBootstrapServers();
            while (iterator.hasNext()) {
                bootstrapServer = (BootstrapServer)iterator.next();
                fileWriter.write(bootstrapServer.toString());
                fileWriter.write("\n");
            }
        }
        this.udpHostCache.write(fileWriter);
        object = ApplicationSettings.LANGUAGE.getValue();
        boolean bl = ConnectionSettings.USE_LOCALE_PREF.getValue() && this.LOCALE_SET_MAP.containsKey(object) && ((Set)this.LOCALE_SET_MAP.get(object)).size() - 1 > ConnectionSettings.NUM_LOCALE_PREF.getValue();
        bootstrapServer = this.permanentHosts.iterator();
        while (bootstrapServer.hasNext()) {
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)bootstrapServer.next();
            if (bl && !((String)object).equals(extendedEndpoint.getClientLocale()) && (!extendedEndpoint.getConnectionSuccesses().hasNext() || extendedEndpoint.getConnectionFailures().hasNext())) continue;
            extendedEndpoint.write(fileWriter);
        }
        fileWriter.close();
    }

    public boolean add(PingReply pingReply) {
        ExtendedEndpoint extendedEndpoint;
        IpPort ipPort;
        ExtendedEndpoint extendedEndpoint2 = pingReply.getDailyUptime() != -1 ? new ExtendedEndpoint(pingReply.getAddress(), pingReply.getPort(), pingReply.getDailyUptime()) : new ExtendedEndpoint(pingReply.getAddress(), pingReply.getPort());
        if (!pingReply.getClientLocale().equals("")) {
            extendedEndpoint2.setClientLocale(pingReply.getClientLocale());
        }
        if (pingReply.isUDPHostCache()) {
            extendedEndpoint2.setHostname(pingReply.getUDPCacheAddress());
            extendedEndpoint2.setUDPHostCache(true);
        }
        if (!this.isValidHost(extendedEndpoint2)) {
            return false;
        }
        if (pingReply.supportsUnicast()) {
            QueryUnicaster.instance().addUnicastEndpoint(pingReply.getInetAddress(), pingReply.getPort());
        }
        this.rank((Collection)pingReply.getPackedIPPorts());
        Iterator iterator = pingReply.getPackedIPPorts().iterator();
        while (iterator.hasNext()) {
            ipPort = (IpPort)iterator.next();
            extendedEndpoint = new ExtendedEndpoint(ipPort.getAddress(), ipPort.getPort());
            if (!this.isValidHost(extendedEndpoint)) continue;
            this.add(extendedEndpoint, 1);
        }
        iterator = pingReply.getPackedUDPHostCaches().iterator();
        while (iterator.hasNext()) {
            ipPort = (IpPort)iterator.next();
            extendedEndpoint = new ExtendedEndpoint(ipPort.getAddress(), ipPort.getPort());
            extendedEndpoint.setUDPHostCache(true);
            this.addUDPHostCache(extendedEndpoint);
        }
        if (extendedEndpoint2.isUDPHostCache()) {
            return this.addUDPHostCache(extendedEndpoint2);
        }
        if (pingReply.isUltrapeer()) {
            if (pingReply.hasFreeLeafSlots()) {
                this.addToFixedSizeSet(extendedEndpoint2, this.FREE_LEAF_SLOTS_SET);
                if (!pingReply.hasFreeUltrapeerSlots()) {
                    return true;
                }
            }
            if (pingReply.hasFreeUltrapeerSlots() || ApplicationSettings.LANGUAGE.getValue().equals(pingReply.getClientLocale()) && pingReply.getNumFreeLocaleSlots() > 0) {
                this.addToFixedSizeSet(extendedEndpoint2, this.FREE_ULTRAPEER_SLOTS_SET);
                return true;
            }
            return this.add(extendedEndpoint2, 1);
        }
        return this.add(extendedEndpoint2, 0);
    }

    private boolean addUDPHostCache(ExtendedEndpoint extendedEndpoint) {
        return this.udpHostCache.add(extendedEndpoint);
    }

    private synchronized void addToFixedSizeSet(ExtendedEndpoint extendedEndpoint, Set set) {
        if (set.add((Object)extendedEndpoint) && set.size() > 200) {
            set.remove(set.iterator().next());
        }
        this.addPermanent(extendedEndpoint);
        this.notify();
    }

    private synchronized void addToLocaleMap(ExtendedEndpoint extendedEndpoint) {
        String string = extendedEndpoint.getClientLocale();
        if (this.LOCALE_SET_MAP.containsKey((Object)string)) {
            Set set = (Set)this.LOCALE_SET_MAP.get((Object)string);
            if (set.add((Object)extendedEndpoint) && set.size() > 100) {
                set.remove(set.iterator().next());
            }
        } else {
            HashSet hashSet = new HashSet();
            hashSet.add((Object)extendedEndpoint);
            this.LOCALE_SET_MAP.put((Object)string, (Object)hashSet);
        }
    }

    public void add(Collection collection) {
        this.rank(collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add((Endpoint)iterator.next(), true);
        }
    }

    public boolean add(Endpoint endpoint, boolean bl) {
        if (!this.isValidHost(endpoint)) {
            return false;
        }
        if (bl) {
            return this.add(endpoint, 1);
        }
        return this.add(endpoint, 0);
    }

    public boolean add(Endpoint endpoint, boolean bl, String string) {
        if (!this.isValidHost(endpoint)) {
            return false;
        }
        if (bl) {
            return this.add(new ExtendedEndpoint(endpoint.getAddress(), endpoint.getPort(), string), 1);
        }
        return this.add(new ExtendedEndpoint(endpoint.getAddress(), endpoint.getPort(), string), 0);
    }

    public boolean add(Endpoint endpoint, int n) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("adding host " + endpoint));
        }
        if (endpoint instanceof ExtendedEndpoint) {
            return this.add((ExtendedEndpoint)endpoint, n);
        }
        return this.add(new ExtendedEndpoint(endpoint.getAddress(), endpoint.getPort()), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(ExtendedEndpoint extendedEndpoint, int n) {
        this.repOk();
        if (extendedEndpoint.isUDPHostCache()) {
            return this.addUDPHostCache(extendedEndpoint);
        }
        this.addPermanent(extendedEndpoint);
        boolean bl = false;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (!this.ENDPOINT_SET.contains((Object)extendedEndpoint)) {
                bl = true;
                this.ENDPOINT_SET.add((Object)extendedEndpoint);
                Object object = this.ENDPOINT_QUEUE.insert(extendedEndpoint, n);
                if (object != null) {
                    this.ENDPOINT_SET.remove(object);
                }
                this.notify();
            }
        }
        this.repOk();
        return bl;
    }

    private synchronized boolean addPermanent(ExtendedEndpoint extendedEndpoint) {
        if (NetworkUtils.isPrivateAddress(extendedEndpoint.getInetAddress())) {
            return false;
        }
        if (this.permanentHostsSet.contains((Object)extendedEndpoint)) {
            return false;
        }
        this.addToLocaleMap(extendedEndpoint);
        Object object = this.permanentHosts.insert(extendedEndpoint);
        if (object != extendedEndpoint) {
            this.permanentHostsSet.add((Object)extendedEndpoint);
            if (object != null) {
                this.permanentHostsSet.remove(object);
            }
            return true;
        }
        return false;
    }

    private synchronized boolean removePermanent(ExtendedEndpoint extendedEndpoint) {
        boolean bl;
        boolean bl2 = this.permanentHosts.remove(extendedEndpoint);
        Assert.that(bl2 == (bl = this.permanentHostsSet.remove((Object)extendedEndpoint)), "Queue " + bl2 + " but set " + bl);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidHost(Endpoint endpoint) {
        byte[] byArray;
        if (endpoint.isUDPHostCache()) {
            return true;
        }
        try {
            byArray = endpoint.getHostBytes();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        if (NetworkUtils.isPrivateAddress(byArray)) {
            return false;
        }
        if (NetworkUtils.isMe(byArray, endpoint.getPort())) {
            return false;
        }
        if (RouterService.getAcceptor().isBannedIP(byArray)) {
            return false;
        }
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (this.EXPIRED_HOSTS.contains((Object)endpoint)) {
                return false;
            }
            if (this.PROBATION_HOSTS.contains((Object)endpoint)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Endpoint getAnEndpoint() throws InterruptedException {
        while (true) {
            try {
                return this.getAnEndpointInternal();
            }
            catch (NoSuchElementException noSuchElementException) {
                try {
                    ++this._catchersWaiting;
                    this.wait();
                    continue;
                }
                finally {
                    --this._catchersWaiting;
                    continue;
                }
            }
            break;
        }
    }

    public synchronized void doneWithConnect(Endpoint endpoint, boolean bl) {
        if (!(endpoint instanceof ExtendedEndpoint)) {
            return;
        }
        ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)endpoint;
        this.removePermanent(extendedEndpoint);
        if (bl) {
            extendedEndpoint.recordConnectionSuccess();
        } else {
            ++this._failures;
            extendedEndpoint.recordConnectionFailure();
        }
        this.addPermanent(extendedEndpoint);
    }

    private ExtendedEndpoint getAnEndpointInternal() throws NoSuchElementException {
        if (RouterService.isSupernode() && !this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
        }
        if (RouterService.isShieldedLeaf() && !this.FREE_LEAF_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_LEAF_SLOTS_SET);
        }
        if (!this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
        }
        if (!this.FREE_LEAF_SLOTS_SET.isEmpty()) {
            Iterator iterator = this.FREE_LEAF_SLOTS_SET.iterator();
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)iterator.next();
            iterator.remove();
            return extendedEndpoint;
        }
        if (!this.ENDPOINT_QUEUE.isEmpty()) {
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)this.ENDPOINT_QUEUE.extractMax();
            boolean bl = this.ENDPOINT_SET.remove((Object)extendedEndpoint);
            Assert.that(bl, "Rep. invariant for HostCatcher broken.");
            return extendedEndpoint;
        }
        throw new NoSuchElementException();
    }

    private ExtendedEndpoint preferenceWithLocale(Set set) {
        ExtendedEndpoint extendedEndpoint;
        Iterator iterator;
        String string = ApplicationSettings.LANGUAGE.getValue();
        if (!RouterService.getConnectionManager().isLocaleMatched() && this.LOCALE_SET_MAP.containsKey((Object)string)) {
            iterator = (Set)this.LOCALE_SET_MAP.get((Object)string);
            extendedEndpoint = set.iterator();
            while (extendedEndpoint.hasNext()) {
                Object object = extendedEndpoint.next();
                if (!iterator.contains(object)) continue;
                extendedEndpoint.remove();
                iterator.remove(object);
                return (ExtendedEndpoint)object;
            }
        }
        iterator = set.iterator();
        extendedEndpoint = (ExtendedEndpoint)iterator.next();
        iterator.remove();
        return extendedEndpoint;
    }

    public synchronized int getNumHosts() {
        return this.ENDPOINT_QUEUE.size() + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size();
    }

    public synchronized int getNumUltrapeerHosts() {
        return this.ENDPOINT_QUEUE.size(1) + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size();
    }

    Iterator getPermanentHosts() {
        return this.permanentHosts.iterator();
    }

    public synchronized Collection getUltrapeersWithFreeUltrapeerSlots(int n) {
        return this.getPreferencedCollection(this.FREE_ULTRAPEER_SLOTS_SET, ApplicationSettings.LANGUAGE.getValue(), n);
    }

    public synchronized Collection getUltrapeersWithFreeUltrapeerSlots(String string, int n) {
        return this.getPreferencedCollection(this.FREE_ULTRAPEER_SLOTS_SET, string, n);
    }

    public synchronized Collection getUltrapeersWithFreeLeafSlots(int n) {
        return this.getPreferencedCollection(this.FREE_LEAF_SLOTS_SET, ApplicationSettings.LANGUAGE.getValue(), n);
    }

    public synchronized Collection getUltrapeersWithFreeLeafSlots(String string, int n) {
        return this.getPreferencedCollection(this.FREE_LEAF_SLOTS_SET, string, n);
    }

    private Collection getPreferencedCollection(Set set, String string, int n) {
        Iterator iterator;
        if (string == null || string.equals("")) {
            string = ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        HashSet hashSet = new HashSet(n);
        Set set2 = (Set)this.LOCALE_SET_MAP.get((Object)string);
        if (set2 != null) {
            iterator = set2.iterator();
            while (iterator.hasNext() && hashSet.size() < n) {
                Object object = iterator.next();
                if (!set.contains(object)) continue;
                hashSet.add(object);
            }
        }
        iterator = set.iterator();
        while (iterator.hasNext() && hashSet.size() < n) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public synchronized void expire() {
        long l = System.currentTimeMillis();
        long l2 = ConnectionSettings.LAST_GWEBCACHE_FETCH_TIME.getValue();
        if (l2 + 604800000L <= l) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Fetching more bootstrap servers. Last fetch time: " + l2));
            }
            this.gWebCache.fetchBootstrapServersAsync();
        }
        this.recoverHosts();
        this.lastAllowedPongRankTime = l + 20000L;
        RouterService.schedule(new Runnable(){

            public void run() {
                UDPHostRanker.resetData();
            }
        }, 20000L, 0L);
    }

    public synchronized void clear() {
        this.FREE_LEAF_SLOTS_SET.clear();
        this.FREE_ULTRAPEER_SLOTS_SET.clear();
        this.ENDPOINT_QUEUE.clear();
        this.ENDPOINT_SET.clear();
    }

    public String toString() {
        return "[volatile:" + this.ENDPOINT_QUEUE.toString() + ", permanent:" + this.permanentHosts.toString() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repOk() {
        if (!DEBUG) {
            return;
        }
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            Object object;
            Iterator iterator = this.ENDPOINT_SET.iterator();
            block3: while (iterator.hasNext()) {
                object = iterator.next();
                Iterator iterator2 = this.ENDPOINT_QUEUE.iterator();
                while (iterator2.hasNext()) {
                    if (!object.equals(iterator2.next())) continue;
                    continue block3;
                }
                Assert.that(false, "Couldn't find " + object + " in queue");
            }
            iterator = this.ENDPOINT_QUEUE.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                Assert.that(object instanceof ExtendedEndpoint);
                Assert.that(this.ENDPOINT_SET.contains(object));
            }
            iterator = this.permanentHosts.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                Assert.that(object instanceof ExtendedEndpoint);
                Assert.that(this.permanentHostsSet.contains(object));
            }
            iterator = this.permanentHostsSet.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                Assert.that(object instanceof ExtendedEndpoint);
                Assert.that(this.permanentHosts.contains(object), "Couldn't find " + object + " from " + this.permanentHostsSet + " in " + this.permanentHosts);
            }
        }
    }

    private void readHostsFile() {
        LOG.trace((Object)"Reading Hosts File");
        try {
            this.read(this.HOST_FILE);
        }
        catch (IOException iOException) {
            LOG.debug((Object)this.HOST_FILE, (Throwable)iOException);
        }
    }

    public synchronized void recoverHosts() {
        LOG.debug((Object)"recovering hosts file");
        this.PROBATION_HOSTS.clear();
        this.EXPIRED_HOSTS.clear();
        this._failures = 0;
        this.FETCHER.resetFetchTime();
        this.gWebCache.resetData();
        this.udpHostCache.resetData();
        UDPHostRanker.resetData();
        this.readHostsFile();
    }

    public synchronized void putHostOnProbation(Endpoint endpoint) {
        this.PROBATION_HOSTS.add((Object)endpoint);
        if (this.PROBATION_HOSTS.size() > 500) {
            this.PROBATION_HOSTS.remove(this.PROBATION_HOSTS.iterator().next());
        }
    }

    public synchronized void expireHost(Endpoint endpoint) {
        this.EXPIRED_HOSTS.add((Object)endpoint);
        if (this.EXPIRED_HOSTS.size() > 500) {
            this.EXPIRED_HOSTS.remove(this.EXPIRED_HOSTS.iterator().next());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Bootstrapper
    implements Runnable {
        private long nextAllowedMulticastTime = 0L;
        private long nextAllowedFetchTime = 0L;
        private int delay = 20000;
        private static final int POST_UDP_DELAY = 30000;
        private static final int POST_MULTICAST_DELAY = 60000;

        private Bootstrapper() {
        }

        public synchronized void run() {
            if (ConnectionSettings.DO_NOT_BOOTSTRAP.getValue()) {
                return;
            }
            if (HostCatcher.this._catchersWaiting == 0) {
                return;
            }
            long l = System.currentTimeMillis();
            if (HostCatcher.this.udpHostCache.getSize() == 0 && l < this.nextAllowedFetchTime && l < this.nextAllowedMulticastTime) {
                return;
            }
            if (!this.needsHosts(l)) {
                return;
            }
            this.getHosts(l);
        }

        void resetFetchTime() {
            this.nextAllowedFetchTime = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean needsHosts(long l) {
            HostCatcher hostCatcher = HostCatcher.this;
            synchronized (hostCatcher) {
                return HostCatcher.this.getNumHosts() == 0 || !RouterService.isConnected() && HostCatcher.this._failures > 100;
            }
        }

        synchronized void getHosts(long l) {
            if (this.multicastFetch(l)) {
                return;
            }
            if (this.udpHostCacheFetch(l)) {
                return;
            }
            if (this.gwebCacheFetch(l)) {
                return;
            }
        }

        private boolean multicastFetch(long l) {
            if (this.nextAllowedMulticastTime < l && !ConnectionSettings.DO_NOT_MULTICAST_BOOTSTRAP.getValue()) {
                LOG.trace((Object)"Fetching via multicast");
                PingRequest pingRequest = PingRequest.createMulticastPing();
                MulticastService.instance().send(pingRequest);
                this.nextAllowedMulticastTime = l + 60000L;
                return true;
            }
            return false;
        }

        private boolean udpHostCacheFetch(long l) {
            if (HostCatcher.this.udpHostCache.fetchHosts()) {
                LOG.trace((Object)"Fetching via UDP");
                this.nextAllowedFetchTime = l + 30000L;
                return true;
            }
            return false;
        }

        private boolean gwebCacheFetch(long l) {
            if (l < this.nextAllowedFetchTime) {
                return false;
            }
            int n = HostCatcher.this.gWebCache.fetchEndpointsAsync();
            switch (n) {
                case 1: {
                    this.delay *= 5;
                    this.nextAllowedFetchTime = l + (long)this.delay;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Fetching hosts.  Next allowed time: " + this.nextAllowedFetchTime));
                    }
                    return true;
                }
                case 2: {
                    LOG.debug((Object)"Tried to fetch, but was already fetching.");
                    return true;
                }
                case 0: {
                    LOG.debug((Object)"Didn't fetch, gWebCache's turned off.");
                    return false;
                }
                case 3: {
                    LOG.debug((Object)"We've received a bunch of endpoints already, didn't fetch.");
                    MessageService.showError("GWEBCACHE_FETCHED_TOO_MANY");
                    return false;
                }
                case 4: {
                    LOG.debug((Object)"Already contacted each gWebCache, didn't fetch.");
                    MessageService.showError("GWEBCACHE_NO_CACHES_LEFT");
                    return false;
                }
            }
            throw new IllegalArgumentException("invalid value: " + n);
        }
    }
}

