/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public class Response {
    private static final byte EXT_SEPERATOR = 28;
    private static final String EXT_STRING = "\u001c";
    private static final int MAX_LOCATIONS = 10;
    private final long index;
    private final long size;
    private final byte[] nameBytes;
    private final String name;
    private String metadata;
    private byte[] metaBytes;
    private LimeXMLDocument document;
    private final Set urns;
    private final byte[] extBytes;
    private final Set otherLocations;
    private volatile RemoteFileDesc cachedRFD;
    private static final String AUDIOS_NAMESPACE = "<audios xsi:noNamespaceSchemaLocation=\"http://www.limewire.com/schemas/audio.xsd\">";
    private static final String AUDIO_TITLE = "<audio title=\"";
    private static final String AUDIO_BITRATE = "bitrate=\"";
    private static final String AUDIO_SECONDS = "seconds=\"";
    private static final String AUDIOS_CLOSE = "</audio></audios>";
    private static final String QUOTE_SPACE = "\" ";
    private static final String CLOSE_TAG = "\">";
    private static final String KBPS = "kbps";
    private static final String KHZ = "kHz";

    public Response(long l, long l2, String string) {
        this(l, l2, string, "", null, null, null, null);
    }

    public Response(long l, long l2, String string, LimeXMLDocument limeXMLDocument) {
        this(l, l2, string, Response.extractMetadata(limeXMLDocument), null, limeXMLDocument, null, null);
    }

    public Response(long l, long l2, String string, String string2) {
        this(l, l2, string, string2, null, null, null, null);
    }

    public Response(FileDesc fileDesc) {
        this(fileDesc.getIndex(), fileDesc.getSize(), fileDesc.getName(), "", fileDesc.getUrns(), null, Response.getAsEndpoints(fileDesc.getAlternateLocationCollection()), null);
    }

    private Response(long l, long l2, String string, String string2, Set set, LimeXMLDocument limeXMLDocument, Set set2, byte[] byArray) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + l);
        }
        if (l2 > Integer.MAX_VALUE || l2 < 0L) {
            throw new IllegalArgumentException("invalid size: " + l2);
        }
        this.index = l;
        this.size = l2;
        this.name = string == null ? "" : I18NConvert.instance().compose(string);
        byte[] byArray2 = null;
        try {
            byArray2 = this.name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
        }
        this.nameBytes = byArray2;
        this.urns = set == null ? DataUtils.EMPTY_SET : Collections.unmodifiableSet((Set)set);
        this.otherLocations = set2 == null ? DataUtils.EMPTY_SET : Collections.unmodifiableSet((Set)set2);
        this.extBytes = byArray != null ? byArray : Response.createExtBytes(this.urns, this.otherLocations);
        this.metadata = (string2 == null || string2.equals("")) && limeXMLDocument != null ? Response.extractMetadata(limeXMLDocument) : (string2 == null ? "" : string2.trim());
        Assert.that(this.metadata != null, "Null metadata");
        try {
            this.metaBytes = this.metadata.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
        }
        this.document = limeXMLDocument;
    }

    public static Response createFromStream(InputStream inputStream) throws IOException {
        int n;
        long l = ByteOrder.ubytes2long(ByteOrder.leb2int(inputStream));
        long l2 = ByteOrder.ubytes2long(ByteOrder.leb2int(inputStream));
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IOException("invalid index: " + l);
        }
        if (l2 > Integer.MAX_VALUE || l2 < 0L) {
            throw new IOException("invalid size: " + l2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != 0) {
            if (n == -1) {
                throw new IOException("EOF before null termination");
            }
            byteArrayOutputStream.write(n);
        }
        String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        if (string.length() == 0) {
            throw new IOException("empty name in response");
        }
        byteArrayOutputStream.reset();
        while ((n = inputStream.read()) != 0) {
            if (n == -1) {
                throw new IOException("EOF before null termination");
            }
            byteArrayOutputStream.write(n);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string2 = new String(byArray);
        if (string2 == null || string2.equals("")) {
            if (inputStream.available() < 16) {
                throw new IOException("not enough room for the GUID");
            }
            return new Response(l, l2, string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, EXT_STRING);
        HashSet hashSet = null;
        Set set = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string4 = stringTokenizer.nextToken();
            if (URN.isUrn(string4)) {
                try {
                    object = URN.createSHA1Urn(string4);
                    if (hashSet == null) {
                        hashSet = new HashSet(1);
                    }
                    hashSet.add(object);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((object = string4.getBytes()) != null && ((byte[])object).length > 1 && object[0] == -61) {
                GGEP[] gGEPArray;
                boolean bl = false;
                if (stringTokenizer.hasMoreTokens()) {
                    bl = true;
                    gGEPArray = new StringBuffer(string4);
                    while (stringTokenizer.hasMoreTokens()) {
                        gGEPArray.append(EXT_STRING);
                        gGEPArray.append(stringTokenizer.nextToken());
                    }
                    object = gGEPArray.toString().getBytes();
                }
                gGEPArray = null;
                try {
                    if (!bl) {
                        gGEPArray = GGEP.read(object, 0);
                    } else {
                        int[] nArray = new int[1];
                        gGEPArray = GGEP.read(object, 0, nArray);
                        if (nArray[0] != ((byte[])object).length) {
                            stringTokenizer = Response.recreateTokenizer(object, nArray[0]);
                        }
                    }
                    set = GGEPUtil.getLocations(gGEPArray);
                    continue;
                }
                catch (BadGGEPBlockException badGGEPBlockException) {
                    // empty catch block
                }
            }
            string3 = Response.createXmlString(string, string4);
        }
        return new Response(l, l2, string, string3, (Set)hashSet, null, set, byArray);
    }

    private static StringTokenizer recreateTokenizer(byte[] byArray, int n) {
        String string = new String(byArray, n, byArray.length - n);
        return new StringTokenizer(string, EXT_STRING);
    }

    private static String createXmlString(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.countTokens() < 2) {
            return "";
        }
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        if (string3 != null) {
            string3 = string3.toLowerCase();
        }
        if (string4 != null) {
            string4 = string4.toLowerCase();
        }
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string4.startsWith(KBPS)) {
            bl = true;
        } else if (string3.endsWith(KBPS)) {
            bl2 = true;
        }
        if (bl) {
            string6 = string3;
        } else if (bl2) {
            n = string3.indexOf(KBPS);
            string6 = string3.substring(0, n);
        }
        if (bl || bl2) {
            while (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            }
        } else if (string2.endsWith(KHZ)) {
            bl3 = true;
            string5 = string3;
            n = string4.indexOf(KBPS);
            if (n > -1) {
                string6 = string4.substring(0, n);
            } else {
                bl3 = false;
            }
        }
        if (bl || bl2 || bl3) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(AUDIOS_NAMESPACE);
            stringBuffer.append(AUDIO_TITLE);
            stringBuffer.append(string);
            stringBuffer.append(QUOTE_SPACE);
            stringBuffer.append(AUDIO_BITRATE);
            stringBuffer.append(string6);
            stringBuffer.append(QUOTE_SPACE);
            stringBuffer.append(AUDIO_SECONDS);
            stringBuffer.append(string5);
            stringBuffer.append(CLOSE_TAG);
            stringBuffer.append(AUDIOS_CLOSE);
            return stringBuffer.toString();
        }
        return "";
    }

    private static byte[] createExtBytes(Set set, Set set2) {
        try {
            if (Response.isEmpty(set) && Response.isEmpty(set2)) {
                return DataUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (!Response.isEmpty(set)) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    URN uRN = (URN)iterator.next();
                    Assert.that(uRN != null, "Null URN");
                    byteArrayOutputStream.write(uRN.toString().getBytes());
                    if (!iterator.hasNext()) continue;
                    byteArrayOutputStream.write(28);
                }
                if (!Response.isEmpty(set2)) {
                    byteArrayOutputStream.write(28);
                }
            }
            if (!Response.isEmpty(set2)) {
                GGEPUtil.addGGEP(byteArrayOutputStream, set2);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
    }

    private static boolean isEmpty(Set set) {
        return set == null || set.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set getAsEndpoints(AlternateLocationCollection alternateLocationCollection) {
        if (alternateLocationCollection == null || alternateLocationCollection.getAltLocsSize() == 0) {
            return DataUtils.EMPTY_SET;
        }
        AlternateLocationCollection alternateLocationCollection2 = alternateLocationCollection;
        synchronized (alternateLocationCollection2) {
            HashSet hashSet = null;
            int n = 0;
            Iterator iterator = alternateLocationCollection.iterator();
            while (iterator.hasNext() && n < 10) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                Endpoint endpoint = alternateLocation.getHost();
                if (NetworkUtils.isMe(endpoint.getAddress(), endpoint.getPort())) continue;
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                hashSet.add((Object)alternateLocation.getHost());
                ++n;
            }
            return hashSet == null ? DataUtils.EMPTY_SET : hashSet;
        }
    }

    private static String extractMetadata(LimeXMLDocument limeXMLDocument) {
        if (limeXMLDocument == null) {
            return "";
        }
        try {
            return limeXMLDocument.getXMLString();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            return "";
        }
    }

    public int writeToArray(byte[] byArray, int n) {
        ByteOrder.int2leb((int)this.index, byArray, n);
        ByteOrder.int2leb((int)this.size, byArray, n + 4);
        System.arraycopy(this.nameBytes, 0, byArray, n += 8, this.nameBytes.length);
        n += this.nameBytes.length;
        byArray[n++] = 0;
        System.arraycopy(this.extBytes, 0, byArray, n, this.extBytes.length);
        n += this.extBytes.length;
        byArray[n++] = 0;
        return n;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        int n;
        ByteOrder.int2leb((int)this.index, outputStream);
        ByteOrder.int2leb((int)this.size, outputStream);
        for (n = 0; n < this.nameBytes.length; ++n) {
            outputStream.write(this.nameBytes[n]);
        }
        outputStream.write(0);
        for (n = 0; n < this.extBytes.length; ++n) {
            outputStream.write(this.extBytes[n]);
        }
        outputStream.write(0);
    }

    public void setDocument(LimeXMLDocument limeXMLDocument) {
        this.document = limeXMLDocument;
        this.metadata = Response.extractMetadata(this.document);
        try {
            this.metaBytes = this.metadata.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
        }
    }

    public int getLength() {
        return 8 + this.nameBytes.length + 1 + this.extBytes.length + 1;
    }

    public long getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public int getNameBytesSize() {
        return this.nameBytes.length;
    }

    public int getMetaBytesSize() {
        return this.metaBytes.length;
    }

    public byte[] getNameBytes() {
        byte[] byArray = new byte[this.nameBytes.length];
        System.arraycopy(this.nameBytes, 0, byArray, 0, this.nameBytes.length);
        return byArray;
    }

    public byte[] getMetaBytes() {
        byte[] byArray = new byte[this.metaBytes.length];
        System.arraycopy(this.metaBytes, 0, byArray, 0, this.metaBytes.length);
        return byArray;
    }

    public String getName() {
        return this.name;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public LimeXMLDocument getDocument() {
        if (this.document != null) {
            return this.document;
        }
        if (this.metadata != null && !this.metadata.equals("")) {
            try {
                this.document = new LimeXMLDocument(this.metadata);
                return this.document;
            }
            catch (SAXException sAXException) {
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Set getUrns() {
        return this.urns;
    }

    public Set getLocations() {
        return this.otherLocations;
    }

    byte[] getExtBytes() {
        return this.extBytes;
    }

    public RemoteFileDesc toRemoteFileDesc(HostData hostData) {
        RemoteFileDesc remoteFileDesc;
        if (this.cachedRFD != null && this.cachedRFD.getPort() == hostData.getPort() && this.cachedRFD.getHost().equals(hostData.getIP())) {
            return this.cachedRFD;
        }
        this.cachedRFD = remoteFileDesc = new RemoteFileDesc(hostData.getIP(), hostData.getPort(), this.getIndex(), this.getName(), (int)this.getSize(), hostData.getClientGUID(), hostData.getSpeed(), hostData.isChatEnabled(), hostData.getQuality(), hostData.isBrowseHostEnabled(), this.getDocument(), this.getUrns(), hostData.isReplyToMulticastQuery(), hostData.isFirewalled(), hostData.getVendorCode(), System.currentTimeMillis(), hostData.getPushProxies());
        return remoteFileDesc;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Response)) {
            return false;
        }
        Response response = (Response)object;
        return this.getIndex() == response.getIndex() && this.getSize() == response.getSize() && this.getName().equals(response.getName()) && Arrays.equals((byte[])this.getNameBytes(), (byte[])response.getNameBytes()) && this.getMetadata().equals(response.getMetadata()) && Arrays.equals((byte[])this.getMetaBytes(), (byte[])response.getMetaBytes()) && (this.getDocument() == null ? response.getDocument() == null : this.getDocument().equals(response.getDocument())) && this.getUrns().equals(response.getUrns());
    }

    public int hashCode() {
        return this.getName().hashCode() + (int)this.getSize() + (int)this.getIndex();
    }

    public String toString() {
        return "index:        " + this.index + "\r\n" + "size:         " + this.size + "\r\n" + "name:         " + this.name + "\r\n" + "metadata:     " + this.metadata + "\r\n" + "xml document: " + this.document + "\r\n" + "urns:         " + this.urns;
    }

    private static class GGEPUtil {
        private GGEPUtil() {
        }

        static void addGGEP(OutputStream outputStream, Set set) throws IOException {
            if (set == null || set.size() == 0) {
                throw new NullPointerException("null or empty locations");
            }
            GGEP gGEP = new GGEP();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    try {
                        Endpoint endpoint = (Endpoint)iterator.next();
                        byteArrayOutputStream.write(endpoint.getHostBytes());
                        ByteOrder.short2leb((short)endpoint.getPort(), byteArrayOutputStream);
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
            gGEP.put("ALT", byteArrayOutputStream.toByteArray());
            gGEP.write(outputStream);
        }

        static byte[] getGGEPBytes(Set set) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                GGEPUtil.addGGEP(byteArrayOutputStream, set);
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
            return byteArrayOutputStream.toByteArray();
        }

        static Set getLocations(GGEP[] gGEPArray) {
            if (gGEPArray == null) {
                return DataUtils.EMPTY_SET;
            }
            HashSet hashSet = null;
            byte[] byArray = new byte[4];
            IPFilter iPFilter = IPFilter.instance();
            for (int i = 0; i < gGEPArray.length; ++i) {
                byte[] byArray2;
                block7: {
                    if (!gGEPArray[i].hasKey("ALT")) continue;
                    try {
                        byArray2 = gGEPArray[i].getBytes("ALT");
                        if (byArray2.length % 6 != 0) {
                        }
                        break block7;
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        ErrorService.error(badGGEPPropertyException);
                    }
                    continue;
                }
                for (int j = 0; j < byArray2.length; j += 6) {
                    int n = ByteOrder.ubytes2int(ByteOrder.leb2short(byArray2, j + 4));
                    if (!NetworkUtils.isValidPort(n)) continue;
                    byArray[0] = byArray2[j];
                    byArray[1] = byArray2[j + 1];
                    byArray[2] = byArray2[j + 2];
                    byArray[3] = byArray2[j + 3];
                    if (!NetworkUtils.isValidAddress(byArray) || !iPFilter.allow(byArray) || NetworkUtils.isMe(byArray, n)) continue;
                    if (hashSet == null) {
                        hashSet = new HashSet();
                    }
                    hashSet.add((Object)new Endpoint(byArray, n));
                }
            }
            return hashSet == null ? DataUtils.EMPTY_SET : hashSet;
        }
    }
}

