/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionWatchdog;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HorizonCounter;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.Pinger;
import com.limegroup.gnutella.PushManager;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.StandardMessageRouter;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.bootstrap.BootstrapServerManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.MutableGUIDFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.upelection.PromotionManager;
import com.limegroup.gnutella.uploader.NormalUploadState;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.SimpleTimer;
import com.limegroup.gnutella.xml.MetaFileManager;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RouterService {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$RouterService == null ? (class$com$limegroup$gnutella$RouterService = RouterService.class$("com.limegroup.gnutella.RouterService")) : class$com$limegroup$gnutella$RouterService));
    private static FileManager fileManager = new MetaFileManager();
    private static final SimpleTimer timer = new SimpleTimer(true);
    private static final Acceptor acceptor = new Acceptor();
    private static ConnectionManager manager = new ConnectionManager();
    private static HostCatcher catcher = new HostCatcher();
    private static final DownloadManager downloader = new DownloadManager();
    private static UploadManager uploadManager = new UploadManager();
    private static PushManager pushManager = new PushManager();
    private static PromotionManager promotionManager = new PromotionManager();
    private static final ResponseVerifier verifier = new ResponseVerifier();
    private static final Statistics statistics = Statistics.instance();
    private static final UDPService udpService = UDPService.instance();
    private static final SearchResultHandler RESULT_HANDLER = new SearchResultHandler();
    private static boolean isShuttingDown;
    private static ActivityCallback callback;
    private static MessageRouter router;
    private static boolean _started;
    private static long _lastQueryTime;
    private static boolean _fullPower;
    static /* synthetic */ Class class$com$limegroup$gnutella$RouterService;

    public RouterService(ActivityCallback activityCallback) {
        this(activityCallback, new StandardMessageRouter());
    }

    public RouterService(ActivityCallback activityCallback, MessageRouter messageRouter, FileManager fileManager) {
        this(activityCallback, messageRouter);
        RouterService.fileManager = fileManager;
    }

    public RouterService(ActivityCallback activityCallback, MessageRouter messageRouter) {
        callback = activityCallback;
        router = messageRouter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class clazz = class$com$limegroup$gnutella$RouterService == null ? (class$com$limegroup$gnutella$RouterService = RouterService.class$("com.limegroup.gnutella.RouterService")) : class$com$limegroup$gnutella$RouterService;
        synchronized (clazz) {
            int n;
            LOG.trace((Object)"START RouterService");
            if (RouterService.isStarted()) {
                return;
            }
            _started = true;
            LOG.trace((Object)"START MessageRouter");
            callback.componentLoading("MESSAGE_ROUTER");
            router.initialize();
            LOG.trace((Object)"STOPMessageRouter");
            LOG.trace((Object)"START Acceptor");
            callback.componentLoading("ACCEPTOR");
            acceptor.start();
            LOG.trace((Object)"STOP Acceptor");
            LOG.trace((Object)"START ConnectionManager");
            callback.componentLoading("CONNECTION_MANAGER");
            manager.initialize();
            LOG.trace((Object)"STOP ConnectionManager");
            LOG.trace((Object)"START DownloadManager");
            downloader.initialize();
            LOG.trace((Object)"STOP DownloadManager");
            LOG.trace((Object)"START SupernodeAssigner");
            SupernodeAssigner supernodeAssigner = new SupernodeAssigner(uploadManager, downloader, manager);
            supernodeAssigner.start();
            LOG.trace((Object)"STOP SupernodeAssigner");
            LOG.trace((Object)"START HostCatcher.initialize");
            callback.componentLoading("HOST_CATCHER");
            catcher.initialize();
            LOG.trace((Object)"STOP HostCatcher.initialize");
            if (ConnectionSettings.CONNECT_ON_STARTUP.getValue() && (n = ConnectionSettings.NUM_CONNECTIONS.getValue()) > 0) {
                LOG.trace((Object)"START connect");
                RouterService.connect();
                LOG.trace((Object)"STOP connect");
            }
            LOG.trace((Object)"START FileManager");
            callback.componentLoading("FILE_MANAGER");
            fileManager.start();
            LOG.trace((Object)"STOP FileManager");
            LOG.trace((Object)"START DownloadManager.postGuiInit");
            callback.componentLoading("DOWNLOAD_MANAGER_POST_GUI");
            downloader.postGuiInit();
            LOG.trace((Object)"STOP DownloadManager.postGuiInit");
            LOG.trace((Object)"START QueryUnicaster");
            callback.componentLoading("QUERY_UNICASTER");
            QueryUnicaster.instance().start();
            LOG.trace((Object)"STOP QueryUnicaster");
            LOG.trace((Object)"START Pinger");
            callback.componentLoading("PINGER");
            Pinger.instance().start();
            LOG.trace((Object)"STOP Pinger");
            LOG.trace((Object)"START ConnectionWatchdog");
            callback.componentLoading("CONNECTION_WATCHDOG");
            ConnectionWatchdog.instance().start();
            LOG.trace((Object)"STOP ConnectionWatchdog");
            LOG.trace((Object)"START SavedFileManager");
            callback.componentLoading("SAVED_FILE_MANAGER");
            SavedFileManager.instance();
            LOG.trace((Object)"STOP SavedFileManager");
            LOG.trace((Object)"STOP RouterService.");
        }
    }

    public static boolean isStarted() {
        return _started;
    }

    public static ActivityCallback getCallback() {
        return callback;
    }

    public static void setFullPower(boolean bl) {
        if (_fullPower != bl) {
            _fullPower = bl;
            NormalUploadState.setThrottleSwitching(!bl);
            HTTPDownloader.setThrottleSwitching(!bl);
        }
    }

    public static MessageRouter getMessageRouter() {
        return router;
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    public static DownloadManager getDownloadManager() {
        return downloader;
    }

    public static UDPService getUdpService() {
        return udpService;
    }

    public static ConnectionManager getConnectionManager() {
        return manager;
    }

    public static UploadManager getUploadManager() {
        return uploadManager;
    }

    public static PushManager getPushManager() {
        return pushManager;
    }

    public static Acceptor getAcceptor() {
        return acceptor;
    }

    public static HostCatcher getHostCatcher() {
        return catcher;
    }

    public static SearchResultHandler getSearchResultHandler() {
        return RESULT_HANDLER;
    }

    public static PromotionManager getPromotionManager() {
        return promotionManager;
    }

    public static void schedule(Runnable runnable, long l, long l2) {
        timer.schedule(runnable, l, l2);
    }

    public static ManagedConnection connectToHostBlocking(String string, int n) throws IOException {
        return manager.createConnectionBlocking(string, n);
    }

    public static void connectToHostAsynchronously(String string, int n) {
        InetAddress inetAddress;
        byte[] byArray = null;
        try {
            inetAddress = InetAddress.getByName(string);
            byArray = inetAddress.getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        if (byArray[0] == 127 && n == acceptor.getPort(true) && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        byte[] byArray2 = acceptor.getAddress(true);
        if (Arrays.equals((byte[])byArray, (byte[])byArray2) && n == acceptor.getPort(true)) {
            return;
        }
        if (!acceptor.isBannedIP(inetAddress.getHostAddress())) {
            manager.createConnectionAsynchronously(string, n);
        }
    }

    public static void connect() {
        RouterService.adjustSpamFilters();
        manager.connect();
    }

    public static void disconnect() {
        manager.disconnect();
    }

    public static void removeConnection(ManagedConnection managedConnection) {
        manager.remove(managedConnection);
    }

    public static void clearHostCatcher() {
        catcher.clear();
    }

    public static int getRealNumHosts() {
        return catcher.getNumHosts();
    }

    public static int getNumDownloads() {
        return downloader.downloadsInProgress();
    }

    public static int getNumActiveDownloads() {
        return downloader.getNumActiveDownloads();
    }

    public static int getNumWaitingDownloads() {
        return downloader.getNumWaitingDownloads();
    }

    public static int getNumIndividualDownloaders() {
        return downloader.getNumIndividualDownloaders();
    }

    public static int getNumUploads() {
        return uploadManager.uploadsInProgress();
    }

    public static int getNumQueuedUploads() {
        return uploadManager.getNumQueuedUploads();
    }

    public static long getCurrentUptime() {
        return statistics.getUptime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void shutdown() {
        try {
            block7: {
                if (!RouterService.isStarted()) {
                    return;
                }
                Statistics.instance().shutdown();
                ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(RouterService.acceptedIncomingConnection());
                try {
                    try {
                        catcher.write();
                    }
                    catch (IOException iOException) {
                        Object var2_1 = null;
                        SettingsHandler.save();
                        break block7;
                    }
                    Object var2 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    SettingsHandler.save();
                    throw throwable;
                }
                SettingsHandler.save();
            }
            downloader.writeSnapshot();
            UrnCache.instance().persistCache();
            CreationTimeCache.instance().persistCache();
            TigerTreeCache.instance().persistCache();
            return;
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
        }
    }

    public static void adjustSpamFilters() {
        IPFilter.refreshIPFilter();
        Iterator iterator = manager.getConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            managedConnection.setPersonalFilter(SpamFilter.newPersonalFilter());
            managedConnection.setRouteFilter(SpamFilter.newRouteFilter());
        }
        UDPReplyHandler.setPersonalFilter(SpamFilter.newPersonalFilter());
    }

    public static void setListeningPort(int n) throws IOException {
        acceptor.setListeningPort(n);
    }

    public static boolean acceptedIncomingConnection() {
        return acceptor.acceptedIncoming();
    }

    public static int getActiveConnectionMessages() {
        int n = 0;
        Iterator iterator = manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            n += managedConnection.getNumMessagesSent();
            n += managedConnection.getNumMessagesReceived();
        }
        return n;
    }

    public static int countConnectionsWithNMessages(int n) {
        int n2 = 0;
        Iterator iterator = manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            int n3 = managedConnection.getNumMessagesSent();
            if ((n3 += managedConnection.getNumMessagesReceived()) <= n) continue;
            ++n2;
        }
        return n2;
    }

    public static long getNumHosts() {
        return HorizonCounter.instance().getNumHosts();
    }

    public static long getNumFiles() {
        return HorizonCounter.instance().getNumFiles();
    }

    public static long getTotalFileSize() {
        return HorizonCounter.instance().getTotalFileSize();
    }

    public static void dumpConnections() {
        System.out.println("UltraPeer connections");
        RouterService.dumpConnections((Collection)manager.getInitializedConnections());
        System.out.println("Leaf connections");
        RouterService.dumpConnections((Collection)manager.getInitializedClientConnections());
    }

    private static void dumpConnections(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().toString());
        }
    }

    public static void updateHorizon() {
        HorizonCounter.instance().refresh();
    }

    public static byte[] newQueryGUID() {
        if (RouterService.isOOBCapable() && OutOfBandThroughputStat.isOOBEffectiveForMe()) {
            return GUID.makeAddressEncodedGuid(RouterService.getAddress(), RouterService.getPort());
        }
        return GUID.makeGuid();
    }

    public static void query(byte[] byArray, String string, MediaType mediaType) {
        RouterService.query(byArray, string, "", mediaType);
    }

    public static void query(byte[] byArray, String string) {
        RouterService.query(byArray, string, null);
    }

    public static void query(byte[] byArray, String string, String string2, MediaType mediaType) {
        try {
            QueryRequest queryRequest = null;
            if (RouterService.isIpPortValid() && new GUID(byArray).addressesMatch(RouterService.getAddress(), RouterService.getPort())) {
                queryRequest = QueryRequest.createOutOfBandQuery(byArray, string, string2, mediaType);
                OutOfBandThroughputStat.OOB_QUERIES_SENT.incrementStat();
            } else {
                queryRequest = QueryRequest.createQuery(byArray, string, string2, mediaType);
            }
            RouterService.recordAndSendQuery(queryRequest, mediaType);
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
        }
    }

    public static void queryWhatIsNew(byte[] byArray, MediaType mediaType) {
        try {
            QueryRequest queryRequest = null;
            if (new GUID(byArray).addressesMatch(RouterService.getAddress(), RouterService.getPort())) {
                queryRequest = QueryRequest.createWhatIsNewOOBQuery(byArray, (byte)2, mediaType);
                OutOfBandThroughputStat.OOB_QUERIES_SENT.incrementStat();
            } else {
                queryRequest = QueryRequest.createWhatIsNewQuery(byArray, (byte)2, mediaType);
            }
            if (FilterSettings.FILTER_WHATS_NEW_ADULT.getValue()) {
                MutableGUIDFilter.instance().addGUID(byArray);
            }
            RouterService.recordAndSendQuery(queryRequest, mediaType);
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
        }
    }

    private static void recordAndSendQuery(QueryRequest queryRequest, MediaType mediaType) {
        _lastQueryTime = System.currentTimeMillis();
        verifier.record(queryRequest, mediaType);
        RESULT_HANDLER.addQuery(queryRequest);
        router.sendDynamicQuery(queryRequest);
    }

    public static long getLastQueryTime() {
        return _lastQueryTime;
    }

    public static void stopQuery(GUID gUID) {
        QueryUnicaster.instance().purgeQuery(gUID);
        RESULT_HANDLER.removeQuery(gUID);
        router.queryKilled(gUID);
        if (RouterService.isSupernode()) {
            QueryDispatcher.instance().addToRemove(gUID);
        }
        MutableGUIDFilter.instance().removeGUID(gUID.bytes());
    }

    public static boolean matchesType(byte[] byArray, Response response) {
        return verifier.matchesType(byArray, response);
    }

    public static boolean isMandragoreWorm(byte[] byArray, Response response) {
        return verifier.isMandragoreWorm(byArray, response);
    }

    public static Collection getPreferencedHosts(boolean bl, String string, int n) {
        TreeSet treeSet = new TreeSet(IpPort.COMPARATOR);
        if (bl) {
            treeSet.addAll(catcher.getUltrapeersWithFreeUltrapeerSlots(string, n));
        } else {
            treeSet.addAll(catcher.getUltrapeersWithFreeLeafSlots(string, n));
        }
        if (treeSet.size() < n) {
            List list = manager.getInitializedConnectionsMatchLocale(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && treeSet.size() < n) {
                treeSet.add(iterator.next());
            }
            if (treeSet.size() < n) {
                list = manager.getInitializedConnections();
                iterator = list.iterator();
                while (iterator.hasNext() && treeSet.size() < n) {
                    treeSet.add(iterator.next());
                }
            }
        }
        return treeSet;
    }

    public static int getNumConnections() {
        return manager.getNumConnections();
    }

    public static int getNumInitializedConnections() {
        return manager.getNumInitializedConnections();
    }

    public static int getNumUltrapeerToLeafConnections() {
        return manager.getNumInitializedClientConnections();
    }

    public static int getNumLeafToUltrapeerConnections() {
        return manager.getNumClientSupernodeConnections();
    }

    public static int getNumUltrapeerToUltrapeerConnections() {
        return manager.getNumUltrapeerConnections();
    }

    public static int getNumOldConnections() {
        return manager.getNumOldConnections();
    }

    public static boolean isFullyConnected() {
        return manager.isFullyConnected();
    }

    public static boolean isConnected() {
        return manager.isConnected();
    }

    public static boolean isConnecting() {
        return manager.isConnecting();
    }

    public static boolean isFetchingEndpoints() {
        return BootstrapServerManager.instance().isEndpointFetchInProgress();
    }

    public static int getNumSharedFiles() {
        return fileManager.getNumFiles();
    }

    public static int getNumPendingShared() {
        return fileManager.getNumPendingFiles();
    }

    public static int getSharedFileSize() {
        return fileManager.getSize();
    }

    public static FileDesc[] getIncompleteFileDescriptors() {
        return fileManager.getIncompleteFileDescriptors();
    }

    public static FileDesc[] getSharedFileDescriptors(File file) {
        if (file == null) {
            return fileManager.getAllSharedFileDescriptors();
        }
        return fileManager.getSharedFileDescriptors(file);
    }

    public static Downloader download(RemoteFileDesc[] remoteFileDescArray, List list, boolean bl, GUID gUID) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        return downloader.download(remoteFileDescArray, list, bl, gUID);
    }

    public static Downloader download(RemoteFileDesc[] remoteFileDescArray, boolean bl, GUID gUID) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        return RouterService.download(remoteFileDescArray, DataUtils.EMPTY_LIST, bl, gUID);
    }

    public static Downloader download(File file) throws AlreadyDownloadingException, CantResumeException {
        return downloader.download(file);
    }

    public static Downloader download(String string, String string2, byte[] byArray, MediaType mediaType) throws AlreadyDownloadingException {
        return downloader.download(string, string2, byArray, mediaType);
    }

    public static BrowseHostHandler doAsynchronousBrowseHost(final String string, final int n, GUID gUID, GUID gUID2, final Set set) {
        final BrowseHostHandler browseHostHandler = new BrowseHostHandler(callback, gUID, gUID2);
        ManagedThread managedThread = new ManagedThread(new Runnable(){

            public void run() {
                try {
                    browseHostHandler.browseHost(string, n, set);
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable);
                }
            }
        }, "BrowseHoster");
        managedThread.setDaemon(true);
        managedThread.start();
        return browseHostHandler;
    }

    public static boolean isSupernode() {
        return manager.isSupernode();
    }

    public static boolean isShieldedLeaf() {
        return manager.isShieldedLeaf();
    }

    public static int getNumFreeLeafSlots() {
        return manager.getNumFreeLeafSlots();
    }

    public static int getNumFreeNonLeafSlots() {
        return manager.getNumFreeNonLeafSlots();
    }

    public static int getNumFreeLimeWireLeafSlots() {
        return manager.getNumFreeLimeWireLeafSlots();
    }

    public static int getNumFreeLimeWireNonLeafSlots() {
        return manager.getNumFreeLimeWireNonLeafSlots();
    }

    public static void setIsShuttingDown(boolean bl) {
        isShuttingDown = bl;
    }

    public static boolean getIsShuttingDown() {
        return isShuttingDown;
    }

    public static boolean addressChanged() {
        byte[] byArray = RouterService.getAddress();
        if (!NetworkUtils.isValidAddress(byArray)) {
            return false;
        }
        if (NetworkUtils.isPrivateAddress(byArray)) {
            return false;
        }
        if (!NetworkUtils.isValidPort(RouterService.getPort())) {
            return false;
        }
        FileDesc[] fileDescArray = fileManager.getAllSharedFileDescriptors();
        for (int i = 0; i < fileDescArray.length; ++i) {
            fileDescArray[i].addUrnsForSelf();
        }
        acceptor.resetLastConnectBackTime();
        udpService.resetLastConnectBackTime();
        return true;
    }

    public static byte[] getExternalAddress() {
        return acceptor.getExternalAddress();
    }

    public static byte[] getAddress() {
        return acceptor.getAddress(true);
    }

    public static byte[] getNonForcedAddress() {
        return acceptor.getAddress(false);
    }

    public static int getPort() {
        return acceptor.getPort(true);
    }

    public static int getNonForcedPort() {
        return acceptor.getPort(false);
    }

    public static boolean isGUESSCapable() {
        return udpService.isGUESSCapable();
    }

    public static boolean isOOBCapable() {
        return RouterService.isGUESSCapable() && OutOfBandThroughputStat.isSuccessRateGood() && !NetworkUtils.isPrivate() && SearchSettings.OOB_ENABLED.getValue() && acceptor.isAddressExternal() && RouterService.isIpPortValid();
    }

    public static GUID getUDPConnectBackGUID() {
        return udpService.getConnectBackGUID();
    }

    public static boolean isIpPortValid() {
        return NetworkUtils.isValidAddress(RouterService.getAddress()) && NetworkUtils.isValidPort(RouterService.getPort());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _lastQueryTime = 0L;
        _fullPower = true;
    }
}

