/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.bootstrap.BootstrapServer;
import com.limegroup.gnutella.bootstrap.DefaultBootstrapServers;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Random12;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.ParseException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BootstrapServerManager {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$bootstrap$BootstrapServerManager == null ? (class$com$limegroup$gnutella$bootstrap$BootstrapServerManager = BootstrapServerManager.class$("com.limegroup.gnutella.bootstrap.BootstrapServerManager")) : class$com$limegroup$gnutella$bootstrap$BootstrapServerManager));
    private static final BootstrapServerManager INSTANCE = new BootstrapServerManager();
    public static final int CACHE_OFF = 0;
    public static final int FETCH_SCHEDULED = 1;
    public static final int FETCH_IN_PROGRESS = 2;
    public static final int FETCHED_TOO_MANY = 3;
    public static final int NO_CACHES_LEFT = 4;
    private static final int MAX_RESPONSES = 50;
    private static final int MAX_CACHES = 5;
    private static final int ENDPOINTS_TO_ADD = 10;
    private static final int MAX_BOOTSTRAP_SERVERS = 1000;
    public static int MAX_HOSTS_PER_REQUEST = 20;
    public static int UPDATE_DELAY_MSEC = 3600000;
    private final List SERVERS = new ArrayList();
    private BootstrapServer _lastConnectable;
    private Random12 _rand = new Random12();
    private volatile boolean _hostFetchInProgress = false;
    private volatile int _lastIndex = 0;
    private volatile int _responsesAdded = 0;
    static /* synthetic */ Class class$com$limegroup$gnutella$bootstrap$BootstrapServerManager;

    public static BootstrapServerManager instance() {
        return INSTANCE;
    }

    protected BootstrapServerManager() {
    }

    public synchronized void addBootstrapServer(BootstrapServer bootstrapServer) {
        if (bootstrapServer == null) {
            throw new NullPointerException("null bootstrap server not allowed");
        }
        if (!this.SERVERS.contains((Object)bootstrapServer)) {
            this.SERVERS.add((Object)bootstrapServer);
        }
        if (this.SERVERS.size() > 1000) {
            this.removeServer((BootstrapServer)this.SERVERS.get(0));
        }
    }

    public synchronized void bootstrapServersAdded() {
        this.addDefaultsIfNeeded();
        Collections.shuffle((List)this.SERVERS);
    }

    public synchronized void resetData() {
        this._lastIndex = 0;
        this._responsesAdded = 0;
        Collections.shuffle((List)this.SERVERS);
    }

    public boolean isEndpointFetchInProgress() {
        return this._hostFetchInProgress;
    }

    public synchronized Iterator getBootstrapServers() {
        return this.SERVERS.iterator();
    }

    public synchronized void fetchBootstrapServersAsync() {
        if (!ConnectionSettings.USE_GWEBCACHE.getValue()) {
            return;
        }
        this.addDefaultsIfNeeded();
        this.requestAsync(new UrlfileRequest(), "GWebCache urlfile");
    }

    public synchronized int fetchEndpointsAsync() {
        if (!ConnectionSettings.USE_GWEBCACHE.getValue()) {
            return 0;
        }
        this.addDefaultsIfNeeded();
        if (!this._hostFetchInProgress) {
            if (this._responsesAdded >= 50 && this._lastIndex >= 5) {
                return 3;
            }
            if (this._lastIndex >= this.size()) {
                return 4;
            }
            this._hostFetchInProgress = true;
            this.requestAsync(new HostfileRequest(), "GWebCache hostfile");
            return 1;
        }
        return 2;
    }

    public synchronized void sendUpdatesAsync(Endpoint endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("cannot accept null update IP");
        }
        this.addDefaultsIfNeeded();
        try {
            if (!NetworkUtils.isPrivateAddress(endpoint.getHostBytes())) {
                this.requestAsync(new UpdateRequest(endpoint), "GWebCache update");
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private void addDefaultsIfNeeded() {
        if (this.SERVERS.size() > 0) {
            return;
        }
        DefaultBootstrapServers.addDefaults(this);
        Collections.shuffle((List)this.SERVERS);
    }

    private void requestAsync(final GWebCacheRequest gWebCacheRequest, String string) {
        if (gWebCacheRequest == null) {
            throw new NullPointerException("asynchronous request to null cache");
        }
        ManagedThread managedThread = new ManagedThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void managedRun() {
                try {
                    BootstrapServerManager.this.requestBlocking(gWebCacheRequest);
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable);
                }
                finally {
                    gWebCacheRequest.done();
                }
            }
        };
        managedThread.setName(string);
        managedThread.setDaemon(true);
        managedThread.start();
    }

    private void requestBlocking(GWebCacheRequest gWebCacheRequest) {
        BootstrapServer bootstrapServer;
        if (gWebCacheRequest == null) {
            throw new NullPointerException("blocking request to null cache");
        }
        for (int i = 0; gWebCacheRequest.needsMoreData() && i < MAX_HOSTS_PER_REQUEST && (bootstrapServer = gWebCacheRequest.nextServer()) != null; ++i) {
            this.requestFromOneHost(gWebCacheRequest, bootstrapServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFromOneHost(GWebCacheRequest gWebCacheRequest, BootstrapServer bootstrapServer) {
        GetMethod getMethod;
        if (gWebCacheRequest == null) {
            throw new NullPointerException("null cache in request to one host");
        }
        if (bootstrapServer == null) {
            throw new NullPointerException("null server in request to one host");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("requesting: " + gWebCacheRequest + " from " + bootstrapServer));
        }
        BufferedReader bufferedReader = null;
        String string = bootstrapServer.getURLString();
        String string2 = string + "?client=" + "LIME" + "&version=" + URLEncoder.encode(CommonUtils.getLimeWireVersion()) + "&" + gWebCacheRequest.parameters();
        if (string.indexOf(".limewire.com/") > -1) {
            string2 = string2 + "&clientGUID=" + ApplicationSettings.CLIENT_ID.getValue();
        }
        try {
            getMethod = new GetMethod(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn((Object)"Invalid server", (Throwable)illegalArgumentException);
            gWebCacheRequest.handleError(bootstrapServer);
            return;
        }
        getMethod.addRequestHeader("Cache-Control", "no-cache");
        getMethod.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
        getMethod.addRequestHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        getMethod.setFollowRedirects(false);
        HttpClient httpClient = HttpClientManager.getNewClient(30000, 10000);
        try {
            String string3;
            HttpClientManager.executeMethodRedirecting(httpClient, (HttpMethod)getMethod);
            InputStream inputStream = getMethod.getResponseBodyAsStream();
            if (inputStream == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Invalid server: " + bootstrapServer));
                }
                gWebCacheRequest.handleError(bootstrapServer);
                return;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            if (getMethod.getStatusCode() < 200 || getMethod.getStatusCode() >= 300) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Invalid status code: " + getMethod.getStatusCode()));
                }
                throw new IOException("no 2XX ok.");
            }
            boolean bl = true;
            boolean bl2 = false;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (bl && StringUtils.startsWithIgnoreCase(string3, "ERROR")) {
                    gWebCacheRequest.handleError(bootstrapServer);
                    bl2 = true;
                } else {
                    boolean bl3 = gWebCacheRequest.handleResponseData(bootstrapServer, string3);
                    if (!bl2) {
                        bl2 = !bl3;
                    }
                }
                bl = false;
            }
            if (!bl2) {
                this._lastConnectable = bootstrapServer;
            }
        }
        catch (IOException iOException) {
            LOG.warn((Object)"Exception while handling server", (Throwable)iOException);
            gWebCacheRequest.handleError(bootstrapServer);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
                getMethod.abort();
            }
        }
    }

    protected synchronized int size() {
        return this.SERVERS.size();
    }

    protected int randomServer() {
        return this._rand.nextInt(this.SERVERS.size());
    }

    protected synchronized void removeServer(BootstrapServer bootstrapServer) {
        this.SERVERS.remove((Object)bootstrapServer);
        this._lastIndex = Math.max(0, this._lastIndex - 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class UpdateRequest
    extends GWebCacheRequest {
        private boolean gotResponse = false;
        private Endpoint myIP;

        protected UpdateRequest(Endpoint endpoint) {
            this.myIP = endpoint;
        }

        protected String parameters() {
            String string = null;
            if (BootstrapServerManager.this._lastConnectable != null) {
                string = "url=" + URLEncoder.encode(BootstrapServerManager.this._lastConnectable.getURLString());
            }
            String string2 = null;
            if (this.myIP != null) {
                string2 = "ip=" + this.myIP.getAddress() + ":" + this.myIP.getPort();
            }
            if (string == null && string2 == null) {
                return "";
            }
            if (string != null && string2 == null) {
                return string;
            }
            if (string == null && string2 != null) {
                return string2;
            }
            Assert.that(string != null && string2 != null);
            return string2 + "&" + string;
        }

        protected boolean handleResponseData(BootstrapServer bootstrapServer, String string) {
            if (StringUtils.startsWithIgnoreCase(string, "OK")) {
                this.gotResponse = true;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return !this.gotResponse;
        }

        protected BootstrapServer nextServer() {
            if (BootstrapServerManager.this.SERVERS.size() == 0) {
                return null;
            }
            return (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this.randomServer());
        }

        public String toString() {
            return "update request";
        }
    }

    private final class UrlfileRequest
    extends GWebCacheRequest {
        private int responses = 0;

        private UrlfileRequest() {
        }

        protected String parameters() {
            return "urlfile=1";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean handleResponseData(BootstrapServer bootstrapServer, String string) {
            try {
                BootstrapServer bootstrapServer2 = new BootstrapServer(string);
                BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
                synchronized (bootstrapServerManager) {
                    BootstrapServerManager.this.addBootstrapServer(bootstrapServer2);
                }
                ++this.responses;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Added bootstrap host: " + bootstrapServer2));
                }
                ConnectionSettings.LAST_GWEBCACHE_FETCH_TIME.setValue(System.currentTimeMillis());
            }
            catch (ParseException parseException) {
                this.handleError(bootstrapServer);
                return false;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return this.responses < 10;
        }

        protected BootstrapServer nextServer() {
            if (BootstrapServerManager.this.SERVERS.size() == 0) {
                return null;
            }
            return (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this.randomServer());
        }

        public String toString() {
            return "urlfile request";
        }
    }

    private final class HostfileRequest
    extends GWebCacheRequest {
        private int responses = 0;

        private HostfileRequest() {
        }

        protected String parameters() {
            return "hostfile=1";
        }

        protected boolean handleResponseData(BootstrapServer bootstrapServer, String string) {
            try {
                Endpoint endpoint = new Endpoint(string, true);
                RouterService.getHostCatcher().add(endpoint, 2);
                ++this.responses;
                BootstrapServerManager.this._responsesAdded++;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleError(bootstrapServer);
                return false;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return this.responses < 10;
        }

        protected void done() {
            BootstrapServerManager.this._hostFetchInProgress = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected BootstrapServer nextServer() {
            BootstrapServer bootstrapServer = null;
            HostfileRequest hostfileRequest = this;
            synchronized (hostfileRequest) {
                if (BootstrapServerManager.this._lastIndex >= BootstrapServerManager.this.SERVERS.size()) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Used up all servers, last: " + BootstrapServerManager.this._lastIndex));
                    }
                } else {
                    bootstrapServer = (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this._lastIndex);
                    BootstrapServerManager.this._lastIndex++;
                }
            }
            return bootstrapServer;
        }

        public String toString() {
            return "hostfile request";
        }
    }

    private abstract class GWebCacheRequest {
        private GWebCacheRequest() {
        }

        protected abstract String parameters();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleError(BootstrapServer bootstrapServer) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Error on server: " + bootstrapServer));
            }
            BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
            synchronized (bootstrapServerManager) {
                BootstrapServerManager.this.removeServer(bootstrapServer);
                if (BootstrapServerManager.this._lastConnectable == bootstrapServer) {
                    BootstrapServerManager.this._lastConnectable = null;
                }
            }
        }

        protected abstract boolean handleResponseData(BootstrapServer var1, String var2);

        protected abstract boolean needsMoreData();

        protected abstract BootstrapServer nextServer();

        protected void done() {
        }
    }
}

