/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.dime.DIMEMessageException;
import com.limegroup.gnutella.util.DataUtils;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DIMERecord {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$dime$DIMERecord == null ? (class$com$limegroup$gnutella$dime$DIMERecord = DIMERecord.class$("com.limegroup.gnutella.dime.DIMERecord")) : class$com$limegroup$gnutella$dime$DIMERecord));
    public static final byte VERSION = 8;
    private static final byte VERSION_MASK = -8;
    private static final byte MB_MASK = 4;
    private static final byte ME_MASK = 2;
    private static final byte CF_MASK = 1;
    private byte _byte1;
    public static final byte TYPE_UNCHANGED = 0;
    public static final byte TYPE_MEDIA_TYPE = 16;
    public static final byte TYPE_ABSOLUTE_URI = 32;
    public static final byte TYPE_UNKNOWN = 48;
    public static final byte TYPE_NONE = 64;
    private static final byte TYPE_MASK = -16;
    private static final byte RESERVED = 0;
    private static final byte RESERVED_MASK = 15;
    private final byte _byte2;
    private final byte[] _options;
    private final byte[] _id;
    private final byte[] _type;
    private final byte[] _data;
    private String _idString = null;
    private Map _optionsMap = null;
    static /* synthetic */ Class class$com$limegroup$gnutella$dime$DIMERecord;

    public DIMERecord(byte by, byte by2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this._byte1 = by;
        this._byte2 = by2;
        if (byArray == null) {
            byArray = DataUtils.EMPTY_BYTE_ARRAY;
        }
        if (byArray2 == null) {
            byArray2 = DataUtils.EMPTY_BYTE_ARRAY;
        }
        if (byArray3 == null) {
            byArray3 = DataUtils.EMPTY_BYTE_ARRAY;
        }
        if (byArray4 == null) {
            byArray4 = DataUtils.EMPTY_BYTE_ARRAY;
        }
        this._options = byArray;
        this._id = byArray2;
        this._type = byArray3;
        this._data = byArray4;
        this.validate();
    }

    public DIMERecord(byte by, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this(8, (byte)(by | 0), byArray, byArray2, byArray3, byArray4);
    }

    public static DIMERecord createFromStream(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[12];
        DIMERecord.fillBuffer(byArray, inputStream);
        try {
            DIMERecord.validateFirstBytes(byArray[0], byArray[1]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
        int n = ByteOrder.beb2int(byArray, 2, 2);
        int n2 = ByteOrder.beb2int(byArray, 4, 2);
        int n3 = ByteOrder.beb2int(byArray, 6, 2);
        int n4 = ByteOrder.beb2int(byArray, 8, 4);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating dime record.  optionsLength: " + n + ", idLength: " + n2 + ", typeLength: " + n3 + ", dataLength: " + n4));
        }
        if (n4 < 0) {
            throw new IOException("data too big.");
        }
        byte[] byArray2 = DIMERecord.readInformation(n, inputStream);
        byte[] byArray3 = DIMERecord.readInformation(n2, inputStream);
        byte[] byArray4 = DIMERecord.readInformation(n3, inputStream);
        byte[] byArray5 = DIMERecord.readInformation(n4, inputStream);
        try {
            return new DIMERecord(byArray[0], byArray[1], byArray2, byArray3, byArray4, byArray5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
    }

    public int getRecordLength() {
        return 12 + this.getOptionsLength() + DIMERecord.calculatePaddingLength(this.getOptionsLength()) + this.getIdLength() + DIMERecord.calculatePaddingLength(this.getIdLength()) + this.getTypeLength() + DIMERecord.calculatePaddingLength(this.getTypeLength()) + this.getDataLength() + DIMERecord.calculatePaddingLength(this.getDataLength());
    }

    void write(OutputStream outputStream) throws IOException {
        outputStream.write(this._byte1);
        outputStream.write(this._byte2);
        ByteOrder.int2beb(this.getOptionsLength(), outputStream, 2);
        ByteOrder.int2beb(this.getIdLength(), outputStream, 2);
        ByteOrder.int2beb(this.getTypeLength(), outputStream, 2);
        ByteOrder.int2beb(this.getDataLength(), outputStream, 4);
        this.writeOptions(outputStream);
        this.writeId(outputStream);
        this.writeType(outputStream);
        this.writeData(outputStream);
    }

    public void writeOptions(OutputStream outputStream) throws IOException {
        DIMERecord.writeDataWithPadding(this._options, outputStream);
    }

    public void writeId(OutputStream outputStream) throws IOException {
        DIMERecord.writeDataWithPadding(this._id, outputStream);
    }

    public void writeType(OutputStream outputStream) throws IOException {
        DIMERecord.writeDataWithPadding(this._type, outputStream);
    }

    public void writeData(OutputStream outputStream) throws IOException {
        DIMERecord.writeDataWithPadding(this._data, outputStream);
    }

    public void setFirstRecord(boolean bl) {
        this._byte1 = bl ? (byte)(this._byte1 | 4) : (byte)(this._byte1 & 0xFFFFFFFB);
    }

    public boolean isFirstRecord() {
        return (this._byte1 & 4) == 4;
    }

    public void setLastRecord(boolean bl) {
        this._byte1 = bl ? (byte)(this._byte1 | 2) : (byte)(this._byte1 & 0xFFFFFFFD);
    }

    public boolean isLastRecord() {
        return (this._byte1 & 2) == 2;
    }

    public int getTypeId() {
        return this._byte2 & 0xFFFFFFF0;
    }

    public int getTypeLength() {
        return this._type.length;
    }

    public byte[] getType() {
        return this._type;
    }

    public String getTypeString() {
        try {
            return new String(this.getType(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
            return null;
        }
    }

    public int getDataLength() {
        return this._data.length;
    }

    public byte[] getData() {
        return this._data;
    }

    public int getIdLength() {
        return this._id.length;
    }

    public byte[] getId() {
        return this._id;
    }

    public int getOptionsLength() {
        return this._options.length;
    }

    public byte[] getOptions() {
        return this._options;
    }

    public String getIdentifier() {
        if (this._idString == null) {
            this._idString = new String(this.getId());
        }
        return this._idString;
    }

    public Map getOptionsMap() throws DIMEMessageException {
        if (this._optionsMap == null) {
            this._optionsMap = DIMERecord.parseOptions(this.getOptions());
        }
        return this._optionsMap;
    }

    public static void writePadding(int n, OutputStream outputStream) throws IOException {
        int n2 = DIMERecord.calculatePaddingLength(n);
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                outputStream.write(DataUtils.BYTE_ARRAY_ONE);
                return;
            }
            case 2: {
                outputStream.write(DataUtils.BYTE_ARRAY_TWO);
                return;
            }
            case 3: {
                outputStream.write(DataUtils.BYTE_ARRAY_THREE);
                return;
            }
        }
        throw new IllegalStateException("invalid padding.");
    }

    private static void validateFirstBytes(byte by, byte by2) {
        if ((by & 0xFFFFFFF8) != 8) {
            throw new IllegalArgumentException("invalid version: " + ((by & 0xFFFFFFF8) >> 3 & 0x1F));
        }
        if ((by2 & 0xF) != 0) {
            throw new IllegalArgumentException("invalid reserved: " + (by2 & 0xF));
        }
    }

    private void validate() {
        DIMERecord.validateFirstBytes(this._byte1, this._byte2);
        byte by = (byte)(this._byte2 & 0xFFFFFFF0);
        switch (by) {
            case 0: {
                if (this.getTypeLength() == 0) break;
                throw new IllegalArgumentException("TYPE_UNCHANGED requires 0 type length");
            }
            case 16: {
                break;
            }
            case 32: {
                break;
            }
            case 48: {
                if (this.getTypeLength() == 0) break;
                throw new IllegalArgumentException("TYPE_UNKNOWN requires 0 type length");
            }
            case 64: {
                if (this.getTypeLength() == 0 && this.getDataLength() == 0) break;
                throw new IllegalArgumentException("TYPE_NONE requires 0 type & data length");
            }
            default: {
                throw new IllegalArgumentException("invalid type: " + (by >> 4 & 0xF));
            }
        }
    }

    private static byte[] readInformation(int n, InputStream inputStream) throws IOException {
        if (n == 0) {
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n];
        DIMERecord.fillBuffer(byArray, inputStream);
        DIMERecord.skipPaddedData(n, inputStream);
        return byArray;
    }

    private static void writeDataWithPadding(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray.length == 0) {
            return;
        }
        outputStream.write(byArray);
        DIMERecord.writePadding(byArray.length, outputStream);
    }

    private static int calculatePaddingLength(int n) {
        return n % 4 == 0 ? 0 : 4 - n % 4;
    }

    private static void skipPaddedData(int n, InputStream inputStream) throws IOException {
        long l;
        int n2 = DIMERecord.calculatePaddingLength(n);
        for (long i = 0L; i < (long)n2; i += l) {
            l = inputStream.skip((long)n2 - i);
            if (l != -1L && l != 0L) continue;
            throw new IOException("eof");
        }
    }

    private static void fillBuffer(byte[] byArray, InputStream inputStream) throws IOException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = inputStream.read(byArray, i, byArray.length - i);
            if (n != -1) continue;
            throw new IOException("eof");
        }
    }

    private static Map parseOptions(byte[] byArray) throws DIMEMessageException {
        int n;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < byArray.length; i += n) {
            String string;
            String string2;
            if (byArray.length - i < 4) {
                throw new DIMEMessageException("illegal options field");
            }
            byte[] byArray2 = new byte[2];
            System.arraycopy(byArray, i, byArray2, 0, 2);
            try {
                string2 = new String(byArray2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = null;
            }
            n = ByteOrder.beb2int(byArray, i += 2, 2);
            if (byArray.length - (i += 2) < n) {
                throw new DIMEMessageException("illegal options field");
            }
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, i, byArray3, 0, n);
            try {
                string = new String(byArray3, "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = null;
            }
            if (string2 == null || string == null) continue;
            hashMap.put((Object)string2, (Object)string);
        }
        return hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

