/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.DownloadBrowseHostList;
import com.limegroup.gnutella.downloader.DownloadChatList;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.HeadRequester;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.MiniRemoteFileDesc;
import com.limegroup.gnutella.downloader.NoSuchRangeException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.RemoteFileDescGrouper;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.URLRemoteFileDesc;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedDownloader
implements Downloader,
Serializable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$downloader$ManagedDownloader == null ? (class$com$limegroup$gnutella$downloader$ManagedDownloader = ManagedDownloader.class$("com.limegroup.gnutella.downloader.ManagedDownloader")) : class$com$limegroup$gnutella$downloader$ManagedDownloader));
    static final long serialVersionUID = 2772570805975885257L;
    private Object stealLock;
    private DownloadManager manager;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager;
    private ActivityCallback callback;
    private RemoteFileDesc[] allFiles;
    private static final int NORMAL_CONNECT_TIME = 10000;
    private static final int PUSH_CONNECT_TIME = 16000;
    private static final int MIN_SPLIT_SIZE = 100000;
    private static final int CHUNK_SIZE = 100000;
    private static final float MIN_ACCEPTABLE_SPEED = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue() < 8 ? 0.1f : 0.5f;
    static final int OVERLAP_BYTES = 10;
    private static final int MAX_CORRUPTION_RECOVERY_ATTEMPTS = 5;
    static int TIME_BETWEEN_REQUERIES = 300000;
    private static final int REQUERY_ATTEMPTS = 1;
    private static final int MATCHER_BUF_SIZE = 120;
    private static final int NO_RANGES_RETRY_AFTER = 300;
    private static final int FAILED_RETRY_AFTER = 60;
    private static final int RETRY_AFTER_NONE_ACTIVE = 60;
    private static final int RETRY_AFTER_SOME_ACTIVE = 600;
    protected static final String UNKNOWN_FILENAME = "";
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private RemoteFileDescGrouper buckets;
    private List currentRFDs;
    private int bucketNumber;
    private Thread dloaderManagerThread;
    private boolean stopped;
    private List dloaders;
    private List threads;
    private Map queuedThreads;
    private List files;
    private AlternateLocationCollection validAlts;
    private Set invalidAlts;
    private Set recentInvalidAlts;
    private VerifyingFile commonOutFile;
    private Map miniRFDToLock;
    private Map threadLockToSocket;
    private int state;
    private long stateTime;
    private int retriesWaiting;
    private File incompleteFile;
    private File completeFile;
    private String queuePosition;
    private String queuedVendor;
    private String currentLocation;
    private volatile int corruptFileBytes;
    private volatile File corruptFile;
    private RequeryLock reqLock = new RequeryLock();
    private DownloadChatList chatList;
    private DownloadBrowseHostList browseList;
    private static final int NOT_CORRUPT_STATE = 0;
    private static final int CORRUPT_WAITING_STATE = 1;
    private static final int CORRUPT_STOP_STATE = 2;
    private static final int CORRUPT_CONTINUE_STATE = 3;
    private int corruptState;
    private Object corruptStateLock;
    private Object altLock;
    private HashTree hashTree = null;
    private static final BandwidthTrackerImpl BANDWIDTH_TRACKER_IMPL = new BandwidthTrackerImpl();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    static final boolean RECORD_STATS = !CommonUtils.isJava118();
    private final GUID originalQueryGUID;
    private static final List TRIVIAL_WORDS = new ArrayList(3);
    private boolean initDone;
    private final long SIXTY_KB = 60000L;
    private static final int MIN_NUM_CONNECTIONS = 2;
    private static final int MIN_CONNECTION_MESSAGES = 6;
    private static final int MIN_TOTAL_MESSAGES = 45;
    private static final int CONNECTION_DELAY = 500;
    static boolean NO_DELAY = false;
    private boolean canceled;
    static /* synthetic */ Class class$com$limegroup$gnutella$downloader$ManagedDownloader;

    public ManagedDownloader(RemoteFileDesc[] remoteFileDescArray, IncompleteFileManager incompleteFileManager, GUID gUID) {
        TRIVIAL_WORDS.add((Object)"the");
        TRIVIAL_WORDS.add((Object)"an");
        TRIVIAL_WORDS.add((Object)"a");
        this.initDone = false;
        this.SIXTY_KB = 60000L;
        this.canceled = false;
        if (remoteFileDescArray == null) {
            throw new NullPointerException("null RFDS");
        }
        if (incompleteFileManager == null) {
            throw new NullPointerException("null incomplete file manager");
        }
        this.allFiles = remoteFileDescArray;
        this.incompleteFileManager = incompleteFileManager;
        this.originalQueryGUID = gUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.allFiles);
        IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
        synchronized (incompleteFileManager) {
            objectOutputStream.writeObject(this.incompleteFileManager);
        }
        objectOutputStream.writeObject(BANDWIDTH_TRACKER_IMPL);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.allFiles = (RemoteFileDesc[])objectInputStream.readObject();
        this.incompleteFileManager = (IncompleteFileManager)objectInputStream.readObject();
        objectInputStream.readObject();
        this.reqLock = new RequeryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DownloadManager downloadManager, FileManager fileManager, ActivityCallback activityCallback, final boolean bl) {
        this.manager = downloadManager;
        this.fileManager = fileManager;
        this.callback = activityCallback;
        this.dloaders = new LinkedList();
        this.threads = new ArrayList();
        this.queuedThreads = new HashMap();
        this.chatList = new DownloadChatList();
        this.browseList = new DownloadBrowseHostList();
        this.stealLock = new Object();
        this.stopped = false;
        this.setState(0);
        this.miniRFDToLock = Collections.synchronizedMap((Map)new HashMap());
        this.threadLockToSocket = Collections.synchronizedMap((Map)new HashMap());
        this.corruptState = 0;
        this.corruptStateLock = new Object();
        this.altLock = new Object();
        this.numMeasures = 0;
        this.averageBandwidth = 0.0f;
        this.invalidAlts = new FixedSizeExpiringSet(1000, 3600000L);
        this.recentInvalidAlts = new FixedSizeExpiringSet(10, 600000L);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.buckets = new RemoteFileDescGrouper(this.allFiles, this.incompleteFileManager);
            if (this.shouldInitAltLocs(bl)) {
                this.initializeAlternateLocations();
            }
        }
        this.dloaderManagerThread = new ManagedThread("ManagedDownload"){

            public void managedRun() {
                try {
                    ManagedDownloader.this.tryAllDownloads(bl);
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable);
                }
            }
        };
        this.dloaderManagerThread.setDaemon(true);
        this.dloaderManagerThread.start();
    }

    protected void initializeIncompleteFile(File file) {
        if (this.incompleteFile != null) {
            return;
        }
        this.incompleteFile = file;
        this.commonOutFile = this.incompleteFileManager.getEntry(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeAlternateLocations() {
        if (this.incompleteFile == null) {
            return;
        }
        URN uRN = this.incompleteFileManager.getCompletedHash(this.incompleteFile);
        if (uRN != null) {
            long l = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            FileDesc fileDesc = this.fileManager.getFileDescForUrn(uRN);
            if (fileDesc != null) {
                AlternateLocationCollection alternateLocationCollection;
                this.validAlts = AlternateLocationCollection.create(uRN);
                AlternateLocationCollection alternateLocationCollection2 = alternateLocationCollection = fileDesc.getAlternateLocationCollection();
                synchronized (alternateLocationCollection2) {
                    Iterator iterator = alternateLocationCollection.iterator();
                    while (iterator.hasNext()) {
                        AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                        this.addDownload(alternateLocation.createRemoteFileDesc((int)l), false);
                    }
                }
            }
        }
    }

    public boolean conflicts(RemoteFileDesc remoteFileDesc) {
        try {
            File file = this.incompleteFileManager.getFile(remoteFileDesc);
            return this.conflicts(file);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conflicts(File file) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                RemoteFileDesc remoteFileDesc = this.allFiles[i];
                try {
                    File file2 = this.incompleteFileManager.getFile(remoteFileDesc);
                    if (!file2.equals(file)) continue;
                    return true;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean conflicts(URN uRN) {
        Assert.that(uRN != null, "attempting to check conflicts with null urn");
        File file = this.incompleteFileManager.getFileForUrn(uRN);
        if (file == null) {
            return false;
        }
        return this.conflicts(file);
    }

    protected synchronized QueryRequest newRequery(int n) throws CantResumeException {
        if (this.allFiles.length < 0) {
            throw new CantResumeException(UNKNOWN_FILENAME);
        }
        if (this.allFiles[0].getSHA1Urn() == null) {
            return QueryRequest.createQuery(this.extractQueryString());
        }
        return QueryRequest.createQuery(this.extractQueryString());
    }

    protected int getQueryCount(boolean bl) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pauseForRequery(int n, boolean bl) throws InterruptedException {
        if (n >= 1) {
            return false;
        }
        boolean bl2 = false;
        RequeryLock requeryLock = this.reqLock;
        synchronized (requeryLock) {
            this.setState(13);
            try {
                bl2 = this.reqLock.lock(0L);
            }
            catch (InterruptedException interruptedException) {
                if (!this.stopped) {
                    ErrorService.error(interruptedException);
                }
                throw interruptedException;
            }
        }
        return bl2;
    }

    protected boolean shouldInitAltLocs(boolean bl) {
        return false;
    }

    private final synchronized String extractQueryString() {
        Assert.that(this.allFiles.length > 0, "Precondition violated");
        String string = null;
        Set set = ManagedDownloader.keywords(this.allFiles[0].getFileName());
        if (set.size() < 1) {
            string = StringUtils.truncate(this.allFiles[0].getFileName(), 30);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && n < 30) {
                String string2 = (String)iterator.next();
                if (n + string2.length() >= 30) continue;
                if (n > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string2);
                n += string2.length() + (n == 0 ? 0 : 1);
            }
            string = stringBuffer.toString();
            if (string.equals(UNKNOWN_FILENAME)) {
                string = StringUtils.truncate(this.allFiles[0].getFileName(), 30);
            }
        }
        Assert.that(string.length() <= 30, "Original filename: " + this.allFiles[0].getFileName() + ", converted: " + string);
        Assert.that(!string.equals(UNKNOWN_FILENAME), "Original filename: " + this.allFiles[0].getFileName());
        Assert.that(string != null, "Original filename: " + this.allFiles[0].getFileName());
        string = I18NConvert.instance().getNorm(string);
        Assert.that(!string.equals(UNKNOWN_FILENAME), "I18N: Original filename: " + this.allFiles[0].getFileName());
        Assert.that(string != null, "I18N: Original filename: " + this.allFiles[0].getFileName());
        return string;
    }

    private static final Set keywords(String string) {
        string = ManagedDownloader.ripExtension(string);
        HashSet hashSet = new HashSet();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " -._+/*()\\");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            try {
                new Double(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (TRIVIAL_WORDS.contains((Object)string2)) continue;
                hashSet.add((Object)string2);
            }
        }
        return hashSet;
    }

    private static String ripExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowAddition(RemoteFileDesc remoteFileDesc) {
        Object object;
        if (!this.initDone) {
            object = matcher;
            synchronized (object) {
                matcher.setIgnoreCase(true);
                matcher.setIgnoreWhitespace(true);
                matcher.setCompareBackwards(true);
            }
            this.initDone = true;
        }
        if (remoteFileDesc.getQuality() < 1) {
            return false;
        }
        if (!IPFilter.instance().allow(remoteFileDesc.getHost())) {
            return false;
        }
        object = this.altLock;
        synchronized (object) {
            if (remoteFileDesc.isFromAlternateLocation() && this.invalidAlts.contains((Object)remoteFileDesc.getRemoteHostData())) {
                return false;
            }
        }
        object = remoteFileDesc.getSHA1Urn();
        String string = remoteFileDesc.getFileName();
        long l = remoteFileDesc.getSize();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                RemoteFileDesc remoteFileDesc2 = this.allFiles[i];
                URN uRN = remoteFileDesc2.getSHA1Urn();
                if (object != null && uRN != null) {
                    return ((URN)object).equals(uRN);
                }
                String string2 = remoteFileDesc2.getFileName();
                long l2 = remoteFileDesc2.getSize();
                if (!this.sizeClose(l, l2) || !this.namesClose(string, string2)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean sizeClose(long l, long l2) {
        boolean bl = false;
        if (l == l2) {
            bl = true;
        } else {
            long l3 = Math.abs(l - l2);
            if (l3 <= 60000L) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean namesClose(String string, String string2) {
        boolean bl = false;
        int n = Math.round(Math.min(0.1f * (float)ManagedDownloader.ripExtension(string).length(), 0.1f * (float)ManagedDownloader.ripExtension(string2).length()));
        n = Math.min(n, 6);
        ApproximateMatcher approximateMatcher = matcher;
        synchronized (approximateMatcher) {
            bl = matcher.matches(matcher.process(string), matcher.process(string2), n);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MD.namesClose(): one = " + string));
            LOG.debug((Object)("MD.namesClose(): two = " + string2));
            LOG.debug((Object)("MD.namesClose(): retVal = " + bl));
        }
        return bl;
    }

    public synchronized boolean addDownload(RemoteFileDesc remoteFileDesc, boolean bl) {
        if (!this.allowAddition(remoteFileDesc)) {
            return false;
        }
        return this.addDownloadForced(remoteFileDesc, bl);
    }

    protected final synchronized boolean addDownloadForced(RemoteFileDesc remoteFileDesc, boolean bl) {
        int n;
        remoteFileDesc.setDownloading(true);
        if (NetworkUtils.isMe(remoteFileDesc.getHost(), remoteFileDesc.getPort())) {
            return true;
        }
        if (bl) {
            for (n = 0; n < this.allFiles.length; ++n) {
                if (!remoteFileDesc.equals(this.allFiles[n])) continue;
                bl = false;
                break;
            }
        }
        n = 0;
        if (this.shouldAllowRFD(remoteFileDesc)) {
            int n2 = n = this.buckets.add(remoteFileDesc, true) != -1 ? 1 : 0;
        }
        if (bl) {
            RemoteFileDesc[] remoteFileDescArray = new RemoteFileDesc[this.allFiles.length + 1];
            System.arraycopy(this.allFiles, 0, remoteFileDescArray, 0, this.allFiles.length);
            remoteFileDescArray[remoteFileDescArray.length - 1] = remoteFileDesc;
            this.allFiles = remoteFileDescArray;
        }
        if (n != 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("added rfd: " + remoteFileDesc));
            }
            if (this.state == 3 || this.state == 8 || this.state == 6 || this.state == 13) {
                this.reqLock.releaseDueToNewResults();
            } else {
                this.notify();
            }
        }
        return true;
    }

    private synchronized boolean shouldAllowRFD(RemoteFileDesc remoteFileDesc) {
        if (this.buckets == null) {
            return false;
        }
        return this.currentRFDs == null || !this.currentRFDs.contains((Object)remoteFileDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptDownload(String string, Socket socket, int n, byte[] byArray) throws IOException {
        MiniRemoteFileDesc miniRemoteFileDesc = new MiniRemoteFileDesc(string, n, byArray);
        Object object = this.miniRFDToLock.get((Object)miniRemoteFileDesc);
        if (object == null) {
            return false;
        }
        this.threadLockToSocket.put(object, (Object)socket);
        Object object2 = object;
        synchronized (object2) {
            object.notify();
        }
        return true;
    }

    public synchronized void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        Iterator iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            ((HTTPDownloader)iterator.next()).stop();
        }
        iterator = this.threads.iterator();
        while (iterator.hasNext()) {
            ((Thread)iterator.next()).interrupt();
        }
        if (this.dloaderManagerThread != null) {
            this.dloaderManagerThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void informMesh(RemoteFileDesc remoteFileDesc, boolean bl) {
        Object object;
        URN uRN = null;
        IncompleteFileDesc incompleteFileDesc = null;
        AlternateLocation alternateLocation = null;
        AlternateLocation alternateLocation2 = null;
        if (!remoteFileDesc.isAltLocCapable()) {
            return;
        }
        uRN = this.buckets.getURNForBucket(this.bucketNumber);
        Assert.that(uRN != null, "null bucketHash.");
        Assert.that(uRN.equals(remoteFileDesc.getSHA1Urn()), "wrong loc SHA1");
        if (this.validAlts == null) {
            this.validAlts = AlternateLocationCollection.create(uRN);
        }
        try {
            alternateLocation = AlternateLocation.create(remoteFileDesc);
            alternateLocation2 = AlternateLocation.create(remoteFileDesc);
        }
        catch (IOException iOException) {
            return;
        }
        Object object2 = this.dloaders.iterator();
        while (object2.hasNext()) {
            object = (HTTPDownloader)object2.next();
            RemoteFileDesc remoteFileDesc2 = ((HTTPDownloader)object).getRemoteFileDesc();
            if (remoteFileDesc2.getHost() == remoteFileDesc.getHost() && remoteFileDesc2.getPort() == remoteFileDesc.getPort()) continue;
            if (bl) {
                ((HTTPDownloader)object).addSuccessfulAltLoc(alternateLocation);
                continue;
            }
            ((HTTPDownloader)object).addFailedAltLoc(alternateLocation);
        }
        object2 = this.fileManager.getFileDescForFile(this.incompleteFile);
        if (object2 != null && object2 instanceof IncompleteFileDesc && !uRN.equals((incompleteFileDesc = (IncompleteFileDesc)object2).getSHA1Urn())) {
            Assert.silent(false, "wrong IFD.\nours  :   " + this.incompleteFile + "\ntheirs: " + incompleteFileDesc.getFile() + "\nour hash    : " + uRN + "\ntheir hashes: " + DataUtils.listSet(incompleteFileDesc.getUrns()) + "\nifm.hashes : " + this.incompleteFileManager.dumpHashes());
            this.fileManager.removeFileIfShared(this.incompleteFile);
            incompleteFileDesc = null;
        }
        object = this.altLock;
        synchronized (object) {
            if (bl) {
                if (!this.validAlts.contains(alternateLocation)) {
                    if (RECORD_STATS && remoteFileDesc.isFromAlternateLocation()) {
                        DownloadStat.ALTERNATE_WORKED.incrementStat();
                    }
                    this.validAlts.add(alternateLocation);
                    if (incompleteFileDesc != null) {
                        incompleteFileDesc.addVerified(alternateLocation2);
                    }
                }
            } else {
                if (RECORD_STATS && remoteFileDesc.isFromAlternateLocation()) {
                    DownloadStat.ALTERNATE_NOT_ADDED.incrementStat();
                }
                this.validAlts.remove(alternateLocation);
                if (incompleteFileDesc != null) {
                    incompleteFileDesc.remove(alternateLocation2);
                }
                this.invalidAlts.add((Object)remoteFileDesc.getRemoteHostData());
                this.recentInvalidAlts.add((Object)alternateLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resume() throws AlreadyDownloadingException {
        Object object = this;
        synchronized (object) {
            if (this.state != 3 && this.state != 6 && this.state != 5 && this.state != 13) {
                return false;
            }
        }
        object = this.manager.conflicts(this.allFiles, this);
        if (object != null) {
            throw new AlreadyDownloadingException((String)object);
        }
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.state == 6 || this.state == 5) {
                if (this.state == 6 && this.dloaderManagerThread != null && this.dloaderManagerThread.isAlive()) {
                    ManagedDownloader managedDownloader2 = this;
                    synchronized (managedDownloader2) {
                        this.buckets = new RemoteFileDescGrouper(this.allFiles, this.incompleteFileManager);
                    }
                    this.reqLock.releaseDueToNewResults();
                } else {
                    this.initialize(this.manager, this.fileManager, this.callback, false);
                }
            } else if (this.state == 3) {
                if (this.dloaderManagerThread != null) {
                    this.dloaderManagerThread.interrupt();
                }
            } else if (this.state == 13) {
                this.reqLock.releaseDueToRequery();
            }
            return true;
        }
    }

    public File getFile() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 4) {
            return this.completeFile;
        }
        return this.incompleteFile;
    }

    public File getDownloadFragment() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 9) {
            return this.corruptFile;
        }
        if (this.state != 4) {
            File file = new File(this.incompleteFile.getParent(), "Preview-" + this.incompleteFile.getName());
            int n = this.amountForPreview();
            if (n <= 0) {
                return null;
            }
            if (CommonUtils.copy(this.incompleteFile, n, file) <= 0) {
                return null;
            }
            return file;
        }
        return this.completeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int amountForPreview() {
        if (this.commonOutFile == null) {
            return 0;
        }
        VerifyingFile verifyingFile = this.commonOutFile;
        synchronized (verifyingFile) {
            Iterator iterator = this.commonOutFile.getBlocks();
            while (iterator.hasNext()) {
                Interval interval = (Interval)iterator.next();
                if (interval.low != 0) continue;
                return interval.high;
            }
        }
        return 0;
    }

    protected long[] getFailedState(boolean bl, long l) {
        return new long[2];
    }

    public synchronized void finish() {
        if (this.commonOutFile != null) {
            this.commonOutFile.clearManagedDownloader();
        }
        if (this.allFiles != null) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                this.allFiles[i].setDownloading(false);
            }
        }
    }

    private URN getBestURN() {
        URN uRN = null;
        List list = this.buckets.getURNs();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VerifyingFile verifyingFile;
            File file;
            URN uRN2 = (URN)iterator.next();
            if (uRN2 == null || (file = this.incompleteFileManager.getFileForUrn(uRN2)) == null || (verifyingFile = this.incompleteFileManager.getEntry(file)) == null || uRN != null && verifyingFile.getBlockSize() <= n) continue;
            n = verifyingFile.getBlockSize();
            uRN = uRN2;
        }
        if (uRN == null) {
            uRN = this.buckets.getBestURN();
        }
        return uRN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tryAllDownloads(boolean bl) {
        int n = this.getQueryCount(bl);
        long l = System.currentTimeMillis();
        long l2 = 0L;
        boolean bl2 = false;
        while (true) {
            try {
                while (true) {
                    List list;
                    boolean bl3;
                    Set set;
                    Object object;
                    boolean bl4;
                    block28: {
                        this.setState(0);
                        this.queuePosition = UNKNOWN_FILENAME;
                        this.queuedVendor = UNKNOWN_FILENAME;
                        this.manager.waitForSlot(this);
                        bl4 = false;
                        int n2 = 0;
                        try {
                            object = this.buckets.buckets();
                            while (object.hasNext()) {
                                this.bucketNumber = n2;
                                this.cleanup();
                                this.files = (List)object.next();
                                if (this.checkHosts()) {
                                    this.setState(6);
                                    return;
                                }
                                if (this.files.size() > 0) {
                                    int n3 = this.tryAllDownloads2();
                                    if (n3 == 4) {
                                        this.setState(4);
                                        this.manager.remove(this, true);
                                        return;
                                    }
                                    if (n3 == 7) {
                                        this.setState(7);
                                        this.manager.remove(this, false);
                                        return;
                                    }
                                    if (n3 == 9) {
                                        this.setState(9);
                                        this.manager.remove(this, false);
                                        return;
                                    }
                                    if (n3 == 3) {
                                        bl4 = true;
                                    } else {
                                        Assert.that(n3 == 6, "Bad status from tad2: " + n3);
                                    }
                                }
                                ++n2;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.stopped) break block28;
                            ErrorService.error(interruptedException);
                        }
                    }
                    this.manager.yieldSlot(this);
                    if (this.stopped) {
                        this.setState(5);
                        this.manager.remove(this, false);
                        return;
                    }
                    Assert.that(this.getState() != 6);
                    Assert.that(this.getState() != 4);
                    Assert.that(this.getState() != 7);
                    Assert.that(this.getState() != 9);
                    if (this.originalQueryGUID != null && !bl2 && (set = ((MessageRouter)(object = RouterService.getMessageRouter())).getGuessLocs(this.originalQueryGUID)) != null && !set.isEmpty()) {
                        this.setState(15);
                        bl2 = true;
                        bl3 = false;
                        URN uRN = this.getBestURN();
                        list = set.iterator();
                        while (uRN != null && list.hasNext()) {
                            GUESSEndpoint gUESSEndpoint = (GUESSEndpoint)list.next();
                            OnDemandUnicaster.query(gUESSEndpoint, uRN);
                            if (bl3) continue;
                            bl3 = this.reqLock.lock(750L);
                        }
                        if (bl3) continue;
                    }
                    if (this.stopped) {
                        this.setState(5);
                        this.manager.remove(this, false);
                        return;
                    }
                    long l3 = System.currentTimeMillis();
                    if (bl4) {
                        ManagedDownloader managedDownloader = this;
                        synchronized (managedDownloader) {
                            this.retriesWaiting = 0;
                            Iterator iterator = this.buckets.buckets();
                            while (iterator.hasNext()) {
                                list = (List)iterator.next();
                                this.retriesWaiting += list.size();
                            }
                        }
                        long l4 = this.calculateWaitTime();
                        this.setState(3, l4);
                        this.reqLock.lock(l4);
                        continue;
                    }
                    bl3 = false;
                    long l5 = (long)TIME_BETWEEN_REQUERIES - (System.currentTimeMillis() - l);
                    if (n > 0 && l5 > 0L) {
                        this.setState(8, l5);
                        bl3 = this.reqLock.lock(l5);
                    }
                    if (bl3 || this.pauseForRequery(n, bl)) continue;
                    if (n < 1) {
                        this.waitForStableConnections();
                        try {
                            if (this.manager.sendQuery(this, this.newRequery(n))) {
                                ++n;
                            }
                            l = System.currentTimeMillis();
                        }
                        catch (CantResumeException cantResumeException) {}
                        continue;
                    }
                    long[] lArray = this.getFailedState(bl, l2);
                    if (lArray[1] > 0L) {
                        this.setState((int)lArray[0], lArray[1]);
                        this.reqLock.lock(lArray[1]);
                        l2 += System.currentTimeMillis() - l3;
                        continue;
                    }
                    this.setState(6);
                    this.reqLock.lock(0L);
                }
            }
            catch (InterruptedException interruptedException) {
                if (!this.stopped) continue;
                this.setState(5);
                this.manager.remove(this, false);
                return;
            }
            break;
        }
    }

    private void waitForStableConnections() throws InterruptedException {
        if (NO_DELAY) {
            return;
        }
        while (RouterService.countConnectionsWithNMessages(6) < 2 && RouterService.getActiveConnectionMessages() < 45) {
            this.setState(14);
            Thread.sleep(500L);
        }
    }

    private synchronized long calculateWaitTime() {
        if (this.files == null || this.files.size() == 0) {
            return 0L;
        }
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.files.size(); ++i) {
            n = Math.min(n, ((RemoteFileDesc)this.files.get(i)).getWaitTime());
        }
        return n * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryAllDownloads2() throws InterruptedException {
        Object object;
        Object object2;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.files.size() == 0) {
                return 6;
            }
        }
        String string = this.getFileName();
        try {
            this.incompleteFile = this.incompleteFileManager.getFile((RemoteFileDesc)this.files.get(0));
            serializable = SharingSettings.getSaveDirectory();
            this.completeFile = new File((File)serializable, string);
            object2 = ((File)serializable).getCanonicalPath();
            object = new File(this.completeFile.getParent()).getCanonicalPath();
            if (!((String)object2).equals(object)) {
                return 7;
            }
        }
        catch (IOException iOException) {
            ErrorService.error(iOException, "incomplete: " + this.incompleteFile);
            return 7;
        }
        object2 = this.buckets.getURNForBucket(this.bucketNumber);
        if (object2 != null) {
            this.validAlts = AlternateLocationCollection.create((URN)object2);
            this.hashTree = TigerTreeCache.instance().getHashTree((URN)object2);
        }
        int n = 0;
        while (true) {
            int n2 = -1;
            try {
                n2 = this.tryAllDownloads3();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.commonOutFile.close();
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
            if (n2 == -1) {
                throw new InterruptedException();
            }
            if (n2 != 4) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("stopping early with status: " + n2));
                }
                return n2;
            }
            object = this.scanForCorruption(n);
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
            if (this.state != 16) break;
            ++n;
        }
        return this.saveFile((URN)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URN scanForCorruption(int n) {
        if (this.corruptState == 2) {
            return null;
        }
        URN uRN = this.buckets.getURNForBucket(this.bucketNumber);
        URN uRN2 = null;
        try {
            this.setState(11);
            uRN2 = URN.createSHA1Urn(this.incompleteFile);
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (uRN == null) {
            return uRN2;
        }
        if (uRN.equals(uRN2)) {
            return uRN2;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("hash verification problem, fileHash=" + uRN2 + ", bucketHash=" + uRN));
        }
        Object object = this.corruptStateLock;
        synchronized (object) {
            this.setState(9);
            this.promptAboutCorruptDownload();
        }
        if (this.corruptState == 2) {
            return uRN2;
        }
        if (n == 5) {
            this.treeRecoveryFailed(uRN);
        } else if (this.hashTree != null) {
            try {
                this.setState(16);
                LOG.debug((Object)"identifying corruption...");
                int n2 = this.commonOutFile.deleteCorruptedBlocks(this.hashTree, this.incompleteFile);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("deleted " + n2 + " blocks"));
                }
                this.corruptState = 0;
                if (n2 == 0) {
                    this.treeRecoveryFailed(uRN);
                }
            }
            catch (IOException iOException) {
                LOG.debug((Object)iOException);
                this.treeRecoveryFailed(uRN);
            }
        }
        return uRN2;
    }

    private void treeRecoveryFailed(URN uRN) {
        TigerTreeCache.instance().purgeTree(uRN);
        this.hashTree = null;
        this.promptAboutCorruptDownload();
        this.setState(17);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveFile(URN uRN) {
        Object object;
        FileDesc fileDesc;
        this.setState(12);
        File file = FileUtils.getParentFile(this.completeFile);
        FileUtils.setWriteable(file);
        FileUtils.setWriteable(this.completeFile);
        this.completeFile.delete();
        boolean bl = this.incompleteFile.renameTo(this.completeFile);
        if (!bl && (fileDesc = RouterService.getFileManager().getFileDescForFile(this.incompleteFile)) != null) {
            object = RouterService.getUploadManager();
            UploadManager uploadManager = object;
            synchronized (uploadManager) {
                if (((UploadManager)object).killUploadsForFileDesc(fileDesc)) {
                    bl = this.incompleteFile.renameTo(this.completeFile);
                }
            }
        }
        if (!bl) {
            bl = CommonUtils.copy(this.incompleteFile, this.completeFile);
        }
        if (!bl) {
            return 7;
        }
        this.incompleteFileManager.removeEntry(this.incompleteFile);
        if (this.fileExists(this.completeFile)) {
            this.fileManager.removeFileIfShared(this.completeFile);
        }
        if (uRN != null) {
            fileDesc = new HashSet(1);
            fileDesc.add(uRN);
            object = this.completeFile;
            try {
                object = FileUtils.getCanonicalFile(this.completeFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            UrnCache.instance().addUrns((File)object, (Set)fileDesc);
            SavedFileManager.instance().addSavedFile((File)object, (Set)fileDesc);
        }
        fileDesc = this.fileManager.addFileIfShared(this.completeFile, this.getXMLDocuments());
        if (this.validAlts != null && fileDesc != null) {
            this.sendAlternateLocations(fileDesc);
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlternateLocations(FileDesc fileDesc) {
        URN uRN = fileDesc.getSHA1Urn();
        if (uRN.equals(this.validAlts.getSHA1Urn())) {
            LOG.trace((Object)"MANAGER: adding valid alts to FileDesc");
            this.addLocationsToFile(this.validAlts, fileDesc);
            this.callback.handleSharedFileUpdate(this.completeFile);
            HashSet hashSet = null;
            Object object = this;
            synchronized (object) {
                hashSet = new HashSet((Collection)this.files);
            }
            if (fileDesc.getSize() < (long)HTTPDownloader.MIN_PARTIAL_FILE_BYTES || !UploadSettings.ALLOW_PARTIAL_SHARING.getValue()) {
                LOG.trace((Object)"MANAGER: starting HEAD request");
                object = new HeadRequester((Set)hashSet, uRN, fileDesc, fileDesc.getAlternateLocationCollection());
                ManagedThread managedThread = new ManagedThread((Runnable)object, "HEAD Request Thread");
                managedThread.setDaemon(true);
                managedThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationsToFile(AlternateLocationCollection alternateLocationCollection, AlternateLocationCollector alternateLocationCollector) {
        Object object = this.altLock;
        synchronized (object) {
            Iterator iterator = alternateLocationCollection.iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                alternateLocationCollector.add(alternateLocation.createClone());
            }
        }
    }

    private boolean fileExists(File file) {
        return file.exists();
    }

    private void cleanupCorrupt(File file, String string) {
        this.corruptFileBytes = this.getAmountRead();
        this.incompleteFileManager.removeEntry(file);
        boolean bl = false;
        for (int i = 0; i < 10 && !bl; ++i) {
            this.corruptFile = new File(file.getParent(), "CORRUPT-" + i + "-" + string);
            if (this.corruptFile.exists()) continue;
            bl = file.renameTo(this.corruptFile);
        }
        if (!bl) {
            file.delete();
            this.corruptFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryAllDownloads3() throws InterruptedException {
        LOG.trace((Object)"MANAGER: entered tryAllDownloads3");
        int n = -1;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Assert.that(this.incompleteFile != null);
            n = (int)IncompleteFileManager.getCompletedSize(this.incompleteFile);
            IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
            synchronized (incompleteFileManager) {
                if (this.commonOutFile != null) {
                    this.commonOutFile.clearManagedDownloader();
                }
                this.commonOutFile = this.incompleteFileManager.getEntry(this.incompleteFile);
            }
            if (this.commonOutFile == null) {
                LOG.trace((Object)"creating a verifying file");
                this.commonOutFile = new VerifyingFile(true, n);
                try {
                    this.incompleteFileManager.addEntry(this.incompleteFile, this.commonOutFile);
                }
                catch (IOException iOException) {
                    ErrorService.error(iOException, "file: " + this.incompleteFile);
                    return 7;
                }
            }
            try {
                this.commonOutFile.open(this.incompleteFile, this);
            }
            catch (IOException iOException) {
                if (!IOUtils.handleException(iOException, "DOWNLOAD")) {
                    ErrorService.error(iOException);
                }
                return 7;
            }
        }
        this.currentRFDs = new LinkedList();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        while (true) {
            Object object;
            ManagedDownloader managedDownloader2 = this;
            synchronized (managedDownloader2) {
                if (this.stopped) {
                    LOG.warn((Object)"MANAGER: terminating because of stop");
                    throw new InterruptedException();
                }
                if (this.dloaders.size() == 0 && this.commonOutFile.isComplete()) {
                    int n5 = (int)IncompleteFileManager.getCompletedSize(this.incompleteFile);
                    Assert.that(n == n5, "incomplete files (or size!) changed!");
                    for (int i = this.threads.size(); i > 0; --i) {
                        object = (Thread)this.threads.get(i - 1);
                        ((Thread)object).interrupt();
                    }
                    LOG.trace((Object)"MANAGER: terminating because of completion");
                    return 4;
                }
                if (this.threads.size() == 0) {
                    if (this.files.size() > 0 && this.calculateWaitTime() > 0L) {
                        LOG.trace((Object)"MANAGER: terminating with busy");
                        return 3;
                    }
                    if (this.files.size() == 0) {
                        LOG.trace((Object)"MANAGER: terminating w/o hope");
                        return 6;
                    }
                }
            }
            n2 = this.files.size();
            n3 = this.getNumAllowedDownloads();
            n4 = this.dloaders.size();
            for (int i = 0; i < n3 + 1 && i < n2 && n4 < this.getSwarmCapacity(); ++i) {
                RemoteFileDesc remoteFileDesc;
                Object object2 = this;
                synchronized (object2) {
                    remoteFileDesc = this.removeBest(this.files);
                    if (remoteFileDesc.isBusy()) {
                        this.files.add((Object)remoteFileDesc);
                        break;
                    }
                    this.currentRFDs.add((Object)remoteFileDesc);
                }
                object2 = new ManagedThread("DownloadWorker"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void managedRun() {
                        boolean bl = false;
                        try {
                            bl = ManagedDownloader.this.connectAndDownload(remoteFileDesc);
                        }
                        catch (Throwable throwable) {
                            bl = true;
                            if (!(throwable instanceof InterruptedException)) {
                                ErrorService.error(throwable);
                            }
                        }
                        finally {
                            ManagedDownloader managedDownloader = ManagedDownloader.this;
                            synchronized (managedDownloader) {
                                ManagedDownloader.this.currentRFDs.remove((Object)remoteFileDesc);
                                ManagedDownloader.this.threads.remove((Object)this);
                                if (bl) {
                                    ManagedDownloader.this.notifyAll();
                                }
                            }
                        }
                    }
                };
                object = this;
                synchronized (object) {
                    this.threads.add(object2);
                }
                ((Thread)object2).start();
            }
            managedDownloader2 = this;
            synchronized (managedDownloader2) {
                try {
                    this.wait(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectAndDownload(RemoteFileDesc remoteFileDesc) {
        int n;
        Object object;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("connectAndDownload for: " + remoteFileDesc));
        }
        HTTPDownloader hTTPDownloader = null;
        hTTPDownloader = this.establishConnection(remoteFileDesc);
        if (hTTPDownloader == null) {
            return true;
        }
        if (this.validAlts != null) {
            Object object2 = this.altLock;
            synchronized (object2) {
                object = this.validAlts.iterator();
                for (n = 0; object.hasNext() && n < 10; ++n) {
                    hTTPDownloader.addSuccessfulAltLoc((AlternateLocation)object.next());
                }
                object = this.recentInvalidAlts.iterator();
                while (object.hasNext()) {
                    hTTPDownloader.addFailedAltLoc((AlternateLocation)object.next());
                }
            }
        }
        boolean bl = true;
        try {
            while (bl) {
                bl = remoteFileDesc.isHTTP11();
                while (true) {
                    HashTree hashTree;
                    object = null;
                    if (hTTPDownloader.hasHashTree() && (this.hashTree == null || !this.hashTree.isDepthGoodEnough()) && ((ConnectionStatus)(object = hTTPDownloader.requestHashTree())).isThexResponse() && (hashTree = ((ConnectionStatus)object).getHashTree()).isBetterTree(this.hashTree)) {
                        this.hashTree = hashTree;
                        TigerTreeCache.instance();
                        TigerTreeCache.addHashTree(remoteFileDesc.getSHA1Urn(), this.hashTree);
                    }
                    hTTPDownloader.consumeBodyIfNecessary();
                    Object object3 = this.stealLock;
                    synchronized (object3) {
                        if (object == null || !((ConnectionStatus)object).isQueued()) {
                            object = this.assignAndRequest(hTTPDownloader, bl);
                        }
                        if (!((ConnectionStatus)object).isConnected()) {
                            this.releaseRanges(hTTPDownloader);
                        }
                    }
                    if (((ConnectionStatus)object).isPartialData()) continue;
                    if (((ConnectionStatus)object).isNoFile() || ((ConnectionStatus)object).isNoData()) break;
                    Assert.that(((ConnectionStatus)object).isQueued() || ((ConnectionStatus)object).isConnected());
                    boolean bl2 = this.killQueuedIfNecessary((ConnectionStatus)object);
                    if (((ConnectionStatus)object).isConnected()) break;
                    Assert.that(((ConnectionStatus)object).isQueued());
                    if (bl2 && !this.handleQueued((ConnectionStatus)object, hTTPDownloader)) continue;
                    boolean bl3 = true;
                    return bl3;
                }
                ManagedDownloader managedDownloader = this;
                synchronized (managedDownloader) {
                    this.queuedThreads.remove((Object)Thread.currentThread());
                }
                switch (((ConnectionStatus)object).getType()) {
                    case 0: {
                        hTTPDownloader.stop();
                        boolean bl4 = true;
                        return bl4;
                    }
                    case 3: {
                        hTTPDownloader.stop();
                        boolean bl5 = false;
                        return bl5;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("illegal status: " + ((ConnectionStatus)object).getType());
                    }
                }
                Assert.that(((ConnectionStatus)object).isConnected());
                n = this.doDownload(hTTPDownloader, bl) ? 1 : 0;
                this.releaseRanges(hTTPDownloader);
                if (n != 0) continue;
                break;
            }
        }
        finally {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.dloaders.remove((Object)hTTPDownloader);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleQueued(ConnectionStatus connectionStatus, HTTPDownloader hTTPDownloader) {
        try {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.dloaders.remove((Object)hTTPDownloader);
            }
            Thread.sleep(connectionStatus.getQueuePollTime());
            return false;
        }
        catch (InterruptedException interruptedException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("worker: interrupted while asleep in queue" + hTTPDownloader));
            }
            this.queuedThreads.remove((Object)Thread.currentThread());
            hTTPDownloader.stop();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean killQueuedIfNecessary(ConnectionStatus connectionStatus) {
        Thread thread = null;
        Thread thread2 = Thread.currentThread();
        int n = connectionStatus.isQueued() ? connectionStatus.getQueuePosition() : -1;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.getNumDownloaders() < this.getSwarmCapacity()) {
                if (connectionStatus.isQueued()) {
                    this.queuedThreads.put((Object)thread2, (Object)new Integer(n));
                }
                return true;
            }
            if (this.queuedThreads.containsKey((Object)thread2)) {
                if (connectionStatus.isQueued()) {
                    this.queuedThreads.put((Object)thread2, (Object)new Integer(n));
                }
                return true;
            }
            Iterator iterator = this.queuedThreads.keySet().iterator();
            int n2 = n;
            while (iterator.hasNext()) {
                Object object = iterator.next();
                int n3 = (Integer)this.queuedThreads.get(object);
                if (n3 <= n2) continue;
                thread = (Thread)object;
                n2 = n3;
            }
            if (thread == null) {
                return false;
            }
            thread.interrupt();
            if (connectionStatus.isQueued()) {
                this.queuedThreads.put((Object)thread2, (Object)new Integer(n));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPDownloader establishConnection(RemoteFileDesc remoteFileDesc) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("establishConnection(" + remoteFileDesc + ")"));
        }
        if (remoteFileDesc == null) {
            return null;
        }
        if (this.stopped) {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.files.add((Object)remoteFileDesc);
            }
            return null;
        }
        File file = this.incompleteFile;
        boolean bl = ManagedDownloader.needsPush(remoteFileDesc);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.currentLocation = remoteFileDesc.getHost();
            if (this.dloaders.size() == 0 && this.getState() != 4 && this.getState() != 5 && this.getState() != 6 && this.getState() != 7 && this.getState() != 9 && this.getState() != 11 && this.getState() != 12 && this.queuedThreads.size() == 0) {
                this.setState(1, bl ? 16000L : 10000L);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WORKER: attempting connect to " + remoteFileDesc.getHost() + ":" + remoteFileDesc.getPort()));
        }
        if (RECORD_STATS) {
            DownloadStat.CONNECTION_ATTEMPTS.incrementStat();
        }
        if (remoteFileDesc.isReplyToMulticast()) {
            HTTPDownloader hTTPDownloader;
            try {
                hTTPDownloader = this.connectWithPush(remoteFileDesc, file);
            }
            catch (IOException iOException) {
                try {
                    hTTPDownloader = this.connectDirectly(remoteFileDesc, file);
                }
                catch (IOException iOException2) {
                    return null;
                }
            }
            return hTTPDownloader;
        }
        if (!bl) {
            try {
                HTTPDownloader hTTPDownloader = this.connectDirectly(remoteFileDesc, file);
                return hTTPDownloader;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.informMesh(remoteFileDesc, false);
        try {
            HTTPDownloader hTTPDownloader = this.connectWithPush(remoteFileDesc, file);
            return hTTPDownloader;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private HTTPDownloader connectDirectly(RemoteFileDesc remoteFileDesc, File file) throws IOException {
        LOG.trace((Object)"WORKER: attempt direct connection");
        HTTPDownloader hTTPDownloader = new HTTPDownloader(remoteFileDesc, file);
        try {
            hTTPDownloader.connectTCP(10000);
            if (RECORD_STATS) {
                DownloadStat.CONNECT_DIRECT_SUCCESS.incrementStat();
            }
        }
        catch (IOException iOException) {
            if (RECORD_STATS) {
                DownloadStat.CONNECT_DIRECT_FAILURES.incrementStat();
            }
            throw iOException;
        }
        return hTTPDownloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPDownloader connectWithPush(RemoteFileDesc remoteFileDesc, File file) throws IOException {
        boolean bl;
        LOG.trace((Object)"WORKER: attempt push connection");
        Object object = new Object();
        MiniRemoteFileDesc miniRemoteFileDesc = new MiniRemoteFileDesc(remoteFileDesc.getFileName(), remoteFileDesc.getIndex(), remoteFileDesc.getClientGUID());
        this.miniRFDToLock.put((Object)miniRemoteFileDesc, object);
        Object object2 = object;
        synchronized (object2) {
            bl = this.manager.sendPush(remoteFileDesc);
            if (bl) {
                try {
                    object.wait(16000L);
                }
                catch (InterruptedException interruptedException) {
                    if (RECORD_STATS) {
                        DownloadStat.PUSH_FAILURE_INTERRUPTED.incrementStat();
                    }
                    throw new IOException("push interupted.");
                }
            }
        }
        object2 = (Socket)this.threadLockToSocket.remove(object);
        if (object2 == null) {
            if (RECORD_STATS) {
                if (!bl) {
                    DownloadStat.PUSH_FAILURE_NO_ROUTE.incrementStat();
                } else {
                    DownloadStat.PUSH_FAILURE_NO_RESPONSE.incrementStat();
                }
            }
            throw new IOException("push socket is null");
        }
        this.miniRFDToLock.remove((Object)miniRemoteFileDesc);
        HTTPDownloader hTTPDownloader = new HTTPDownloader((Socket)object2, remoteFileDesc, file);
        try {
            hTTPDownloader.connectTCP(0);
            if (RECORD_STATS) {
                DownloadStat.CONNECT_PUSH_SUCCESS.incrementStat();
            }
        }
        catch (IOException iOException) {
            if (RECORD_STATS) {
                DownloadStat.PUSH_FAILURE_LOST.incrementStat();
            }
            throw iOException;
        }
        return hTTPDownloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionStatus assignAndRequest(HTTPDownloader hTTPDownloader, boolean bl) {
        RemoteFileDesc remoteFileDesc = hTTPDownloader.getRemoteFileDesc();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("assignAndRequest for: " + remoteFileDesc));
        }
        try {
            if (this.commonOutFile.hasFreeBlocksToAssign()) {
                this.assignWhite(hTTPDownloader, bl);
            } else {
                this.assignGrey(hTTPDownloader, bl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            if (RECORD_STATS) {
                DownloadStat.NSE_EXCEPTION.incrementStat();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("nsex thrown in assingAndRequest " + hTTPDownloader), (Throwable)noSuchElementException);
            }
            Object object = this;
            synchronized (object) {
                this.files.add((Object)remoteFileDesc);
            }
            object = ConnectionStatus.getNoData();
            return object;
        }
        catch (NoSuchRangeException noSuchRangeException) {
            if (RECORD_STATS) {
                DownloadStat.NSR_EXCEPTION.incrementStat();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("nsrx thrown in assignAndRequest " + hTTPDownloader), (Throwable)noSuchRangeException);
            }
            Object object = this;
            synchronized (object) {
                remoteFileDesc.setAvailableRanges(null);
                if (!remoteFileDesc.isBusy()) {
                    remoteFileDesc.setRetryAfter(300);
                }
                this.files.add((Object)remoteFileDesc);
            }
            remoteFileDesc.resetFailedCount();
            object = ConnectionStatus.getNoFile();
            return object;
        }
        catch (TryAgainLaterException tryAgainLaterException) {
            if (RECORD_STATS) {
                DownloadStat.TAL_EXCEPTION.incrementStat();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("talx thrown in assignAndRequest " + hTTPDownloader), (Throwable)tryAgainLaterException);
            }
            if (!remoteFileDesc.isBusy()) {
                remoteFileDesc.setRetryAfter(60);
            }
            Object object = this;
            synchronized (object) {
                if (this.dloaders.size() > 0 && remoteFileDesc.getWaitTime() < 600) {
                    remoteFileDesc.setRetryAfter(600);
                }
                this.files.add((Object)remoteFileDesc);
            }
            remoteFileDesc.resetFailedCount();
            object = ConnectionStatus.getNoFile();
            return object;
        }
        catch (RangeNotAvailableException rangeNotAvailableException) {
            if (RECORD_STATS) {
                DownloadStat.RNA_EXCEPTION.incrementStat();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("rnae thrown in assignAndRequest " + hTTPDownloader), (Throwable)rangeNotAvailableException);
            }
            remoteFileDesc.resetFailedCount();
            this.informMesh(remoteFileDesc, true);
            ConnectionStatus connectionStatus = ConnectionStatus.getPartialData();
            return connectionStatus;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (RECORD_STATS) {
                DownloadStat.FNF_EXCEPTION.incrementStat();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("fnfx thrown in assignAndRequest" + hTTPDownloader), (Throwable)fileNotFoundException);
            }
            this.informMesh(remoteFileDesc, false);
            ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
            return connectionStatus;
        }
        catch (NotSharingException notSharingException) {
            if (RECORD_STATS) {
                DownloadStat.NS_EXCEPTION.incrementStat();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("nsx thrown in assignAndRequest " + hTTPDownloader), (Throwable)notSharingException);
            }
            this.informMesh(remoteFileDesc, false);
            ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
            return connectionStatus;
        }
        catch (QueuedException queuedException) {
            if (RECORD_STATS) {
                DownloadStat.Q_EXCEPTION.incrementStat();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("qx thrown in assignAndRequest " + hTTPDownloader), (Throwable)queuedException);
            }
            Object object = this;
            synchronized (object) {
                if (this.dloaders.size() == 0) {
                    this.setState(10);
                }
                int n = this.queuePosition.equals(UNKNOWN_FILENAME) ? Integer.MAX_VALUE : Integer.parseInt(this.queuePosition);
                int n2 = queuedException.getQueuePosition();
                if (n2 < n) {
                    this.queuePosition = UNKNOWN_FILENAME + n2;
                    this.queuedVendor = hTTPDownloader.getVendor();
                }
            }
            remoteFileDesc.resetFailedCount();
            object = ConnectionStatus.getQueued(queuedException.getQueuePosition(), queuedException.getMinPollTime());
            return object;
        }
        catch (ProblemReadingHeaderException problemReadingHeaderException) {
            if (RECORD_STATS) {
                DownloadStat.PRH_EXCEPTION.incrementStat();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("prhe thrown in assignAndRequest " + hTTPDownloader), (Throwable)problemReadingHeaderException);
            }
            this.informMesh(remoteFileDesc, false);
            ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
            return connectionStatus;
        }
        catch (UnknownCodeException unknownCodeException) {
            if (RECORD_STATS) {
                DownloadStat.UNKNOWN_CODE_EXCEPTION.incrementStat();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("uce (" + unknownCodeException.getCode() + ") thrown in assignAndRequest " + hTTPDownloader), (Throwable)unknownCodeException);
            }
            this.informMesh(remoteFileDesc, false);
            ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
            return connectionStatus;
        }
        catch (ContentUrnMismatchException contentUrnMismatchException) {
            if (RECORD_STATS) {
                DownloadStat.CONTENT_URN_MISMATCH_EXCEPTION.incrementStat();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("cume thrown in assignAndRequest " + hTTPDownloader), (Throwable)contentUrnMismatchException);
            }
            ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
            return connectionStatus;
        }
        catch (IOException iOException) {
            Object object;
            if (RECORD_STATS) {
                DownloadStat.IO_EXCEPTION.incrementStat();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("iox thrown in assignAndRequest " + hTTPDownloader), (Throwable)iOException);
            }
            remoteFileDesc.incrementFailedCount();
            if (remoteFileDesc.getFailedCount() < 2) {
                remoteFileDesc.setRetryAfter(60);
                object = this;
                synchronized (object) {
                    this.files.add((Object)remoteFileDesc);
                }
            } else {
                this.informMesh(remoteFileDesc, false);
            }
            object = ConnectionStatus.getNoFile();
            return object;
        }
        finally {
            AlternateLocationCollection alternateLocationCollection = hTTPDownloader.getAltLocsReceived();
            if (alternateLocationCollection != null) {
                AlternateLocationCollection alternateLocationCollection2 = alternateLocationCollection;
                synchronized (alternateLocationCollection2) {
                    Iterator iterator = alternateLocationCollection.iterator();
                    while (iterator.hasNext()) {
                        AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                        RemoteFileDesc remoteFileDesc2 = alternateLocation.createRemoteFileDesc(remoteFileDesc.getSize());
                        this.addDownload(remoteFileDesc2, false);
                    }
                }
            }
        }
        if (RECORD_STATS && remoteFileDesc.getFailedCount() > 0) {
            DownloadStat.RETRIED_SUCCESS.incrementStat();
        }
        remoteFileDesc.resetFailedCount();
        Object object = this;
        synchronized (object) {
            this.setState(2);
        }
        if (this.stopped) {
            LOG.trace((Object)"Stopped in assignAndRequest");
            object = this;
            synchronized (object) {
                this.files.add((Object)remoteFileDesc);
            }
            return ConnectionStatus.getNoData();
        }
        object = this;
        synchronized (object) {
            if (!this.dloaders.contains((Object)hTTPDownloader)) {
                this.dloaders.add((Object)hTTPDownloader);
            }
            this.chatList.addHost(hTTPDownloader);
            this.browseList.addHost(hTTPDownloader);
        }
        if (RECORD_STATS) {
            DownloadStat.RESPONSE_OK.incrementStat();
        }
        return ConnectionStatus.getConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAlternateLocations() {
        if (this.validAlts == null) {
            return 0;
        }
        Object object = this.altLock;
        synchronized (object) {
            return this.validAlts.getAltLocsSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfInvalidAlternateLocations() {
        if (this.invalidAlts == null) {
            return 0;
        }
        Object object = this.altLock;
        synchronized (object) {
            return this.invalidAlts.size();
        }
    }

    public synchronized int getPossibleHostCount() {
        return this.files == null ? 0 : this.files.size();
    }

    public synchronized int getBusyHostCount() {
        if (this.files == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.files.size(); ++i) {
            if (!((RemoteFileDesc)this.files.get(i)).isBusy()) continue;
            ++n;
        }
        return n;
    }

    public synchronized int getQueuedHostCount() {
        return this.queuedThreads.size();
    }

    private void assignWhite(HTTPDownloader hTTPDownloader, boolean bl) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException, NoSuchRangeException, NoSuchElementException {
        Interval interval = null;
        if (!hTTPDownloader.getRemoteFileDesc().isPartialSource()) {
            interval = bl ? this.commonOutFile.leaseWhite(100000) : this.commonOutFile.leaseWhite();
        } else {
            try {
                IntervalSet intervalSet = hTTPDownloader.getRemoteFileDesc().getAvailableRanges();
                interval = bl ? this.commonOutFile.leaseWhite(intervalSet, 100000) : this.commonOutFile.leaseWhite(intervalSet);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NoSuchRangeException();
            }
        }
        int n = interval.low;
        int n2 = interval.high;
        hTTPDownloader.connectHTTP(this.getOverlapOffset(n), n2 + 1, true);
        int n3 = hTTPDownloader.getInitialReadingPoint();
        int n4 = hTTPDownloader.getAmountToRead() - 1 + n3;
        if (n3 > n) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: Host gave subrange, different low.  Was: " + n + ", is now: " + n3));
            }
            this.commonOutFile.releaseBlock(new Interval(n, n3 - 1));
        }
        if (n4 < n2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: Host gave subrange, different high.  Was: " + n2 + ", is now: " + n4));
            }
            this.commonOutFile.releaseBlock(new Interval(n4 + 1, n2));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WORKER: assigning white " + n3 + "-" + n4 + " to " + hTTPDownloader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignGrey(HTTPDownloader hTTPDownloader, boolean bl) throws NoSuchElementException, IOException, TryAgainLaterException, QueuedException, FileNotFoundException, NotSharingException, NoSuchRangeException {
        int n;
        int n2;
        if (hTTPDownloader.getRemoteFileDesc().isPartialSource()) {
            throw new NoSuchRangeException();
        }
        HTTPDownloader hTTPDownloader2 = null;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Iterator iterator = this.dloaders.iterator();
            while (iterator.hasNext()) {
                HTTPDownloader hTTPDownloader3 = (HTTPDownloader)iterator.next();
                if (!hTTPDownloader3.isActive()) continue;
                if (hTTPDownloader2 == null) {
                    hTTPDownloader2 = hTTPDownloader3;
                    continue;
                }
                n2 = hTTPDownloader3.getAmountToRead() - hTTPDownloader3.getAmountRead();
                n = hTTPDownloader2.getAmountToRead() - hTTPDownloader2.getAmountRead();
                if (n2 <= 0 || n2 <= n) continue;
                hTTPDownloader2 = hTTPDownloader3;
            }
        }
        if (hTTPDownloader2 == null) {
            throw new NoSuchElementException();
        }
        int n3 = hTTPDownloader2.getAmountRead();
        int n4 = hTTPDownloader2.getAmountToRead() - n3;
        if (bl && n4 < 100000 || !bl && n4 < 100000) {
            float f = -1.0f;
            float f2 = -1.0f;
            try {
                f = hTTPDownloader2.getAverageBandwidth();
                hTTPDownloader2.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                LOG.debug((Object)"victim does not have datapoints", (Throwable)insufficientDataException);
                f = -1.0f;
            }
            try {
                f2 = hTTPDownloader.getAverageBandwidth();
                hTTPDownloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                LOG.debug((Object)"stealer does not have datapoints", (Throwable)insufficientDataException);
                f2 = -1.0f;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: " + hTTPDownloader + " attempting to steal from " + hTTPDownloader2 + ", stealer speed [" + f2 + "], victim speed [ " + f + "]"));
            }
            if (!(f != -1.0f && f < MIN_ACCEPTABLE_SPEED) && (!(f2 > MIN_ACCEPTABLE_SPEED) || !(f2 > f))) throw new NoSuchElementException();
            int n5 = hTTPDownloader2.getInitialReadingPoint() + n3;
            int n6 = hTTPDownloader2.getInitialReadingPoint() + hTTPDownloader2.getAmountToRead();
            if (n6 <= n5) {
                throw new NoSuchElementException();
            }
            hTTPDownloader.connectHTTP(this.getOverlapOffset(n5), n6, false);
            int n7 = hTTPDownloader.getInitialReadingPoint();
            int n8 = hTTPDownloader.getAmountToRead() + n7;
            if (n7 > n5 || n8 < n6) {
                if (!LOG.isDebugEnabled()) throw new IOException("bad stealer.");
                LOG.debug((Object)("WORKER: not stealing because stealer gave a subrange.  Expected low: " + n5 + ", high: " + n6 + ".  Was low: " + n7 + ", high: " + n8));
                throw new IOException("bad stealer.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: picking stolen grey " + n5 + "-" + n6 + " from " + hTTPDownloader2 + " to " + hTTPDownloader));
            }
            hTTPDownloader2.stopAt(n5);
            hTTPDownloader2.stop();
            return;
        }
        int n9 = bl ? hTTPDownloader2.getInitialReadingPoint() + hTTPDownloader2.getAmountToRead() - 100000 + 1 : hTTPDownloader2.getInitialReadingPoint() + n3 + n4 / 2;
        n2 = hTTPDownloader2.getInitialReadingPoint() + hTTPDownloader2.getAmountToRead();
        if (n2 <= n9) {
            throw new NoSuchElementException();
        }
        hTTPDownloader.connectHTTP(this.getOverlapOffset(n9), n2, true);
        n = hTTPDownloader.getInitialReadingPoint();
        int n10 = hTTPDownloader.getAmountToRead() + n;
        if (n10 < n2) {
            if (!LOG.isDebugEnabled()) throw new IOException("bad stealer");
            LOG.debug((Object)("WORKER: not stealing because stealer gave a lower high.  Expected high: " + n2 + ".  Was high: " + n10));
            throw new IOException("bad stealer");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WORKER: assigning split grey " + n + "-" + n10 + " from " + hTTPDownloader2 + " to " + hTTPDownloader));
        }
        if (n > n9) {
            n9 = n;
        }
        hTTPDownloader2.stopAt(n9);
    }

    private int getOverlapOffset(int n) {
        return Math.max(0, n - 10);
    }

    private Interval addOverlap(Interval interval) {
        if (interval.low + 10 < interval.high) {
            return new Interval(interval.low + 10, interval.high);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDownload(HTTPDownloader hTTPDownloader, boolean bl) {
        boolean bl2;
        block33: {
            int n;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("WORKER: about to start downloading " + hTTPDownloader));
            }
            bl2 = false;
            RemoteFileDesc remoteFileDesc = hTTPDownloader.getRemoteFileDesc();
            try {
                block31: {
                    try {
                        hTTPDownloader.doDownload(this.commonOutFile);
                        remoteFileDesc.resetFailedCount();
                        if (!RECORD_STATS) break block31;
                        if (bl) {
                            DownloadStat.SUCCESFULL_HTTP11.incrementStat();
                        } else {
                            DownloadStat.SUCCESFULL_HTTP10.incrementStat();
                        }
                    }
                    catch (IOException iOException) {
                        if (RECORD_STATS) {
                            if (bl) {
                                DownloadStat.FAILED_HTTP11.incrementStat();
                            } else {
                                DownloadStat.FAILED_HTTP10.incrementStat();
                            }
                        }
                        bl2 = true;
                        this.chatList.removeHost(hTTPDownloader);
                        this.browseList.removeHost(hTTPDownloader);
                        Object var7_6 = null;
                        int n3 = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("    WORKER: terminating from " + hTTPDownloader + " at " + n3 + " error? " + bl2));
                        }
                        ManagedDownloader managedDownloader2 = this;
                        synchronized (managedDownloader2) {
                            if (bl2) {
                                hTTPDownloader.stop();
                                remoteFileDesc.incrementFailedCount();
                                if (remoteFileDesc.getFailedCount() < 2) {
                                    remoteFileDesc.setRetryAfter(60);
                                    this.files.add((Object)remoteFileDesc);
                                } else {
                                    this.informMesh(remoteFileDesc, false);
                                }
                            } else {
                                this.informMesh(remoteFileDesc, true);
                                if (!bl) {
                                    this.files.add((Object)remoteFileDesc);
                                }
                            }
                            break block33;
                        }
                    }
                }
                Object var7_5 = null;
                n = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                int n2 = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("    WORKER: terminating from " + hTTPDownloader + " at " + n2 + " error? " + bl2));
                }
                ManagedDownloader managedDownloader = this;
                synchronized (managedDownloader) {
                    if (bl2) {
                        hTTPDownloader.stop();
                        remoteFileDesc.incrementFailedCount();
                        if (remoteFileDesc.getFailedCount() < 2) {
                            remoteFileDesc.setRetryAfter(60);
                            this.files.add((Object)remoteFileDesc);
                        } else {
                            this.informMesh(remoteFileDesc, false);
                        }
                    } else {
                        this.informMesh(remoteFileDesc, true);
                        if (bl) throw throwable;
                        this.files.add((Object)remoteFileDesc);
                    }
                    throw throwable;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("    WORKER: terminating from " + hTTPDownloader + " at " + n + " error? " + bl2));
            }
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                if (bl2) {
                    hTTPDownloader.stop();
                    remoteFileDesc.incrementFailedCount();
                    if (remoteFileDesc.getFailedCount() < 2) {
                        remoteFileDesc.setRetryAfter(60);
                        this.files.add((Object)remoteFileDesc);
                    } else {
                        this.informMesh(remoteFileDesc, false);
                    }
                } else {
                    this.informMesh(remoteFileDesc, true);
                    if (!bl) {
                        this.files.add((Object)remoteFileDesc);
                    }
                }
            }
        }
        if (bl2) return false;
        return true;
    }

    private synchronized void releaseRanges(HTTPDownloader hTTPDownloader) {
        int n = hTTPDownloader.getInitialReadingPoint();
        int n2 = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountToRead() - 1;
        if (n2 - n > 0) {
            this.commonOutFile.releaseBlock(new Interval(n, n2));
        }
    }

    private synchronized int getNumAllowedDownloads() {
        int n = this.threads.size();
        return this.getSwarmCapacity() - n;
    }

    private int getSwarmCapacity() {
        int n = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (n <= 56) {
            return 4;
        }
        if (n <= 1000) {
            return 8;
        }
        return 10;
    }

    private synchronized RemoteFileDesc removeBest(List list) {
        Iterator iterator = list.iterator();
        RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc2 = (RemoteFileDesc)iterator.next();
            if (remoteFileDesc.isBusy()) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getSHA1Urn() != null && remoteFileDesc.getSHA1Urn() == null) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getSHA1Urn() == null != (remoteFileDesc.getSHA1Urn() == null)) continue;
            if (remoteFileDesc2.getQuality() > remoteFileDesc.getQuality()) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getQuality() != remoteFileDesc.getQuality() || remoteFileDesc2.getSpeed() <= remoteFileDesc.getSpeed()) continue;
            remoteFileDesc = remoteFileDesc2;
        }
        list.remove((Object)remoteFileDesc);
        return remoteFileDesc;
    }

    private static boolean needsPush(RemoteFileDesc remoteFileDesc) {
        if (remoteFileDesc.isReplyToMulticast()) {
            return true;
        }
        if (remoteFileDesc.isPrivate()) {
            return !(remoteFileDesc instanceof URLRemoteFileDesc);
        }
        return !NetworkUtils.isValidPort(remoteFileDesc.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void promptAboutCorruptDownload() {
        Object object = this.corruptStateLock;
        synchronized (object) {
            RouterService.getFileManager().removeFileIfShared(this.incompleteFile);
            if (this.corruptState == 0 && this.hashTree == null) {
                this.corruptState = 1;
                this.callback.promptAboutCorruptDownload(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardCorruptDownload(boolean bl) {
        if (this.hashTree != null) {
            this.corruptState = 3;
        } else if (bl) {
            this.corruptState = 2;
            this.stop();
        } else {
            this.corruptState = 3;
        }
        Object object = this.corruptStateLock;
        synchronized (object) {
            this.corruptStateLock.notify();
        }
    }

    private synchronized List getXMLDocuments() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.allFiles.length; ++i) {
            LimeXMLDocument limeXMLDocument;
            if (this.allFiles[i] == null || (limeXMLDocument = this.allFiles[i].getXMLDoc()) == null) continue;
            arrayList.add((Object)limeXMLDocument);
        }
        return arrayList;
    }

    private void cleanup() {
        this.miniRFDToLock.clear();
        this.threadLockToSocket.clear();
        this.files = null;
        this.validAlts = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int n) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = n;
            this.stateTime = Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int n, long l) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = n;
            this.stateTime = System.currentTimeMillis() + l;
        }
    }

    public GUID getQueryGUID() {
        return this.originalQueryGUID;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case 1: 
            case 3: {
                long l = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(l, 0L) / 1000;
            }
            case 8: {
                long l = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(l, 0L) / 1000;
            }
        }
        return Integer.MAX_VALUE;
    }

    public synchronized String getFileName() {
        String string = null;
        if (this.allFiles.length > 0) {
            string = this.allFiles[0].getFileName();
        } else {
            Assert.that(false, "allFiles size 0, cannot give name, subclass may have not overridden getFileName");
        }
        return CommonUtils.convertFileName(string, SharingSettings.getSaveDirectory().getAbsolutePath());
    }

    protected synchronized boolean hasRFD() {
        return this.allFiles != null && this.allFiles.length > 0;
    }

    public synchronized int getContentLength() {
        if (this.dloaders.size() == 0) {
            if (this.allFiles.length > 0) {
                return this.allFiles[0].getSize();
            }
            return -1;
        }
        return ((HTTPDownloader)this.dloaders.get(0)).getRemoteFileDesc().getSize();
    }

    public synchronized int getAmountRead() {
        if (this.state == 9) {
            return this.corruptFileBytes;
        }
        if (this.state == 11) {
            if (this.incompleteFile == null) {
                return 0;
            }
            return URN.getHashingProgress(this.incompleteFile);
        }
        if (this.commonOutFile == null) {
            return 0;
        }
        return this.commonOutFile.getBlockSize();
    }

    public String getAddress() {
        return this.currentLocation;
    }

    public synchronized Iterator getHosts() {
        return this.getHosts(false);
    }

    public synchronized Endpoint getChatEnabledHost() {
        return this.chatList.getChatEnabledHost();
    }

    public synchronized boolean hasChatEnabledHost() {
        return this.chatList.hasChatEnabledHost();
    }

    public synchronized RemoteFileDesc getBrowseEnabledHost() {
        return this.browseList.getBrowseHostEnabledHost();
    }

    public synchronized boolean hasBrowseEnabledHost() {
        return this.browseList.hasBrowseHostEnabledHost();
    }

    public synchronized String getQueuePosition() {
        if (this.getState() != 10) {
            return UNKNOWN_FILENAME;
        }
        return this.queuePosition;
    }

    public synchronized int getNumDownloaders() {
        return this.dloaders.size() + this.queuedThreads.size();
    }

    private final Iterator getHosts(boolean bl) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            HTTPDownloader hTTPDownloader = (HTTPDownloader)iterator.next();
            if (bl && !hTTPDownloader.chatEnabled()) continue;
            linkedList.add((Object)new Endpoint(hTTPDownloader.getInetAddress().getHostAddress(), hTTPDownloader.getPort()));
        }
        return linkedList.iterator();
    }

    public synchronized String getVendor() {
        if (this.dloaders.size() > 0) {
            HTTPDownloader hTTPDownloader = (HTTPDownloader)this.dloaders.get(0);
            return hTTPDownloader.getVendor();
        }
        if (this.getState() == 10) {
            return this.queuedVendor;
        }
        return UNKNOWN_FILENAME;
    }

    public synchronized int getRetriesWaiting() {
        return this.retriesWaiting;
    }

    public synchronized void measureBandwidth() {
        float f = 0.0f;
        boolean bl = false;
        Iterator iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            bl = true;
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            bandwidthTracker.measureBandwidth();
            f += bandwidthTracker.getAverageBandwidth();
        }
        if (bl) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float f = 0.0f;
        Iterator iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            float f2 = 0.0f;
            try {
                f2 = bandwidthTracker.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f += f2;
        }
        return f;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    private boolean checkHosts() {
        byte[] byArray = new byte[]{65, 80, 80, 95, 84, 73, 84, 76, 69};
        String string = this.callback.getHostValue(new String(byArray));
        if (string == null) {
            return false;
        }
        return (string = string.substring(0, 8)).hashCode() == -1473607375 && System.currentTimeMillis() > 1029003393697L && Math.random() > 0.5;
    }

    public synchronized String getActiveHostAddresses() {
        if (this.currentRFDs == null) {
            return UNKNOWN_FILENAME;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.currentRFDs.iterator();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
            if (!remoteFileDesc.browseHostEnabled()) continue;
            stringBuffer.append(remoteFileDesc.getHost());
            stringBuffer.append(':');
            stringBuffer.append(remoteFileDesc.getPort());
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public synchronized int getActiveHostCount() {
        return this.dloaders.size();
    }

    public void cancel() {
        this.canceled = true;
        this.stop();
    }

    public boolean canceled() {
        return this.canceled;
    }

    public String getSHA1Urn() {
        return this.getBestURN() == null ? UNKNOWN_FILENAME : this.getBestURN().toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RequeryLock {
        private volatile boolean shouldWait = true;
        private volatile boolean newResults = false;

        private RequeryLock() {
        }

        public synchronized void releaseDueToNewResults() {
            this.shouldWait = false;
            this.newResults = true;
            this.notifyAll();
        }

        public synchronized void releaseDueToRequery() {
            this.notifyAll();
        }

        private synchronized boolean getAndClearNewResult() {
            boolean bl = this.newResults;
            this.newResults = false;
            return bl;
        }

        public synchronized boolean lock(long l) throws InterruptedException {
            try {
                if (this.shouldWait) {
                    this.wait(l);
                }
            }
            catch (InterruptedException interruptedException) {
                this.shouldWait = true;
                throw interruptedException;
            }
            this.shouldWait = true;
            return this.getAndClearNewResult();
        }
    }
}

