/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.HashSet;
import java.io.File;
import java.io.Serializable;

public class ResumeDownloader
extends ManagedDownloader
implements Serializable {
    static final long serialVersionUID = -4535935715006098724L;
    private final File _incompleteFile;
    private final String _name;
    private final int _size;
    private final URN _hash;

    public ResumeDownloader(IncompleteFileManager incompleteFileManager, File file, String string, int n) {
        super(new RemoteFileDesc[0], incompleteFileManager, null);
        if (file == null) {
            throw new NullPointerException("null incompleteFile");
        }
        this._incompleteFile = file;
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Bad name in ResumeDownloader");
        }
        this._name = string;
        this._size = n;
        this._hash = incompleteFileManager.getCompletedHash(file);
    }

    public void initialize(DownloadManager downloadManager, FileManager fileManager, ActivityCallback activityCallback, boolean bl) {
        this.initializeIncompleteFile(this._incompleteFile);
        super.initialize(downloadManager, fileManager, activityCallback, bl);
    }

    public boolean conflicts(File file) {
        return file.equals(this._incompleteFile);
    }

    protected boolean allowAddition(RemoteFileDesc remoteFileDesc) {
        return IncompleteFileManager.same(this._name, this._size, this._hash, remoteFileDesc.getFileName(), remoteFileDesc.getSize(), remoteFileDesc.getSHA1Urn());
    }

    public synchronized int getContentLength() {
        return this._size;
    }

    public synchronized String getFileName() {
        return this._name;
    }

    protected boolean pauseForRequery(int n, boolean bl) throws InterruptedException {
        if (n > 0 || bl) {
            return super.pauseForRequery(n, bl);
        }
        return false;
    }

    protected boolean shouldInitAltLocs(boolean bl) {
        return !bl;
    }

    protected QueryRequest newRequery(int n) {
        HashSet hashSet = null;
        if (this._hash != null) {
            hashSet = new HashSet(1);
            hashSet.add((Object)this._hash);
        }
        String string = StringUtils.truncate(this.getFileName(), 30);
        if (this._hash != null) {
            return QueryRequest.createQuery(string);
        }
        return QueryRequest.createQuery(string);
    }
}

