/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.AllowFilter;
import com.limegroup.gnutella.filters.CompositeFilter;
import com.limegroup.gnutella.filters.DuplicateFilter;
import com.limegroup.gnutella.filters.GUIDFilter;
import com.limegroup.gnutella.filters.GreedyQueryFilter;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.MutableGUIDFilter;
import com.limegroup.gnutella.filters.RequeryFilter;
import com.limegroup.gnutella.filters.SpamReplyFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.FilterSettings;
import com.sun.java.util.collections.Vector;

public abstract class SpamFilter {
    public static SpamFilter newPersonalFilter() {
        SpamFilter spamFilter;
        String[] stringArray;
        Vector vector = new Vector();
        String[] stringArray2 = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        if (stringArray2.length != 0) {
            stringArray = IPFilter.instance();
            vector.add((Object)stringArray);
        }
        stringArray = FilterSettings.BANNED_WORDS.getValue();
        boolean bl = FilterSettings.FILTER_ADULT.getValue();
        boolean bl2 = FilterSettings.FILTER_VBS.getValue();
        boolean bl3 = FilterSettings.FILTER_HTML.getValue();
        if (stringArray.length != 0 || bl || bl2 || bl3) {
            spamFilter = new KeywordFilter();
            for (int i = 0; i < stringArray.length; ++i) {
                ((KeywordFilter)spamFilter).disallow(stringArray[i]);
            }
            if (bl) {
                ((KeywordFilter)spamFilter).disallowAdult();
            }
            if (bl2) {
                ((KeywordFilter)spamFilter).disallowVbs();
            }
            if (bl3) {
                ((KeywordFilter)spamFilter).disallowHtml();
            }
            vector.add((Object)spamFilter);
        }
        spamFilter = new SpamReplyFilter();
        vector.add((Object)spamFilter);
        MutableGUIDFilter mutableGUIDFilter = MutableGUIDFilter.instance();
        vector.add((Object)mutableGUIDFilter);
        return SpamFilter.compose(vector);
    }

    public static SpamFilter newRouteFilter() {
        Vector vector = new Vector();
        vector.add((Object)new RequeryFilter());
        vector.add((Object)new GUIDFilter());
        if (FilterSettings.FILTER_DUPLICATES.getValue()) {
            vector.add((Object)new DuplicateFilter());
        }
        if (FilterSettings.FILTER_GREEDY_QUERIES.getValue()) {
            vector.add((Object)new GreedyQueryFilter());
        }
        return SpamFilter.compose(vector);
    }

    private static SpamFilter compose(Vector vector) {
        if (vector.size() == 0) {
            return new AllowFilter();
        }
        if (vector.size() == 1) {
            return (SpamFilter)vector.get(0);
        }
        Object[] objectArray = new SpamFilter[vector.size()];
        vector.copyInto(objectArray);
        return new CompositeFilter((SpamFilter[])objectArray);
    }

    public abstract boolean allow(Message var1);
}

