/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.limegroup.gnutella.ByteOrder;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Random;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import org.logi.crypto.Crypto;
import org.logi.crypto.keys.DESKey;

public final class QueryKey {
    private static SecretKey SECRET_KEY = null;
    private static SecretPad SECRET_PAD = null;
    public static final int MIN_QK_SIZE_IN_BYTES = 4;
    public static final int MAX_QK_SIZE_IN_BYTES = 16;
    private byte[] _queryKey;

    private QueryKey(byte[] byArray) throws IllegalArgumentException {
        if (!QueryKey.isValidQueryKeyBytes(byArray)) {
            throw new IllegalArgumentException();
        }
        this._queryKey = new byte[byArray.length];
        System.arraycopy(byArray, 0, this._queryKey, 0, byArray.length);
    }

    public void prepareForNetwork() {
        for (int i = 0; i < this._queryKey.length; ++i) {
            if (this._queryKey[i] != 28) continue;
            this._queryKey[i] = -6;
        }
    }

    public static SecretKey generateSecretKey() {
        return new SecretKey();
    }

    public static SecretPad generateSecretPad() {
        return new SecretPad();
    }

    public boolean equals(Object object) {
        if (!(object instanceof QueryKey)) {
            return false;
        }
        QueryKey queryKey = (QueryKey)object;
        return Arrays.equals((byte[])this._queryKey, (byte[])queryKey._queryKey);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = this._queryKey[i] % this._queryKey.length;
            if (n2 < 0) {
                n2 *= -1;
            }
            n += this._queryKey[n2] * 7;
        }
        return n;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this._queryKey);
    }

    public String toString() {
        return "{Query Key: " + new BigInteger(this._queryKey) + "}";
    }

    public static boolean isValidQueryKeyBytes(byte[] byArray) {
        return byArray != null && byArray.length >= 4 && byArray.length <= 16;
    }

    public static QueryKey getQueryKey(byte[] byArray, boolean bl) throws IllegalArgumentException {
        QueryKey queryKey = new QueryKey(byArray);
        if (bl) {
            queryKey.prepareForNetwork();
        }
        return queryKey;
    }

    public static QueryKey getQueryKey(InetAddress inetAddress, int n) {
        return QueryKey.getQueryKey(inetAddress, n, SECRET_KEY, SECRET_PAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryKey getQueryKey(InetAddress inetAddress, int n, SecretKey secretKey, SecretPad secretPad) {
        int n2;
        int n3;
        byte[] byArray = new byte[8];
        byte[] byArray2 = inetAddress.getAddress();
        short s = (short)n;
        byte[] byArray3 = new byte[2];
        ByteOrder.short2leb(s, byArray3, 0);
        int n4 = secretPad._pad[0] % 8;
        if (n4 < 0) {
            n4 *= -1;
        }
        if ((n3 = secretPad._pad[1] % 8) < 0) {
            n3 *= -1;
        }
        if (n3 == n4) {
            n3 = n4 == 0 ? 1 : n4 - 1;
        }
        byArray[n4] = secretPad._pad[0];
        byArray[n3] = secretPad._pad[1];
        int n5 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            while (n5 == n4 || n5 == n3) {
                ++n5;
            }
            byArray[n5++] = byArray2[n2];
        }
        for (n2 = 0; n2 < 2; ++n2) {
            while (n5 == n4 || n5 == n3) {
                ++n5;
            }
            byArray[n5++] = byArray3[n2];
        }
        byte[] byArray4 = new byte[8];
        SecretKey secretKey2 = secretKey;
        synchronized (secretKey2) {
            secretKey._DESKey.encrypt(byArray, 0, byArray4, 0);
        }
        return QueryKey.getQueryKey(byArray4, true);
    }

    static {
        Crypto.initRandom();
        SECRET_KEY = new SecretKey();
        SECRET_PAD = new SecretPad();
    }

    public static class SecretPad {
        private byte[] _pad = new byte[2];

        private SecretPad() {
            new Random().nextBytes(this._pad);
        }
    }

    public static class SecretKey {
        private DESKey _DESKey = new DESKey();

        private SecretKey() {
        }
    }
}

