/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.util.Hashtable;
import java.util.Properties;

public abstract class DefaultHeaders
extends Properties {
    private static final String QUERY_ROUTING_VERSION = "0.1";

    protected DefaultHeaders(String string) {
        byte[] byArray = RouterService.getAddress();
        int n = RouterService.getPort();
        if (NetworkUtils.isValidAddress(byArray) && NetworkUtils.isValidPort(n)) {
            ((Hashtable)this).put("Listen-IP", NetworkUtils.ip2string(byArray) + ":" + n);
        }
        if (string != null) {
            ((Hashtable)this).put("Remote-IP", string);
        }
        DefaultHeaders.addCommonHeaders(this);
    }

    private static void addCommonHeaders(Properties properties) {
        ((Hashtable)properties).put("X-Query-Routing", QUERY_ROUTING_VERSION);
        ((Hashtable)properties).put("User-Agent", CommonUtils.getHttpServer());
        ((Hashtable)properties).put("GGEP", "0.5");
        ((Hashtable)properties).put("X-Guess", QUERY_ROUTING_VERSION);
        ((Hashtable)properties).put("Vendor-Message", QUERY_ROUTING_VERSION);
        ((Hashtable)properties).put("X-Degree", Integer.toString(ConnectionManager.ULTRAPEER_CONNECTIONS));
        ((Hashtable)properties).put("X-Ultrapeer-Query-Routing", QUERY_ROUTING_VERSION);
        ((Hashtable)properties).put("X-Max-TTL", "3");
        ((Hashtable)properties).put("X-Dynamic-Querying", QUERY_ROUTING_VERSION);
        ((Hashtable)properties).put("X-Locale-Pref", ApplicationSettings.LANGUAGE.getValue());
        if (ConnectionSettings.ACCEPT_DEFLATE.getValue()) {
            ((Hashtable)properties).put(HeaderNames.ACCEPT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        ((Hashtable)properties).put("Pong-Caching", QUERY_ROUTING_VERSION);
        ((Hashtable)properties).put("X-OS", "Mac Classic");
    }
}

