/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.AuthenticationHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.LeafHeaders;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public final class LeafHandshakeResponder
extends AuthenticationHandshakeResponder {
    private boolean _pref = false;

    public LeafHandshakeResponder(String string) {
        super(RouterService.getConnectionManager(), string);
    }

    protected HandshakeResponse respondUnauthenticated(HandshakeResponse handshakeResponse, boolean bl) throws IOException {
        if (bl) {
            return this.respondToOutgoing(handshakeResponse);
        }
        return this.respondToIncoming(handshakeResponse);
    }

    private HandshakeResponse respondToOutgoing(HandshakeResponse handshakeResponse) {
        if (!handshakeResponse.isUltrapeer()) {
            return HandshakeResponse.createLeafRejectOutgoingResponse();
        }
        if (this._pref && !ApplicationSettings.LANGUAGE.getValue().equals(handshakeResponse.getLocalePref())) {
            return HandshakeResponse.createLeafRejectLocaleOutgoingResponse();
        }
        if (!this._manager.allowConnection(handshakeResponse)) {
            return HandshakeResponse.createLeafRejectOutgoingResponse();
        }
        Properties properties = new Properties();
        if (handshakeResponse.isDeflateAccepted()) {
            ((Hashtable)properties).put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(properties);
    }

    private HandshakeResponse respondToIncoming(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isCrawler()) {
            return HandshakeResponse.createCrawlerResponse();
        }
        if (!handshakeResponse.isUltrapeer()) {
            return HandshakeResponse.createLeafRejectOutgoingResponse();
        }
        LeafHeaders leafHeaders = new LeafHeaders(this.getRemoteIP());
        if (!this._manager.allowConnection(handshakeResponse)) {
            return HandshakeResponse.createLeafRejectIncomingResponse(handshakeResponse);
        }
        if (handshakeResponse.isDeflateAccepted()) {
            ((Hashtable)leafHeaders).put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(handshakeResponse, leafHeaders);
    }

    public void setLocalePreferencing(boolean bl) {
        this._pref = bl;
    }
}

