/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import phex.common.Ip2CountryManager;

public class PingReply
extends Message
implements Serializable,
IpPort {
    private final List PACKED_IP_PORTS;
    private final List PACKED_UDP_HOST_CACHES;
    private final String UDP_CACHE_ADDRESS;
    private final int FREE_ULTRAPEER_SLOTS;
    private final int FREE_LEAF_SLOTS;
    public static final int STANDARD_PAYLOAD_SIZE = 14;
    private final byte[] PAYLOAD;
    private final InetAddress IP;
    private final int PORT;
    private final InetAddress MY_IP;
    private final int MY_PORT;
    private final long FILES;
    private final long KILOBYTES;
    private final int DAILY_UPTIME;
    private final boolean SUPPORTS_UNICAST;
    private final String VENDOR;
    private final int VENDOR_MAJOR_VERSION;
    private final int VENDOR_MINOR_VERSION;
    private final QueryKey QUERY_KEY;
    private final boolean HAS_GGEP_EXTENSION;
    private static final byte[] CACHED_VENDOR = new byte[5];
    private String CLIENT_LOCALE;
    private int FREE_LOCALE_SLOTS;

    public static PingReply create(byte[] byArray, byte by) {
        return PingReply.create(byArray, by, (Collection)Collections.EMPTY_LIST);
    }

    public static PingReply create(byte[] byArray, byte by, Collection collection) {
        return PingReply.create(byArray, by, RouterService.getPort(), RouterService.getAddress(), RouterService.getNumSharedFiles(), (long)RouterService.getSharedFileSize() / 1024L, RouterService.isSupernode(), Statistics.instance().calculateDailyUptime(), UDPService.instance().isGUESSCapable(), ApplicationSettings.LANGUAGE.getValue().equals("") ? ApplicationSettings.DEFAULT_LOCALE.getValue() : ApplicationSettings.LANGUAGE.getValue(), RouterService.getConnectionManager().getNumLimeWireLocalePrefSlots(), collection);
    }

    public static PingReply create(byte[] byArray, byte by, IpPort ipPort) {
        return PingReply.create(byArray, by, ipPort, (Collection)Collections.EMPTY_LIST);
    }

    public static PingReply create(byte[] byArray, byte by, IpPort ipPort, Collection collection) {
        GGEP gGEP = PingReply.newGGEP(Statistics.instance().calculateDailyUptime(), RouterService.isSupernode(), UDPService.instance().isGUESSCapable());
        String string = ApplicationSettings.LANGUAGE.getValue().equals("") ? ApplicationSettings.DEFAULT_LOCALE.getValue() : ApplicationSettings.LANGUAGE.getValue();
        PingReply.addLocale(gGEP, string, RouterService.getConnectionManager().getNumLimeWireLocalePrefSlots());
        PingReply.addAddress(gGEP, ipPort);
        PingReply.addPackedHosts(gGEP, collection);
        return PingReply.create(byArray, by, RouterService.getPort(), RouterService.getAddress(), RouterService.getNumSharedFiles(), (long)RouterService.getSharedFileSize() / 1024L, RouterService.isSupernode(), gGEP);
    }

    public static PingReply createQueryKeyReply(byte[] byArray, byte by, QueryKey queryKey) {
        return PingReply.create(byArray, by, RouterService.getPort(), RouterService.getAddress(), RouterService.getNumSharedFiles(), RouterService.getSharedFileSize() / 1024, RouterService.isSupernode(), PingReply.qkGGEP(queryKey));
    }

    public static PingReply createQueryKeyReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, QueryKey queryKey) {
        return PingReply.create(byArray, by, n, byArray2, l, l2, bl, PingReply.qkGGEP(queryKey));
    }

    public static PingReply create(byte[] byArray, byte by, int n, byte[] byArray2) {
        return PingReply.create(byArray, by, n, byArray2, 0L, 0L, false, -1, false);
    }

    public static PingReply createExternal(byte[] byArray, byte by, int n, byte[] byArray2, boolean bl) {
        return PingReply.create(byArray, by, n, byArray2, 0L, 0L, bl, -1, false);
    }

    public static PingReply createExternal(byte[] byArray, byte by, int n, byte[] byArray2, int n2, boolean bl) {
        return PingReply.create(byArray, by, n, byArray2, 0L, 0L, bl, n2, false);
    }

    public static PingReply createGUESSReply(byte[] byArray, byte by, Endpoint endpoint) throws UnknownHostException {
        return PingReply.create(byArray, by, endpoint.getPort(), endpoint.getHostBytes(), 0L, 0L, true, -1, true);
    }

    public static PingReply createGUESSReply(byte[] byArray, byte by, int n, byte[] byArray2) {
        return PingReply.create(byArray, by, n, byArray2, 0L, 0L, true, -1, true);
    }

    public static PingReply create(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2) {
        return PingReply.create(byArray, by, n, byArray2, l, l2, false, -1, false);
    }

    public static PingReply create(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, int n2, boolean bl2) {
        return PingReply.create(byArray, by, n, byArray2, l, l2, bl, PingReply.newGGEP(n2, bl, bl2));
    }

    public static PingReply create(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, int n2, boolean bl2, String string, int n3) {
        return PingReply.create(byArray, by, n, byArray2, l, l2, bl, n2, bl2, string, n3, (Collection)Collections.EMPTY_LIST);
    }

    public static PingReply create(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, int n2, boolean bl2, String string, int n3, Collection collection) {
        GGEP gGEP = PingReply.newGGEP(n2, bl, bl2);
        PingReply.addLocale(gGEP, string, n3);
        PingReply.addPackedHosts(gGEP, collection);
        return PingReply.create(byArray, by, n, byArray2, l, l2, bl, gGEP);
    }

    public PingReply mutateGUID(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("bad guid size: " + byArray.length);
        }
        try {
            return PingReply.createFromNetwork(byArray, this.getTTL(), this.getHops(), this.PAYLOAD);
        }
        catch (BadPacketException badPacketException) {
            throw new IllegalArgumentException("Input pong was bad!");
        }
    }

    public static PingReply create(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, GGEP gGEP) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (!NetworkUtils.isValidAddress(byArray2)) {
            throw new IllegalArgumentException("invalid address: " + NetworkUtils.ip2string(byArray2));
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(NetworkUtils.ip2string(byArray2));
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(unknownHostException.getMessage());
        }
        byte[] byArray3 = null;
        if (gGEP != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
            byArray3 = byteArrayOutputStream.toByteArray();
        }
        int n2 = 14 + (byArray3 == null ? 0 : byArray3.length);
        byte[] byArray4 = new byte[n2];
        ByteOrder.short2leb((short)n, byArray4, 0);
        byArray4[2] = byArray2[0];
        byArray4[3] = byArray2[1];
        byArray4[4] = byArray2[2];
        byArray4[5] = byArray2[3];
        ByteOrder.int2leb((int)l, byArray4, 6);
        ByteOrder.int2leb((int)(bl ? PingReply.mark(l2) : l2), byArray4, 10);
        if (byArray3 != null) {
            System.arraycopy(byArray3, 0, byArray4, 14, byArray3.length);
        }
        return new PingReply(byArray, by, 0, byArray4, gGEP, inetAddress);
    }

    public static PingReply createFromNetwork(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        if (byArray == null) {
            throw new NullPointerException("null guid");
        }
        if (byArray2 == null) {
            throw new NullPointerException("null payload");
        }
        if (byArray2.length < 14) {
            throw new BadPacketException("invalid payload length");
        }
        int n = ByteOrder.ubytes2int(ByteOrder.leb2short(byArray2, 0));
        if (!NetworkUtils.isValidPort(n)) {
            throw new BadPacketException("invalid port: " + n);
        }
        String string = NetworkUtils.ip2string(byArray2, 2);
        InetAddress inetAddress = null;
        GGEP gGEP = PingReply.parseGGEP(byArray2);
        if (gGEP != null) {
            Object object;
            if (gGEP.hasKey("VC")) {
                object = null;
                try {
                    object = gGEP.getBytes("VC");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    throw new BadPacketException("bad GGEP: " + object);
                }
                if (((byte[])object).length < 4) {
                    throw new BadPacketException("invalid vendor length: " + ((byte[])object).length);
                }
            }
            if (gGEP.hasKey("LOC")) {
                try {
                    object = gGEP.getBytes("LOC");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    throw new BadPacketException("GGEP error : creating from network : client locale");
                }
            }
            if (gGEP.hasKey("IPP")) {
                object = null;
                try {
                    object = gGEP.getBytes("IPP");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    throw new BadPacketException(badGGEPPropertyException.getMessage());
                }
                if (object == null || ((byte[])object).length % 6 != 0) {
                    throw new BadPacketException("invalid data");
                }
            }
            if (gGEP.hasKey("PHC")) {
                try {
                    gGEP.getBytes("PHC");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    throw new BadPacketException(badGGEPPropertyException.getMessage());
                }
            }
            if (gGEP.hasKey("UDPHC")) {
                try {
                    object = gGEP.getString("UDPHC");
                    inetAddress = InetAddress.getByName((String)object);
                    string = inetAddress.getHostAddress();
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                }
                catch (UnknownHostException unknownHostException) {
                    throw new BadPacketException(unknownHostException.getMessage());
                }
            }
        }
        if (!NetworkUtils.isValidAddress(string)) {
            throw new BadPacketException("invalid address: " + string);
        }
        if (inetAddress == null) {
            try {
                inetAddress = InetAddress.getByName(NetworkUtils.ip2string(byArray2, 2));
            }
            catch (UnknownHostException unknownHostException) {
                throw new BadPacketException("bad IP:" + string + " " + unknownHostException.getMessage());
            }
        }
        return new PingReply(byArray, by, by2, byArray2, gGEP, inetAddress);
    }

    private PingReply(byte[] byArray, byte by, byte by2, byte[] byArray2, GGEP gGEP, InetAddress inetAddress) {
        super(byArray, (byte)1, by, by2, byArray2.length);
        this.PAYLOAD = byArray2;
        this.PORT = ByteOrder.ubytes2int(ByteOrder.leb2short(this.PAYLOAD, 0));
        this.FILES = ByteOrder.ubytes2long(ByteOrder.leb2int(this.PAYLOAD, 6));
        this.KILOBYTES = ByteOrder.ubytes2long(ByteOrder.leb2int(this.PAYLOAD, 10));
        this.IP = inetAddress;
        int n = -1;
        boolean bl = false;
        String string = "";
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        QueryKey queryKey = null;
        String string2 = Ip2CountryManager.getInstance().getIP2Language(inetAddress.getHostAddress(), ApplicationSettings.DEFAULT_LOCALE.getValue());
        int n6 = -1;
        InetAddress inetAddress2 = null;
        int n7 = 0;
        List list = Collections.EMPTY_LIST;
        List list2 = Collections.EMPTY_LIST;
        String string3 = null;
        if (gGEP != null) {
            Object object;
            block39: {
                if (gGEP.hasKey("DU")) {
                    try {
                        n = gGEP.getInt("DU");
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
                bl = gGEP.hasKey("GUE");
                if (gGEP.hasKey("VC")) {
                    try {
                        object = gGEP.getBytes("VC");
                        if (((byte[])object).length >= 4) {
                            string = new String((byte[])object, 0, 4);
                        }
                        if (((byte[])object).length > 4) {
                            n2 = object[4] >> 4;
                            n3 = object[4] & 0xF;
                        }
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
                if (gGEP.hasKey("QK")) {
                    try {
                        object = gGEP.getBytes("QK");
                        if (QueryKey.isValidQueryKeyBytes(object)) {
                            queryKey = QueryKey.getQueryKey(object, false);
                        }
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
                if (gGEP.hasKey("UP")) {
                    try {
                        object = gGEP.getBytes("UP");
                        if (((byte[])object).length >= 3) {
                            n4 = object[1];
                            n5 = object[2];
                        }
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
                if (gGEP.hasKey("LOC")) {
                    try {
                        object = gGEP.getBytes("LOC");
                        if (((byte[])object).length >= 2) {
                            string2 = new String((byte[])object, 0, 2);
                        }
                        if (((byte[])object).length >= 3) {
                            n6 = ByteOrder.ubyte2int(object[2]);
                        }
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
                if (gGEP.hasKey("IP")) {
                    try {
                        object = gGEP.getBytes("IP");
                        byte[] byArray3 = new byte[4];
                        if (((byte[])object).length >= 6) {
                            System.arraycopy(object, 0, byArray3, 0, 4);
                        }
                        if (!NetworkUtils.isValidAddress(byArray3)) break block39;
                        try {
                            inetAddress2 = NetworkUtils.getByAddress(byArray3);
                            n7 = ByteOrder.ubytes2int(ByteOrder.leb2short(object, 4));
                            if (NetworkUtils.isPrivateAddress(inetAddress2) || !NetworkUtils.isValidPort(n7)) {
                                inetAddress2 = null;
                                n7 = 0;
                            }
                        }
                        catch (UnknownHostException unknownHostException) {}
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
            }
            if (gGEP.hasKey("UDPHC")) {
                string3 = "";
                try {
                    string3 = gGEP.getString("UDPHC");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    // empty catch block
                }
            }
            if (gGEP.hasKey("IPP")) {
                try {
                    object = gGEP.getBytes("IPP");
                    list = NetworkUtils.unpackIps(object);
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                }
                catch (BadPacketException badPacketException) {
                    // empty catch block
                }
            }
            if (gGEP.hasKey("PHC")) {
                try {
                    object = gGEP.getString("PHC");
                    list2 = this.listCaches((String)object);
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    // empty catch block
                }
            }
        }
        this.MY_IP = inetAddress2;
        this.MY_PORT = n7;
        this.HAS_GGEP_EXTENSION = gGEP != null;
        this.DAILY_UPTIME = n;
        this.SUPPORTS_UNICAST = bl;
        this.VENDOR = string;
        this.VENDOR_MAJOR_VERSION = n2;
        this.VENDOR_MINOR_VERSION = n3;
        this.QUERY_KEY = queryKey;
        this.FREE_LEAF_SLOTS = n4;
        this.FREE_ULTRAPEER_SLOTS = n5;
        this.CLIENT_LOCALE = string2;
        this.FREE_LOCALE_SLOTS = n6;
        this.UDP_CACHE_ADDRESS = string3 != null && "".equals(string3) ? this.getAddress() : string3;
        this.PACKED_IP_PORTS = list;
        this.PACKED_UDP_HOST_CACHES = list2;
    }

    private static GGEP newGGEP(int n, boolean bl, boolean bl2) {
        GGEP gGEP = new GGEP(true);
        if (n >= 0) {
            gGEP.put("DU", n);
        }
        if (bl2 && bl) {
            byte[] byArray = new byte[]{PingReply.convertToGUESSFormat(CommonUtils.getGUESSMajorVersionNumber(), CommonUtils.getGUESSMinorVersionNumber())};
            gGEP.put("GUE", byArray);
        }
        if (bl) {
            PingReply.addUltrapeerExtension(gGEP);
        }
        gGEP.put("VC", CACHED_VENDOR);
        return gGEP;
    }

    private static GGEP qkGGEP(QueryKey queryKey) {
        try {
            GGEP gGEP = new GGEP(true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            queryKey.write(byteArrayOutputStream);
            gGEP.put("QK", byteArrayOutputStream.toByteArray());
            return gGEP;
        }
        catch (IOException iOException) {
            Assert.that(false, "Couldn't encode QueryKey" + queryKey);
            return null;
        }
    }

    private static GGEP addLocale(GGEP gGEP, String string, int n) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = string.getBytes();
        byArray[0] = byArray2[0];
        byArray[1] = byArray2[1];
        byArray[2] = (byte)n;
        gGEP.put("LOC", byArray);
        return gGEP;
    }

    private static GGEP addAddress(GGEP gGEP, IpPort ipPort) {
        byte[] byArray = new byte[6];
        System.arraycopy(ipPort.getInetAddress().getAddress(), 0, byArray, 0, 4);
        ByteOrder.short2leb((short)ipPort.getPort(), byArray, 4);
        gGEP.put("IP", byArray);
        return gGEP;
    }

    private static GGEP addPackedHosts(GGEP gGEP, Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return gGEP;
        }
        gGEP.put("IPP", NetworkUtils.packIpPorts(collection));
        return gGEP;
    }

    private static void addUltrapeerExtension(GGEP gGEP) {
        byte[] byArray = new byte[]{PingReply.convertToGUESSFormat(CommonUtils.getUPMajorVersionNumber(), CommonUtils.getUPMinorVersionNumber()), (byte)RouterService.getNumFreeLimeWireLeafSlots(), (byte)RouterService.getNumFreeLimeWireNonLeafSlots()};
        gGEP.put("UP", byArray);
    }

    private static byte convertToGUESSFormat(int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n2 < 0 || n > 15 || n2 > 15) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        n3 <<= 4;
        return (byte)(n3 |= n2);
    }

    public boolean hasFreeSlots() {
        return this.hasFreeLeafSlots() || this.hasFreeUltrapeerSlots();
    }

    public boolean hasFreeLeafSlots() {
        return this.FREE_LEAF_SLOTS > 0;
    }

    public boolean hasFreeUltrapeerSlots() {
        return this.FREE_ULTRAPEER_SLOTS > 0;
    }

    public int getNumLeafSlots() {
        return this.FREE_LEAF_SLOTS;
    }

    public int getNumUltrapeerSlots() {
        return this.FREE_ULTRAPEER_SLOTS;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.PAYLOAD);
        SentMessageStatHandler.TCP_PING_REPLIES.addMessage(this);
    }

    public int getPort() {
        return this.PORT;
    }

    public String getAddress() {
        return this.IP.getHostAddress();
    }

    public byte[] getIPBytes() {
        byte[] byArray = new byte[]{this.PAYLOAD[2], this.PAYLOAD[3], this.PAYLOAD[4], this.PAYLOAD[5]};
        return byArray;
    }

    public long getFiles() {
        return this.FILES;
    }

    public long getKbytes() {
        return this.KILOBYTES;
    }

    public int getDailyUptime() {
        return this.DAILY_UPTIME;
    }

    public boolean supportsUnicast() {
        return this.SUPPORTS_UNICAST;
    }

    public String getVendor() {
        return this.VENDOR;
    }

    public int getVendorMajorVersion() {
        return this.VENDOR_MAJOR_VERSION;
    }

    public int getVendorMinorVersion() {
        return this.VENDOR_MINOR_VERSION;
    }

    public QueryKey getQueryKey() {
        return this.QUERY_KEY;
    }

    public List getPackedIPPorts() {
        return this.PACKED_IP_PORTS;
    }

    public List getPackedUDPHostCaches() {
        return this.PACKED_UDP_HOST_CACHES;
    }

    public boolean hasGGEPExtension() {
        return this.HAS_GGEP_EXTENSION;
    }

    private static GGEP parseGGEP(byte[] byArray) {
        if (byArray.length <= 14) {
            return null;
        }
        try {
            return new GGEP(byArray, 14, null);
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            return null;
        }
    }

    public Message stripExtendedPayload() {
        byte[] byArray = new byte[14];
        System.arraycopy(this.PAYLOAD, 0, byArray, 0, 14);
        return new PingReply(this.getGUID(), this.getTTL(), this.getHops(), byArray, null, this.IP);
    }

    private List listCaches(String string) {
        LinkedList linkedList = new LinkedList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            int n2;
            String string2;
            block7: {
                string2 = stringTokenizer.nextToken();
                n2 = string2.indexOf("&");
                if (n2 != -1) {
                    string2 = string2.substring(0, n2);
                }
                n2 = string2.indexOf(":");
                n = 6346;
                if (n2 == 0 || n2 == string2.length()) continue;
                if (n2 != -1) {
                    try {
                        n = Integer.valueOf(string2.substring(n2 + 1));
                        break block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                }
                n2 = string2.length();
            }
            if (!NetworkUtils.isValidPort(n)) continue;
            String string3 = string2.substring(0, n2);
            try {
                linkedList.add((Object)new IpPortImpl(string3, n));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return Collections.unmodifiableList((List)linkedList);
    }

    public boolean isUltrapeer() {
        long l = this.getKbytes();
        if (l < 8L) {
            return false;
        }
        return PingReply.isPowerOf2(ByteOrder.long2int(l));
    }

    public static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    public void recordDrop() {
        DroppedSentMessageStatHandler.TCP_PING_REPLIES.addMessage(this);
    }

    private static long mark(long l) {
        int n = ByteOrder.long2int(l);
        if (n < 12) {
            return 8L;
        }
        if (n < 24) {
            return 16L;
        }
        if (n < 48) {
            return 32L;
        }
        if (n < 96) {
            return 64L;
        }
        if (n < 192) {
            return 128L;
        }
        if (n < 384) {
            return 256L;
        }
        if (n < 768) {
            return 512L;
        }
        if (n < 1536) {
            return 1024L;
        }
        if (n < 3072) {
            return 2048L;
        }
        if (n < 6144) {
            return 4096L;
        }
        if (n < 12288) {
            return 8192L;
        }
        if (n < 24576) {
            return 16384L;
        }
        if (n < 49152) {
            return 32768L;
        }
        if (n < 98304) {
            return 65536L;
        }
        if (n < 196608) {
            return 131072L;
        }
        if (n < 393216) {
            return 262144L;
        }
        if (n < 786432) {
            return 524288L;
        }
        if (n < 0x180000) {
            return 0x100000L;
        }
        if (n < 0x300000) {
            return 0x200000L;
        }
        if (n < 0x600000) {
            return 0x400000L;
        }
        if (n < 0xC00000) {
            return 0x800000L;
        }
        if (n < 0x1800000) {
            return 0x1000000L;
        }
        if (n < 0x3000000) {
            return 0x2000000L;
        }
        if (n < 0x6000000) {
            return 0x4000000L;
        }
        if (n < 0xC000000) {
            return 0x8000000L;
        }
        if (n < 0x18000000) {
            return 0x10000000L;
        }
        if (n < 0x30000000) {
            return 0x20000000L;
        }
        return 0x40000000L;
    }

    public String toString() {
        return "PingReply(" + this.getAddress() + ":" + this.getPort() + ", free ultrapeers slots: " + this.hasFreeUltrapeerSlots() + ", free leaf slots: " + this.hasFreeLeafSlots() + ", vendor: " + this.VENDOR + " " + this.VENDOR_MAJOR_VERSION + "." + this.VENDOR_MINOR_VERSION + ", " + super.toString() + ", locale : " + this.CLIENT_LOCALE + ")";
    }

    public InetAddress getInetAddress() {
        return this.IP;
    }

    public InetAddress getMyInetAddress() {
        return this.MY_IP;
    }

    public int getMyPort() {
        return this.MY_PORT;
    }

    public String getClientLocale() {
        return this.CLIENT_LOCALE;
    }

    public int getNumFreeLocaleSlots() {
        return this.FREE_LOCALE_SLOTS;
    }

    public boolean isUDPHostCache() {
        return this.UDP_CACHE_ADDRESS != null;
    }

    public String getUDPCacheAddress() {
        return this.UDP_CACHE_ADDRESS;
    }

    static {
        System.arraycopy("LIME".getBytes(), 0, CACHED_VENDOR, 0, "LIME".getBytes().length);
        PingReply.CACHED_VENDOR[4] = PingReply.convertToGUESSFormat(CommonUtils.getMajorVersionNumber(), CommonUtils.getMinorVersionNumber());
    }
}

