/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NameValue;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PingRequest
extends Message {
    public static final byte SCP_ULTRAPEER_OR_LEAF_MASK = 1;
    public static final byte SCP_LEAF = 0;
    public static final byte SCP_ULTRAPEER = 1;
    private byte[] payload = null;
    private GGEP _ggep;

    public PingRequest(byte[] byArray, byte by, byte by2) {
        super(byArray, (byte)0, by, by2, 0);
    }

    protected PingRequest(byte[] byArray, byte by, byte by2, byte by3) {
        super(byArray, (byte)0, by, by2, by3);
    }

    public PingRequest(byte[] byArray, byte by, byte by2, byte[] byArray2) {
        super(byArray, (byte)0, by, by2, byArray2.length);
        this.payload = byArray2;
    }

    public PingRequest(byte by) {
        super((byte)0, by, 0);
        this.addBasicGGEPs();
    }

    public PingRequest(byte[] byArray, byte by) {
        super(byArray, (byte)0, by, (byte)0, 0);
        this.addBasicGGEPs();
    }

    private PingRequest(byte[] byArray, byte by, List list) {
        super(byArray, (byte)0, by, (byte)0, 0);
        this.addGGEPs(list);
    }

    public static PingRequest createQueryKeyRequest() {
        LinkedList linkedList = new LinkedList();
        linkedList.add((Object)new NameValue("QK"));
        return new PingRequest(GUID.makeGuid(), 1, (List)linkedList);
    }

    public static PingRequest createUDPPing() {
        GUID gUID;
        LinkedList linkedList = new LinkedList();
        if (ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue()) {
            gUID = new GUID();
        } else {
            linkedList.add((Object)new NameValue("IP"));
            gUID = UDPService.instance().getSolicitedGUID();
        }
        byte[] byArray = new byte[]{RouterService.isSupernode() ? (byte)1 : 0};
        linkedList.add((Object)new NameValue("SCP", byArray));
        return new PingRequest(gUID.bytes(), 1, (List)linkedList);
    }

    public static PingRequest createMulticastPing() {
        GUID gUID = new GUID();
        byte[] byArray = new byte[]{RouterService.isSupernode() ? (byte)1 : 0};
        LinkedList linkedList = new LinkedList();
        linkedList.add((Object)new NameValue("SCP", byArray));
        return new PingRequest(gUID.bytes(), 1, (List)linkedList);
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        if (this.payload != null) {
            outputStream.write(this.payload);
        }
        SentMessageStatHandler.TCP_PING_REQUESTS.addMessage(this);
    }

    public Message stripExtendedPayload() {
        if (this.payload == null) {
            return this;
        }
        return new PingRequest(this.getGUID(), this.getTTL(), this.getHops());
    }

    public void recordDrop() {
        DroppedSentMessageStatHandler.TCP_PING_REQUESTS.addMessage(this);
    }

    public String toString() {
        return "PingRequest(" + super.toString() + ")";
    }

    public boolean isHeartbeat() {
        return this.getHops() == 1 && this.getTTL() == 0;
    }

    public void addIPRequest() {
        LinkedList linkedList = new LinkedList();
        linkedList.add((Object)new NameValue("IP"));
        this.addGGEPs((List)linkedList);
    }

    private void addBasicGGEPs() {
        LinkedList linkedList = new LinkedList();
        linkedList.add((Object)new NameValue("LOC", ApplicationSettings.LANGUAGE.getValue()));
        this.addGGEPs((List)linkedList);
    }

    private void addGGEPs(List list) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this._ggep == null) {
                this._ggep = new GGEP(true);
            }
            this._ggep.putAll(list);
            this._ggep.write(byteArrayOutputStream);
            byteArrayOutputStream.write(0);
            this.payload = byteArrayOutputStream.toByteArray();
            this.updateLength(this.payload.length);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
    }

    public String getLocale() {
        if (this.payload != null) {
            try {
                this.parseGGEP();
                if (this._ggep.hasKey("LOC")) {
                    return this._ggep.getString("LOC");
                }
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
        }
        return ApplicationSettings.DEFAULT_LOCALE.getValue();
    }

    public boolean supportsCachedPongs() {
        if (this.payload != null) {
            try {
                this.parseGGEP();
                return this._ggep.hasKey("SCP");
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return false;
    }

    public byte[] getSupportsCachedPongData() {
        byte[] byArray = null;
        if (this.payload != null) {
            try {
                this.parseGGEP();
                if (this._ggep.hasKey("SCP")) {
                    byArray = DataUtils.EMPTY_BYTE_ARRAY;
                    return this._ggep.getBytes("SCP");
                }
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
        }
        return byArray;
    }

    public boolean isQueryKeyRequest() {
        if (this.getTTL() != 0 || this.getHops() != 1) {
            return false;
        }
        if (this.payload != null) {
            try {
                this.parseGGEP();
                return this._ggep.hasKey("QK");
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean requestsIP() {
        if (this.payload != null) {
            try {
                this.parseGGEP();
                return this._ggep.hasKey("IP");
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return false;
    }

    private void parseGGEP() throws BadGGEPBlockException {
        if (this._ggep == null) {
            this._ggep = new GGEP(this.payload, 0, null);
        }
    }
}

