/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.IOException;
import java.io.OutputStream;

public final class LimeACKVendorMessage
extends VendorMessage {
    public static final int VERSION = 2;

    LimeACKVendorMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, VendorMessage.F_LIME_VENDOR_ID, 11, n, byArray2);
        if (this.getVersion() == 1) {
            throw new BadPacketException("UNSUPPORTED OLD VERSION");
        }
        if (this.getPayload().length < 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
        if (this.getVersion() == 2 && this.getPayload().length != 1) {
            throw new BadPacketException("VERSION 2 UNSUPPORTED PAYLOAD LEN: " + this.getPayload().length);
        }
    }

    public LimeACKVendorMessage(GUID gUID, int n) {
        super(VendorMessage.F_LIME_VENDOR_ID, 11, 2, LimeACKVendorMessage.derivePayload(n));
        this.setGUID(gUID);
    }

    public int getNumResults() {
        return ByteOrder.ubyte2int(this.getPayload()[0]);
    }

    private static byte[] derivePayload(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Number of results too big: " + n);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        ByteOrder.short2leb((short)n, byArray2, 0);
        byArray[0] = byArray2[0];
        return byArray;
    }

    public boolean equals(Object object) {
        if (object instanceof LimeACKVendorMessage) {
            GUID gUID = new GUID(this.getGUID());
            GUID gUID2 = new GUID(((VendorMessage)object).getGUID());
            int n = ((LimeACKVendorMessage)object).getNumResults();
            return gUID.equals(gUID2) && this.getNumResults() == n && super.equals(object);
        }
        return false;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.UDP_LIME_ACK.addMessage(this);
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

