/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.sun.java.util.collections.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class VendorMessage
extends Message {
    protected static final int F_MESSAGES_SUPPORTED = 0;
    protected static final int F_HOPS_FLOW = 4;
    protected static final int F_TCP_CONNECT_BACK = 7;
    protected static final int F_UDP_CONNECT_BACK = 7;
    protected static final int F_UDP_CONNECT_BACK_REDIR = 8;
    protected static final int F_CAPABILITIES = 10;
    protected static final int F_LIME_ACK = 11;
    protected static final int F_REPLY_NUMBER = 12;
    protected static final int F_PUSH_PROXY_REQ = 21;
    protected static final int F_PUSH_PROXY_ACK = 22;
    protected static final int F_GIVE_STATS = 14;
    protected static final int F_STATISTICS = 15;
    protected static final int F_GIVE_ULTRAPEER = 5;
    protected static final int F_ULTRAPEER_LIST = 6;
    protected static final byte[] F_LIME_VENDOR_ID = new byte[]{76, 73, 77, 69};
    protected static final byte[] F_BEAR_VENDOR_ID = new byte[]{66, 69, 65, 82};
    protected static final byte[] F_GTKG_VENDOR_ID = new byte[]{71, 84, 75, 71};
    protected static final byte[] F_NULL_VENDOR_ID = new byte[]{0, 0, 0, 0};
    private static final int LENGTH_MINUS_PAYLOAD = 8;
    private static final BadPacketException UNRECOGNIZED_EXCEPTION = new BadPacketException("Unrecognized Vendor Message");
    private final byte[] _vendorID;
    private final int _selector;
    private final int _version;
    private final byte[] _payload;
    private final int _hashCode;

    protected VendorMessage(byte[] byArray, int n, int n2, byte[] byArray2) {
        this(byArray, n, n2, byArray2, -1);
    }

    protected VendorMessage(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        super((byte)49, (byte)1, 8 + byArray2.length, n3);
        if (byArray.length != 4) {
            throw new IllegalArgumentException("wrong vendorID length: " + byArray.length);
        }
        if ((n & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid selector: " + n);
        }
        if ((n2 & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid version: " + n2);
        }
        this._vendorID = byArray;
        this._selector = n;
        this._version = n2;
        this._payload = byArray2;
        this._hashCode = VendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    protected VendorMessage(byte[] byArray, byte by, byte by2, byte[] byArray2, int n, int n2, byte[] byArray3) throws BadPacketException {
        this(byArray, by, by2, byArray2, n, n2, byArray3, -1);
    }

    protected VendorMessage(byte[] byArray, byte by, byte by2, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) throws BadPacketException {
        super(byArray, (byte)49, by, by2, 8 + byArray3.length, n3);
        if (byArray2.length != 4) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.VENDOR_INVALID_ID.incrementStat();
            }
            throw new BadPacketException("Vendor ID Invalid!");
        }
        if ((n & 0xFFFF0000) != 0) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.VENDOR_INVALID_SELECTOR.incrementStat();
            }
            throw new BadPacketException("Selector Invalid!");
        }
        if ((n2 & 0xFFFF0000) != 0) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.VENDOR_INVALID_VERSION.incrementStat();
            }
            throw new BadPacketException("Version Invalid!");
        }
        this._vendorID = byArray2;
        this._selector = n;
        this._version = n2;
        this._payload = byArray3;
        this._hashCode = VendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    private static int computeHashCode(int n, int n2, byte[] byArray, byte[] byArray2) {
        int n3;
        int n4 = 0;
        n4 += 17 * n;
        n4 += 17 * n2;
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n4 += 17 * byArray[n3];
        }
        for (n3 = 0; n3 < byArray2.length; ++n3) {
            n4 += 17 * byArray2[n3];
        }
        return n4;
    }

    protected byte[] getPayload() {
        return this._payload;
    }

    protected int getVersion() {
        return this._version;
    }

    public static VendorMessage deriveVendorMessage(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
        if (byArray2.length < 8) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.VENDOR_INVALID_PAYLOAD.incrementStat();
            }
            throw new BadPacketException("Not enough bytes for a VM!!");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int n2 = -1;
        int n3 = -1;
        try {
            byArray3 = new byte[4];
            byteArrayInputStream.read(byArray3, 0, byArray3.length);
            n2 = ByteOrder.ubytes2int(ByteOrder.leb2short(byteArrayInputStream));
            n3 = ByteOrder.ubytes2int(ByteOrder.leb2short(byteArrayInputStream));
            byArray4 = new byte[byteArrayInputStream.available()];
            byteArrayInputStream.read(byArray4, 0, byArray4.length);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        if (n2 == 4 && Arrays.equals((byte[])byArray3, (byte[])F_BEAR_VENDOR_ID)) {
            return new HopsFlowVendorMessage(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 11 && Arrays.equals((byte[])byArray3, (byte[])F_LIME_VENDOR_ID)) {
            return new LimeACKVendorMessage(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 12 && Arrays.equals((byte[])byArray3, (byte[])F_LIME_VENDOR_ID)) {
            return new ReplyNumberVendorMessage(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 7 && Arrays.equals((byte[])byArray3, (byte[])F_BEAR_VENDOR_ID)) {
            return new TCPConnectBackVendorMessage(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 0 && Arrays.equals((byte[])byArray3, (byte[])F_NULL_VENDOR_ID)) {
            return new MessagesSupportedVendorMessage(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 7 && Arrays.equals((byte[])byArray3, (byte[])F_GTKG_VENDOR_ID)) {
            return new UDPConnectBackVendorMessage(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 21 && Arrays.equals((byte[])byArray3, (byte[])F_LIME_VENDOR_ID)) {
            return new PushProxyRequest(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 22 && Arrays.equals((byte[])byArray3, (byte[])F_LIME_VENDOR_ID)) {
            return new PushProxyAcknowledgement(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 11 && Arrays.equals((byte[])byArray3, (byte[])F_BEAR_VENDOR_ID)) {
            return new QueryStatusRequest(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 12 && Arrays.equals((byte[])byArray3, (byte[])F_BEAR_VENDOR_ID)) {
            return new QueryStatusResponse(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 7 && Arrays.equals((byte[])byArray3, (byte[])F_LIME_VENDOR_ID)) {
            return new TCPConnectBackRedirect(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 8 && Arrays.equals((byte[])byArray3, (byte[])F_LIME_VENDOR_ID)) {
            return new UDPConnectBackRedirect(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 10 && Arrays.equals((byte[])byArray3, (byte[])F_NULL_VENDOR_ID)) {
            return new CapabilitiesVM(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 14 && Arrays.equals((byte[])byArray3, (byte[])F_LIME_VENDOR_ID)) {
            return new GiveStatsVendorMessage(byArray, by, by2, n3, byArray4, n);
        }
        if (n2 == 15 && Arrays.equals((byte[])byArray3, (byte[])F_LIME_VENDOR_ID)) {
            return new StatisticVendorMessage(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 5 && Arrays.equals((byte[])byArray3, (byte[])F_LIME_VENDOR_ID)) {
            return new UDPCrawlerPing(byArray, by, by2, n3, byArray4);
        }
        if (n2 == 6 && Arrays.equals((byte[])byArray3, (byte[])F_LIME_VENDOR_ID)) {
            return new UDPCrawlerPong(byArray, by, by2, n3, byArray4);
        }
        if (Message.RECORD_STATS) {
            ReceivedErrorStat.VENDOR_UNRECOGNIZED.incrementStat();
        }
        throw UNRECOGNIZED_EXCEPTION;
    }

    public boolean equals(Object object) {
        if (object instanceof VendorMessage) {
            VendorMessage vendorMessage = (VendorMessage)object;
            return this._selector == vendorMessage._selector && Arrays.equals((byte[])this._vendorID, (byte[])vendorMessage._vendorID) && Arrays.equals((byte[])this._payload, (byte[])vendorMessage._payload);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this._vendorID);
        ByteOrder.short2leb((short)this._selector, outputStream);
        ByteOrder.short2leb((short)this._version, outputStream);
        outputStream.write(this.getPayload());
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public void recordDrop() {
    }
}

